/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.refactoring.dialogs;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.config.ClientSetting;
import oracle.ide.config.IdeSettings;
import oracle.ide.controls.tree.CustomJTree;
import oracle.ide.controls.tree.TreeCellCheckedEvent;
import oracle.ide.controls.tree.TreeCellCheckedListener;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.javatools.resource.CommonIconsUtils;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.refactoring.dialogs.CopyableInteger;

public abstract class BaseDialog
extends JPanel {
    private JEWTDialog _dlg;
    private String _preferenceKey;
    private Context _context;
    protected static boolean _preferNewTabChecked;
    private boolean _okButtonEnabled;
    private JLabel _messageLabel;
    private UpdateOnChanges _updateOnChangesListener;

    private void $init$() {
        this._okButtonEnabled = true;
    }

    protected abstract String getTitle();

    protected abstract int getDefaultPreferences();

    protected abstract void updateOKButton();

    protected abstract void updateSettings(CopyableInteger var1);

    protected abstract JComponent getDefaultFocusedComponent();

    protected abstract String getHelpTopicID();

    protected BaseDialog(String preferenceKey, Context context) {
        super(new GridBagLayout());
        this.$init$();
        this._preferenceKey = preferenceKey;
        this._context = context;
    }

    public void setDlg(JEWTDialog dlg) {
        this._dlg = dlg;
        JComponent defaultFocusedComponent = this.getDefaultFocusedComponent();
        this._dlg.setInitialFocus((Component)defaultFocusedComponent);
        this.updateOKButton();
    }

    protected Context getContext() {
        return this._context;
    }

    private JEWTDialog getDlg() {
        return this._dlg;
    }

    protected boolean isInitialized() {
        return this.getDlg() != null;
    }

    protected CopyableInteger getSettings() {
        IdeSettings settings = Ide.getSettings();
        CopyableInteger data = (CopyableInteger)settings.getData(this._preferenceKey);
        if (data == null) {
            data = new CopyableInteger();
            data.setValue(this.getDefaultPreferences());
            ClientSetting.findOrCreate((String)"oracle.jdeveloper").putData(this._preferenceKey, (Copyable)data);
        }
        return data;
    }

    public boolean runDialog() {
        IdeMainWindow mainWindow = Ide.getMainWindow();
        String helpTopicID = this.getHelpTopicID();
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, helpTopicID);
        String title = this.getTitle();
        JEWTDialog dlg = new JEWTDialog((Frame)mainWindow, title, 7);
        this.setDlg(dlg);
        dlg.setContent((Component)this);
        dlg.setResizable(true);
        boolean b = WizardLauncher.runDialog((JDialog)dlg);
        if (b) {
            this.updateSettings();
        }
        return b;
    }

    private void updateSettings() {
        CopyableInteger settings = this.getSettings();
        this.updateSettings(settings);
    }

    protected void setOKButtonEnabled(boolean enabled) {
        if (this._okButtonEnabled != enabled) {
            this._okButtonEnabled = enabled;
            SwingUtilities.invokeLater(new 1());
        }
    }

    public static boolean isPreferNewTabChecked() {
        return _preferNewTabChecked;
    }

    public static void setPreferNewTabChecked(boolean preferNewTabChecked) {
        _preferNewTabChecked = preferNewTabChecked;
    }

    protected void setMessage(String message, boolean isWarning) {
        if (message == null) {
            message = "";
        }
        this._messageLabel.setText(message);
        Icon icon = message.length() == 0 ? null : (isWarning ? CommonIconsUtils.getWarningIcon() : CommonIconsUtils.getErrorIcon());
        this._messageLabel.setIcon(icon);
        this._messageLabel.setToolTipText(message);
    }

    protected void setMessageLabel(JLabel label) {
        this._messageLabel = label;
        this._messageLabel.setFocusable(true);
    }

    protected final void updateOnChanges(JTextComponent textComponent) {
        Document document = textComponent.getDocument();
        UpdateOnChanges updateOnChangesListener = this.getUpdateOnChangesListener();
        document.addDocumentListener(updateOnChangesListener);
    }

    protected final void updateOnChanges(JComboBox comboBox) {
        UpdateOnChanges updateOnChangesListener = this.getUpdateOnChangesListener();
        comboBox.addItemListener(updateOnChangesListener);
    }

    public void updateOnChanges(JCheckBox checkBox) {
        checkBox.getModel().addChangeListener(this.getUpdateOnChangesListener());
    }

    public void updateOnChanges(JTable table) {
        table.getModel().addTableModelListener(this.getUpdateOnChangesListener());
    }

    protected final void updateOnTreeCellChecked(CustomJTree customJTree) {
        UpdateOnChanges updateOnChangesListener = this.getUpdateOnChangesListener();
        customJTree.addTreeCellCheckedListener((TreeCellCheckedListener)updateOnChangesListener);
    }

    public void updateOnSelectionChange(JList list) {
        ListSelectionModel selectionModel = list.getSelectionModel();
        UpdateOnChanges updateOnChangesListener = this.getUpdateOnChangesListener();
        selectionModel.addListSelectionListener(updateOnChangesListener);
    }

    public void updateOnSelectionChange(JTree tree) {
        UpdateOnChanges updateOnChangesListener = this.getUpdateOnChangesListener();
        tree.addTreeSelectionListener(updateOnChangesListener);
    }

    private UpdateOnChanges getUpdateOnChangesListener() {
        if (this._updateOnChangesListener == null) {
            this._updateOnChangesListener = new UpdateOnChanges(null);
        }
        return this._updateOnChangesListener;
    }

    static JEWTDialog mav$getDlg(BaseDialog baseDialog) {
        return baseDialog.getDlg();
    }

    static boolean ra$_okButtonEnabled(BaseDialog baseDialog) {
        return baseDialog._okButtonEnabled;
    }

    final class 1
    implements Runnable {
        public void run() {
            JEWTDialog dlg = BaseDialog.mav$getDlg(BaseDialog.this);
            if (dlg != null && dlg.isOKButtonEnabled() != BaseDialog.ra$_okButtonEnabled(BaseDialog.this)) {
                dlg.setOKButtonEnabled(BaseDialog.ra$_okButtonEnabled(BaseDialog.this));
            }
        }
    }

    private class UpdateOnChanges
    implements DocumentListener,
    ListSelectionListener,
    TreeSelectionListener,
    TreeCellCheckedListener,
    ChangeListener,
    TableModelListener,
    ItemListener {
        public void changedUpdate(DocumentEvent e) {
            BaseDialog.this.updateOKButton();
        }

        public void insertUpdate(DocumentEvent e) {
            BaseDialog.this.updateOKButton();
        }

        public void removeUpdate(DocumentEvent e) {
            BaseDialog.this.updateOKButton();
        }

        public void valueChanged(ListSelectionEvent e) {
            BaseDialog.this.updateOKButton();
        }

        public void valueChanged(TreeSelectionEvent e) {
            BaseDialog.this.updateOKButton();
        }

        public void cellChecked(TreeCellCheckedEvent e) {
            BaseDialog.this.updateOKButton();
        }

        public void cellUnchecked(TreeCellCheckedEvent e) {
            BaseDialog.this.updateOKButton();
        }

        public void stateChanged(ChangeEvent e) {
            BaseDialog.this.updateOKButton();
        }

        public void tableChanged(TableModelEvent e) {
            BaseDialog.this.updateOKButton();
        }

        public void itemStateChanged(ItemEvent e) {
            BaseDialog.this.updateOKButton();
        }

        private UpdateOnChanges() {
        }

        UpdateOnChanges(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

