/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.refactoring.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ArrayList;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.LineNavigationPoint;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;

public abstract class BaseUsageEntry {
    public static final String PROPERTY_VALID = "VALID";
    public static final int TYPE_DEFINITION = 0;
    public static final int TYPE_USAGE = 1;
    private Project _project;
    private int _usageType;
    private int _usageTypeCode;
    private ArrayList _propertyChangeListeners;
    private boolean _included;
    private Object _userObject;

    private void $init$() {
        this._propertyChangeListeners = new ArrayList(2);
        this._included = true;
    }

    protected BaseUsageEntry(Project project, int usageType) {
        this.$init$();
        this._project = project;
        this._usageType = usageType;
    }

    public Project getProject() {
        return this._project;
    }

    public int getUsageType() {
        return this._usageType;
    }

    public void goToChange(boolean focusEditor, boolean selectWord) {
        Project project = this.getProject();
        Context context = Context.newIdeContext();
        context.setWorkspace(Ide.getActiveWorkspace());
        context.setProject(project);
        URL url = this.getURL();
        try {
            Node node = NodeFactory.findOrCreate((URL)url);
            context.setNode(node);
            int offset = this.getOffset();
            if (focusEditor) {
                LineNavigationPoint navigationPoint = new LineNavigationPoint(context, offset, false);
                NavigationManager navigationManager = NavigationManager.getNavigationManager();
                navigationManager.navigateTo((NavigationPoint)navigationPoint);
            } else {
                EditorManager editorManager = EditorManager.getEditorManager();
                OpenEditorOptions openEditorOptions = new OpenEditorOptions(context, CodeEditor.class);
                openEditorOptions.setFlags(1);
                CodeEditor editor = (CodeEditor)editorManager.openEditor(openEditorOptions);
                editor.gotoOffset(offset, 0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._propertyChangeListeners.add(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._propertyChangeListeners.remove(propertyChangeListener);
    }

    protected void fireProperyChange(String property, Object oldValue, Object newValue) {
        PropertyChangeEvent event = new PropertyChangeEvent(this, property, oldValue, newValue);
        int i = 0;
        while (i < this._propertyChangeListeners.size()) {
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)this._propertyChangeListeners.get(i);
            propertyChangeListener.propertyChange(event);
            ++i;
        }
    }

    public abstract void release();

    public abstract URL getURL();

    public abstract int getOffset();

    public abstract int getLength();

    public boolean isIncluded() {
        return this._included;
    }

    public void setIncluded(boolean included) {
        this._included = included;
    }

    public abstract boolean isValid();

    public Object getUserObject() {
        return this._userObject;
    }

    public void setUserObject(Object userObject) {
        this._userObject = userObject;
    }

    public void setUsageTypeCode(int usageTypeCode) {
        this._usageTypeCode = usageTypeCode;
    }

    public int getUsageTypeCode() {
        return this._usageTypeCode;
    }
}

