/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.refactoring.model;

import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.model.JavaClass;

public abstract class ClassDescription {
    public abstract String getPackageName();

    public abstract String getClassName();

    public abstract String getQualifiedName();

    public abstract boolean isInterface();

    public abstract JavaClass getJavaClass(JavaProvider var1);

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that instanceof ClassDescription) {
            ClassDescription classDescription = (ClassDescription)that;
            if (this.getQualifiedName().equals(classDescription.getQualifiedName())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.getQualifiedName().hashCode();
    }

    public static ClassDescription createClassDescription(JavaClass sourceClass) {
        return new JotClassDescription(sourceClass);
    }

    public static ClassDescription createClassDescription(String packageName, String className, boolean isInterface) {
        return new StringClassDescription(packageName, className, isInterface, null);
    }

    private static class JotClassDescription
    extends ClassDescription {
        private JavaClass _javaClass;

        public JotClassDescription(JavaClass javaClass) {
            this._javaClass = javaClass;
        }

        public String getPackageName() {
            return this._javaClass.getPackageName();
        }

        public String getClassName() {
            return this._javaClass.getName();
        }

        public String getQualifiedName() {
            return this._javaClass.getQualifiedName();
        }

        public boolean isInterface() {
            return this._javaClass.isInterface();
        }

        public JavaClass getJavaClass(JavaProvider provider) {
            return this._javaClass;
        }
    }

    private static class StringClassDescription
    extends ClassDescription {
        private String _packageName;
        private String _className;
        private String _qualifiedName;
        private boolean _isInterface;

        private StringClassDescription(String packageName, String className, boolean isInterface) {
            this._packageName = packageName == null ? "" : packageName;
            this._className = className;
            this._qualifiedName = packageName == null ? className : packageName + '.' + className;
            this._isInterface = isInterface;
        }

        public String getPackageName() {
            return this._packageName;
        }

        public String getClassName() {
            return this._className;
        }

        public String getQualifiedName() {
            return this._qualifiedName;
        }

        public boolean isInterface() {
            return this._isInterface;
        }

        public JavaClass getJavaClass(JavaProvider provider) {
            String qualifiedName = this.getQualifiedName();
            return provider.getClass(qualifiedName);
        }

        StringClassDescription(String string, String string2, boolean bl, 1 var4_4) {
            this(string, string2, bl);
        }

        public final class 1 {
        }
    }
}

