/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.refactoring.model;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.jdeveloper.refactoring.changes.RefactoringChange;
import oracle.jdeveloper.refactoring.model.SearchOperation;
import oracle.jdeveloper.refactoring.model.URLRefactoringHandler;
import oracle.jdeveloper.refactoring.model.UsageModel;
import oracle.jdevimpl.refactoring.TextChangeCommand;

public abstract class TextChangeBasedRefactoringHandler
extends URLRefactoringHandler {
    private static final String CACHED_CHANGES_KEY = "CACHED_CHANGES";

    protected RefactoringChange[] getChanges(SearchOperation searchOperation, UsageModel usageModel, Project project) {
        return null;
    }

    private RefactoringChange[] getCachedChanges(SearchOperation searchOperation, UsageModel usageModel, Project project) {
        RefactoringChange[] ret = null;
        String cachedChangesKey = CACHED_CHANGES_KEY + this.hashCode();
        HashMap<Project, RefactoringChange[]> cachedChanges = (HashMap<Project, RefactoringChange[]>)searchOperation.getProperty(cachedChangesKey);
        if (cachedChanges == null) {
            cachedChanges = new HashMap<Project, RefactoringChange[]>();
            searchOperation.setProperty(cachedChangesKey, cachedChanges);
        } else {
            ret = (RefactoringChange[])cachedChanges.get(project);
        }
        if (ret == null) {
            ret = this.getChanges(searchOperation, usageModel, project);
            cachedChanges.put(project, ret);
        }
        return ret;
    }

    public Node[] getAffectedNodes(SearchOperation searchOperation, UsageModel usageModel, Project project) {
        RefactoringChange[] changes = this.getCachedChanges(searchOperation, usageModel, project);
        HashSet<Node> affectedNodes = new HashSet<Node>();
        int i = 0;
        while (i < changes.length) {
            RefactoringChange change = changes[i];
            Node node = change.getNode();
            if (node != null) {
                affectedNodes.add(node);
            }
            ++i;
        }
        return affectedNodes.toArray(new Node[affectedNodes.size()]);
    }

    public boolean doChanges(SearchOperation searchOperation, UsageModel usageModel, Project project) {
        boolean ret = false;
        RefactoringChange[] changes = this.getCachedChanges(searchOperation, usageModel, project);
        List<RefactoringChange> list = Arrays.asList(changes);
        TextChangeCommand textChangeCommand = new TextChangeCommand(searchOperation, list);
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        try {
            if (commandProcessor.invoke((Command)textChangeCommand) == 0) {
                ret = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }
}

