/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.refactoring.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.performance.PerformanceLogger;
import oracle.jdeveloper.java.JavaClassLocator;
import oracle.jdeveloper.model.DependencyCache;
import oracle.jdeveloper.refactoring.model.ProgressIndicator;
import oracle.jdeveloper.refactoring.model.SearchOperation;
import oracle.jdeveloper.refactoring.model.UsageModel;
import oracle.jdevimpl.refactoring.search.Scope;

public abstract class URLHandler {
    public Project[] getIncludedProjects(SearchOperation searchOperation, ProgressIndicator progressIndicator) {
        return null;
    }

    public abstract HashSet chooseURLs(SearchOperation var1, Project var2, ProgressIndicator var3);

    public abstract UsageModel findUsages(SearchOperation var1, Project var2, URL[] var3, ProgressIndicator var4);

    public static Project[] getIncludedProjects(SearchOperation searchOperation, String fqClassName) {
        return URLHandler.getIncludedProjects(searchOperation, new String[]{fqClassName});
    }

    public static Project[] getIncludedProjects(SearchOperation searchOperation, String[] fqClassNames) {
        return URLHandler.getIncludedProjects(searchOperation.getContext(), Scope.createDummyScope(), fqClassNames);
    }

    public static Project[] getIncludedProjects(Context context, Scope scope, String ... fqClassNames) {
        PerformanceLogger.get().startTiming("URLHandler.getIncludedProjects");
        try {
            if (scope.getType() == 2) {
                Project[] projectArray = new Project[]{context.getProject()};
                return projectArray;
            }
            if (scope.getType() == 3 && scope.getWorkingSet().getExcludedProjectList() != null) {
                Workspace workspace = context.getWorkspace();
                ArrayList<Project> projects = new ArrayList<Project>();
                Iterator iterator = workspace.getChildren();
                while (iterator.hasNext()) {
                    Project project;
                    Object o = iterator.next();
                    if (!(o instanceof Project) || !scope.isValidProject(project = (Project)o)) continue;
                    projects.add(project);
                }
                Project[] projectArray = projects.toArray(new Project[projects.size()]);
                return projectArray;
            }
            DependencyCache deps = DependencyCache.getInstance(context);
            Collection<Project> results = deps.getProjectsUsing(context, fqClassNames);
            ArrayList<Project> projects = new ArrayList<Project>(results);
            Iterator<Project> iterator = projects.iterator();
            while (iterator.hasNext()) {
                if (scope.isValidProject(iterator.next())) continue;
                iterator.remove();
            }
            Project[] projectArray = projects.toArray(new Project[projects.size()]);
            return projectArray;
        }
        catch (InterruptedException ie) {
            Project[] projectArray = null;
            PerformanceLogger.get().stopTiming("URLHandler.getIncludedProjects", "Obtained list of projects to search for usages");
            return projectArray;
        }
        {
            finally {
                PerformanceLogger.get().stopTiming("URLHandler.getIncludedProjects", "Obtained list of projects to search for usages");
            }
        }
    }

    private static boolean isSameClassFile(URL classURL, JavaClassLocator javaClassLocator, String fqClassName) {
        URL classURL_i;
        return classURL != null && classURL.equals(classURL_i = javaClassLocator.getClassURL(fqClassName));
    }

    private static boolean isSameSourceFile(URL sourceURL, JavaClassLocator javaClassLocator, String fqClassName) {
        URL sourceURL_i;
        return sourceURL != null && sourceURL.equals(sourceURL_i = javaClassLocator.getSourceURL(fqClassName));
    }
}

