/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.refactoring.model;

import java.net.URL;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.TextNode;
import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferListener;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.jdeveloper.refactoring.model.BaseUsageEntry;

public class UsageEntry
extends BaseUsageEntry
implements TextBufferListener {
    public static final int VALIDITY_IGNORE = 0;
    public static final int VALIDITY_RANGE = 1;
    public static final int VALIDITY_BUFFER = 2;
    private TextNode _textNode;
    private int _validityType;
    private int _length;
    private boolean _valid;
    private OffsetMark _offsetMark;
    private TextBuffer _textBuffer;
    private String _originalText;
    private int _originalOffsetPos;

    private void $init$() {
        this._valid = true;
    }

    public UsageEntry(Project project, TextNode textNode, int offset, int length, int usageType) {
        super(project, usageType);
        this.$init$();
        this.init(textNode, length, offset, 1);
    }

    public UsageEntry(Project project, URL url, int offset, int length, int usageType, int validityType) {
        super(project, usageType);
        this.$init$();
        Node node = NodeFactory.find((URL)url);
        this.init((TextNode)node, length, offset, validityType);
    }

    public UsageEntry(Project project, SourceElement sourceElement, int usageType, int validityType) {
        super(project, usageType);
        this.$init$();
        SourceFile owningFile = sourceElement.getOwningSourceFile();
        int startOffset = sourceElement.getStartOffset();
        int endOffset = sourceElement.getEndOffset();
        TextNode node = (TextNode)NodeFactory.find((URL)owningFile.getURL());
        this.init(node, endOffset - startOffset, startOffset, validityType);
    }

    public static UsageEntry createEntry(Project project, URL url, int offset, int length) {
        return UsageEntry.createEntry(project, url, offset, length, 1);
    }

    public static UsageEntry createEntry(Project project, URL url, int offset, int length, int usageType) {
        UsageEntry usageEntry = null;
        try {
            Node node = NodeFactory.findOrCreate((URL)url);
            if (node instanceof TextNode) {
                TextNode textNode = (TextNode)node;
                usageEntry = new UsageEntry(project, textNode, offset, length, usageType);
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return usageEntry;
    }

    private void init(TextNode textNode, int length, int offset, int validityType) {
        if (textNode == null) {
            throw new NullPointerException();
        }
        if (length <= 0) {
            throw new IllegalArgumentException();
        }
        if (offset < 0) {
            throw new IllegalArgumentException();
        }
        this._textNode = textNode;
        this._textBuffer = textNode.acquireTextBuffer();
        this._length = length;
        this._validityType = validityType;
        this._originalOffsetPos = offset;
        this._offsetMark = this._textBuffer.addOffsetMark(this._originalOffsetPos);
        this._originalText = this._textBuffer.getString(offset, length);
        if (this._validityType != 0) {
            this._textBuffer.addTextBufferListener((TextBufferListener)this);
        }
    }

    public void release() {
        if (this._textBuffer != null) {
            this._textBuffer.removeOffsetMark(this._offsetMark);
            this._offsetMark = null;
            this._textBuffer.removeTextBufferListener((TextBufferListener)this);
            this._textBuffer = null;
        }
    }

    public boolean isValid() {
        return this._valid;
    }

    public TextNode getTextNode() {
        return this._textNode;
    }

    public URL getURL() {
        return this._textNode.getURL();
    }

    public TextBuffer getTextBuffer() {
        return this._textBuffer;
    }

    public int getOffset() {
        return this._offsetMark.getOffset();
    }

    public int getLength() {
        return this._length;
    }

    public void insertUpdate(TextBuffer buffer, int offset, int count, char[] insertedData) {
        this.whenTextChangesAt(offset, count);
    }

    public void removeUpdate(TextBuffer buffer, int offset, int count, char[] removedData) {
        this.whenTextChangesAt(offset, count);
    }

    public void attributeUpdate(TextBuffer buffer, int attribute) {
        switch (attribute) {
            case 4: {
                int offset = this.getOffset();
                int bufferLength = this._textBuffer.getLength();
                if (offset + this._length < bufferLength) {
                    String newString = this._textBuffer.getString(offset, this._length);
                    if (this._originalText.equals(newString)) break;
                    this.whenTextHasChanged();
                    break;
                }
                this.whenTextHasChanged();
                break;
            }
        }
    }

    private void whenTextChangesAt(int offset, int count) {
        boolean isInRange;
        int myOffset = this._offsetMark.getOffset();
        switch (this._validityType) {
            case 1: {
                isInRange = UsageEntry.intersects(offset, offset + count, myOffset) || UsageEntry.intersects(myOffset, myOffset + this._length, offset);
                break;
            }
            case 2: {
                isInRange = true;
                break;
            }
            default: {
                isInRange = false;
                break;
            }
        }
        if (isInRange) {
            this.whenTextHasChanged();
        }
    }

    private static boolean intersects(int from, int to, int at) {
        return from <= at && at <= to;
    }

    private void whenTextHasChanged() {
        if (this._valid) {
            this._valid = false;
            this.fireProperyChange("VALID", Boolean.TRUE, Boolean.FALSE);
        }
    }
}

