/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.refactoring.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.util.Assert;
import oracle.jdeveloper.refactoring.model.BaseUsageEntry;
import oracle.jdeveloper.refactoring.model.UsageEntryComparator;

public class UsageModel {
    private ArrayList<BaseUsageEntry> _usageEntries;
    private PropertyChangeListener _propertyChangeListener;

    private void $init$() {
        this._usageEntries = new ArrayList();
    }

    public UsageModel() {
        this.$init$();
    }

    public void dump() {
        int i = 0;
        while (i < this._usageEntries.size()) {
            BaseUsageEntry usageEntry = this._usageEntries.get(i);
            URL projectUrl = usageEntry.getProject().getURL();
            URL fileUrl = usageEntry.getURL();
            int offset = usageEntry.getOffset();
            System.out.println(projectUrl.getFile().toString() + "|" + fileUrl.getFile().toString() + "|" + offset);
            ++i;
        }
    }

    public void addUsageEntry(BaseUsageEntry baseUsageEntry) {
        1 redirectPropertyChange = new 1();
        baseUsageEntry.addPropertyChangeListener(redirectPropertyChange);
        this._usageEntries.add(baseUsageEntry);
    }

    private void removeUsageEntry(BaseUsageEntry usageEntry) {
        usageEntry.removePropertyChangeListener(this._propertyChangeListener);
    }

    public void addAll(UsageModel other) {
        ArrayList otherEntries = other.getUsageEntries();
        int i = 0;
        while (i < otherEntries.size()) {
            BaseUsageEntry usageEntry = (BaseUsageEntry)otherEntries.get(i);
            this.addUsageEntry(usageEntry);
            ++i;
        }
    }

    public void transferAll(UsageModel source) {
        ArrayList otherEntries = source.getUsageEntries();
        int i = 0;
        while (i < otherEntries.size()) {
            BaseUsageEntry usageEntry = (BaseUsageEntry)otherEntries.get(i);
            source.removeUsageEntry(usageEntry);
            this.addUsageEntry(usageEntry);
            ++i;
        }
    }

    public void release() {
        int i = 0;
        while (i < this._usageEntries.size()) {
            BaseUsageEntry usageEntry = this._usageEntries.get(i);
            usageEntry.release();
            ++i;
        }
    }

    public ArrayList getUsageEntries() {
        return this._usageEntries;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        Assert.check((this._propertyChangeListener == null ? 1 : 0) != 0);
        this._propertyChangeListener = propertyChangeListener;
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        Assert.check((this._propertyChangeListener == propertyChangeListener ? 1 : 0) != 0);
        this._propertyChangeListener = null;
    }

    public void sort() {
        Collections.sort(this._usageEntries, new UsageEntryComparator());
    }

    public Node[] getDistinctNodes() {
        HashSet<Node> affectedNodes = new HashSet<Node>();
        ArrayList usageEntries = this.getUsageEntries();
        int i = 0;
        while (i < usageEntries.size()) {
            BaseUsageEntry usageEntry = (BaseUsageEntry)usageEntries.get(i);
            URL url = usageEntry.getURL();
            try {
                Node affectedNode = NodeFactory.findOrCreate((URL)url);
                affectedNodes.add(affectedNode);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        return affectedNodes.toArray(new Node[affectedNodes.size()]);
    }

    static PropertyChangeListener ra$_propertyChangeListener(UsageModel usageModel) {
        return usageModel._propertyChangeListener;
    }

    final class 1
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent event) {
            if (UsageModel.ra$_propertyChangeListener(UsageModel.this) != null) {
                UsageModel.ra$_propertyChangeListener(UsageModel.this).propertyChange(event);
            }
        }
    }
}

