/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.refactoring.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ResourceUtils;
import oracle.ide.vcs.VCSManager;
import oracle.jdeveloper.refactoring.util.Util;

public class MakeWritableHelper {
    private static String dialogTitle = "Refactoring";

    public static boolean makeWritable(URL[] urls, String title) {
        String savedDialogTitle = dialogTitle;
        dialogTitle = title;
        boolean res = MakeWritableHelper.makeWritable(urls);
        dialogTitle = savedDialogTitle;
        return res;
    }

    public static boolean makeWritable(URL[] urls) {
        ArrayList<URL> urls0 = new ArrayList<URL>(Arrays.asList(urls));
        Iterator itr = urls0.iterator();
        while (itr.hasNext()) {
            if (URLFileSystem.isReadOnly((URL)((URL)itr.next()))) continue;
            itr.remove();
        }
        int versionedUrlCount = 0;
        Iterator itr2 = urls0.iterator();
        while (itr2.hasNext()) {
            if (!VCSManager.getVCSManager().isVersioned((URL)itr2.next())) continue;
            ++versionedUrlCount;
        }
        return (versionedUrlCount <= 0 || MakeWritableHelper.checkout(urls0, versionedUrlCount)) && MakeWritableHelper.setReadWrite(urls0);
    }

    private static boolean showMessage(Collection urls, String message) {
        boolean ret = false;
        Vector<String> names = new Vector<String>();
        for (URL url : urls) {
            String platformPathName = URLFileSystem.getPlatformPathName((URL)url);
            names.add(platformPathName);
        }
        Collections.sort(names);
        JList list = new JList(names);
        JScrollPane scrollPane = new JScrollPane(list);
        JLabel label = new JLabel();
        ResourceUtils.resLabel((JLabel)label, (Component)scrollPane, (String)message);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)label, "North");
        panel.add((Component)scrollPane, "Center");
        JEWTDialog dialog = new JEWTDialog((Frame)Ide.getMainWindow(), dialogTitle, 7);
        dialog.setContent((Component)panel);
        dialog.setDefaultButton(1);
        ret = dialog.runDialog();
        return ret;
    }

    private static boolean checkout(Collection urls, int versionedUrlCount) {
        if (urls.size() <= 0) {
            return true;
        }
        boolean ret = true;
        1MyRunnable myRunnable = new 1MyRunnable((Component)Ide.getMainWindow(), urls, versionedUrlCount);
        ret = myRunnable.start();
        return ret;
    }

    private static boolean setReadWrite(Collection urls) {
        boolean ret = false;
        if (urls.size() > 0) {
            boolean canMakeWritable = MakeWritableHelper.showMessage(urls, "The following files will be made writable:");
            if (canMakeWritable) {
                ret = true;
                int i = 0;
                Iterator itr = urls.iterator();
                while (ret && itr.hasNext()) {
                    URL url = (URL)itr.next();
                    if (URLFileSystem.setReadOnly((URL)url, (boolean)false)) {
                        itr.remove();
                    } else if (Util.setReadOnly(url, false)) {
                        itr.remove();
                    } else {
                        String message = MessageFormat.format("Failed to make {0} writable", URLFileSystem.getPlatformPathName((URL)url));
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)message, (String)"File State", null);
                        ret = false;
                    }
                    ++i;
                }
            }
        } else {
            ret = true;
        }
        return ret;
    }

    static class 1MyRunnable
    implements Runnable {
        private ProgressBar _progressBar;
        private boolean _results;
        private final /* synthetic */ Collection v$urls;
        private final /* synthetic */ int v$versionedUrlCount;

        public 1MyRunnable(Component parent, Collection collection, int n) {
            this.v$versionedUrlCount = n;
            this.v$urls = collection;
            this._progressBar = new ProgressBar(parent, "File State", (Runnable)this, false);
        }

        public boolean start() {
            this._progressBar.start("Performing version control operations", " ");
            return this._results;
        }

        public void run() {
            boolean ret = true;
            int i = 0;
            Iterator itr = this.v$urls.iterator();
            while (ret && itr.hasNext()) {
                URL url = (URL)itr.next();
                int completionStatus = (i + 1) * 100 / this.v$versionedUrlCount;
                String fileName = URLFileSystem.getPlatformPathName((URL)url);
                if (!VCSManager.getVCSManager().isVersioned(url)) continue;
                ++i;
                if (!this._progressBar.hasUserCancelled()) {
                    this._progressBar.updateProgress(completionStatus, null, fileName);
                    try {
                        if (VCSManager.getVCSManager().checkOutNode(NodeFactory.find((URL)url))) {
                            itr.remove();
                            continue;
                        }
                        ret = false;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                ret = false;
            }
            this._progressBar.setDoneStatus();
            this._results = ret;
        }
    }
}

