/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.refactoring.util;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.undo.UndoableEdit;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.todo.AbstractToDoItem;
import oracle.ide.todo.ToDoItem;
import oracle.ide.todo.ToDoManager;
import oracle.ide.view.View;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.write.SourceTransaction;
import oracle.jdeveloper.java.CacheSupport;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdeveloper.refactoring.events.RefactoringEvent;
import oracle.jdeveloper.refactoring.model.SearchOperation;
import oracle.jdeveloper.refactoring.util.MakeWritableHelper;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.util.Helpers;
import oracle.jdevimpl.refactoring.RefManagerImpl;
import oracle.jdevimpl.refactoring.util.AbortedOperationException;

public class RefactoringCommandSupport {
    private HashMap _transactions;
    private HashSet _affectedNodes;
    private ArrayList _createdURLs;
    private ArrayList _deletedURLs;
    private boolean _openCreatedFiles;
    private SearchOperation _searchOperation;
    private ArrayList _todos;
    private HashMap _caretPositionings;

    private void $init$() {
        this._transactions = new HashMap();
        this._affectedNodes = new HashSet();
        this._todos = new ArrayList();
    }

    public RefactoringCommandSupport() {
        this.$init$();
    }

    public void setOpenCreatedFiles(boolean openCreatedFiles) {
        this._openCreatedFiles = openCreatedFiles;
    }

    public void setSearchOperation(SearchOperation searchOperation) {
        this._searchOperation = searchOperation;
    }

    public final SourceTransaction beginTransaction(SourceElement sourceElement) {
        SourceFile sourceFile = sourceElement.getOwningSourceFile();
        SourceTransaction sourceTransaction = (SourceTransaction)this._transactions.get(sourceFile);
        if (sourceTransaction == null) {
            TextBuffer textBuffer = sourceFile.getTextBuffer();
            textBuffer.setReadOnly(false);
            sourceTransaction = sourceFile.beginTransaction();
            this._transactions.put(sourceFile, sourceTransaction);
            URL url = sourceFile.getURL();
            this.addAffectedURL(url);
        }
        return sourceTransaction;
    }

    public SourceFile createSourceFile(Context context, String packageName, String className) {
        String patchedPackageName = packageName.replace('.', '/');
        URL packageUrl = PathsConfiguration.getURLForPackage((String)patchedPackageName, (Context)context);
        if (packageUrl == null) {
            throw new AbortedOperationException();
        }
        URL classUrl = URLFactory.newURL((URL)packageUrl, (String)(className + ".java"));
        Project project = context.getProject();
        SourceFile sourceFile = this.createSourceFile(project, classUrl);
        return sourceFile;
    }

    public SourceFile createSourceFile(Project project, URL url) {
        JavaManager javaManager = JavaManager.getJavaManager((Project)project);
        SourceFile ret = javaManager.getSourceFile(url);
        if (ret == null) {
            try {
                ret = javaManager.createSourceFile(url);
                if (this._createdURLs == null) {
                    this._createdURLs = new ArrayList(1);
                }
                this._createdURLs.add(url);
                this.beginTransaction((SourceElement)ret);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    private boolean isCreatedFile(URL url) {
        return this._createdURLs != null && this._createdURLs.contains(url);
    }

    public void deleteFile(URL url) {
        if (this._deletedURLs == null) {
            this._deletedURLs = new ArrayList(1);
        }
        this._deletedURLs.add(url);
    }

    private boolean isDeletedFile(URL url) {
        return this._deletedURLs != null && this._deletedURLs.contains(url);
    }

    public void addAffectedURL(URL url) {
        try {
            Node node = NodeFactory.findOrCreate((URL)url);
            this._affectedNodes.add(node);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean commit(Context context, String transactionName) {
        block6: {
            ret = false;
            command = new MyCommand(context, transactionName, this);
            commandProcessor = CommandProcessor.getInstance();
            try {
                try {
                    ret = commandProcessor.invoke((Command)command) == 0;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    FeedbackManager.reportException((Throwable)e);
                }
            }
            finally {
                if (ret) break block6;
                ** for (node : this._affectedNodes)
            }
lbl-1000:
            // 1 sources

            {
                if (!node.isReadOnly() || !(node instanceof TextNode) || (textBuffer = (textNode = (TextNode)node).acquireTextBuffer()).isReadOnly()) continue;
                textBuffer.setReadOnly(true);
                continue;
            }
lbl18:
            // 1 sources

            this.abort();
        }
        return ret;
    }

    public void abort() {
        Collection sourceTransactions = this._transactions.values();
        for (SourceTransaction sourceTransaction : sourceTransactions) {
            sourceTransaction.abort();
        }
        this._affectedNodes.clear();
        this._transactions.clear();
    }

    public void addToDo(SourceElement sourceElement, String message) {
        Object[] todo = new Object[]{sourceElement, message};
        this._todos.add(todo);
    }

    public void repositionCaret(CodeEditor codeEditor, SourceElement sourceElement, boolean afterElement) {
        CaretPositioning caretPositioning = new CaretPositioning(codeEditor, sourceElement, afterElement);
        if (this._caretPositionings == null) {
            this._caretPositionings = new HashMap(1);
        }
        this._caretPositionings.put(codeEditor, caretPositioning);
    }

    static HashMap ra$_transactions(RefactoringCommandSupport refactoringCommandSupport) {
        return refactoringCommandSupport._transactions;
    }

    static ArrayList ra$_deletedURLs(RefactoringCommandSupport refactoringCommandSupport) {
        return refactoringCommandSupport._deletedURLs;
    }

    static boolean mav$isDeletedFile(RefactoringCommandSupport refactoringCommandSupport, URL uRL) {
        return refactoringCommandSupport.isDeletedFile(uRL);
    }

    static boolean mav$isCreatedFile(RefactoringCommandSupport refactoringCommandSupport, URL uRL) {
        return refactoringCommandSupport.isCreatedFile(uRL);
    }

    static ArrayList ra$_createdURLs(RefactoringCommandSupport refactoringCommandSupport) {
        return refactoringCommandSupport._createdURLs;
    }

    static ArrayList ra$_todos(RefactoringCommandSupport refactoringCommandSupport) {
        return refactoringCommandSupport._todos;
    }

    static boolean ra$_openCreatedFiles(RefactoringCommandSupport refactoringCommandSupport) {
        return refactoringCommandSupport._openCreatedFiles;
    }

    static HashMap ra$_caretPositionings(RefactoringCommandSupport refactoringCommandSupport) {
        return refactoringCommandSupport._caretPositionings;
    }

    static SearchOperation ra$_searchOperation(RefactoringCommandSupport refactoringCommandSupport) {
        return refactoringCommandSupport._searchOperation;
    }

    static HashSet ra$_affectedNodes(RefactoringCommandSupport refactoringCommandSupport) {
        return refactoringCommandSupport._affectedNodes;
    }

    private static class MyCommand
    extends Command {
        private Node[] _affectedNodes;
        private RefactoringCommandSupport _pendingCommand;
        private UndoableEdit[] _undoableEdits;
        private HashMap _createdFiles;
        private HashMap _deletedFiles;
        private SearchOperation _searchOperation;
        private int _caretPositionBefore;
        private int _caretPositionAfter;
        private WeakReference _codeEditorReference;
        private boolean _isDone;

        private void $init$() {
            this._caretPositionBefore = -1;
            this._caretPositionAfter = -1;
            this._isDone = false;
        }

        public MyCommand(Context context, String name, RefactoringCommandSupport refactoringCommandSupport) {
            super(-1, 3, name);
            this.$init$();
            this.setContext(context);
            this._searchOperation = RefactoringCommandSupport.ra$_searchOperation(refactoringCommandSupport);
            HashSet affectedNodes = RefactoringCommandSupport.ra$_affectedNodes(refactoringCommandSupport);
            this._affectedNodes = affectedNodes.toArray(new Node[affectedNodes.size()]);
            this._pendingCommand = refactoringCommandSupport;
        }

        public int doit() throws Exception {
            int ret = 1;
            if (this.prepareFiles()) {
                CacheSupport cacheSupport = this.beginCacheUse();
                try {
                    this.fireEvent(4);
                    if (this._pendingCommand == null) {
                        this.redo();
                    } else {
                        CodeEditor codeEditor;
                        boolean openCreatedFiles = RefactoringCommandSupport.ra$_openCreatedFiles(this._pendingCommand);
                        SourceElement highlightedElement = null;
                        Context context = this.getContext();
                        View view = context.getView();
                        if (view instanceof CodeEditor) {
                            Element[] selected;
                            codeEditor = (CodeEditor)view;
                            this._caretPositionBefore = codeEditor.getCaretPosition();
                            int start = codeEditor.getSelectionStart();
                            int end = codeEditor.getSelectionEnd();
                            if (end > start && (selected = codeEditor.getSelection()).length == 1 && selected[0].getData() != null && selected[0].getData() instanceof SourceElement) {
                                highlightedElement = (SourceElement)selected[0].getData();
                                this._pendingCommand.repositionCaret(codeEditor, highlightedElement, false);
                            }
                            this._codeEditorReference = new WeakReference<CodeEditor>(codeEditor);
                        } else {
                            codeEditor = null;
                        }
                        HashMap caretPositionings = RefactoringCommandSupport.ra$_caretPositionings(this._pendingCommand);
                        this.commitTransactions();
                        if (openCreatedFiles && this._createdFiles != null) {
                            for (URL url : this._createdFiles.keySet()) {
                                Util.openEditor(this.getContext(), url);
                            }
                        }
                        if (caretPositionings != null) {
                            Collection positionings = caretPositionings.values();
                            for (CaretPositioning caretPositioning : positionings) {
                                caretPositioning.repositionCaret();
                            }
                        }
                        if (codeEditor != null) {
                            this._caretPositionAfter = codeEditor.getCaretPosition();
                            if (highlightedElement != null) {
                                codeEditor.setSelectionEnd(highlightedElement.getEndOffset());
                            }
                        }
                    }
                    this.deleteURLs(this._deletedFiles);
                    this._isDone = true;
                    ret = 0;
                }
                finally {
                    this.saveAffectedNodes();
                    cacheSupport.endCacheUse();
                }
                if (ret == 0) {
                    this.fireEvent(5);
                }
            }
            return ret;
        }

        private void createToDos() {
            ArrayList todos = RefactoringCommandSupport.ra$_todos(this._pendingCommand);
            ArrayList<AbstractToDoItem> createdToDos = new ArrayList<AbstractToDoItem>(todos.size());
            ToDoManager toDoManager = ToDoManager.getToDoManager();
            int i = 0;
            while (i < todos.size()) {
                Object[] objects = (Object[])todos.get(i);
                SourceElement sourceElement = (SourceElement)objects[0];
                String message = (String)objects[1];
                AbstractToDoItem toDoItem = (AbstractToDoItem)toDoManager.createToDoItem(message, 1, null);
                SourceFile owningFile = sourceElement.getOwningSourceFile();
                URL url = owningFile.getURL();
                toDoItem.setURL(url);
                TextBuffer textBuffer = owningFile.getTextBuffer();
                LineMap lineMap = textBuffer.getLineMap();
                int offset = sourceElement.getStartOffset();
                int line = lineMap.getLineFromOffset(offset) + 1;
                toDoItem.setLine(line);
                createdToDos.add(toDoItem);
                ++i;
            }
            if (createdToDos.size() > 0) {
                ToDoItem[] addItems = createdToDos.toArray(new ToDoItem[createdToDos.size()]);
                toDoManager.add(addItems);
            }
        }

        private void fireEvent(int refBeforeDo) {
            if (this._searchOperation != null) {
                RefManagerImpl refManager = RefManagerImpl.getImplInstance();
                refManager.fireRefEvent(new RefactoringEvent(refBeforeDo, this._searchOperation));
            }
        }

        private void saveClosedNodes() throws IOException {
            EditorManager editorManager = EditorManager.getEditorManager();
            if (editorManager != null) {
                HashSet<Node> editedNodes = new HashSet<Node>();
                List allEditors = editorManager.getAllEditors();
                int i = 0;
                while (i < allEditors.size()) {
                    Node node;
                    Editor editor = (Editor)allEditors.get(i);
                    Context context = editor.getContext();
                    if (context != null && (node = context.getNode()) != null) {
                        editedNodes.add(node);
                    }
                    ++i;
                }
                Node[] affectedNodes = this.getAffectedNodes();
                int i2 = 0;
                while (i2 < affectedNodes.length) {
                    Node affectedNode = affectedNodes[i2];
                    if (!editedNodes.contains(affectedNode)) {
                        affectedNode.save();
                    }
                    ++i2;
                }
            }
        }

        private void redo() throws IllegalAccessException, InstantiationException, IOException {
            CodeEditor codeEditor;
            if (this._createdFiles != null) {
                for (URL url : this._createdFiles.keySet()) {
                    String text = (String)this._createdFiles.get(url);
                    this.createNode(url, text);
                }
            }
            int i = 0;
            while (i < this._undoableEdits.length) {
                UndoableEdit undoableEdit = this._undoableEdits[i];
                undoableEdit.redo();
                ++i;
            }
            if (this._caretPositionAfter >= 0 && this._codeEditorReference != null && (codeEditor = (CodeEditor)this._codeEditorReference.get()) != null) {
                codeEditor.setCaretPosition(this._caretPositionAfter);
            }
        }

        public int undo() throws Exception {
            int ret = 1;
            if (this.prepareFiles()) {
                CacheSupport cacheSupport = this.beginCacheUse();
                this.fireEvent(6);
                try {
                    CodeEditor codeEditor;
                    if (this._deletedFiles != null) {
                        for (URL url : this._deletedFiles.keySet()) {
                            String text = (String)this._deletedFiles.get(url);
                            this.createNode(url, text);
                        }
                    }
                    int i = 0;
                    while (i < this._undoableEdits.length) {
                        UndoableEdit undoableEdit = this._undoableEdits[i];
                        undoableEdit.undo();
                        ++i;
                    }
                    this.deleteURLs(this._createdFiles);
                    if (this._caretPositionBefore >= 0 && this._codeEditorReference != null && (codeEditor = (CodeEditor)this._codeEditorReference.get()) != null) {
                        codeEditor.setCaretPosition(this._caretPositionBefore);
                    }
                    ret = 0;
                    this._isDone = false;
                }
                finally {
                    this.saveAffectedNodes();
                    cacheSupport.endCacheUse();
                }
                if (ret == 0) {
                    this.fireEvent(7);
                }
            }
            return ret;
        }

        private boolean prepareFiles() {
            URL[] urls = new URL[this._affectedNodes.length];
            int i = 0;
            while (i < this._affectedNodes.length) {
                URL url;
                Node node = this._affectedNodes[i];
                urls[i] = url = node.getURL();
                Helpers.removeClasses(this.getContext().getProject(), url);
                ++i;
            }
            return MakeWritableHelper.makeWritable(urls);
        }

        private void deleteURLs(Map urls) throws IOException {
            if (urls != null) {
                for (URL url : urls.keySet()) {
                    Node node = NodeFactory.find((URL)url);
                    if (node != null) {
                        node.delete();
                        continue;
                    }
                    URLFileSystem.delete((URL)url);
                }
            }
        }

        public Node[] getAffectedNodes() {
            ArrayList<Object> ret;
            Collection<Object> excludeUrls;
            if (this._pendingCommand == null) {
                HashMap excludedMap = this._isDone ? this._deletedFiles : this._createdFiles;
                excludeUrls = excludedMap == null ? null : excludedMap.keySet();
            } else {
                excludeUrls = RefactoringCommandSupport.ra$_createdURLs(this._pendingCommand);
            }
            if (excludeUrls != null) {
                ret = new ArrayList(this._affectedNodes.length);
                int i = 0;
                while (i < this._affectedNodes.length) {
                    Node affectedNode = this._affectedNodes[i];
                    URL url = affectedNode.getURL();
                    if (!excludeUrls.contains(url)) {
                        ret.add(affectedNode);
                    }
                    ++i;
                }
            } else {
                ret = new ArrayList<Node>(Arrays.asList(this._affectedNodes));
            }
            Node contextNode = this.context.getNode();
            ret.remove(contextNode);
            return ret.toArray(new Node[ret.size()]);
        }

        private CacheSupport beginCacheUse() {
            Context context = this.getContext();
            Project project = context.getProject();
            JavaManager javaManager = JavaManager.getJavaManager((Project)project);
            CacheSupport cacheSupport = javaManager.getCacheSupport();
            cacheSupport.beginCacheUse();
            return cacheSupport;
        }

        private void commitTransactions() {
            HashMap transactions = RefactoringCommandSupport.ra$_transactions(this._pendingCommand);
            ArrayList deletedURLs = RefactoringCommandSupport.ra$_deletedURLs(this._pendingCommand);
            if (deletedURLs != null) {
                int i = 0;
                while (i < deletedURLs.size()) {
                    URL deletedURL = (URL)deletedURLs.get(i);
                    this.addFileDeletion(deletedURL);
                    ++i;
                }
            }
            Set sourceFiles = transactions.keySet();
            int sourceFilesSize = sourceFiles.size();
            ArrayList<UndoableEdit> undoableEdits = new ArrayList<UndoableEdit>(sourceFilesSize);
            for (SourceFile sourceFile : sourceFiles) {
                URL url = sourceFile.getURL();
                if (RefactoringCommandSupport.mav$isDeletedFile(this._pendingCommand, url)) continue;
                SourceTransaction sourceTransaction = (SourceTransaction)transactions.get(sourceFile);
                try {
                    UndoableEdit undoableEdit = sourceTransaction.commit();
                    if (RefactoringCommandSupport.mav$isCreatedFile(this._pendingCommand, url)) {
                        this.addFileCreation(sourceFile);
                        Node node = NodeFactory.find((URL)url);
                        node.save();
                        continue;
                    }
                    if (undoableEdit == null) continue;
                    undoableEdits.add(undoableEdit);
                }
                catch (Exception e) {
                    System.out.println("Failed to commit " + URLFileSystem.getPlatformPathName((URL)url));
                    e.printStackTrace();
                }
            }
            this.createToDos();
            this._pendingCommand = null;
            this._undoableEdits = undoableEdits.toArray(new UndoableEdit[undoableEdits.size()]);
        }

        private void addFileCreation(SourceFile sourceFile) {
            URL url = sourceFile.getURL();
            String text = sourceFile.getText();
            if (this._createdFiles == null) {
                this._createdFiles = new HashMap(1);
                this._createdFiles.put(url, text);
            }
        }

        private void addFileDeletion(URL url) {
            try {
                TextNode node = (TextNode)NodeFactory.findOrCreate((URL)url);
                TextBuffer textBuffer = node.acquireTextBuffer();
                String text = textBuffer.getString(0, textBuffer.getLength());
                if (this._deletedFiles == null) {
                    this._deletedFiles = new HashMap(1);
                    this._deletedFiles.put(url, text);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void createNode(URL url, String text) throws IllegalAccessException, InstantiationException, IOException {
            char[] chars = text.toCharArray();
            TextNode node = (TextNode)NodeFactory.findOrCreate((URL)url);
            TextBuffer textBuffer = node.acquireTextBuffer();
            textBuffer.beginEdit();
            textBuffer.removeToEnd(0);
            textBuffer.append(chars);
            textBuffer.endEdit();
            node.releaseTextBuffer();
            node.save();
        }

        private void saveAffectedNodes() throws IOException {
            int i = 0;
            while (i < this._affectedNodes.length) {
                Node node = this._affectedNodes[i];
                node.save();
                ++i;
            }
        }
    }

    private static class CaretPositioning {
        private CodeEditor _codeEditor;
        private SourceElement _element;
        private boolean _after;

        public CaretPositioning(CodeEditor codeEditor, SourceElement element, boolean after) {
            this._codeEditor = codeEditor;
            this._element = element;
            this._after = after;
        }

        public void repositionCaret() {
            int offset = this._after ? this._element.getEndOffset() : this._element.getStartOffset();
            this._codeEditor.setCaretPosition(offset);
        }
    }
}

