/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.refactoring.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.jdeveloper.java.util.SourceElementHandle;
import oracle.jdeveloper.refactoring.model.BaseUsageEntry;
import oracle.jdevimpl.refactoring.util.AbortedOperationException;

public class SourceElementEntry
extends BaseUsageEntry
implements PropertyChangeListener {
    private SourceElementHandle _sourceElementHandle;

    public SourceElementEntry(Project project, SourceElement sourceElement, int usageType) {
        super(project, usageType);
        this._sourceElementHandle = new SourceElementHandle(sourceElement);
        this._sourceElementHandle.addPropertyChangeListener(this);
    }

    public void release() {
        this._sourceElementHandle.removePropertyChangeListener(this);
        this._sourceElementHandle.release();
    }

    public URL getURL() {
        return this._sourceElementHandle.getURL();
    }

    public int getOffset() {
        return this._sourceElementHandle.getOffset();
    }

    public int getLength() {
        int length = 0;
        SourceElement element = this.getSourceElement();
        if (element != null) {
            int startOffset = element.getStartOffset();
            int endOffset = element.getEndOffset();
            length = endOffset - startOffset;
        }
        return length;
    }

    public SourceElement getSourceElement() {
        return this._sourceElementHandle.getElement();
    }

    public SourceElement getSourceElementOrThrow() throws AbortedOperationException {
        SourceElement sourceElement = this.getSourceElement();
        if (sourceElement == null) {
            URL url = this.getURL();
            String platformPathName = URLFileSystem.getPlatformPathName((URL)url);
            throw new AbortedOperationException("The content of the file has changed:" + platformPathName);
        }
        return sourceElement;
    }

    public boolean isValid() {
        SourceElement element = this.getSourceElement();
        return element != null;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        Object oldValue = evt.getOldValue();
        Object newValue = evt.getNewValue();
        this.fireProperyChange(propertyName, oldValue, newValue);
    }
}

