/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.refactoring.util;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Dependable;
import oracle.ide.model.DependencyConfiguration;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.TextNode;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.Assert;
import oracle.ide.util.ModelUtil;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceClassInitializer;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldDeclaration;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdeveloper.refactoring.model.ProgressIndicator;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdeveloper.style.CodingStyleManager;
import oracle.jdeveloper.style.CodingStyleOptions;
import oracle.jdeveloper.usage.UsageQueryTask;
import oracle.jdeveloper.usage.util.BackgroundTask;
import oracle.jdevimpl.refactoring.model.SearchOperationImpl;

public class Util {
    private static final boolean WAIT_WITH_SLEEP = true;
    private static final int SLEEP_TIME = 25;
    private static final int REFRESH_RATE = 500;
    public static final Comparator SOURCE_ELEMENT_POSITION_COMPARATOR = new 1();

    public static void waitUntilFinished(UsageQueryTask task, ProgressIndicator progressIndicator) {
        int lastRefresh = 500;
        while (!task.isFinished()) {
            if (lastRefresh >= 500) {
                if (progressIndicator != null) {
                    String progressText = task.getProgressText();
                    progressIndicator.setProgressStepText(progressText);
                    lastRefresh = 0;
                }
            } else {
                lastRefresh += 25;
            }
            Util.sleep();
        }
    }

    public static void waitUntilFinished(BackgroundTask task) {
        while (!task.isFinished()) {
            Util.sleep();
        }
    }

    public static void waitUntilFinished(BackgroundTask task, ProgressIndicator progressIndicator) {
        int lastRefresh = 500;
        while (!(task.isFinished() || progressIndicator != null && progressIndicator.isUserCancelled())) {
            if (lastRefresh >= 500) {
                if (progressIndicator != null) {
                    String progressText = task.getProgressText();
                    progressIndicator.setProgressStepText(progressText);
                    lastRefresh = 0;
                }
            } else {
                lastRefresh += 25;
            }
            Util.sleep();
        }
    }

    public static TextNode getTextNode(URL url) {
        TextNode ret = null;
        try {
            ret = (TextNode)NodeFactory.findOrCreate((URL)url);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static TextBuffer getTextBuffer(URL url) {
        TextBuffer ret = null;
        TextNode textNode = Util.getTextNode(url);
        if (textNode != null) {
            ret = textNode.acquireTextBuffer();
        }
        return ret;
    }

    public static void setMnemonic(AbstractButton abstractButton, String label) {
        int mnemonicKeyCode = StringUtils.getMnemonicKeyCode((String)label);
        abstractButton.setMnemonic(mnemonicKeyCode);
        int mnemonicIndex = StringUtils.getMnemonicIndex((String)label);
        if (mnemonicIndex != -1) {
            abstractButton.setDisplayedMnemonicIndex(mnemonicIndex);
        }
    }

    public static boolean isJavaSource(URL url) {
        String fileName = url.getFile();
        if (fileName != null) {
            String lcFileName = fileName.toLowerCase();
            return lcFileName.endsWith(".java") || lcFileName.endsWith(".sqlj");
        }
        return false;
    }

    public static String cutLongFileName(URL url, int maxLength) {
        String fileName = URLFileSystem.getPlatformPathName((URL)url);
        int length = fileName.length();
        if (length > maxLength) {
            int halfLength = maxLength / 2;
            int leftEnd = 5;
            int i = halfLength;
            while (i > 5) {
                char c = fileName.charAt(i);
                if (c == '/' || c == '\\') {
                    leftEnd = i + 1;
                }
                --i;
            }
            int rightStart = length - 5;
            int i2 = length - halfLength;
            while (i2 < length - 5) {
                char c = fileName.charAt(i2);
                if (c == '/' || c == '\\') {
                    rightStart = i2;
                }
                ++i2;
            }
            fileName = fileName.substring(0, leftEnd) + "..." + fileName.substring(rightStart);
        }
        return fileName;
    }

    private static void sleep() {
        try {
            Thread.sleep(25);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static String getPackageName(String fqClassName) {
        int lastDot = fqClassName.lastIndexOf(46);
        if (lastDot > 0) {
            return fqClassName.substring(0, lastDot);
        }
        return "";
    }

    public static String getClassName(String fqClassName) {
        int lastDot = fqClassName.lastIndexOf(46);
        if (lastDot != -1) {
            fqClassName = fqClassName.substring(lastDot + 1);
        }
        fqClassName.replace('$', '.');
        return fqClassName;
    }

    public static String getFqClassName(String pkg, String className) {
        if (ModelUtil.hasLength((String)pkg)) {
            return pkg + "." + className;
        }
        return className;
    }

    public static String getFqClassName(String pkg, String owningClass, String className) {
        String res = "";
        if (pkg != null && pkg.length() != 0) {
            res = res + pkg + '.';
        }
        if (owningClass != null && owningClass.length() != 0) {
            res = res + owningClass + '.';
        }
        res = res + className;
        return res;
    }

    public static void openEditor(Context context, URL url) {
        Context editorContext = new Context(context);
        try {
            Node node = NodeFactory.findOrCreate((URL)url);
            node.setURL(url);
            editorContext.setNode(node);
            EditorManager editorManager = EditorManager.getEditorManager();
            editorManager.openEditorInFrame(CodeEditor.class, editorContext);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static HashSet getDependentProjects(Workspace workspace, Project baseProject) {
        HashSet projectsSet = new HashSet();
        Util.getDependantProjects(workspace, baseProject, projectsSet);
        return projectsSet;
    }

    private static void getDependantProjects(Workspace workspace, Project baseProject, HashSet projectsSet) {
        Iterator projectIterator = workspace.getChildren();
        List projects = Util.iteratorAsList(projectIterator);
        HashSet dependentProjects = new HashSet();
        Util.getDependantProjects(baseProject, projects, dependentProjects);
        projectsSet.addAll(dependentProjects);
    }

    private static void getDependantProjects(Project project, List projects, HashSet dependentProjects) {
        if (!dependentProjects.contains(project)) {
            dependentProjects.add(project);
            int i = 0;
            while (i < projects.size()) {
                Project project_i = (Project)projects.get(i);
                Iterator dependencies = DependencyConfiguration.getInstance((Project)project_i).getDependencies();
                while (dependencies.hasNext()) {
                    Project dependentProject;
                    Dependable dependable = (Dependable)dependencies.next();
                    Element dependableSource = dependable.getSource();
                    if (!(dependableSource instanceof Project) || !project.equals((Object)(dependentProject = (Project)dependableSource))) continue;
                    Util.getDependantProjects(project_i, projects, dependentProjects);
                }
                ++i;
            }
        }
    }

    public static void showRefactoringErrorMessage(int messageKey) {
        Util.showRefactoringErrorMessage(null, messageKey);
    }

    public static void showRefactoringErrorMessage(int titleKey, int messageKey) {
        String title = titleKey == -1 ? "Refactoring" : RefactoringArb.getString(titleKey);
        Util.showRefactoringErrorMessage(title, messageKey);
    }

    private static void showRefactoringErrorMessage(String title, int messageKey) {
        String message = RefactoringArb.getString(messageKey);
        Util.showRefactoringErrorMessage(title, message);
    }

    public static void showRefactoringErrorMessage(String title, String message) {
        IdeMainWindow mainWindow = Ide.getMainWindow();
        if (mainWindow != null) {
            MessageDialog.information((Component)mainWindow, (Object)message, (String)(title == null ? "Refactoring" : title), null);
        }
    }

    static boolean isClassInSources(Workspace workspace, Project project, URL url) {
        Project definingProject = Util.getDefiningProject(workspace, project, url);
        boolean ret = definingProject != null;
        return ret;
    }

    public static boolean canRefactor(SourceElement sourceElement) {
        URL url;
        SourceFile owningFile;
        return sourceElement != null && (owningFile = sourceElement.getOwningSourceFile()) != null && (url = owningFile.getURL()) != null && Util.canRefactor(url);
    }

    public static boolean canRefactor(Context context) {
        URL url;
        Node node = context.getNode();
        if (node != null && (url = node.getURL()) != null) {
            return Util.canRefactor(context, url);
        }
        return false;
    }

    public static boolean canRefactor(Context context, URL url) {
        return Util.canRefactor(url) && Util.projectContains(context.getProject(), url);
    }

    private static boolean workspaceContains(Context context, URL url) {
        Workspace workspace;
        if (context != null) {
            workspace = context.getWorkspace();
        } else {
            Assert.println((String)"Cannot refactor without a valid context. Using the active workspace as a workaround");
            Assert.printStackTrace();
            workspace = Ide.getActiveWorkspace();
        }
        Project activeProject = context.getProject();
        if (Util.projectContains(activeProject, url)) {
            return true;
        }
        Iterator projects = workspace.getChildren();
        while (projects.hasNext()) {
            Project project = (Project)projects.next();
            if (!Util.projectContains(project, url)) continue;
            return true;
        }
        return false;
    }

    private static boolean projectContains(Project project, URL url) {
        PathsConfiguration pathsConfiguration;
        URLPath sourcePath;
        boolean ret = false;
        if (project != null && (sourcePath = (pathsConfiguration = PathsConfiguration.getInstance((Project)project)).getProjectSourcePath()).getLongestMatchingEntry(url) != null) {
            ret = true;
        }
        return ret;
    }

    public static boolean canRefactor(URL url) {
        boolean ret = false;
        try {
            Node node = NodeFactory.findOrCreate((URL)url);
            if (node != null && Util.canMakeReadWrite(url)) {
                ret = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    private static boolean canMakeReadWrite(URL url) {
        String protocol = url.getProtocol();
        return !protocol.equalsIgnoreCase("jar") && !protocol.equalsIgnoreCase("zip");
    }

    public static boolean hasUpperCase(String text) {
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (Character.isUpperCase(c)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isPackagePrivate(int modifiers) {
        return (modifiers & 7) == 0;
    }

    public static boolean isClassInSources(Workspace workspace, Project project, SourceClass sourceClass) {
        boolean ret = false;
        if (sourceClass != null) {
            SourceFile sourceFile = sourceClass.getOwningSourceFile();
            URL url = sourceFile.getURL();
            ret = Util.isClassInSources(workspace, project, url);
        }
        return ret;
    }

    public static SourceElement getAncestorOfClass(Class cls, SourceElement sourceElement) {
        while (sourceElement != null) {
            if (cls.isInstance(sourceElement)) {
                return sourceElement;
            }
            sourceElement = sourceElement.getParent();
        }
        return null;
    }

    public static SourceElement getAncestorOfKind(int symbolKind, SourceElement sourceElement) {
        while (sourceElement != null) {
            if (sourceElement.getSymbolKind() == symbolKind) {
                return sourceElement;
            }
            sourceElement = sourceElement.getParent();
        }
        return null;
    }

    public static String[] getFqParamTypes(JavaMethod javaMethod) {
        Collection parameters = javaMethod.getParameters();
        String[] parameterTypes = new String[parameters.size()];
        int pos = 0;
        for (JavaVariable javaVariable : parameters) {
            String typeName = "";
            JavaType resolvedType = javaVariable.getResolvedType();
            if (resolvedType != null) {
                typeName = resolvedType.getQualifiedName();
            } else {
                SourceTypeReference sourceType;
                SourceVariable sourceVariable = (SourceVariable)javaVariable.getSourceElement();
                if (sourceVariable != null && (sourceType = sourceVariable.getSourceType()) != null) {
                    typeName = sourceType.getName();
                }
            }
            parameterTypes[pos++] = typeName;
        }
        return parameterTypes;
    }

    public static String getFullMethodName(JavaMethod method, boolean includeClassName, boolean fqClassName, boolean fqParamNames) {
        String className = null;
        if (includeClassName) {
            JavaClass declaringClass = method.getOwningClass();
            className = fqClassName ? declaringClass.getQualifiedName() : declaringClass.getName();
        }
        String methodName = method.isConstructor() ? method.getOwningClass().getName() : method.getName();
        Collection parameterTypes = method.getParameters();
        String[] parameterTypeNames = new String[parameterTypes.size()];
        Iterator iterator = parameterTypes.iterator();
        int i = 0;
        while (i < parameterTypeNames.length) {
            JavaVariable javaVariable = (JavaVariable)iterator.next();
            JavaType parameterType = javaVariable.getResolvedType();
            parameterTypeNames[i] = parameterType != null ? (fqParamNames ? parameterType.getQualifiedName() : parameterType.getName()) : "???";
            ++i;
        }
        return Util.getFullMethodName(className, methodName, parameterTypeNames);
    }

    public static String getFullMethodName(String className, String methodName, String[] parameterTypes) {
        StringBuffer sb = new StringBuffer();
        if (className != null) {
            sb.append(className);
            sb.append('.');
        }
        sb.append(methodName);
        sb.append('(');
        int i = 0;
        while (i < parameterTypes.length) {
            String parameterType = parameterTypes[i];
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(parameterType);
            ++i;
        }
        sb.append(')');
        return sb.toString();
    }

    public static SourceElement getStatementLevelElement(SourceElement sourceElement) {
        SourceElement parent = sourceElement.getParent();
        while (parent != null) {
            int symbolKind = parent.getSymbolKind();
            if (symbolKind == 2) {
                return sourceElement;
            }
            sourceElement = parent;
            parent = parent.getParent();
        }
        return null;
    }

    public static boolean setReadOnly(URL url, boolean readOnly) {
        boolean ret = false;
        String[] cmdarray = null;
        String platformPathName = URLFileSystem.getPlatformPathName((URL)url);
        String osName = System.getProperty("os.name", "");
        if (osName.startsWith("Windows")) {
            cmdarray = new String[]{"ATTRIB", readOnly ? "+R" : "-R", '\"' + platformPathName + '\"'};
        } else if (platformPathName.equalsIgnoreCase("Linux")) {
            cmdarray = new String[]{"chmod", readOnly ? "u-w" : "u+w", '\"' + platformPathName + '\"'};
        }
        if (cmdarray != null) {
            Runtime runtime = Runtime.getRuntime();
            try {
                Node node;
                Process process = runtime.exec(cmdarray);
                if (process.waitFor() == 0 && (ret = new File(platformPathName).canWrite()) && (node = NodeFactory.find((URL)url)) instanceof TextNode) {
                    TextNode textNode = (TextNode)node;
                    textNode.isReadOnly();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public static boolean isInCallToConstructor(SourceElement sourceElement) {
        while (sourceElement != null) {
            int nodeID = sourceElement.getSymbolKind();
            switch (nodeID) {
                case 53: {
                    SourceMethodCallExpression sourceMethodCallExpression = (SourceMethodCallExpression)sourceElement;
                    JavaMethod resolvedMethod = sourceMethodCallExpression.getResolvedMethod();
                    if (resolvedMethod == null || !resolvedMethod.isConstructor()) break;
                    return true;
                }
                case 2: {
                    return false;
                }
            }
            sourceElement = sourceElement.getParent();
        }
        return false;
    }

    public static URL createTypeURL(Context context, String pkgName, String typeName) {
        Project project = context.getProject();
        PathsConfiguration pathsConfiguration = PathsConfiguration.getInstance((Project)project);
        URLPath projectSourcePath = pathsConfiguration.getProjectSourcePath();
        URL[] entries = projectSourcePath.getEntries();
        URL entry = entries[0];
        String pathSuffix = pkgName.replace('.', '/');
        entry = URLFactory.newURL((URL)entry, (String)pathSuffix);
        int firstDot = typeName.indexOf(46);
        String fileName = firstDot != -1 ? typeName.substring(0, firstDot - 1) : typeName;
        URL fileURL = URLFactory.newURL((URL)entry, (String)(fileName + ".java"));
        return fileURL;
    }

    public static String getIndentString() {
        CodingStyleManager csm = CodingStyleManager.getCodingStyleManager();
        CodingStyleOptions styleOptions = csm.getCodingStyleOptions();
        return new String(styleOptions.getIndentChars(1));
    }

    public static Project[] getAffectedProjects(Workspace workspace, URL url) {
        HashSet<Project> ret = new HashSet<Project>();
        Project[] projectsContainingSource = Util.getProjectsContainingSource(workspace, url);
        ArrayList<Project> rootProjects = new ArrayList<Project>(Arrays.asList(projectsContainingSource));
        while (!rootProjects.isEmpty()) {
            Project project = rootProjects.remove(0);
            ret.add(project);
            Iterator dependencies = DependencyConfiguration.getInstance((Project)project).getDependencies();
            while (dependencies.hasNext()) {
                Dependable dependable = (Dependable)dependencies.next();
                Project dependentProject = (Project)dependable.getSource();
                rootProjects.add(dependentProject);
            }
        }
        return ret.toArray(new Project[ret.size()]);
    }

    public static Project[] getProjectsContainingSource(Workspace workspace, URL url) {
        ArrayList<Project> ret = new ArrayList<Project>();
        Iterator children = workspace.getChildren();
        while (children.hasNext()) {
            Project project = (Project)children.next();
            ContentSet allContents = ProjectContent.getInstance((PropertyStorage)project).getAllContents();
            if (!allContents.canHaveMember(url)) continue;
            ret.add(0, project);
        }
        return ret.toArray(new Project[ret.size()]);
    }

    public static Project getDefiningProject(Context context, URL url) {
        Project activeProject = context.getProject();
        Workspace workspace = context.getWorkspace();
        return Util.getDefiningProject(workspace, activeProject, url);
    }

    private static Project getDefiningProject(Workspace workspace, Project activeProject, URL url) {
        Project definingProject;
        block0: {
            definingProject = null;
            if (!Util.isDefiningProject(activeProject, url)) break block0;
            definingProject = activeProject;
        }
        return definingProject;
    }

    private static boolean isDefiningProject(Project project, URL url) {
        ContentSet activeContent = ProjectContent.getInstance((PropertyStorage)project).getAllContents();
        return activeContent.canHaveMember(url);
    }

    public static boolean isStaticContext(SourceExpression sourceExpression) {
        SourceExpression parent = sourceExpression;
        while (parent != null) {
            switch (parent.getSymbolKind()) {
                case 19: {
                    return ((SourceMethod)parent).isStatic();
                }
                case 6: {
                    return false;
                }
                case 9: {
                    return ((SourceFieldDeclaration)parent).isStatic();
                }
                case 5: {
                    return ((SourceClassInitializer)parent).isStatic();
                }
            }
            parent = parent.getParent();
        }
        return false;
    }

    public static SourceTypeReference createSourceType(SourceTypeReference originalSourceType, SourceFile targetFile) {
        SourceTypeReference ret;
        JavaType resolvedType = originalSourceType.getResolvedType();
        if (resolvedType != null) {
            SourceFactory factory = targetFile.getFactory();
            ret = factory.createType(resolvedType.getQualifiedName());
        } else {
            ret = (SourceTypeReference)originalSourceType.cloneSelf(targetFile);
        }
        return ret;
    }

    public static void setOperationHints(SearchOperationImpl searchOperation, JavaMember[] javaMembers) {
        if (javaMembers.length > 0) {
            SourceMember sourceMember;
            int maxRestriction = 2;
            int i = 0;
            while (maxRestriction > 0 && i < javaMembers.length) {
                JavaMember javaMember = javaMembers[i];
                int thisRestriction = javaMember.isPrivate() ? 2 : (javaMember.isPackagePrivate() ? 1 : 0);
                maxRestriction = Math.min(maxRestriction, thisRestriction);
                ++i;
            }
            if (maxRestriction > 0 && (sourceMember = (SourceMember)javaMembers[0].getSourceElement()) != null) {
                SourceFile owningSourceFile = sourceMember.getOwningSourceFile();
                switch (maxRestriction) {
                    case 2: {
                        URL fileUrl = owningSourceFile.getURL();
                        searchOperation.setSearchHintFile(fileUrl);
                        break;
                    }
                    case 1: {
                        String packageName = owningSourceFile.getPackageName();
                        searchOperation.setSearchHintPackage(packageName);
                        break;
                    }
                }
            }
        }
    }

    public static void setOperationHints(SearchOperationImpl searchOperation, JavaMember javaMember, boolean overloadedMethods) {
        JavaMember[] javaMembers;
        if (overloadedMethods) {
            JavaClass owningClass = javaMember.getOwningClass();
            Collection methods = owningClass.getDeclaredMethods(javaMember.getName());
            javaMembers = methods.toArray(new JavaMember[methods.size()]);
        } else {
            javaMembers = new JavaMember[]{javaMember};
        }
        Util.setOperationHints(searchOperation, javaMembers);
    }

    public static void setOperationHints(SearchOperationImpl searchOperation, JavaClass javaClass, boolean includeMembers) {
        JavaClass owningClass = javaClass.getOwningClass();
        if (owningClass != null) {
            JavaMember[] javaMembers;
            if (includeMembers) {
                ArrayList<JavaClass> allMembers = new ArrayList<JavaClass>();
                allMembers.add(owningClass);
                allMembers.addAll(owningClass.getDeclaredMethods());
                allMembers.addAll(owningClass.getDeclaredFields());
                allMembers.addAll(owningClass.getDeclaredClasses());
                javaMembers = allMembers.toArray(new JavaMember[allMembers.size()]);
            } else {
                javaMembers = new JavaMember[]{javaClass};
            }
            Util.setOperationHints(searchOperation, javaMembers);
        }
    }

    public static void dumpProjectDependencies(Workspace workspace) {
        List allProjects = Util.iteratorAsList(workspace.getChildren());
        HashSet roots = new HashSet(allProjects);
        System.out.println("---------------------------------------------------");
        int i = 0;
        while (i < allProjects.size()) {
            Project project = (Project)allProjects.get(i);
            Iterator dependencies = DependencyConfiguration.getInstance((Project)project).getDependencies();
            while (dependencies.hasNext()) {
                Dependable dependable = (Dependable)dependencies.next();
                Element dependableSource = dependable.getSource();
                if (!(dependableSource instanceof Project)) continue;
                System.out.println(project.getShortLabel() + " depends on " + dependableSource.getShortLabel());
                roots.remove(project);
            }
            ++i;
        }
        System.out.println("---------------------------------------------------");
        for (Project project : roots) {
            System.out.println(project.getShortLabel());
            Util.dumpDependencies(workspace, project, "  ", new HashSet());
        }
    }

    private static void dumpDependencies(Workspace workspace, Project project, String indent, HashSet visited) {
        Iterator allProjects = workspace.getChildren();
        while (allProjects.hasNext()) {
            Project project_i = (Project)allProjects.next();
            if (visited.contains(project_i)) continue;
            Iterator dependencies = DependencyConfiguration.getInstance((Project)project_i).getDependencies();
            while (dependencies.hasNext()) {
                Dependable dependable = (Dependable)dependencies.next();
                Element dependableSource = dependable.getSource();
                if (!dependableSource.equals(project)) continue;
                String label = project_i.getShortLabel();
                System.out.println(indent + label);
                visited.add(project_i);
                Util.dumpDependencies(workspace, project_i, indent + "  ", visited);
                visited.remove(project_i);
            }
        }
    }

    private static List iteratorAsList(Iterator i) {
        ArrayList list = new ArrayList(10);
        while (i.hasNext()) {
            list.add(i.next());
        }
        return list;
    }

    static final class 1
    implements Comparator {
        public int compare(Object o1, Object o2) {
            SourceElement sourceElement1 = (SourceElement)o1;
            SourceElement sourceElement2 = (SourceElement)o2;
            return sourceElement1.getStartOffset() - sourceElement2.getStartOffset();
        }
    }
}

