/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.runner;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.controls.GridBagConstraints2;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.HistoryList;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.runner.RunMgrArb;

public final class RemoteConnectDialog {
    private JEWTDialog dlg;
    private JPanel panel;
    private Listener listener;
    private int count;
    private String[] names;
    private String[] values;
    private boolean[] allowBlanks;
    private boolean[] save;
    private JLabel[] labels;
    private HistoryList[] historyLists;
    private JComboBox[] comboBoxes;
    private JTextField[] editors;
    private JCheckBox saveCheckBox;
    private JCheckBox attachToDebugWithPid;
    private JCheckBox attachToLiveWithPid;
    private boolean[] isAttachPid;
    private int subIndex;
    private static final String HistoryNamePrefix = "RemoteConnect";

    private void $init$() {
        this.attachToDebugWithPid = null;
        this.attachToLiveWithPid = null;
        this.isAttachPid = null;
        this.subIndex = -1;
    }

    public static boolean showRemoteConnectDialog(String title, String[] names, String[] values, boolean[] allowBlanks) {
        return RemoteConnectDialog.showRemoteConnectDialog(title, names, values, allowBlanks, null, null, null);
    }

    public static boolean showRemoteConnectDialog(String title, String[] names, String[] values, boolean[] allowBlanks, String helpId) {
        return RemoteConnectDialog.showRemoteConnectDialog(title, names, values, allowBlanks, null, helpId, null);
    }

    public static boolean showRemoteConnectDialog(String title, String[] names, String[] values, boolean[] allowBlanks, boolean[] save) {
        return RemoteConnectDialog.showRemoteConnectDialog(title, names, values, allowBlanks, save, null, null);
    }

    public static boolean showRemoteConnectDialog(String title, String[] names, String[] values, boolean[] allowBlanks, boolean[] save, String helpId) {
        return RemoteConnectDialog.showRemoteConnectDialog(title, names, values, allowBlanks, save, helpId, null);
    }

    public static boolean showRemoteConnectDialog(String title, String[] names, String[] values, boolean[] allowBlanks, boolean[] save, String helpId, boolean[] isAttachPid) {
        int count = names.length;
        if (values.length != count) {
            throw new IllegalArgumentException("values.length must equal names.length");
        }
        if (allowBlanks.length != count) {
            throw new IllegalArgumentException("allowBlanks.length must equal names.length");
        }
        if (save != null && save.length != 1) {
            throw new IllegalArgumentException("save.length must be 1");
        }
        RemoteConnectDialog rcd = new RemoteConnectDialog(names, values, allowBlanks, save, isAttachPid);
        JEWTDialog dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)rcd.panel, (Component)rcd.getInitialFocus(), (String)title);
        rcd.setJEWTDialog(dlg);
        rcd.setLabels();
        dlg.setOKButtonEnabled(rcd.canOk());
        if (helpId != null) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)rcd.panel, helpId);
        }
        if (WizardLauncher.runDialog((JDialog)dlg)) {
            rcd.finish();
            return true;
        }
        return false;
    }

    private RemoteConnectDialog(String[] names, String[] values, boolean[] allowBlanks, boolean[] save, boolean[] isAttachPid) {
        this.$init$();
        this.panel = new JPanel(new GridBagLayout());
        this.listener = new Listener();
        int jdiAttachMethodIndex = -1;
        int substr = 0;
        int n = 0;
        while (n < names.length) {
            if (names[n].equals("jdi_attach_method:")) {
                jdiAttachMethodIndex = n;
                ++substr;
                this.subIndex = n;
                break;
            }
            ++n;
        }
        this.count = names.length;
        this.names = names;
        this.values = values;
        this.allowBlanks = allowBlanks;
        this.save = save;
        this.isAttachPid = isAttachPid;
        int y = 0;
        this.labels = new JLabel[this.count - substr];
        this.comboBoxes = new JComboBox[this.count - substr];
        this.editors = new JTextField[this.count - substr];
        this.historyLists = new HistoryList[this.count - substr];
        int substract = 0;
        int i = 0;
        while (i < this.count) {
            if (i == jdiAttachMethodIndex) {
                ++substract;
            } else {
                this.labels[i - substract] = new JLabel();
                this.historyLists[i - substract] = Ide.loadHistoryList((String)(HistoryNamePrefix + names[i]));
                this.comboBoxes[i - substract] = new JComboBox<String>(this.historyLists[i - substract].getHistory());
                this.comboBoxes[i - substract].setEditable(true);
                this.editors[i - substract] = (JTextField)this.comboBoxes[i - substract].getEditor().getEditorComponent();
                this.comboBoxes[i - substract].addActionListener(this.listener);
                String value = values[i - substract];
                if (value != null) {
                    IdeUtil.comboBoxSelectItem((JComboBox)this.comboBoxes[i - substract], (Object)values[i - substract]);
                }
                IdeUtil.addComboBoxDocumentListener((JComboBox)this.comboBoxes[i - substract], (DocumentListener)this.listener);
                this.comboBoxes[i - substract].addItemListener(this.listener);
                this.panel.add((Component)this.labels[i - substract], new GridBagConstraints2(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
                this.panel.add((Component)this.comboBoxes[i - substract], new GridBagConstraints2(1, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
            }
            ++i;
        }
        if (save != null) {
            this.saveCheckBox = new JCheckBox();
            ResourceUtils.resButton((AbstractButton)this.saveCheckBox, (String)RunMgrArb.getString(47));
            this.panel.add((Component)this.saveCheckBox, new GridBagConstraints2(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        }
        this.panel.add((Component)new JLabel(), new GridBagConstraints2(0, y, 0, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    private Component getInitialFocus() {
        if (this.editors.length > 0) {
            return this.editors[0];
        }
        return null;
    }

    private void setJEWTDialog(JEWTDialog dlg) {
        this.dlg = dlg;
    }

    private void setLabels() {
        int mn;
        int mn2;
        int mn3;
        int mn4;
        int buttonMask;
        int mn5;
        int mn6;
        int mn7;
        ArrayList<Integer> mnemonics = new ArrayList<Integer>();
        if (this.saveCheckBox != null && (mn7 = this.saveCheckBox.getMnemonic()) != 0) {
            mnemonics.add(new Integer(mn7));
        }
        if (this.attachToDebugWithPid != null && (mn6 = this.attachToDebugWithPid.getMnemonic()) != 0) {
            mnemonics.add(new Integer(mn6));
        }
        if (this.attachToLiveWithPid != null && (mn5 = this.attachToLiveWithPid.getMnemonic()) != 0) {
            mnemonics.add(new Integer(mn5));
        }
        if (((buttonMask = this.dlg.getButtonMask()) & 1) != 0 && (mn4 = this.dlg.getButtonMnemonic(1)) != 0) {
            mnemonics.add(new Integer(mn4));
        }
        if ((buttonMask & 2) != 0 && (mn3 = this.dlg.getButtonMnemonic(2)) != 0) {
            mnemonics.add(new Integer(mn3));
        }
        if ((buttonMask & 4) != 0 && (mn2 = this.dlg.getButtonMnemonic(4)) != 0) {
            mnemonics.add(new Integer(mn2));
        }
        if ((buttonMask & 8) != 0 && (mn = this.dlg.getButtonMnemonic(8)) != 0) {
            mnemonics.add(new Integer(mn));
        }
        int substract = 0;
        int i = 0;
        while (i < this.count) {
            if (this.names[i].equals("jdi_attach_method:")) {
                ++substract;
            } else {
                String n = this.names[i];
                int ic = 0;
                while (ic < n.length()) {
                    Integer m;
                    char c = n.charAt(ic);
                    if (c >= 'a' && c <= 'z') {
                        c = (char)(c - 32);
                    }
                    if ((c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') && !mnemonics.contains(m = new Integer(c))) {
                        mnemonics.add(m);
                        n = n.substring(0, ic) + "&" + n.substring(ic);
                        break;
                    }
                    ++ic;
                }
                ResourceUtils.resLabel((JLabel)this.labels[i - substract], (Component)this.editors[i - substract], (String)RunMgrArb.format(14, n));
            }
            ++i;
        }
    }

    private void enableOk() {
        this.dlg.setOKButtonEnabled(this.canOk());
    }

    private boolean canOk() {
        int substract = 0;
        int i = 0;
        while (i < this.count) {
            String value;
            if (i == this.subIndex) {
                ++substract;
            } else if (!this.allowBlanks[i - substract] && (value = this.editors[i - substract].getText()).length() == 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void finish() {
        int substract = 0;
        int i = 0;
        while (i < this.count) {
            if (i == this.subIndex) {
                ++substract;
                ++substract;
            }
            this.values[i - substract] = this.historyLists[i - substract].comboBoxGetSelectedItem(this.comboBoxes[i - substract]);
            ++i;
        }
        if (this.save != null) {
            this.save[0] = this.saveCheckBox.isSelected();
        }
        if (this.attachToDebugWithPid != null) {
            this.isAttachPid[1] = this.attachToDebugWithPid.isSelected();
        }
        if (this.attachToLiveWithPid != null) {
            this.isAttachPid[2] = this.attachToLiveWithPid.isSelected();
        }
    }

    static void mav$enableOk(RemoteConnectDialog remoteConnectDialog) {
        remoteConnectDialog.enableOk();
    }

    static JCheckBox ra$attachToDebugWithPid(RemoteConnectDialog remoteConnectDialog) {
        return remoteConnectDialog.attachToDebugWithPid;
    }

    static JCheckBox ra$attachToLiveWithPid(RemoteConnectDialog remoteConnectDialog) {
        return remoteConnectDialog.attachToLiveWithPid;
    }

    static JComboBox[] ra$comboBoxes(RemoteConnectDialog remoteConnectDialog) {
        return remoteConnectDialog.comboBoxes;
    }

    static int ra$subIndex(RemoteConnectDialog remoteConnectDialog) {
        return remoteConnectDialog.subIndex;
    }

    static JTextField[] ra$editors(RemoteConnectDialog remoteConnectDialog) {
        return remoteConnectDialog.editors;
    }

    static int ra$count(RemoteConnectDialog remoteConnectDialog) {
        return remoteConnectDialog.count;
    }

    class Listener
    implements ActionListener,
    DocumentListener,
    ItemListener {
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (RemoteConnectDialog.ra$attachToDebugWithPid(RemoteConnectDialog.this) != null && RemoteConnectDialog.ra$attachToDebugWithPid(RemoteConnectDialog.this) == source) {
                if (RemoteConnectDialog.ra$attachToLiveWithPid(RemoteConnectDialog.this) != null && RemoteConnectDialog.ra$attachToLiveWithPid(RemoteConnectDialog.this).isSelected()) {
                    RemoteConnectDialog.ra$attachToLiveWithPid(RemoteConnectDialog.this).setSelected(false);
                }
                if (RemoteConnectDialog.ra$attachToDebugWithPid(RemoteConnectDialog.this).isSelected()) {
                    RemoteConnectDialog.ra$comboBoxes(RemoteConnectDialog.this)[0].setSelectedItem(null);
                    RemoteConnectDialog.ra$comboBoxes(RemoteConnectDialog.this)[0].setEnabled(false);
                } else {
                    RemoteConnectDialog.ra$comboBoxes(RemoteConnectDialog.this)[0].setEnabled(true);
                }
                return;
            }
            if (RemoteConnectDialog.ra$attachToLiveWithPid(RemoteConnectDialog.this) != null && RemoteConnectDialog.ra$attachToLiveWithPid(RemoteConnectDialog.this) == source) {
                if (RemoteConnectDialog.ra$attachToDebugWithPid(RemoteConnectDialog.this) != null && RemoteConnectDialog.ra$attachToDebugWithPid(RemoteConnectDialog.this).isSelected()) {
                    RemoteConnectDialog.ra$attachToDebugWithPid(RemoteConnectDialog.this).setSelected(false);
                }
                if (RemoteConnectDialog.ra$attachToLiveWithPid(RemoteConnectDialog.this).isSelected()) {
                    RemoteConnectDialog.ra$comboBoxes(RemoteConnectDialog.this)[0].setSelectedItem(null);
                    RemoteConnectDialog.ra$comboBoxes(RemoteConnectDialog.this)[0].setEnabled(false);
                } else {
                    RemoteConnectDialog.ra$comboBoxes(RemoteConnectDialog.this)[0].setEnabled(true);
                }
                return;
            }
            int substract = 0;
            int i = 0;
            while (i < RemoteConnectDialog.ra$count(RemoteConnectDialog.this)) {
                if (i == RemoteConnectDialog.ra$subIndex(RemoteConnectDialog.this)) {
                    ++substract;
                } else if (source == RemoteConnectDialog.ra$comboBoxes(RemoteConnectDialog.this)[i - substract]) {
                    RemoteConnectDialog.ra$editors(RemoteConnectDialog.this)[i - substract].setText((String)RemoteConnectDialog.ra$comboBoxes(RemoteConnectDialog.this)[i - substract].getSelectedItem());
                    break;
                }
                ++i;
            }
        }

        public void changedUpdate(DocumentEvent e) {
            RemoteConnectDialog.mav$enableOk(RemoteConnectDialog.this);
        }

        public void insertUpdate(DocumentEvent e) {
            RemoteConnectDialog.mav$enableOk(RemoteConnectDialog.this);
        }

        public void removeUpdate(DocumentEvent e) {
            RemoteConnectDialog.mav$enableOk(RemoteConnectDialog.this);
        }

        public void itemStateChanged(ItemEvent e) {
            RemoteConnectDialog.mav$enableOk(RemoteConnectDialog.this);
        }

        Listener() {
        }
    }
}

