/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.runner;

import java.net.URL;
import oracle.ide.model.Project;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.runner.RunConfigurations;
import oracle.jdeveloper.runner.RunMgrArb;

public class RunConfiguration
extends HashStructureAdapter
implements PropertyStorage {
    public static final String NAME = "name";
    public static final String CUSTOM = "custom";
    public static final String RUN_DIRECTORY_URL = "runDirectoryURL";
    public static final String VM_NAME = "VMName";
    public static final String JAVA_OPTIONS = "javaOptions";
    public static final String TARGET_URL = "targetURL";
    public static final String RUN_ACTIVE_FILE = "runActiveFile";
    public static final String PROGRAM_ARGUMENTS = "programArguments";
    public static final String REMOTE_DEBUGGING_PROFILING = "remoteDebuggingProfiling";
    public static final String CONNECTION_NAME = "connectionName";
    public static final String COMPILE_BEFORE_RUN = "compileBeforeRun";
    public static final String RUN_ANT_BEFORE_RUN = "runAntBeforeRun";
    public static final String CLEAR_LOG_BEFORE_RUN = "clearLogBeforeRun";
    public static final String SAVE_ALL_BEFORE_RUN = "saveAllBeforeRun";
    public static final String LOG_COMMAND = "logCommand";
    public static final String LOG_OUTPUT = "logOutput";
    public static final String LOG_ERROR = "logError";
    public static final String ALLOW_INPUT = "allowInput";
    public static final String LOG_EXIT = "logExit";
    public static final String USE_PROXY = "useProxy";
    public static final String JS_RUN_CONFIGURATION_TYPE = "JavaScriptRunConfigurationType";
    public static final String JS_RUN_CONFIGURATION_ENABLE_BEBUG_STATEMENT = "JavaScriptRunConfigurationEnableDebugStatement";
    public static final String JS_RUN_CONFIGURATION_STOP_ON_ERROR = "JavaScriptRunConfigurationStopOnError";
    public static final String JS_RUN_CONFIGURATION_STOP_ON_EXCEPTION = "JavaScriptRunConfigurationStopOnException";
    public static final String JS_RUN_CONFIGURATION_TRANSFER_ERRORS = "JavaScriptRunConfigurationTransferErrors";
    public static final String JS_RUN_CONFIGURATION_STOP_IN_CHROME = "JavaScriptRunConfigurationStopInChrome";
    public static final String JS_RUN_CONFIGURATION_BROWSER_EXECUTABLE = "JavaScriptRunConfigurationBrowserExecutable";

    public RunConfiguration(HashStructure hash) {
        super(hash);
    }

    public RunConfiguration() {
        super(HashStructure.newInstance());
    }

    public RunConfiguration(RunConfiguration copyFrom, String name, boolean custom) {
        super(HashStructure.newInstance());
        if (copyFrom != null) {
            copyFrom.getProperties().copyTo(this._hash);
        }
        this.setName(name);
        this.setCustom(custom);
    }

    public static RunConfiguration getInstance(PropertyStorage propertyStorage) {
        if (propertyStorage instanceof Project) {
            return RunConfigurations.getActiveRunConfiguration((Project)propertyStorage);
        }
        return null;
    }

    public static RunConfiguration getRunConfiguration(Project project, String configName) {
        return RunConfiguration.getInstance((PropertyStorage)project);
    }

    public static String getDefaultName() {
        return RunMgrArb.getString(98);
    }

    public String toString() {
        return this.getName();
    }

    public HashStructure getProperties() {
        return this._hash;
    }

    public void restoreDefaults() {
        String name = this.getName();
        boolean custom = this.isCustom();
        this._hash.clear();
        this.setName(name);
        this.setCustom(custom);
    }

    public String getName() {
        return this._hash.getString(NAME, "");
    }

    public void setName(String name) {
        if (name == null) {
            name = "";
        }
        this._hash.putString(NAME, name);
    }

    public boolean isCustom() {
        return this._hash.getBoolean(CUSTOM, false);
    }

    public void setCustom(boolean custom) {
        this._hash.putBoolean(CUSTOM, custom);
    }

    public URL getRunDirectoryURL() {
        return this._hash.getURL(RUN_DIRECTORY_URL, null);
    }

    public void setRunDirectoryURL(URL runDirectoryURL) {
        if (runDirectoryURL == null || runDirectoryURL.getProtocol().equals("file")) {
            this._hash.putURL(RUN_DIRECTORY_URL, runDirectoryURL);
        }
    }

    private String getVMName() {
        return this._hash.getString(VM_NAME, "client");
    }

    public void setVMName(String vmName) {
        this._hash.putString(VM_NAME, vmName);
    }

    public String getJavaOptions() {
        return this._hash.getString(JAVA_OPTIONS, "");
    }

    public void setJavaOptions(String javaOptions) {
        if (javaOptions == null) {
            javaOptions = "";
        }
        this._hash.putString(JAVA_OPTIONS, javaOptions);
    }

    public URL getTargetURL() {
        return this._hash.getURL(TARGET_URL, null);
    }

    public void setTargetURL(URL targetURL) {
        this._hash.putURL(TARGET_URL, targetURL);
    }

    public boolean isRunActiveFile() {
        return this._hash.getBoolean(RUN_ACTIVE_FILE, true);
    }

    public void setRunActiveFile(boolean runActiveFile) {
        this._hash.putBoolean(RUN_ACTIVE_FILE, runActiveFile);
    }

    public String getProgramArguments() {
        return this._hash.getString(PROGRAM_ARGUMENTS, "");
    }

    public void setProgramArguments(String programArguments) {
        if (programArguments == null) {
            programArguments = "";
        }
        this._hash.putString(PROGRAM_ARGUMENTS, programArguments);
    }

    public boolean isRemoteDebuggingProfiling() {
        return this._hash.getBoolean(REMOTE_DEBUGGING_PROFILING, false);
    }

    public void setRemoteDebuggingProfiling(boolean remoteDebuggingProfiling) {
        this._hash.putBoolean(REMOTE_DEBUGGING_PROFILING, remoteDebuggingProfiling);
    }

    public String getConnectionName() {
        return this._hash.getString(CONNECTION_NAME, null);
    }

    public void setConnectionName(String connectionName) {
        this._hash.putString(CONNECTION_NAME, connectionName);
    }

    public boolean isCompileBeforeRun() {
        return this._hash.getBoolean(COMPILE_BEFORE_RUN, true);
    }

    public void setCompileBeforeRun(boolean compileBeforeRun) {
        this._hash.putBoolean(COMPILE_BEFORE_RUN, compileBeforeRun);
    }

    public boolean isRunAntBeforeRun() {
        return this._hash.getBoolean(RUN_ANT_BEFORE_RUN, false);
    }

    public void setRunAntBeforeRun(boolean runAntBeforeRun) {
        this._hash.putBoolean(RUN_ANT_BEFORE_RUN, runAntBeforeRun);
    }

    public boolean isClearLogBeforeRun() {
        return this._hash.getBoolean(CLEAR_LOG_BEFORE_RUN, true);
    }

    public void setClearLogBeforeRun(boolean clearLogBeforeRun) {
        this._hash.putBoolean(CLEAR_LOG_BEFORE_RUN, clearLogBeforeRun);
    }

    public boolean isSaveAllBeforeRun() {
        return this._hash.getBoolean(SAVE_ALL_BEFORE_RUN, false);
    }

    public void setSaveAllBeforeRun(boolean saveAllBeforeRun) {
        this._hash.putBoolean(SAVE_ALL_BEFORE_RUN, saveAllBeforeRun);
    }

    public boolean isLogCommand() {
        return this._hash.getBoolean(LOG_COMMAND, true);
    }

    public void setLogCommand(boolean logCommand) {
        this._hash.putBoolean(LOG_COMMAND, logCommand);
    }

    public boolean isLogOutput() {
        return this._hash.getBoolean(LOG_OUTPUT, true);
    }

    public void setLogOutput(boolean logOutput) {
        this._hash.putBoolean(LOG_OUTPUT, logOutput);
    }

    public boolean isLogError() {
        return this._hash.getBoolean(LOG_ERROR, true);
    }

    public void setLogError(boolean logError) {
        this._hash.putBoolean(LOG_ERROR, logError);
    }

    public boolean isAllowInput() {
        return this._hash.getBoolean(ALLOW_INPUT, false);
    }

    public void setAllowInput(boolean allowInput) {
        this._hash.putBoolean(ALLOW_INPUT, allowInput);
    }

    public boolean isLogExit() {
        return this._hash.getBoolean(LOG_EXIT, true);
    }

    public void setLogExit(boolean logExit) {
        this._hash.putBoolean(LOG_EXIT, logExit);
    }

    public boolean isUseProxy() {
        return this._hash.getBoolean(USE_PROXY, true);
    }

    public void setUseProxy(boolean useProxy) {
        this._hash.putBoolean(USE_PROXY, useProxy);
    }

    public String getVMName(JDK jdk) {
        return this.getVMName(jdk, null);
    }

    public String getVMName(JDK jdk, Project project) {
        String vmName = this.getVMName();
        if (jdk != null) {
            int length;
            boolean found = false;
            String defaultVM = null;
            String[] vmChoices = jdk.getInstalledVMs();
            if (vmChoices != null && (length = vmChoices.length) > 0) {
                defaultVM = vmChoices[0];
                if (vmName != null) {
                    int i = 0;
                    while (i < length) {
                        if (vmName.equals(vmChoices[i])) {
                            found = true;
                            break;
                        }
                        ++i;
                    }
                }
            }
            if (!found) {
                if (project != null) {
                    this.setVMName(defaultVM);
                    project.markDirty(true);
                }
                return defaultVM;
            }
        }
        return vmName;
    }

    public boolean usingOJVM(JDK jdk) {
        String vmName = this.getVMName(jdk, null);
        return vmName != null && vmName.startsWith("ojvm");
    }

    public boolean usingMinimal(JDK jdk) {
        String vmName = this.getVMName(jdk, null);
        return vmName != null && vmName.equals("minimal");
    }

    public boolean usingVanilla(JDK jdk) {
        String vmName = this.getVMName(jdk, null);
        return vmName != null && vmName.equals("vanilla");
    }

    public boolean usingClassic(JDK jdk) {
        String vmName = this.getVMName(jdk, null);
        return vmName != null && vmName.equals("classic");
    }

    public String getJSRunConfigurationType() {
        return this._hash.getString(JS_RUN_CONFIGURATION_TYPE, null);
    }

    public void setJSRunConfigurationType(String connectionName) {
        this._hash.putString(JS_RUN_CONFIGURATION_TYPE, connectionName);
    }

    public String getJSRunConfigurationEnableDebug() {
        return this._hash.getString(JS_RUN_CONFIGURATION_ENABLE_BEBUG_STATEMENT, null);
    }

    public void setJSRunConfigurationEnableDebug(String connectionName) {
        this._hash.putString(JS_RUN_CONFIGURATION_ENABLE_BEBUG_STATEMENT, connectionName);
    }

    public String getJSRunConfigurationStopOnError() {
        return this._hash.getString(JS_RUN_CONFIGURATION_STOP_ON_ERROR, null);
    }

    public void setJSRunConfigurationStopOnError(String connectionName) {
        this._hash.putString(JS_RUN_CONFIGURATION_STOP_ON_ERROR, connectionName);
    }

    public String getJSRunConfigurationStopOnException() {
        return this._hash.getString(JS_RUN_CONFIGURATION_STOP_ON_EXCEPTION, null);
    }

    public void setJSRunConfigurationStopOnException(String connectionName) {
        this._hash.putString(JS_RUN_CONFIGURATION_STOP_ON_EXCEPTION, connectionName);
    }

    public String getJSRunConfigurationTransferErrors() {
        return this._hash.getString(JS_RUN_CONFIGURATION_TRANSFER_ERRORS, null);
    }

    public void setJSRunConfigurationTransferErrors(String connectionName) {
        this._hash.putString(JS_RUN_CONFIGURATION_TRANSFER_ERRORS, connectionName);
    }

    public String getJSRunConfigurationStopInChrome() {
        return this._hash.getString(JS_RUN_CONFIGURATION_STOP_IN_CHROME, null);
    }

    public void setJSRunConfigurationStopInChrome(String connectionName) {
        this._hash.putString(JS_RUN_CONFIGURATION_STOP_IN_CHROME, connectionName);
    }

    public String getJSRunConfigurationBrowserExecutable() {
        return this._hash.getString(JS_RUN_CONFIGURATION_BROWSER_EXECUTABLE, null);
    }

    public void setJSRunConfigurationBrowserExecutable(String connectionName) {
        this._hash.putString(JS_RUN_CONFIGURATION_BROWSER_EXECUTABLE, connectionName);
    }
}

