/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.runner;

import java.awt.Component;
import java.util.List;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.help.HelpInfo;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.log.LogWindow;
import oracle.ide.model.Node;
import oracle.ide.resource.IdeArb;
import oracle.ide.runner.RunLogPage;
import oracle.ide.runner.RunProcess;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.view.View;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.jdeveloper.runner.JRunProcess;
import oracle.jdevimpl.runner.debug.DebugWindowSettings;
import oracle.jdevimpl.runner.run.RunArb;

public class RunningProcess
extends JRunProcess {
    private static Controller controller;
    private static IdeAction actionTerminate;
    private static final int TERMINATE_CMD_ID;
    private DebugWindowSettings debugWindowSettings;
    private StructureChangeListener changeListener;
    private Toolbar logPageToolbar;
    private boolean logPageToolbarSet;
    private static HelpInfo helpInfo;

    public RunningProcess(Context context) {
        super(context);
    }

    public boolean canRun(String runType, Object cookie, Node node, List errors) {
        return true;
    }

    public String getProcessLabelPrefix() {
        return this.labelPrefixOverride != null ? this.labelPrefixOverride : RunArb.getString(7);
    }

    public Icon getIcon() {
        return this.iconOverride != null ? this.iconOverride : RunningProcess.getDefaultIcon();
    }

    public static Icon getDefaultIcon() {
        return RunArb.getIcon(10);
    }

    public HelpInfo getHelpInfo() {
        if (helpInfo == null) {
            helpInfo = new HelpInfo("f1_idelogwindowgen_html");
        }
        return helpInfo;
    }

    protected boolean startTarget() {
        if (super.startTarget()) {
            RunningProcess.makeActions();
            this.setToolbar();
            return true;
        }
        return false;
    }

    public void finished() {
        this.removeToolbar();
        super.finished();
    }

    private static Controller makeController() {
        return new 1();
    }

    private static synchronized void makeActions() {
        if (controller != null) {
            return;
        }
        controller = RunningProcess.makeController();
        actionTerminate = IdeAction.get((int)TERMINATE_CMD_ID, null, (String)IdeArb.getString((int)92), null, (Integer)IdeArb.getInteger((int)424), (ArrayResourceBundle)IdeArb.getInstance(), (int)343, null, (boolean)false);
        actionTerminate.addController(controller);
    }

    private void setToolbar() {
        this.debugWindowSettings = DebugWindowSettings.getInstance();
        this.changeListener = new 2();
        this.debugWindowSettings.addStructureChangeListener(this.changeListener);
        this.logPageToolbarSet = true;
        LogPage lp = this.getLogPage();
        if (lp instanceof RunLogPage) {
            RunLogPage runLogPage = (RunLogPage)lp;
            boolean show = this.debugWindowSettings.isShowToolbarInLogWindow();
            runLogPage.setNorthComponent((Component)(show ? this.getLogPageToolbar() : null));
        }
    }

    private void removeToolbar() {
        if (this.debugWindowSettings != null) {
            this.debugWindowSettings.removeStructureChangeListener(this.changeListener);
        }
        this.changeListener = null;
        this.debugWindowSettings = null;
        this.logPageToolbarSet = false;
        LogPage lp = this.getLogPage();
        if (lp instanceof RunLogPage) {
            RunLogPage runLogPage = (RunLogPage)lp;
            runLogPage.setNorthComponent(null);
        }
        this.clearLogPageToolbar();
    }

    private void updateToolbarVisibility() {
        LogPage lp;
        if (this.logPageToolbarSet && (lp = this.getLogPage()) instanceof RunLogPage) {
            RunLogPage runLogPage = (RunLogPage)lp;
            boolean show = this.debugWindowSettings.isShowToolbarInLogWindow();
            runLogPage.setNorthComponent((Component)(show ? this.getLogPageToolbar() : null));
        }
    }

    private Toolbar getLogPageToolbar() {
        if (this.logPageToolbar == null) {
            this.logPageToolbar = new Toolbar();
            this.logPageToolbar.add((ToggleAction)actionTerminate);
            this.logPageToolbar.validate();
        }
        return this.logPageToolbar;
    }

    private void clearLogPageToolbar() {
        if (this.logPageToolbar != null) {
            this.logPageToolbar.dispose();
            this.logPageToolbar.removeAll();
            this.logPageToolbar.validate();
            this.logPageToolbar = null;
        }
    }

    static {
        TERMINATE_CMD_ID = Ide.findOrCreateCmdID((String)"RunTerminateProcessCommand");
    }

    static void mav$updateToolbarVisibility(RunningProcess runningProcess) {
        runningProcess.updateToolbarVisibility();
    }

    static int ra$TERMINATE_CMD_ID() {
        return TERMINATE_CMD_ID;
    }

    static final class 1
    implements Controller {
        public boolean update(IdeAction action, Context context) {
            int cmdId;
            RunningProcess runningProcess = this.getRunningProcess(context);
            if (runningProcess != null && (cmdId = action.getCommandId()) == RunningProcess.ra$TERMINATE_CMD_ID()) {
                action.setEnabled(runningProcess.canTerminate());
                return true;
            }
            action.setEnabled(false);
            return true;
        }

        public boolean handleEvent(IdeAction action, Context context) {
            int cmdId;
            RunningProcess runningProcess = this.getRunningProcess(context);
            if (runningProcess != null && (cmdId = action.getCommandId()) == RunningProcess.ra$TERMINATE_CMD_ID()) {
                runningProcess.terminate();
                return true;
            }
            return true;
        }

        private RunningProcess getRunningProcess(Context context) {
            RunProcess runProcess;
            LogPage logPage;
            LogWindow logWindow;
            View view;
            RunLogPage runLogPage = null;
            if (context != null && (view = context.getView()) instanceof RunLogPage) {
                runLogPage = (RunLogPage)view;
            }
            if (runLogPage == null && (logWindow = LogManager.getLogManager().getLogWindow()) != null && (logPage = logWindow.getPage()) instanceof RunLogPage) {
                runLogPage = (RunLogPage)logPage;
            }
            if (runLogPage != null && (runProcess = runLogPage.getRunProcess()) instanceof RunningProcess) {
                return (RunningProcess)runProcess;
            }
            return null;
        }
    }

    final class 2
    extends StructureChangeListener {
        public void structureValuesChanged(StructureChangeEvent e) {
            RunningProcess.mav$updateToolbarVisibility(RunningProcess.this);
        }
    }
}

