/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.runner;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeEditorGutter;
import oracle.ide.ceditor.LineNavigationPoint;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.ide.util.ResourceUtils;
import oracle.ide.view.View;
import oracle.ideri.util.Product;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.model.PackagedSource;
import oracle.jdeveloper.runner.RunMgrArb;
import oracle.jdeveloper.runner.SourceFinder;
import oracle.jdeveloper.runner.SourceFinderManager;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.uieditor.UIEditorImpl;

public final class Source {
    private static ArrayList _sourceFinderList = new ArrayList(2);
    private static ArrayList _sourceFinderManagerList = new ArrayList(2);
    private static final int DO_NOTHING = 0;
    private static final int LOOK_IN_PROJECT = 1;
    private static final int LOOK_IN_SOURCE_FINDER = 2;
    private static final int URL_CHOOSER = 3;
    private static final int GENERATE_STUB = 4;
    private static final int DONT_ASK = 5;
    private static List dontAsk = null;

    private Source() {
    }

    public static boolean showSourceFile(Workspace workspace, Project project, String pkg, String fullClassName, String filename, int line, boolean selectLine) {
        return Source.showSourceFile(workspace, project, pkg, fullClassName, filename, line, selectLine, null);
    }

    public static boolean showSourceFile(Workspace workspace, Project project, String pkg, String fullClassName, String filename, int line, boolean selectLine, String sourceNotFoundMessage) {
        return Source.showSourceFile(workspace, project, pkg, fullClassName, filename, line, selectLine, sourceNotFoundMessage, null);
    }

    public static boolean showSourceFile(Workspace workspace, Project project, String pkg, String fullClassName, String filename, int line, boolean selectLine, String sourceNotFoundMessage, DebugVirtualMachine vm) {
        try {
            Node node;
            URL url = Source.findSourceFile(workspace, project, pkg, filename);
            if (url != null && (node = NodeFactory.findOrCreate((URL)url)) != null && Source.showSourceFile(workspace, project, node, line, selectLine)) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (fullClassName != null) {
            try {
                Node node;
                URL url = Source.findURLForClassSource(workspace, project, fullClassName);
                if (url != null && (node = NodeFactory.findOrCreate((URL)url)) != null && filename.equals(Source.getFilenameFromNode(node)) && Source.packageMatches(pkg, node, project) && Source.showSourceFile(workspace, project, node, line, selectLine)) {
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                Node node;
                URL url = Source.findOpenSourceStub(workspace, project, fullClassName);
                if (url != null && (node = NodeFactory.findOrCreate((URL)url)) != null && Source.showSourceFile(workspace, project, node, 0, false)) {
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        StringBuilder urlKeyStringSB = new StringBuilder();
        if (workspace != null && workspace.getURL() != null) {
            urlKeyStringSB.append(workspace.getURL().toString());
        }
        if (vm != null) {
            if (project != null && project.getURL() != null) {
                urlKeyStringSB.append(project.getURL().toString());
            }
            if (pkg != null) {
                urlKeyStringSB.append(pkg);
            }
            if (filename != null) {
                urlKeyStringSB.append(filename);
            }
            if (fullClassName != null) {
                urlKeyStringSB.append(fullClassName);
            }
            if (urlKeyStringSB.length() != 0) {
                try {
                    Node node;
                    URL url = vm.getChachedUserFoundLocation(urlKeyStringSB.toString());
                    if (url != null && (node = NodeFactory.findOrCreate((URL)url)) != null && Source.showSourceFile(workspace, project, node, 0, false)) {
                        boolean bl = true;
                        return bl;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return Source.showSourceNotFoundDialog(workspace, project, pkg, filename, fullClassName, line, selectLine, sourceNotFoundMessage, vm, urlKeyStringSB == null ? "" : urlKeyStringSB.toString());
    }

    public static boolean showSourceFile(Workspace workspace, Project project, URL url, int line, boolean selectLine) {
        try {
            Node node = NodeFactory.findOrCreate((URL)url);
            if (node != null) {
                boolean bl = Source.showSourceFile(workspace, project, node, line, selectLine);
                return bl;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean showSourceFile(Workspace workspace, Project project, Node node, int line, boolean selectLine) {
        Context context = Source.findOpenContext(workspace, project, node);
        if (context == null) {
            context = Source.createContext(workspace, project, node);
        }
        if (context != null) {
            try {
                NavigationManager mgr = NavigationManager.getNavigationManager();
                LineNavigationPoint point = new LineNavigationPoint(context, line, 0, selectLine);
                if (mgr != null) {
                    if (mgr.navigateTo((NavigationPoint)point) != 0) {
                        boolean bl = false;
                        return bl;
                    }
                } else if (point.navigate() != 0) {
                    boolean bl = false;
                    return bl;
                }
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
            }
            return true;
        }
        return false;
    }

    public static CodeEditor showNodeInCodeEditor(Workspace workspace, Project project, Node node) {
        try {
            Context context = Source.createContext(workspace, project, node);
            CodeEditor codeEditor = (CodeEditor)EditorManager.getEditorManager().openEditorInFrame(CodeEditor.class, context);
            return codeEditor;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Editor showNodeInDefaultEditor(Workspace workspace, Project project, Node node) {
        try {
            Context context = Source.createContext(workspace, project, node);
            Editor editor = EditorManager.getEditorManager().openDefaultEditorInFrame(context);
            return editor;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Context findOpenContext(Workspace workspace, Project project, Node node) {
        for (Object e : EditorManager.getEditorManager().getAllEditors()) {
            URL codeEditorWorkspaceURL;
            CodeEditor editor;
            Context context;
            if (!(e instanceof CodeEditor) || (context = (editor = (CodeEditor)e).getContext()) == null || context.getNode() != node) continue;
            URL workspaceURL = workspace != null ? workspace.getURL() : null;
            Workspace codeEditorWorkspace = context.getWorkspace();
            URL uRL = codeEditorWorkspaceURL = codeEditorWorkspace != null ? codeEditorWorkspace.getURL() : null;
            if (workspaceURL != null && codeEditorWorkspaceURL != null && !URLFileSystem.equals((URL)workspaceURL, (URL)codeEditorWorkspaceURL)) continue;
            return context;
        }
        return null;
    }

    private static Context createContext(Workspace workspace, Project project, Node node) {
        try {
            Project definingProject;
            Context ideContext = Context.newIdeContext((Node)node);
            if (workspace != null && workspace != Ide.getDefaultWorkspace()) {
                ideContext.setWorkspace(workspace);
            }
            ideContext.setProject(project);
            if (!Product.isRaptor() && (definingProject = JavaManager.getDefiningProject((Context)ideContext, (URL)node.getURL())) != null) {
                ideContext.setProject(definingProject);
            }
            Context context = ideContext;
            return context;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void addSourceFinder(SourceFinder finder) {
        _sourceFinderList.add(finder);
    }

    public static void removeSourceFinder(SourceFinder finder) {
        _sourceFinderList.remove(finder);
    }

    public static void addSourceFinderManager(SourceFinderManager manager) {
        _sourceFinderManagerList.add(manager);
    }

    public static void removeSourceFinderManager(SourceFinderManager manager) {
        _sourceFinderManagerList.remove(manager);
    }

    public static boolean showUIDesigner(Workspace workspace, Project project, URL url) {
        try {
            Node node = NodeFactory.findOrCreate((URL)url);
            if (node != null) {
                boolean bl = Source.showUIDesigner(workspace, project, node);
                return bl;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean showUIDesigner(Workspace workspace, Project project, Node node) {
        try {
            UIEditorImpl editor;
            Context ideContext = Context.newIdeContext((Node)node);
            if (workspace != null && workspace != Ide.getDefaultWorkspace()) {
                ideContext.setWorkspace(workspace);
            }
            if (project != null && project != Ide.getDefaultProject()) {
                ideContext.setProject(project);
            }
            if ((editor = (UIEditorImpl)EditorManager.getEditorManager().openEditorInFrame(UIEditorImpl.class, ideContext)) != null) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static URL findSourceFile(Workspace workspace, Project project, String pkg, String filename) {
        Node[] openedFiles = Source.getOpenedFiles();
        URL found = Source.lookForFile(pkg, filename, project, openedFiles);
        if (found != null) {
            return found;
        }
        if (project != null) {
            int lastDot = filename.lastIndexOf(46);
            String fullClassName = lastDot == -1 ? filename : filename.substring(0, lastDot);
            if (pkg != null && pkg.length() > 0) {
                fullClassName = pkg + '.' + fullClassName;
            }
            if ((found = Source.findURLForClassSource(workspace, project, fullClassName)) != null) {
                try {
                    Node node = NodeFactory.findOrCreate((URL)found);
                    if (node != null && filename.equals(Source.getFilenameFromNode(node)) && Source.packageMatches(pkg, node, project)) {
                        URL uRL = found;
                        return uRL;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return Source.askSourceFinders(workspace, project, pkg, filename);
    }

    public static URL askSourceFinders(Workspace workspace, Project project, String pkg, String filename) {
        URL found = null;
        Iterator sourceFinderIterator = _sourceFinderList.iterator();
        while (found == null && sourceFinderIterator.hasNext()) {
            SourceFinder finder = (SourceFinder)sourceFinderIterator.next();
            found = finder.findSourceFile(workspace, project, pkg, filename);
        }
        return found;
    }

    public static URL findURLForClass(Workspace workspace, Project project, String fullClassName) {
        return Source.findURLForClassSource(workspace, project, fullClassName);
    }

    public static URL findURLForClassSource(Workspace workspace, Project project, String fullClassName) {
        return Source.findURLForClassSource(project, fullClassName);
    }

    public static URL findURLForClassSource(Project project, String fullClassName) {
        JavaManager javaManager = JavaManager.getJavaManager((Project)project);
        SourceClass sourceClass = javaManager.getSourceClass(fullClassName);
        if (sourceClass != null) {
            return sourceClass.getURL();
        }
        return null;
    }

    public static URL findURLForClassStub(Workspace workspace, Project project, String fullClassName) {
        return Source.findURLForClassStub(project, fullClassName);
    }

    public static URL findURLForClassStub(Project project, String fullClassName) {
        JavaManager javaManager = JavaManager.getJavaManager((Project)project);
        JavaClass javaClass = javaManager.getClass(fullClassName);
        if (javaClass != null) {
            return javaClass.getURL();
        }
        return null;
    }

    public static URL findOpenSourceStub(Workspace workspace, Project project, String fullClassName) {
        URL urlStub = Source.findURLForClassStub(workspace, project, fullClassName);
        if (urlStub != null) {
            Node[] openedFiles = Source.getOpenedFiles();
            int i = openedFiles.length - 1;
            while (i >= 0) {
                if (urlStub.equals(openedFiles[i].getURL())) {
                    return urlStub;
                }
                --i;
            }
        }
        return null;
    }

    public static Node[] getProjectFileList(Project project) {
        ArrayList al = new ArrayList();
        if (project != null) {
            Source.recurseFileList((Node)project, al);
        }
        return al.toArray(new Node[al.size()]);
    }

    private static void recurseFileList(Node node, ArrayList al) {
        Iterator childIter = node.getChildren();
        if (childIter != null) {
            while (childIter.hasNext()) {
                Object next = childIter.next();
                if (!(next instanceof Node)) continue;
                Node child = (Node)next;
                if (child.mayHaveChildren()) {
                    Source.recurseFileList(child, al);
                    continue;
                }
                al.add(child);
            }
        }
    }

    private static URL lookForFile(String pkg, String filename, Project project, Node[] files) {
        int i = files.length - 1;
        while (i >= 0) {
            Node file = files[i];
            if (filename.equals(Source.getFilenameFromNode(file)) && Source.packageMatches(pkg, file, project)) {
                return file.getURL();
            }
            --i;
        }
        return null;
    }

    public static Node[] getOpenedFiles() {
        if (!SwingUtilities.isEventDispatchThread()) {
            return new Node[0];
        }
        ArrayList<Node> temp = new ArrayList<Node>();
        List editors = EditorManager.getEditorManager().getAllEditors();
        int i = editors.size() - 1;
        while (i >= 0) {
            Node node;
            CodeEditor editor;
            Context context;
            Object e = editors.get(i);
            if (e instanceof CodeEditor && (context = (editor = (CodeEditor)e).getContext()) != null && (node = context.getNode()) != null) {
                temp.add(node);
            }
            --i;
        }
        return temp.toArray(new Node[temp.size()]);
    }

    public static Node[] getOpenedFiles(Workspace workspace, Project project) {
        if (!SwingUtilities.isEventDispatchThread()) {
            return new Node[0];
        }
        ArrayList<Node> temp = new ArrayList<Node>();
        URL workspaceURL = workspace != null ? workspace.getURL() : null;
        URL projectURL = project != null ? project.getURL() : null;
        List editors = EditorManager.getEditorManager().getAllEditors();
        int i = editors.size() - 1;
        while (i >= 0) {
            CodeEditor editor;
            Context context;
            Object e = editors.get(i);
            if (e instanceof CodeEditor && (context = (editor = (CodeEditor)e).getContext()) != null) {
                Node node;
                URL codeEditorWorkspaceURL;
                Workspace codeEditorWorkspace = context.getWorkspace();
                URL uRL = codeEditorWorkspaceURL = codeEditorWorkspace != null ? codeEditorWorkspace.getURL() : null;
                if ((workspaceURL == null || codeEditorWorkspaceURL == null || URLFileSystem.equals((URL)workspaceURL, (URL)codeEditorWorkspaceURL)) && (node = context.getNode()) != null) {
                    temp.add(node);
                }
            }
            --i;
        }
        return temp.toArray(new Node[temp.size()]);
    }

    public static String getFilenameFromNode(Node node) {
        if (node instanceof PackagedSource) {
            String fileName = ((PackagedSource)node).getSourceFile();
            return fileName != null ? fileName : "";
        }
        return URLFileSystem.getFileName((URL)node.getURL());
    }

    public static String getPackageFromNode(Node node, Project project) {
        if (node instanceof PackagedSource) {
            try {
                String pkg = ((PackagedSource)node).getPackage(project);
                String string = pkg != null ? pkg : "";
                return string;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "";
    }

    public static boolean packageMatches(String pkg, Node node, Project project) {
        String nodePkg = Source.getPackageFromNode(node, project);
        return Source.packageMatches(pkg, nodePkg);
    }

    public static boolean packageMatches(String pkg, String nodePkg) {
        if (pkg.equals(nodePkg)) {
            return true;
        }
        if (nodePkg != null && nodePkg.length() > 0 && nodePkg.charAt(0) == '*' && pkg.endsWith(nodePkg.substring(1))) {
            return true;
        }
        return pkg.length() > 0 && pkg.charAt(0) == '*' && nodePkg.endsWith(pkg.substring(1));
    }

    public static CodeEditor getCodeEditorFromContext(Context context) {
        if (context != null) {
            View view = context.getView();
            if (view instanceof CodeEditor) {
                return (CodeEditor)view;
            }
            if (view instanceof CodeEditorGutter.GutterView) {
                return (CodeEditor)view.owner();
            }
        }
        return null;
    }

    public static Node getNodeFromCodeEditor(Context context) {
        CodeEditor codeEditor = Source.getCodeEditorFromContext(context);
        if (codeEditor != null) {
            return context.getNode();
        }
        return null;
    }

    public static int getLineFromCodeEditor(Context context) {
        View view;
        if (context != null && (view = context.getView()) != null && view instanceof CodeEditorGutter.GutterView) {
            int line = CodeEditorGutter.getLineForContext((Context)context);
            if (line != -1) {
                return line;
            }
            return 0;
        }
        CodeEditor codeEditor = Source.getCodeEditorFromContext(context);
        if (codeEditor != null) {
            return codeEditor.getCaretLine();
        }
        return 0;
    }

    private static boolean showSourceNotFoundDialog(Workspace workspace, Project project, String pkg, String filename, String fullClassName, int line, boolean selectLine, String sourceNotFoundMessage, DebugVirtualMachine vm, String urlCacheKey) {
        if (Source.getShouldAsk(pkg, filename)) {
            String title = RunMgrArb.getString(25);
            ArrayList<Project> projectsSearched = new ArrayList<Project>();
            if (project != null) {
                projectsSearched.add(project);
            }
            boolean canGenerateStub = Source.canGenerateStub(workspace, project, fullClassName, filename);
            block7: while (true) {
                SourceNotFoundPanel panel = new SourceNotFoundPanel(workspace, project, pkg, filename, fullClassName, sourceNotFoundMessage, projectsSearched, canGenerateStub);
                JEWTDialog dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)panel, (Component)SourceNotFoundPanel.mav$getFirstComponent(panel), (String)title);
                SourceNotFoundPanel.mav$setJEWTDialog(panel, dlg);
                dlg.setOKButtonEnabled(SourceNotFoundPanel.mav$canOk(panel));
                HelpSystem.getHelpSystem().registerTopic((JComponent)panel, "f1_run_sourcenotfound_html");
                if (!WizardLauncher.runDialog((JDialog)dlg)) break;
                switch (SourceNotFoundPanel.mav$getChoice(panel)) {
                    case 1: {
                        Project p = panel.getSelectedProject();
                        if (Source.lookInOtherProject(p, workspace, pkg, filename, line, selectLine)) {
                            return true;
                        }
                        projectsSearched.add(p);
                        continue block7;
                    }
                    case 2: {
                        SourceFinder sf = panel.getSelectedSourceFinder();
                        if (!Source.lookInSourceFinder(sf, workspace, project, pkg, filename, line, selectLine)) continue block7;
                        return true;
                    }
                    case 3: {
                        if (!Source.showURLChooser(workspace, project, pkg, filename, line, selectLine, vm, urlCacheKey)) continue block7;
                        return true;
                    }
                    case 4: {
                        if (!Source.generateStub(workspace, project, fullClassName)) continue block7;
                        return true;
                    }
                    case 5: {
                        Source.setShouldAsk(pkg, filename, false);
                        return false;
                    }
                }
            }
            return false;
        }
        return false;
    }

    private static boolean getShouldAsk(String pkg, String filename) {
        String pkgFilename;
        return dontAsk == null || !dontAsk.contains(pkgFilename = pkg + "." + filename);
    }

    private static void setShouldAsk(String pkg, String filename, boolean shouldAsk) {
        if (dontAsk == null) {
            dontAsk = new ArrayList();
        }
        String pkgFilename = pkg + "." + filename;
        if (shouldAsk) {
            dontAsk.remove(pkgFilename);
        } else {
            dontAsk.add(pkgFilename);
        }
    }

    private static boolean lookInOtherProject(Project otherProject, Workspace workspace, String pkg, String filename, int line, boolean selectLine) {
        try {
            Node node;
            URL url = Source.findSourceFile(workspace, otherProject, pkg, filename);
            if (url != null && (node = NodeFactory.findOrCreate((URL)url)) != null && Source.showSourceFile(workspace, otherProject, node, line, selectLine)) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return false;
    }

    private static boolean lookInSourceFinder(SourceFinder sf, Workspace workspace, Project project, String pkg, String filename, int line, boolean selectLine) {
        try {
            Node node;
            URL url = sf.findSourceFile(workspace, project, pkg, filename);
            if (url != null && (node = NodeFactory.findOrCreate((URL)url)) != null && Source.showSourceFile(workspace, project, node, line, selectLine)) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return false;
    }

    private static boolean showURLChooser(Workspace workspace, Project project, String pkg, String filename, int line, boolean selectLine, DebugVirtualMachine vm, String urlCacheKey) {
        URL url;
        String title = pkg.length() > 0 ? RunMgrArb.format(63, pkg, filename) : RunMgrArb.format(61, filename);
        Context context = Context.newIdeContext();
        if (workspace != null) {
            context.setWorkspace(workspace);
        }
        if (project != null) {
            context.setProject(project);
        }
        URLChooser chooser = DialogUtil.newURLChooser((Context)context);
        chooser.setSelectionMode(0);
        if (chooser.showOpenDialog((Component)Ide.getMainWindow(), title) == 0 && (url = chooser.getSelectedURL()) != null) {
            try {
                Node node = NodeFactory.findOrCreate((URL)url);
                if (node != null && Source.showSourceFile(workspace, project, node, line, selectLine)) {
                    if (vm != null && urlCacheKey.length() > 0) {
                        vm.cacheUserFoundURL(urlCacheKey, url);
                    }
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return false;
    }

    private static boolean canGenerateStub(Workspace workspace, Project project, String fullClassName, String filename) {
        URL urlStub;
        return project != null && fullClassName != null && filename != null && filename.toUpperCase().endsWith(".JAVA") && (urlStub = Source.findURLForClassStub(workspace, project, fullClassName)) != null;
    }

    private static boolean generateStub(Workspace workspace, Project project, String fullClassName) {
        URL urlStub;
        return project != null && fullClassName != null && (urlStub = Source.findURLForClassStub(workspace, project, fullClassName)) != null && Source.showSourceFile(workspace, project, urlStub, 0, false);
    }

    static ArrayList ra$_sourceFinderManagerList() {
        return _sourceFinderManagerList;
    }

    private static final class SourceNotFoundPanel
    extends JPanel
    implements ItemListener {
        private JEWTDialog dlg;
        private JRadioButton radioProject;
        private JComboBox comboboxProjects;
        private List sourceFinderManagers;
        private List radioSourceFinders;
        private List comboboxSourceFinders;
        private JRadioButton radioURLChooser;
        private JRadioButton radioGenerateStub;
        private JRadioButton radioDontAskAgain;

        SourceNotFoundPanel(Workspace workspace, Project project, String pkg, String filename, String fullClassName, String sourceNotFoundMessage, List projectsSearched, boolean canGenerateStub) {
            super(new GridBagLayout());
            int size;
            JLabel specialLabel = null;
            if (sourceNotFoundMessage != null) {
                specialLabel = new JLabel(sourceNotFoundMessage);
            }
            String message = filename.length() > 0 ? (pkg.length() > 0 ? RunMgrArb.format(97, pkg, filename) : RunMgrArb.format(96, filename)) : RunMgrArb.format(95, fullClassName);
            JLabel label = new JLabel(message);
            int projectsSearchedSize = projectsSearched.size();
            JLabel[] labelLookedInProject = new JLabel[projectsSearchedSize];
            int i = 0;
            while (i < projectsSearchedSize) {
                Project p = (Project)projectsSearched.get(i);
                labelLookedInProject[i] = new JLabel(RunMgrArb.format(104, p.getShortLabel()));
                ++i;
            }
            Project[] projects = SourceNotFoundPanel.getOtherProjects(workspace, projectsSearched);
            if (projects.length > 0) {
                Arrays.sort(projects, new ProjectComparator(null));
                this.radioProject = new JRadioButton();
                this.comboboxProjects = new JComboBox<Project>(projects);
            }
            if ((size = Source.ra$_sourceFinderManagerList().size()) > 0) {
                this.sourceFinderManagers = new ArrayList();
                this.radioSourceFinders = new ArrayList();
                this.comboboxSourceFinders = new ArrayList();
                int i2 = 0;
                while (i2 < size) {
                    SourceFinderManager sourceFinderManager = (SourceFinderManager)Source.ra$_sourceFinderManagerList().get(i2);
                    String[] names = sourceFinderManager.getSourceFinderNames();
                    if (names != null && names.length > 0) {
                        JRadioButton radioButton = new JRadioButton();
                        ResourceUtils.resButton((AbstractButton)radioButton, (String)sourceFinderManager.getRadioLabel());
                        JComboBox<String> combobox = new JComboBox<String>(names);
                        this.sourceFinderManagers.add(sourceFinderManager);
                        this.radioSourceFinders.add(radioButton);
                        this.comboboxSourceFinders.add(combobox);
                    }
                    ++i2;
                }
                if (this.sourceFinderManagers.isEmpty()) {
                    this.sourceFinderManagers = null;
                    this.radioSourceFinders = null;
                    this.comboboxSourceFinders = null;
                }
            }
            this.radioURLChooser = new JRadioButton();
            if (canGenerateStub) {
                this.radioGenerateStub = new JRadioButton();
            }
            this.radioDontAskAgain = new JRadioButton();
            ButtonGroup group = new ButtonGroup();
            if (this.radioProject != null) {
                group.add(this.radioProject);
            }
            if (this.radioSourceFinders != null) {
                int i3 = 0;
                while (i3 < this.radioSourceFinders.size()) {
                    group.add((JRadioButton)this.radioSourceFinders.get(i3));
                    ++i3;
                }
            }
            group.add(this.radioURLChooser);
            if (this.radioGenerateStub != null) {
                group.add(this.radioGenerateStub);
            }
            group.add(this.radioDontAskAgain);
            this.setResources();
            this.selectRadio(filename);
            int y = 0;
            if (specialLabel != null) {
                this.add((Component)specialLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 10, 5), 0, 0));
            }
            this.add((Component)label, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 10, 5), 0, 0));
            int i4 = 0;
            while (i4 < labelLookedInProject.length) {
                this.add((Component)labelLookedInProject[i4], new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
                ++i4;
            }
            if (this.radioProject != null) {
                JPanel panel = new JPanel(new FlowLayout(0, 0, 0));
                panel.add(this.radioProject);
                panel.add(this.comboboxProjects);
                this.add((Component)panel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
            }
            if (this.radioSourceFinders != null) {
                int i5 = 0;
                while (i5 < this.radioSourceFinders.size()) {
                    JRadioButton radioButton = (JRadioButton)this.radioSourceFinders.get(i5);
                    JComboBox combobox = (JComboBox)this.comboboxSourceFinders.get(i5);
                    JPanel panel = new JPanel(new FlowLayout(0, 0, 0));
                    panel.add(radioButton);
                    panel.add(combobox);
                    this.add((Component)panel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
                    ++i5;
                }
            }
            this.add((Component)this.radioURLChooser, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
            if (this.radioGenerateStub != null) {
                this.add((Component)this.radioGenerateStub, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
            }
            this.add((Component)this.radioDontAskAgain, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
            this.add((Component)new JLabel(), new GridBagConstraints(0, y, 0, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.addListeners();
        }

        private void setResources() {
            if (this.radioProject != null) {
                ResourceUtils.resButton((AbstractButton)this.radioProject, (String)RunMgrArb.getString(71));
            }
            ResourceUtils.resButton((AbstractButton)this.radioURLChooser, (String)RunMgrArb.getString(80));
            if (this.radioGenerateStub != null) {
                ResourceUtils.resButton((AbstractButton)this.radioGenerateStub, (String)RunMgrArb.getString(28));
            }
            ResourceUtils.resButton((AbstractButton)this.radioDontAskAgain, (String)RunMgrArb.getString(99));
        }

        private void selectRadio(String filename) {
            if (this.radioSourceFinders != null && filename.toUpperCase().endsWith(".PLS")) {
                ((JRadioButton)this.radioSourceFinders.get(0)).setSelected(true);
            } else if (this.radioProject != null) {
                this.radioProject.setSelected(true);
            } else {
                this.radioURLChooser.setSelected(true);
            }
        }

        private void addListeners() {
            if (this.radioProject != null) {
                this.radioProject.addItemListener(this);
                this.comboboxProjects.addItemListener(this);
                this.comboboxProjects.setEnabled(this.radioProject.isSelected());
            }
            if (this.radioSourceFinders != null) {
                int i = 0;
                while (i < this.radioSourceFinders.size()) {
                    JRadioButton radioButton = (JRadioButton)this.radioSourceFinders.get(i);
                    radioButton.addItemListener(this);
                    JComboBox combobox = (JComboBox)this.comboboxSourceFinders.get(i);
                    combobox.addItemListener(this);
                    combobox.setEnabled(radioButton.isSelected());
                    ++i;
                }
            }
            if (this.radioGenerateStub != null) {
                this.radioGenerateStub.addItemListener(this);
            }
            this.radioURLChooser.addItemListener(this);
        }

        private static Project[] getOtherProjects(Workspace workspace, List projectsSearched) {
            ArrayList temp = new ArrayList();
            if (workspace != null) {
                Iterator children = workspace.getChildren();
                while (children.hasNext()) {
                    Object o = children.next();
                    if (!(o instanceof Project) || projectsSearched.contains(o)) continue;
                    temp.add(o);
                }
            }
            return temp.toArray(new Project[temp.size()]);
        }

        public void itemStateChanged(ItemEvent e) {
            Object source = e.getSource();
            if (source instanceof JRadioButton) {
                if (this.radioProject != null) {
                    this.comboboxProjects.setEnabled(this.radioProject.isSelected());
                }
                if (this.radioSourceFinders != null) {
                    int i = 0;
                    while (i < this.radioSourceFinders.size()) {
                        JRadioButton radioButton = (JRadioButton)this.radioSourceFinders.get(i);
                        JComboBox combobox = (JComboBox)this.comboboxSourceFinders.get(i);
                        combobox.setEnabled(radioButton.isSelected());
                        ++i;
                    }
                }
                this.dlg.setOKButtonEnabled(this.canOk());
            } else if (source instanceof JComboBox) {
                this.dlg.setOKButtonEnabled(this.canOk());
            }
        }

        private void setJEWTDialog(JEWTDialog dlg) {
            this.dlg = dlg;
        }

        private boolean canOk() {
            if (this.radioProject != null && this.radioProject.isSelected() && this.getSelectedProject() == null) {
                return false;
            }
            if (this.radioSourceFinders != null) {
                int i = 0;
                while (i < this.radioSourceFinders.size()) {
                    JRadioButton radioButton = (JRadioButton)this.radioSourceFinders.get(i);
                    if (radioButton.isSelected() && this.getSelectedSourceFinder() == null) {
                        return false;
                    }
                    ++i;
                }
            }
            return true;
        }

        private Component getFirstComponent() {
            if (this.radioProject != null) {
                return this.radioProject;
            }
            if (this.radioSourceFinders != null) {
                return (JRadioButton)this.radioSourceFinders.get(0);
            }
            return this.radioURLChooser;
        }

        private int getChoice() {
            if (this.radioProject != null && this.radioProject.isSelected()) {
                return 1;
            }
            if (this.radioSourceFinders != null) {
                int i = 0;
                while (i < this.radioSourceFinders.size()) {
                    JRadioButton radioButton = (JRadioButton)this.radioSourceFinders.get(i);
                    if (radioButton.isSelected()) {
                        return 2;
                    }
                    ++i;
                }
            }
            if (this.radioGenerateStub != null && this.radioGenerateStub.isSelected()) {
                return 4;
            }
            if (this.radioURLChooser.isSelected()) {
                return 3;
            }
            if (this.radioDontAskAgain.isSelected()) {
                return 5;
            }
            return 0;
        }

        Project getSelectedProject() {
            if (this.radioProject != null && this.radioProject.isSelected()) {
                return (Project)this.comboboxProjects.getSelectedItem();
            }
            return null;
        }

        SourceFinder getSelectedSourceFinder() {
            if (this.radioSourceFinders != null) {
                int i = 0;
                while (i < this.radioSourceFinders.size()) {
                    JRadioButton radioButton = (JRadioButton)this.radioSourceFinders.get(i);
                    if (radioButton.isSelected()) {
                        SourceFinderManager sourceFinderManager = (SourceFinderManager)this.sourceFinderManagers.get(i);
                        JComboBox combobox = (JComboBox)this.comboboxSourceFinders.get(i);
                        String name = (String)combobox.getSelectedItem();
                        return sourceFinderManager.getSourceFinder(name);
                    }
                    ++i;
                }
            }
            return null;
        }

        static Component mav$getFirstComponent(SourceNotFoundPanel sourceNotFoundPanel) {
            return sourceNotFoundPanel.getFirstComponent();
        }

        static void mav$setJEWTDialog(SourceNotFoundPanel sourceNotFoundPanel, JEWTDialog jEWTDialog) {
            sourceNotFoundPanel.setJEWTDialog(jEWTDialog);
        }

        static boolean mav$canOk(SourceNotFoundPanel sourceNotFoundPanel) {
            return sourceNotFoundPanel.canOk();
        }

        static int mav$getChoice(SourceNotFoundPanel sourceNotFoundPanel) {
            return sourceNotFoundPanel.getChoice();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProjectComparator
    implements Comparator<Project> {
        @Override
        public int compare(Project project1, Project project2) {
            return project1.getShortLabel().compareTo(project2.getShortLabel());
        }

        private ProjectComparator() {
        }

        ProjectComparator(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

