/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.runner.xslt;

import java.net.URL;
import java.util.List;
import javax.swing.Icon;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.ide.Context;
import oracle.ide.model.DefaultDisplayable;
import oracle.ide.model.Displayable;
import oracle.ide.model.Node;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFileSystem;
import oracle.ide.runner.AbstractStarterFactory;
import oracle.ide.runner.RunProcess;
import oracle.ide.runner.Starter;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.runner.JRunProcess;
import oracle.jdeveloper.runner.JStarterFactory;
import oracle.jdeveloper.runner.xslt.XSLTStarter;
import oracle.jdevimpl.runner.xslt.XSLTArb;
import oracle.jdevimpl.runner.xslt.XSLTRunnerAddin;

public class XSLTStarterFactory
extends AbstractStarterFactory
implements JStarterFactory {
    private static final String XSL_SUFFIX = ".xsl";

    public String getName() {
        return XSLTArb.getString(37);
    }

    public Object canStart(RunProcess runProcess, Node node, List errors) {
        Object target;
        if (runProcess instanceof JRunProcess && (target = XSLTStarterFactory.findXSLTTarget(node, errors)) != null && runProcess.canRun("XSLT", null, node, errors)) {
            return target;
        }
        return null;
    }

    public Starter createStarter(RunProcess runProcess, Node node, Object o) {
        XMLSourceNode target = (XMLSourceNode)o;
        return new XSLTStarter((JRunProcess)runProcess, target);
    }

    public boolean enableRunDebugActions(Context context) {
        Node node = RunProcess.getContextNodeForRun((Context)context);
        if (node instanceof XMLSourceNode) {
            XMLSourceNode xmlNode = (XMLSourceNode)node;
            URL url = xmlNode.getURL();
            if (!url.getProtocol().equalsIgnoreCase("file")) {
                return false;
            }
            if (!XSLTRunnerAddin.isXSLT(xmlNode)) {
                return false;
            }
        }
        return super.enableRunDebugActions(context);
    }

    public Displayable getDisplayable(RunProcess runProcess, Context context, Node node, Object o) {
        return new 1();
    }

    private static Object findXSLTTarget(Node node, List errors) {
        try {
            if (node instanceof XMLSourceNode) {
                XMLSourceNode xmlNode = (XMLSourceNode)node;
                String error = null;
                URL url = xmlNode.getURL();
                if (url.getProtocol().equalsIgnoreCase("file")) {
                    if (XSLTRunnerAddin.isXSLT(xmlNode)) {
                        XMLSourceNode xMLSourceNode = xmlNode;
                        return xMLSourceNode;
                    }
                    error = XSLTArb.format(20, xmlNode.getShortLabel());
                } else {
                    error = JarUtil.isJarURL((URL)url) ? XSLTArb.format(24, xmlNode.getShortLabel()) : XSLTArb.format(16, xmlNode.getShortLabel());
                }
                if (error != null && URLFileSystem.hasSuffix((URL)url, (String)XSL_SUFFIX)) {
                    errors.add(error);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return null;
    }

    final class 1
    extends DefaultDisplayable {
        public String getShortLabel() {
            return XSLTArb.getString(30);
        }

        public Icon getIcon() {
            return OracleIcons.getIcon((String)"xmlfile.png");
        }
    }
}

