/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.sourcecolors.addin;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.Pair;
import oracle.ide.view.View;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.clipboard.ClipboardStack;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceHasName;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.doc.SourceDocComment;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceNewClassExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.util.SourceElementAsList;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdeveloper.sourcecolors.SourceColorizer;
import oracle.jdeveloper.sourcecolors.addin.ExportDialog;
import oracle.jdeveloper.sourcecolors.parser.LinkInfo;

public class ExportToHTMLAddin
implements Addin,
Controller {
    private int _exportActionID;

    public void initialize() {
        this.createActions();
    }

    private void createActions() {
        this._exportActionID = Ide.findOrCreateCmdID((String)"ExportToHTML");
        IdeAction firstAction = IdeAction.get((int)this._exportActionID, null, (String)"Export to HTML...", (String)IdeMainWindow.ACTION_CATEGORY_FILE, null, null, null, (boolean)true);
        firstAction.addController((Controller)this);
        Menubar menubar = Ide.getMenubar();
        JMenuItem firstActionMenu = menubar.createMenuItem((ToggleAction)firstAction, MenuConstants.WEIGHT_FILE_IMPORT + 0.001f);
        menubar.add((Component)firstActionMenu, MenuManager.getJMenu((String)"File"), MenuConstants.SECTION_FILE_IMPORT_EXPORT);
    }

    public boolean handleEvent(IdeAction action, Context context) {
        if (action.getCommandId() == this._exportActionID) {
            this.whenExport(context);
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        if (action.getCommandId() == this._exportActionID) {
            boolean canExport = this.canExport(context);
            action.setEnabled(canExport);
            return true;
        }
        return false;
    }

    private void whenExport(Context context) {
        View view = context.getView();
        Element[] selection = context.getSelection();
        if (selection != null) {
            int length = selection.length;
            if (length == 1 && selection[0] instanceof TextNode) {
                String selectedText = null;
                if (view instanceof CodeEditor) {
                    CodeEditor codeEditor = (CodeEditor)view;
                    selectedText = codeEditor.getSelectedText();
                }
                if (selectedText != null && selectedText.length() > 0) {
                    this.whenExportNodeOrSelection(context, (TextNode)selection[0], selectedText);
                } else {
                    this.whenExportNode(context, (TextNode)selection[0]);
                }
            } else {
                ArrayList textNodes = new ArrayList();
                int i = 0;
                while (i < selection.length) {
                    Element element = selection[i];
                    ExportToHTMLAddin.collectTextNodes(element, textNodes);
                    ++i;
                }
                TextNode[] textNodeArray = textNodes.toArray(new TextNode[textNodes.size()]);
                this.whenExportNodes(context, textNodeArray);
            }
        }
    }

    private static void collectTextNodes(Element element, ArrayList textNodes) {
        if (element instanceof Folder) {
            Folder folder = (Folder)element;
            Iterator children = folder.getChildren();
            while (children.hasNext()) {
                Element childElement = (Element)children.next();
                ExportToHTMLAddin.collectTextNodes(childElement, textNodes);
            }
        } else if (element instanceof TextNode) {
            textNodes.add(element);
        }
    }

    private void export(String output, String fileName, int level) {
        if (fileName == null) {
            StringSelection ss = new StringSelection(output);
            ClipboardStack.pushCurrentClipboard();
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, null);
        } else {
            File file = new File(fileName);
            try {
                File parentFile = file.getParentFile();
                parentFile.mkdirs();
                FileWriter fileWriter = new FileWriter(file);
                fileWriter.write("<HTML>");
                if (level >= 0) {
                    fileWriter.write("<HEAD>");
                    fileWriter.write("<LINK REL=\"stylesheet\" TYPE=\"text/css\" HREF=\"");
                    int i = 0;
                    while (i < level) {
                        fileWriter.write("../");
                        ++i;
                    }
                    fileWriter.write("style.css\">");
                    fileWriter.write("</HEAD>");
                }
                fileWriter.write("<BODY>");
                fileWriter.write(output);
                fileWriter.write("</BODY></HTML>");
                fileWriter.close();
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), e.getLocalizedMessage(), "Export to HTML", 0);
            }
        }
    }

    private LinkInfo[] getLinkInfos(Context context, TextNode textNode, HashMap urlsToHRef, HashSet outOfScopeClasses) {
        ArrayList<LinkInfo> ret = new ArrayList<LinkInfo>();
        if (textNode instanceof JavaSourceNode) {
            URL fromUrl;
            JavaSourceNode javaSourceNode = (JavaSourceNode)textNode;
            JavaManager javaManager = JavaManager.getJavaManager((Project)context.getProject());
            SourceFile sourceFile = javaManager.getSourceFile(fromUrl = javaSourceNode.getURL());
            if (sourceFile != null) {
                System.out.println(URLFileSystem.getPlatformPathName((URL)fromUrl));
                sourceFile.compile();
                List list = SourceElementAsList.asList((SourceElement)sourceFile, (int[])new int[]{53, 27, 57});
                int i = 0;
                while (i < list.size()) {
                    SourceElement sourceElement = (SourceElement)list.get(i);
                    switch (sourceElement.getSymbolKind()) {
                        case 53: {
                            SourceMethod sourceMethod;
                            JavaClass owningClass;
                            JavaMethod resolvedMethod;
                            SourceMethodCallExpression sourceMethodCallExpression = (SourceMethodCallExpression)sourceElement;
                            SourceName nameElement = sourceMethodCallExpression.getNameElement();
                            if (nameElement == null || (resolvedMethod = sourceMethodCallExpression.getResolvedMethod()) == null || outOfScopeClasses.contains(owningClass = resolvedMethod.getOwningClass()) || (sourceMethod = (SourceMethod)resolvedMethod.getSourceElement()) == null) break;
                            String tooltip = ExportToHTMLAddin.getTooltip((SourceElement)sourceMethod);
                            LinkInfo linkInfo = ExportToHTMLAddin.createLinkInfo(nameElement, (SourceElement)sourceMethod, urlsToHRef, tooltip);
                            if (linkInfo != null) {
                                ret.add(linkInfo);
                                break;
                            }
                            outOfScopeClasses.add(owningClass);
                            break;
                        }
                        case 27: {
                            SourceName toName;
                            SourceHasName typeSourceElement;
                            JavaClass owningClass;
                            SourceName nameElement;
                            SourceTypeReference sourceType = (SourceTypeReference)sourceElement;
                            if (sourceType == null || (nameElement = sourceType.getNameElement()) == null) break;
                            SourceElement parent = sourceType.getParent();
                            if (parent.getSymbolKind() == 55) {
                                SourceMethod sourceMethod;
                                JavaClass owningClass2;
                                SourceNewClassExpression sourceClassCreatorExpression = (SourceNewClassExpression)parent;
                                JavaMethod resolvedMethod = sourceClassCreatorExpression.getResolvedMethod();
                                if (resolvedMethod == null || outOfScopeClasses.contains(owningClass2 = resolvedMethod.getOwningClass()) || (sourceMethod = (SourceMethod)resolvedMethod.getSourceElement()) == null) break;
                                String tooltip = ExportToHTMLAddin.getTooltip((SourceElement)sourceMethod);
                                LinkInfo linkInfo = ExportToHTMLAddin.createLinkInfo(nameElement, (SourceElement)sourceMethod, urlsToHRef, tooltip);
                                if (linkInfo != null) {
                                    ret.add(linkInfo);
                                    break;
                                }
                                outOfScopeClasses.add(owningClass2);
                                break;
                            }
                            JavaType resolvedType = sourceType.getResolvedType();
                            if (resolvedType == null || outOfScopeClasses.contains(owningClass = resolvedType.getOwningClass()) || (typeSourceElement = (SourceHasName)resolvedType.getSourceElement()) == null || (toName = typeSourceElement.getNameElement()) == null) break;
                            String tooltip = ExportToHTMLAddin.getTooltip((SourceElement)typeSourceElement);
                            LinkInfo linkInfo = ExportToHTMLAddin.createLinkInfo(nameElement, (SourceElement)toName, urlsToHRef, tooltip);
                            if (linkInfo != null) {
                                ret.add(linkInfo);
                                break;
                            }
                            outOfScopeClasses.add(owningClass);
                            break;
                        }
                        case 57: {
                            SourceElement linkToSource;
                            JavaElement owner;
                            SourceSimpleNameExpression sourceSimpleNameExpression = (SourceSimpleNameExpression)sourceElement;
                            JavaHasType resolvedObject = sourceSimpleNameExpression.getResolvedObject();
                            if (resolvedObject == null || outOfScopeClasses.contains(owner = resolvedObject.getOwner()) || (linkToSource = resolvedObject.getSourceElement()) == null) break;
                            String tooltip = ExportToHTMLAddin.getTooltip(linkToSource);
                            LinkInfo linkInfo = ExportToHTMLAddin.createLinkInfo(sourceSimpleNameExpression.getNameElement(), linkToSource, urlsToHRef, tooltip);
                            if (linkInfo != null) {
                                ret.add(linkInfo);
                                break;
                            }
                            if (!(owner instanceof JavaClass)) break;
                            JavaClass javaClass = (JavaClass)owner;
                            outOfScopeClasses.add(javaClass);
                            break;
                        }
                    }
                    ++i;
                }
            }
        }
        return ret.toArray(new LinkInfo[ret.size()]);
    }

    private static String getTooltip(SourceElement sourceElement) {
        SourceMember sourceMember;
        SourceDocComment docComment;
        if (sourceElement instanceof SourceMember && (docComment = (sourceMember = (SourceMember)sourceElement).getDocComment()) != null) {
            String docText = docComment.getDocText();
            return docText.trim();
        }
        return null;
    }

    private void whenExportNodeOrSelection(Context context, TextNode textNode, String selectedText) {
        ExportDialog exportDialog = new ExportDialog();
        if (exportDialog.runDialog(true, false)) {
            LinkInfo[] linkInfoArray;
            String input;
            if (exportDialog.isExportSelection()) {
                input = selectedText;
            } else {
                TextBuffer textBuffer = textNode.acquireTextBuffer();
                input = textBuffer.getString(0, textBuffer.getLength());
            }
            boolean lineNumbers = exportDialog.isLineNumberSelected();
            boolean linksSelected = exportDialog.isLinksSelected();
            URL url = textNode.getURL();
            if (linksSelected) {
                HashMap<URL, Pair> urlsToHRef = new HashMap<URL, Pair>();
                urlsToHRef.put(url, new Pair((Object)"", (Object)new Integer(0)));
                linkInfoArray = this.getLinkInfos(context, textNode, urlsToHRef, new HashSet());
            } else {
                linkInfoArray = null;
            }
            String language = SourceColorizer.getLanguage(url);
            String output = SourceColorizer.toHTML(language, lineNumbers, input, linkInfoArray);
            if (exportDialog.isExportToClipboard()) {
                this.export(output, null, -1);
            } else {
                this.export(output, exportDialog.getOutputFileName(), 0);
            }
        }
    }

    private void whenExportNode(Context context, TextNode textNode) {
        ExportDialog exportDialog = new ExportDialog();
        if (exportDialog.runDialog(false, false)) {
            LinkInfo[] linkInfos;
            TextBuffer textBuffer = textNode.acquireTextBuffer();
            String input = textBuffer.getString(0, textBuffer.getLength());
            boolean lineNumbers = exportDialog.isLineNumberSelected();
            boolean linksSelected = exportDialog.isLinksSelected();
            URL url = textNode.getURL();
            if (linksSelected) {
                HashMap<URL, Pair> urlsToHRef = new HashMap<URL, Pair>();
                urlsToHRef.put(url, new Pair((Object)"", (Object)new Integer(0)));
                linkInfos = this.getLinkInfos(context, textNode, urlsToHRef, new HashSet());
            } else {
                linkInfos = null;
            }
            String language = SourceColorizer.getLanguage(url);
            String output = SourceColorizer.toHTML(language, lineNumbers, input, linkInfos);
            if (exportDialog.isExportToClipboard()) {
                this.export(output, null, -1);
            } else {
                this.export(output, exportDialog.getOutputFileName(), 0);
            }
        }
    }

    private void whenExportNodes(Context context, TextNode[] textNodes) {
        ExportDialog exportDialog = new ExportDialog();
        if (exportDialog.runDialog(false, true)) {
            String outputDirectoryName = exportDialog.getOutputDirectoryName();
            URL outputDirUrl = URLFactory.newDirURL((String)outputDirectoryName);
            ProjectContent projectContent = ProjectContent.getInstance((PropertyStorage)context.getProject());
            URLPath allRootDirs = projectContent.getAllContents().getAllRootDirs();
            boolean lineNumbers = exportDialog.isLineNumberSelected();
            boolean linksSelected = exportDialog.isLinksSelected();
            HashMap<URL, Pair> urlsToHRef = new HashMap<URL, Pair>();
            HashMap<URL, URL> targetUrls = new HashMap<URL, URL>();
            int i = 0;
            while (i < textNodes.length) {
                String suffix;
                TextNode textNode = textNodes[i];
                URL sourceUrl = textNode.getURL();
                URL longestMatchingEntry = allRootDirs.getLongestMatchingEntry(sourceUrl);
                if (longestMatchingEntry != null) {
                    String sourcePath = URLFileSystem.getPath((URL)sourceUrl);
                    String entryPath = URLFileSystem.getPath((URL)longestMatchingEntry);
                    suffix = sourcePath.substring(entryPath.length()) + ".html";
                } else {
                    suffix = URLFileSystem.getFileName((URL)sourceUrl) + ".html";
                }
                if (linksSelected) {
                    int level = 0;
                    int length = suffix.length();
                    int j = 0;
                    while (j < length) {
                        if (suffix.charAt(j) == '/') {
                            ++level;
                        }
                        ++j;
                    }
                    urlsToHRef.put(sourceUrl, new Pair((Object)suffix, (Object)new Integer(level)));
                }
                URL targetUrl = URLFactory.newURL((URL)outputDirUrl, (String)suffix);
                targetUrls.put(sourceUrl, targetUrl);
                ++i;
            }
            HashSet outOfScopeClasses = new HashSet();
            int i2 = 0;
            while (i2 < textNodes.length) {
                TextNode textNode = textNodes[i2];
                URL sourceUrl = textNode.getURL();
                URL targetUrl = (URL)targetUrls.get(sourceUrl);
                LinkInfo[] linkInfos = linksSelected ? this.getLinkInfos(context, textNode, urlsToHRef, outOfScopeClasses) : null;
                TextBuffer textBuffer = textNode.acquireTextBuffer();
                String input = textBuffer.getString(0, textBuffer.getLength());
                URL url = textNode.getURL();
                String language = SourceColorizer.getLanguage(url);
                String output = SourceColorizer.toHTML(language, lineNumbers, input, linkInfos);
                int level = -1;
                if (linksSelected) {
                    Pair pair = (Pair)urlsToHRef.get(sourceUrl);
                    level = (Integer)pair.second;
                }
                this.export(output, URLFileSystem.getPlatformPathName((URL)targetUrl), level);
                ++i2;
            }
        }
    }

    private boolean canExport(Context context) {
        if (context == null) {
            return false;
        }
        Element[] selection = context.getSelection();
        if (selection != null) {
            int i = 0;
            while (i < selection.length) {
                Element element = selection[i];
                if (!ExportToHTMLAddin.canExport(element)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private static boolean canExport(Element element) {
        if (!(element instanceof TextNode)) {
            if (element instanceof Folder) {
                Folder folder = (Folder)element;
                Iterator children = folder.getChildren();
                while (children.hasNext()) {
                    Element child = (Element)children.next();
                    if (ExportToHTMLAddin.canExport(child)) continue;
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public static LinkInfo createLinkInfo(SourceName fromNameElement, SourceElement toSourceElement, HashMap urlsToHRef, String tooltip) {
        SourceFile toSourceFile = toSourceElement.getOwningSourceFile();
        URL toUrl = toSourceFile.getURL();
        Pair toPair = (Pair)urlsToHRef.get(toUrl);
        if (toPair != null) {
            String href = (String)toPair.first;
            SourceFile fromSourceFile = fromNameElement.getOwningSourceFile();
            URL fromUrl = fromSourceFile.getURL();
            Pair fromPair = (Pair)urlsToHRef.get(fromUrl);
            if (fromPair != null) {
                int level = (Integer)fromPair.second;
                StringBuffer relativeHref = new StringBuffer();
                int i = 0;
                while (i < level) {
                    relativeHref.append("../");
                    ++i;
                }
                relativeHref.append(href);
                TextBuffer textBuffer = toSourceFile.getTextBuffer();
                LineMap lineMap = textBuffer.getLineMap();
                int toOffset = toSourceElement.getStartOffset();
                int toLine = lineMap.getLineFromOffset(toOffset) + 1;
                return new LinkInfo(fromNameElement.getStartOffset(), fromNameElement.getEndOffset(), relativeHref.toString(), toLine, tooltip);
            }
        }
        return null;
    }
}

