/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.uieditor;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.TreeMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.DynamicMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuWeightComparator;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.keyboard.XMLKeyStrokeContext;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.view.View;
import oracle.ide.view.ViewAdapter;
import oracle.ide.view.ViewEvent;
import oracle.ide.view.ViewListener;
import oracle.jdeveloper.uieditor.ModelFactory;
import oracle.jdeveloper.uieditor.UIEditor;
import oracle.jdeveloper.uieditor.UIEditorCanvas;

public abstract class AbstractFactory
extends ViewAdapter
implements ModelFactory {
    protected HashMap views;
    protected HashMap commands;
    private static final String PARENT_KEY = "AbstractFactory.PARENT";
    private static final String WEIGHT_KEY = "menu-weight";
    private static final String SECTION_KEY = "menu-section-id";
    private JComponent[] items;
    private ArrayList submenus;

    private void $init$() {
        this.views = new HashMap(15);
        this.commands = new HashMap();
    }

    public AbstractFactory() {
        this.$init$();
        Ide.getMainWindow().addDynamicMenuListener((DynamicMenuListener)this);
        this.submenus = new ArrayList();
        this.submenus.add(new Info(-1, null, null, 0.0f, 0.0f));
    }

    public final UIEditorCanvas getView(UIEditor editor) {
        UIEditorCanvas view = (UIEditorCanvas)((Object)this.views.get((Object)editor));
        if (view == null && (view = this.createView()) != null) {
            view.setOwner((View)editor);
            this.views.put(editor, view);
            editor.addViewListener((ViewListener)this);
        }
        if (view != null) {
            view.setContext(editor.getContext());
        }
        return view;
    }

    public synchronized XMLKeyStrokeContext getKeyStrokeContext() {
        return null;
    }

    public int registerSubMenu(int parentID, String name, Integer mnemonic, float weight, float section) {
        Info info = null;
        if (parentID >= 0 && parentID <= this.submenus.size()) {
            info = (Info)this.submenus.get(parentID);
        }
        if (info == null || name == null) {
            return 0;
        }
        if (info.children != null) {
            int i = info.children.length - 1;
            while (i >= 0) {
                Info child = (Info)this.submenus.get(info.children[i]);
                if (child.name.equals(name)) {
                    return info.children[i];
                }
                --i;
            }
        } else {
            info.children = new int[0];
        }
        int[] newChildren = new int[info.children.length + 1];
        int result = this.submenus.size();
        System.arraycopy(info.children, 0, newChildren, 0, info.children.length);
        newChildren[newChildren.length - 1] = result;
        info.children = newChildren;
        this.submenus.add(new Info(parentID, name, mnemonic, weight, section));
        return result;
    }

    public synchronized IdeAction registerAction(int cmdID, String name, Integer mnemonic, Icon icon, int parentID, float weight, float section) {
        Integer key = new Integer(cmdID);
        IdeAction action = (IdeAction)this.commands.get(key);
        if (action == null) {
            action = IdeAction.get((int)cmdID, (String)AddinManager.getAddinManager().getCommand(cmdID, null), (String)name, (String)this.getCategory(), (Integer)mnemonic, (Icon)icon, null, (boolean)true);
            action.putValue(PARENT_KEY, (Object)new Integer(parentID));
            action.putValue(WEIGHT_KEY, (Object)new Float(weight));
            action.putValue(SECTION_KEY, (Object)new Float(section));
            this.commands.put(key, action);
        }
        return action;
    }

    public synchronized IdeAction registerAction(int cmdID, String name, Integer mnemonic, ArrayResourceBundle bundle, int bundleKey, int parentID, float weight, float section) {
        Integer key = new Integer(cmdID);
        IdeAction action = (IdeAction)this.commands.get(key);
        if (action == null) {
            action = IdeAction.get((int)cmdID, (String)AddinManager.getAddinManager().getCommand(cmdID, null), (String)name, (String)this.getCategory(), (Integer)mnemonic, (ArrayResourceBundle)bundle, (int)bundleKey, null, (boolean)true);
            action.putValue(PARENT_KEY, (Object)new Integer(parentID));
            action.putValue(WEIGHT_KEY, (Object)new Float(weight));
            action.putValue(SECTION_KEY, (Object)new Float(section));
            this.commands.put(key, action);
        }
        return action;
    }

    public synchronized IdeAction[] getActions() {
        IdeAction[] actions = new IdeAction[this.commands.size()];
        this.commands.values().toArray(actions);
        return actions;
    }

    public boolean isRegistered(IdeAction action) {
        if (action == null) {
            return false;
        }
        int cmdID = action.getCommandId();
        return this.commands.get(new Integer(cmdID)) != null;
    }

    public final void viewClosed(ViewEvent e) {
        View editor = e.getView();
        UIEditorCanvas view = (UIEditorCanvas)((Object)this.views.get(editor));
        editor.removeViewListener((ViewListener)this);
        view.stateChanged(2);
        view.setOwner(null);
        this.views.remove(editor);
    }

    protected abstract UIEditorCanvas createView();

    protected abstract String getCategory();

    public JComponent[] gatherDynamicActions(Context context) {
        if (this.items == null) {
            IdeAction[] actions = this.getActions();
            Menubar menuMgr = Ide.getMenubar();
            ArrayList<JMenuItem> list = new ArrayList<JMenuItem>();
            int size = this.submenus.size();
            int i = 1;
            while (i < size) {
                Info info = (Info)this.submenus.get(i);
                info.liveInstance = menuMgr.createSubMenu(info.name, info.mnemonic, info.weight, info.section);
                if (info.parentID == 0) {
                    list.add(info.liveInstance);
                } else {
                    Info parent = (Info)this.submenus.get(info.parentID);
                    menuMgr.add((Component)info.liveInstance, parent.liveInstance, info.section);
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < actions.length) {
                Object value = actions[i2].getValue("Hidden");
                if (!(value instanceof Boolean) || !((Boolean)value).booleanValue()) {
                    value = actions[i2].getValue(PARENT_KEY);
                    int parentID = (Integer)value;
                    float marker = 0.0f;
                    value = actions[i2].getValue(WEIGHT_KEY);
                    marker = ((Float)value).floatValue();
                    JMenuItem child = menuMgr.createMenuItem((ToggleAction)actions[i2], marker);
                    value = actions[i2].getValue(SECTION_KEY);
                    if (parentID == 0) {
                        child.putClientProperty(SECTION_KEY, value);
                        list.add(child);
                    } else {
                        Info parent = (Info)this.submenus.get(parentID);
                        marker = ((Float)value).floatValue();
                        menuMgr.add((Component)child, parent.liveInstance, marker);
                    }
                }
                ++i2;
            }
            this.addSeparators(list);
            this.items = new JComponent[list.size()];
            list.toArray(this.items);
            this.submenus.clear();
        }
        return this.items;
    }

    private void addSeparators(ArrayList list) {
        if (list == null || list.size() == 0) {
            return;
        }
        TreeMap<Float, ArrayList<JComponent>> sections = new TreeMap<Float, ArrayList<JComponent>>();
        for (JComponent jComp : list) {
            Float section = (Float)jComp.getClientProperty(SECTION_KEY);
            ArrayList<JComponent> sectionList = (ArrayList<JComponent>)sections.get(section);
            if (sectionList == null) {
                sectionList = new ArrayList<JComponent>();
                sections.put(section, sectionList);
            }
            sectionList.add(jComp);
        }
        list.clear();
        MenuWeightComparator comparator = new MenuWeightComparator();
        float lastWeight = Float.MIN_VALUE;
        float firstWeight = Float.MAX_VALUE;
        for (Object section : sections.keySet()) {
            ArrayList sectionList = (ArrayList)sections.get(section);
            JComponent jComp = null;
            Collections.sort(sectionList, comparator);
            jComp = (JComponent)sectionList.get(0);
            firstWeight = ((Float)jComp.getClientProperty(WEIGHT_KEY)).floatValue();
            if (firstWeight <= lastWeight && lastWeight > Float.MIN_VALUE) {
                int size = sectionList.size();
                int j = 0;
                while (j < size) {
                    lastWeight = MenuConstants.increment((float)lastWeight);
                    ((JComponent)sectionList.get(j)).putClientProperty(WEIGHT_KEY, new Float(lastWeight));
                    ++j;
                }
            } else {
                jComp = (JComponent)sectionList.get(sectionList.size() - 1);
                lastWeight = ((Float)jComp.getClientProperty(WEIGHT_KEY)).floatValue();
            }
            lastWeight = MenuConstants.increment((float)lastWeight);
            jComp = new JSeparator();
            jComp.putClientProperty(WEIGHT_KEY, new Float(lastWeight));
            jComp.putClientProperty(SECTION_KEY, section);
            sectionList.add(jComp);
            list.addAll(sectionList);
        }
    }

    private static final class Info {
        int parentID;
        String name;
        Integer mnemonic;
        float weight;
        float section;
        int[] children;
        JMenu liveInstance;

        private void $init$() {
            this.parentID = 0;
            this.weight = Float.MAX_VALUE;
            this.section = Float.MAX_VALUE;
        }

        public Info(int parentID, String name, Integer mnemonic, float weight, float section) {
            this.$init$();
            this.parentID = parentID;
            this.name = name;
            this.mnemonic = mnemonic;
            this.weight = weight;
            this.section = section;
        }
    }
}

