/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.uieditor;

import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import oracle.ide.Context;
import oracle.ide.net.URLPath;
import oracle.ide.util.Assert;
import oracle.javatools.datatransfer.AugmentableTransferable;
import oracle.javatools.datatransfer.DataTransferPluginRegistry;
import oracle.javatools.datatransfer.ExtendedTransferable;
import oracle.javatools.datatransfer.TransferUtils;
import oracle.jdeveloper.cmt.CmtComponentSource;
import oracle.jdeveloper.cmt.CmtComponents;
import oracle.jdeveloper.uieditor.ModelFactory;
import oracle.jdeveloper.uieditor.datatransfer.OperationFactory;
import oracle.jdeveloper.uieditor.uicanvas.LayoutAssistant;

public final class UIManager {
    private static ModelFactory ORPHAN_FACTORY;
    private static final HashMap MODEL_FACTORIES;
    private static final ArrayList OPERATION_FACTORIES;
    private static final DataTransferPluginRegistry REGISTRY;
    private static ArrayList LAYOUTS;
    private static HashMap NAME_TO_NAME_MAP;
    private static HashMap NAME_TO_CLASS_MAP;
    private static HashMap NAME_TO_INSTANCE_MAP;
    private static HashMap NAME_TO_LIBRARY_MAP;
    private static HashMap NAME_TO_PROXY_MAP;
    private static HashMap NAME_TO_PATH_MAP;
    private static AugmentableTransferable DROP_TRANSFERABLE;
    private static AugmentableTransferable PASTE_TRANSFERABLE;

    public static void setDefaultFactory(ModelFactory factory) {
        if (factory != null) {
            Iterator i;
            Set keys = MODEL_FACTORIES.keySet();
            Iterator iterator = i = keys != null ? keys.iterator() : null;
            if (i != null) {
                while (i.hasNext()) {
                    Object key = i.next();
                    if (MODEL_FACTORIES.get(key) != factory) continue;
                    MODEL_FACTORIES.remove(key);
                    break;
                }
            }
        }
        ORPHAN_FACTORY = factory;
    }

    public static void registerFactory(ModelFactory factory) {
        Class cls;
        Class clazz = cls = factory != null ? factory.getModelClass() : null;
        if (cls != null) {
            MODEL_FACTORIES.put(cls, factory);
        }
    }

    public static ModelFactory getFactory(Class cls) {
        ModelFactory factory = null;
        if (cls != null) {
            factory = (ModelFactory)MODEL_FACTORIES.get(cls);
            while (factory == null) {
                factory = UIManager.getRegisteredInterface(cls);
                if (factory != null || cls == ORPHAN_FACTORY.getModelClass() || (cls = cls.getSuperclass()) == null) break;
                factory = (ModelFactory)MODEL_FACTORIES.get(cls);
            }
        }
        return factory;
    }

    private static ModelFactory getRegisteredInterface(Class targetCls) {
        Class<?>[] ifaces;
        Class<?>[] classArray = ifaces = targetCls != null ? targetCls.getInterfaces() : null;
        if (ifaces != null) {
            int i = 0;
            while (i < ifaces.length) {
                Object factory = MODEL_FACTORIES.get(ifaces[i]);
                if (factory == null) {
                    factory = UIManager.getRegisteredInterface(ifaces[i]);
                }
                if (factory != null) {
                    return (ModelFactory)factory;
                }
                ++i;
            }
        }
        return null;
    }

    public static Iterator getFactories() {
        return MODEL_FACTORIES.values().iterator();
    }

    public static void annotate(CmtComponentSource model, CmtComponents mgr) {
        Iterator iter = UIManager.getFactories();
        while (iter.hasNext()) {
            ((ModelFactory)iter.next()).annotate(model, mgr);
        }
        ORPHAN_FACTORY.annotate(model, mgr);
    }

    public static void registerLayoutManager(String layoutName, String libID, String assistantName) {
        if (layoutName != null) {
            if (assistantName != null) {
                NAME_TO_NAME_MAP.put(layoutName, assistantName);
                NAME_TO_LIBRARY_MAP.put(layoutName, libID);
            } else {
                NAME_TO_NAME_MAP.remove(layoutName);
                NAME_TO_LIBRARY_MAP.remove(layoutName);
            }
        }
    }

    public static List getAssistedLayouts() {
        UIManager.loadAssistants();
        return (List)LAYOUTS.clone();
    }

    private static void loadAssistants() {
        Iterator i;
        Set keys = NAME_TO_NAME_MAP.keySet();
        Iterator iterator = i = keys != null ? keys.iterator() : null;
        if (i != null) {
            String layout = null;
            String assistant = null;
            while (i.hasNext()) {
                try {
                    layout = (String)i.next();
                    assistant = (String)NAME_TO_NAME_MAP.get(layout);
                    Class<?> cls = Class.forName(assistant);
                    if (!LayoutAssistant.class.isAssignableFrom(cls)) continue;
                    if (LAYOUTS.indexOf(layout) < 0) {
                        LAYOUTS.add(layout);
                    }
                    NAME_TO_CLASS_MAP.put(layout, cls);
                    NAME_TO_INSTANCE_MAP.remove(layout);
                }
                catch (NoClassDefFoundError e) {
                    Assert.println((String)("Assistant for " + layout + " could not be found: " + assistant));
                }
                catch (Throwable t) {
                    if (!(t instanceof ThreadDeath)) continue;
                    throw (ThreadDeath)t;
                }
            }
        }
        NAME_TO_NAME_MAP.clear();
    }

    public static LayoutAssistant getLayoutAssistant(String clsName) {
        UIManager.loadAssistants();
        LayoutAssistant assistant = (LayoutAssistant)NAME_TO_INSTANCE_MAP.get(clsName);
        if (assistant != null) {
            return assistant;
        }
        Class cls = (Class)NAME_TO_CLASS_MAP.get(clsName);
        if (cls != null) {
            try {
                assistant = (LayoutAssistant)cls.newInstance();
                NAME_TO_INSTANCE_MAP.put(clsName, assistant);
            }
            catch (Exception e) {
                Assert.println((String)("Bad Assistant for " + clsName + ": " + cls.getName()));
            }
        }
        return assistant;
    }

    public static String getLibraryForLayout(String layout) {
        return layout != null ? (String)NAME_TO_LIBRARY_MAP.get(layout) : null;
    }

    public static void registerConcreteProxy(String clsName, String proxyName, URLPath proxyPath) {
        if (clsName != null) {
            if (proxyName != null) {
                NAME_TO_PROXY_MAP.put(clsName, proxyName);
                NAME_TO_PATH_MAP.put(clsName, proxyPath);
            } else {
                NAME_TO_PROXY_MAP.remove(clsName);
                NAME_TO_PATH_MAP.remove(clsName);
            }
        }
    }

    public static String getConcreteProxy(String clsName) {
        return clsName != null ? (String)NAME_TO_PROXY_MAP.get(clsName) : null;
    }

    public static URLPath getProxyPath(String clsName) {
        URLPath result = new URLPath();
        if (clsName != null) {
            result.add((URLPath)NAME_TO_PATH_MAP.get(clsName));
        } else {
            Iterator i;
            Collection values = NAME_TO_PATH_MAP.values();
            Iterator iterator = i = values != null ? values.iterator() : null;
            if (i != null) {
                while (i.hasNext()) {
                    result.add((URLPath)i.next());
                }
            }
        }
        return result;
    }

    public static List createApplicableOperations(Context c, ExtendedTransferable t) {
        LinkedList ops = new LinkedList();
        for (OperationFactory factory : OPERATION_FACTORIES) {
            List list = factory.createRelevantOperations(c, t);
            if (list == null) continue;
            ops.addAll(list);
        }
        return ops;
    }

    public static void registerOperationFactory(OperationFactory factory) {
        if (!OPERATION_FACTORIES.contains(factory)) {
            OPERATION_FACTORIES.add(factory);
        }
    }

    public static void unregisterOperationFactory(OperationFactory factory) {
        if (OPERATION_FACTORIES.contains(factory)) {
            OPERATION_FACTORIES.remove(factory);
        }
    }

    public static DataTransferPluginRegistry getDataTransferPluginRegistry() {
        return REGISTRY;
    }

    public static ExtendedTransferable getDropTransferable() {
        return DROP_TRANSFERABLE;
    }

    public static void setDropTransferable(Transferable t) {
        if (t == null) {
            DROP_TRANSFERABLE = null;
        } else if (t != DROP_TRANSFERABLE) {
            ArrayList<DataTransferPluginRegistry> registries = new ArrayList<DataTransferPluginRegistry>();
            DROP_TRANSFERABLE = TransferUtils.createTransferable((Transferable)t);
            registries.add(REGISTRY);
            registries.add(DataTransferPluginRegistry.getGlobalInstance());
            DataTransferPluginRegistry.performAugmentation((AugmentableTransferable)DROP_TRANSFERABLE, registries);
        }
    }

    public static ExtendedTransferable getPasteTransferable() {
        return PASTE_TRANSFERABLE;
    }

    public static void setPasteTransferable(Transferable t) {
        if (t == null) {
            PASTE_TRANSFERABLE = null;
        } else if (t != PASTE_TRANSFERABLE) {
            ArrayList<DataTransferPluginRegistry> registries = new ArrayList<DataTransferPluginRegistry>();
            PASTE_TRANSFERABLE = TransferUtils.createTransferable((Transferable)t);
            registries.add(REGISTRY);
            registries.add(DataTransferPluginRegistry.getGlobalInstance());
            DataTransferPluginRegistry.performAugmentation((AugmentableTransferable)PASTE_TRANSFERABLE, registries);
        }
    }

    static {
        MODEL_FACTORIES = new HashMap();
        OPERATION_FACTORIES = new ArrayList();
        REGISTRY = new DataTransferPluginRegistry();
        LAYOUTS = new ArrayList();
        NAME_TO_NAME_MAP = new HashMap();
        NAME_TO_CLASS_MAP = new HashMap();
        NAME_TO_INSTANCE_MAP = new HashMap();
        NAME_TO_LIBRARY_MAP = new HashMap();
        NAME_TO_PROXY_MAP = new HashMap();
        NAME_TO_PATH_MAP = new HashMap();
    }
}

