/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.uieditor.dnd;

import java.awt.Component;
import java.awt.Point;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.bali.xml.share.ActionProxy;
import oracle.bali.xml.share.GroupingAction;
import oracle.jdeveloper.cmt.CmtModel;
import oracle.jdeveloper.uieditor.datatransfer.Operation;
import oracle.jdeveloper.uieditor.datatransfer.OperationProcessor;

public class DropMenuInvoker
implements PopupMenuListener,
Runnable {
    private boolean _needsCleanup;
    private final Component _target;
    private final Point _location;
    private final CmtModel _model;
    private final OperationProcessor _processor;
    private final Runnable _cleanupTask;
    private final JPopupMenu _mainMenu;
    private static final int _POPUP_OFFSET_X = 3;
    private static final int _POPUP_OFFSET_Y = 3;
    private static final Object _UNSET = new Object();

    public DropMenuInvoker(DropTargetDropEvent event, CmtModel model, OperationProcessor processor, Runnable cleanupTask) {
        this.$init$();
        this._target = event.getDropTargetContext().getComponent();
        this._location = event.getLocation();
        this._model = model;
        this._processor = processor;
        this._cleanupTask = cleanupTask;
    }

    public DropMenuInvoker(Component target, Point location, CmtModel model, OperationProcessor processor, Runnable cleanupTask) {
        this.$init$();
        this._target = target;
        this._location = location;
        this._model = model;
        this._processor = processor;
        this._cleanupTask = cleanupTask;
    }

    public void invoke() {
        this._mainMenu.addPopupMenuListener(this);
        Object lastGroup = _UNSET;
        Iterator itor = this._processor.getSupportedOperations();
        while (itor.hasNext()) {
            List transferDataInfos;
            Operation operation = (Operation)itor.next();
            Action opAction = operation.createAsAction(this._model, transferDataInfos = this._processor.getListOfDataAndPositions(operation));
            if (opAction == null) continue;
            lastGroup = this._addToMenu(this._mainMenu, opAction, lastGroup);
        }
        this._mainMenu.addSeparator();
        this._mainMenu.add(new CancelAction());
        this._mainMenu.show(this._target, this._location.x + 3, this._location.y + 3);
    }

    public void popupMenuCanceled(PopupMenuEvent e) {
        this._detachAndClean(e);
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        if (e.getSource() == this._mainMenu) {
            this._detachAndClean(e);
        }
    }

    private void _detachAndClean(PopupMenuEvent e) {
        ((JPopupMenu)e.getSource()).removePopupMenuListener(this);
        this._cleanupIfNeeded();
    }

    public void run() {
        this._cleanupIfNeeded();
    }

    private Object _addToMenu(JPopupMenu menu, Action action, Object lastGroup) {
        Object curGroup = GroupingAction.getGroupIdentifier((Action)action);
        if (lastGroup != _UNSET && curGroup != lastGroup) {
            menu.addSeparator();
        }
        if (action instanceof GroupingAction) {
            GroupingAction grouping = (GroupingAction)action;
            String menuName = (String)grouping.getValue("Name");
            JMenu submenu = new JMenu(menuName);
            submenu.getPopupMenu().addPopupMenuListener(this);
            Object submenuLastGroup = _UNSET;
            Iterator itor = grouping.getChildIterator();
            while (itor.hasNext()) {
                Action next = (Action)itor.next();
                submenuLastGroup = this._addToMenu(submenu.getPopupMenu(), next, submenuLastGroup);
            }
            menu.add(submenu);
        } else {
            action = new CleanupProxy((Action)action);
            menu.add((Action)action);
        }
        return curGroup;
    }

    private void _cleanupIfNeeded() {
        if (this._needsCleanup) {
            this._needsCleanup = false;
            if (this._cleanupTask != null) {
                this._cleanupTask.run();
            }
        }
    }

    private void $init$() {
        this._needsCleanup = true;
        this._mainMenu = new JPopupMenu();
    }

    static void mav$_cleanupIfNeeded(DropMenuInvoker dropMenuInvoker) {
        dropMenuInvoker._cleanupIfNeeded();
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super("Cancel");
        }

        public void actionPerformed(ActionEvent e) {
            DropMenuInvoker.mav$_cleanupIfNeeded(DropMenuInvoker.this);
        }
    }

    private class CleanupProxy
    extends ActionProxy {
        private final Action _base;

        public CleanupProxy(Action base) {
            this._base = base;
        }

        protected Action getBaseAction() {
            return this._base;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                super.actionPerformed(e);
            }
            finally {
                DropMenuInvoker.mav$_cleanupIfNeeded(DropMenuInvoker.this);
            }
        }
    }
}

