/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.uieditor.uicanvas;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import oracle.jdeveloper.layout.XYConstraints;

public final class BoxEffects {
    public static final int SELECT = 1;
    public static final int DRAG = 2;
    public static final int THICK_GRID = 3;
    public static final int THIN_GRID = 4;
    private static final int INITIAL_SELECT = 1;
    private static final Border SELECT_BORDER = new LineBorder(Color.black, 1);
    private static final Border DRAG_BORDER = new LineBorder(Color.gray, 2);
    private static final Border THIN_GRID_BORDER = new LineBorder(Color.gray, 1);
    private static final Border THICK_GRID_BORDER = DRAG_BORDER;
    private JPanel[] edges;
    private Container parent;

    public BoxEffects(Container container) {
        this.parent = container;
        this.assure(1);
    }

    public void show(int i, Point location, Dimension size, int style) {
        this.assure(i + 1);
        int x = location.x;
        int y = location.y;
        int width = size.width;
        int height = size.height;
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        if (i < this.edges.length) {
            switch (style) {
                case 2: {
                    this.edges[i].setBorder(DRAG_BORDER);
                    break;
                }
                case 4: {
                    this.edges[i].setBorder(THIN_GRID_BORDER);
                    break;
                }
                case 3: {
                    this.edges[i].setBorder(THICK_GRID_BORDER);
                    break;
                }
                default: {
                    this.edges[i].setBorder(SELECT_BORDER);
                }
            }
            this.parent.add(this.edges[i], new XYConstraints(x, y, width, height), 0);
            this.edges[i].setVisible(true);
            this.edges[i].revalidate();
        }
    }

    public boolean hide(int i) {
        if (this.edges == null) {
            return false;
        }
        if (i >= this.edges.length) {
            return false;
        }
        this.parent.remove(this.edges[i]);
        this.edges[i].setVisible(false);
        return true;
    }

    public void hideAll() {
        if (this.edges == null) {
            return;
        }
        int i = 0;
        while (i < this.edges.length) {
            this.parent.remove(this.edges[i]);
            this.edges[i].setVisible(false);
            ++i;
        }
    }

    private void assure(int i) {
        if (i > 0 && (this.edges == null || i > this.edges.length)) {
            int oldlen;
            JPanel[] newEdges = new JPanel[i];
            int n = oldlen = this.edges != null ? this.edges.length : 0;
            if (oldlen > 0) {
                System.arraycopy(this.edges, 0, newEdges, 0, oldlen);
            }
            this.edges = newEdges;
            int j = oldlen;
            while (j < this.edges.length) {
                this.edges[j] = new JPanel();
                this.edges[j].setVisible(false);
                this.edges[j].setEnabled(false);
                this.edges[j].setOpaque(false);
                this.parent.add((Component)this.edges[j], 0);
                ++j;
            }
        }
    }
}

