/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.usage;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import oracle.ide.index.Index;
import oracle.ide.index.IndexManager;
import oracle.ide.index.keyword.KeywordCriteria;
import oracle.ide.index.task.BackgroundTask;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.net.URLComparator;
import oracle.ide.util.Assert;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.util.AsyncScheduler;
import oracle.javatools.parser.util.AsyncTask;
import oracle.jdeveloper.java.JavaFileProvider;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdeveloper.usage.UsageArb;
import oracle.jdeveloper.usage.UsageManager;
import oracle.jdeveloper.usage.UsageQueryTask;
import oracle.jdeveloper.usage.event.UsageEvent;
import oracle.jdeveloper.usage.event.UsageListener;
import oracle.jdeveloper.usage.util.AbstractBackgroundTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BaseQueryTaskImpl
extends AbstractBackgroundTask
implements UsageQueryTask {
    protected UsageManager _usageManager;
    protected UsageListener _listener;
    protected URL[] _urlsToSearch;
    protected static final String FINISHED_RESULT = "finished";
    protected SourceFile _sourceFile;

    BaseQueryTaskImpl(UsageManager usageManager, UsageListener listener, URL[] urlsToSearch) {
        this.$init$();
        this._usageManager = usageManager;
        this._listener = listener;
        this._urlsToSearch = urlsToSearch;
    }

    protected UsageManager getUsageManager() {
        return this._usageManager;
    }

    protected JavaFileProvider getJavaProvider() {
        return this._usageManager.getJavaProvider();
    }

    @Override
    protected AsyncScheduler getSchedulerImpl() {
        return UsageManager.USAGE_SCHEDULER;
    }

    @Override
    protected final Object runTaskImpl() {
        try {
            Object result = this.runQueryImpl();
            boolean wasCancelled = result == "cancelled";
            int usageCode = wasCancelled ? 1 : 0;
            this.notifyFinished(usageCode);
            Object object = result;
            return object;
        }
        catch (AsyncTask.CancelledException e) {
            this.notifyFinished(1);
            String string = "cancelled";
            return string;
        }
        catch (CancellationException e) {
            this.notifyFinished(1);
            String string = "cancelled";
            return string;
        }
        catch (RuntimeException e) {
            this.notifyFinished(2);
            throw e;
        }
    }

    private void notifyFinished(int usageCode) {
        UsageEvent event = new UsageEvent(this, usageCode);
        this._listener.notifyFinished(event);
    }

    private void notifySkipped(URL url) {
        UsageEvent event = new UsageEvent(this, 3, url);
        this._listener.notifySkipped(event);
    }

    private void notifySkipped(URL url, int start, int end) {
        UsageEvent event = new UsageEvent(this, 4, url, start, end);
        this._listener.notifySkipped(event);
    }

    protected abstract boolean isStartingDataValid();

    protected abstract String getSearchKeyword();

    protected abstract void performUsages(SourceFile var1, int[] var2, int[] var3);

    protected URL[] getURLsToSearch(int rangeStart, int rangeEnd) throws AsyncTask.CancelledException {
        URL[] urlsToSearch = this._urlsToSearch != null ? this._urlsToSearch : this.getURLsFromKeywordIndex(rangeStart, rangeEnd);
        URL[] javaUrlsToSearch = this.getJavaURLsFromURLs(urlsToSearch);
        this.setProgressFromSubTask(100, 0, 10);
        return javaUrlsToSearch;
    }

    protected URL[] getJavaURLsFromURLs(URL[] urls) throws AsyncTask.CancelledException {
        ArrayList<URL> urlList = new ArrayList<URL>();
        int numUrls = urls.length;
        int i = 0;
        while (i < numUrls) {
            this.bailIfCancelled();
            URL url = urls[i];
            try {
                if (url != null) {
                    Node node = NodeFactory.findOrCreate((URL)url);
                    if (node != null && node instanceof JavaSourceNode) {
                        urlList.add(url);
                    } else {
                        this.notifySkipped(url);
                    }
                }
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
            ++i;
        }
        Collections.sort(urlList, new URLComparator());
        numUrls = urlList.size();
        URL[] filteredURLs = new URL[numUrls];
        return urlList.toArray(filteredURLs);
    }

    /*
     * Unable to fully structure code
     */
    protected URL[] getURLsFromKeywordIndex(int rangeStart, int rangeEnd) throws AsyncTask.CancelledException {
        searchKeyword = this.getSearchKeyword();
        foundList = new ArrayList<URL>();
        this.setProgressText(UsageArb.getString(8));
        im = IndexManager.getIndexManager();
        criteria = KeywordCriteria.get((String)searchKeyword);
        project = this._usageManager.getProject();
        this.bailIfCancelled();
        if (project != null) {
            index = im.getIndex(project);
            try {
                try {
                    results = this.getResults((BackgroundTask<URL[]>)index.query(criteria));
                    if (results == null) ** GOTO lbl37
                    foundList.addAll(Arrays.asList(results));
                }
                catch (RejectedExecutionException e) {}
            }
            finally {
                index.release();
            }
        } else {
            path = this._usageManager.getProjectPath();
            index = im.getIndex(null, path._sourcePath);
            try {
                try {
                    results = this.getResults((BackgroundTask<URL[]>)index.query(criteria));
                    if (results != null) {
                        foundList.addAll(Arrays.asList(results));
                    }
                }
                catch (RejectedExecutionException e) {}
            }
            finally {
                index.release();
            }
        }
        numUrls = foundList.size();
        urls = new URL[numUrls];
        return foundList.toArray(urls);
    }

    private URL[] getResults(BackgroundTask<URL[]> query) throws AsyncTask.CancelledException {
        URL[] results = null;
        while (!query.isDone()) {
            if (this.isCancelledImpl()) {
                query.cancel(true);
                this.bailIfCancelled();
            }
            this.setProgressFromSubTask(query.getProgress(), 0, 10);
            this.setProgressText(query.getProgressText());
            try {
                results = (URL[])query.get((long)100, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException timeoutException) {
            }
            catch (InterruptedException ie) {
            }
            catch (CancellationException ce) {
                break;
            }
            catch (ExecutionException ee) {
                Assert.printStackTrace((Throwable)ee);
                break;
            }
        }
        return results;
    }

    protected int[][] getKeywordLocations(URL url, ReadTextBuffer textBuffer) {
        Index index;
        String searchKeyword = this.getSearchKeyword();
        IndexManager im = IndexManager.getIndexManager();
        Project project = this._usageManager.getProject();
        if (project != null) {
            index = im.getIndex(project);
        } else {
            UsageManager.ProjectPath path = this._usageManager.getProjectPath();
            index = im.getIndex(null, path._sourcePath);
        }
        try {
            int[][] locations = index.locate(url, (Object)"keyword.contains", (Object)searchKeyword);
            int numOther = 0;
            int[] nArray = locations[2];
            int n = 0;
            while (n < nArray.length) {
                int flag = nArray[n];
                if (flag != 0) {
                    ++numOther;
                }
                ++n;
            }
            int numLocations = locations[0].length - numOther;
            int[] startLocations = new int[numLocations];
            int[] endLocations = new int[numLocations];
            int[] otherStartLocations = new int[numOther];
            int[] otherEndLocations = new int[numOther];
            int currentLocation = 0;
            int currentOther = 0;
            int i = 0;
            while (i < locations[0].length) {
                if (locations[2][i] == 0) {
                    startLocations[currentLocation] = locations[0][i];
                    endLocations[currentLocation++] = locations[1][i];
                } else {
                    otherStartLocations[currentOther] = locations[0][i];
                    otherEndLocations[currentOther++] = locations[1][i];
                }
                ++i;
            }
            int[][] nArrayArray = new int[][]{startLocations, endLocations, otherStartLocations, otherEndLocations};
            return nArrayArray;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            index.release();
        }
    }

    protected void notifySkippedOccurrences(URL url, int[] startLocations, int[] endLocations) {
        int numOccurrences = startLocations.length;
        int i = 0;
        while (i < numOccurrences) {
            int start = startLocations[i];
            int end = endLocations[i];
            this.notifySkipped(url, start, end);
            ++i;
        }
    }

    protected int[] addIntToArray(int[] array, int count, int value) {
        if (count >= array.length) {
            int newSize = 2 * Math.max(array.length, 10);
            int[] newArray = new int[newSize];
            System.arraycopy(array, 0, newArray, 0, count);
            array = newArray;
        }
        array[count] = value;
        return array;
    }

    protected int[] trimArrayToSize(int[] array, int count) {
        int len = array.length;
        if (len == count) {
            return array;
        }
        int[] newArray = new int[count];
        System.arraycopy(array, 0, newArray, 0, count);
        return newArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cancelTaskImpl() {
        BaseQueryTaskImpl baseQueryTaskImpl = this;
        synchronized (baseQueryTaskImpl) {
            if (this._sourceFile != null) {
                this._sourceFile.cancelCompile();
            }
        }
    }

    private void $init$() {
        this._sourceFile = null;
    }

    /*
     * Exception decompiling
     */
    protected Object runQueryImpl() throws AsyncTask.CancelledException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index 1 out of bounds for length 1
         *     at java.base/jdk.internal.util.Preconditions.outOfBounds(Preconditions.java:100)
         *     at java.base/jdk.internal.util.Preconditions.outOfBoundsCheckIndex(Preconditions.java:106)
         *     at java.base/jdk.internal.util.Preconditions.checkIndex(Preconditions.java:302)
         *     at java.base/java.util.Objects.checkIndex(Objects.java:385)
         *     at java.base/java.util.ArrayList.get(ArrayList.java:427)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CondenseConditionals.condenseConditionals(CondenseConditionals.java:59)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.condenseConditionals(Op03Rewriters.java:68)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:639)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected static String getClassName(String fqClassName) {
        int dot = fqClassName.lastIndexOf(46);
        return dot == -1 ? fqClassName : fqClassName.substring(dot + 1);
    }
}

