/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.usage;

import java.net.URL;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.jdeveloper.usage.BaseQueryTaskImpl;
import oracle.jdeveloper.usage.UsageManager;
import oracle.jdeveloper.usage.event.ClassUsageListener;
import oracle.jdevimpl.java.usage.BaseUsageQuery;

final class ClassQueryTaskImpl
extends BaseQueryTaskImpl {
    private String _fqClassName;
    private JavaClass _javaClass;
    protected String _className;

    ClassQueryTaskImpl(UsageManager usageManager, String fqClassName, ClassUsageListener listener, URL[] urlsToSearch) {
        super(usageManager, listener, urlsToSearch);
        this._fqClassName = fqClassName;
    }

    ClassQueryTaskImpl(UsageManager usageManager, JavaClass javaClass, ClassUsageListener listener, URL[] urlsToSearch) {
        super(usageManager, listener, urlsToSearch);
        this._javaClass = javaClass;
        this._fqClassName = javaClass.getRawName();
    }

    protected boolean isStartingDataValid() {
        return this._fqClassName.length() > 0;
    }

    protected String getSearchKeyword() {
        if (this._className == null) {
            this._className = ClassQueryTaskImpl.getClassName(this._fqClassName);
        }
        return this._className;
    }

    protected void performUsages(SourceFile file, int[] startLocations, int[] endLocations) {
        BaseUsageQuery.findClassUsages(file, this._listener, startLocations, endLocations, this._fqClassName);
    }
}

