/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.usage;

import java.net.URL;
import java.util.Arrays;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.scanner.JavaLexer;
import oracle.jdeveloper.usage.BaseQueryTaskImpl;
import oracle.jdeveloper.usage.UsageManager;
import oracle.jdeveloper.usage.event.ConstructorUsageListener;
import oracle.jdevimpl.java.usage.BaseUsageQuery;

final class ConstructorQueryTaskImpl
extends BaseQueryTaskImpl {
    private String _fqClassName;
    private String[] _fqParameterTypes;
    protected String _className;

    ConstructorQueryTaskImpl(UsageManager usageManager, String fqClassName, String[] fqParameterTypes, ConstructorUsageListener listener, URL[] urlsToSearch) {
        super(usageManager, listener, urlsToSearch);
        this._fqClassName = fqClassName;
        this._fqParameterTypes = fqParameterTypes;
    }

    protected boolean isStartingDataValid() {
        if (this._fqClassName.length() >= 0 && this._fqParameterTypes != null) {
            int numParameters = this._fqParameterTypes.length;
            int i = 0;
            while (i < numParameters) {
                String type = this._fqParameterTypes[i];
                if (type == null || type.length() == 0) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    protected String getSearchKeyword() {
        if (this._className == null) {
            this._className = ConstructorQueryTaskImpl.getClassName(this._fqClassName);
        }
        return this._className;
    }

    protected int[][] getKeywordLocations(URL url, ReadTextBuffer textBuffer) {
        JavaLexer lexer = new JavaLexer();
        lexer.setTextBuffer(textBuffer);
        lexer.setPosition(0);
        lexer.setRecognizeSQLJ(true);
        lexer.setSkipComments(true);
        LexerToken lexerToken = lexer.createLexerToken();
        lexer.lex(lexerToken);
        int[] startLocations = new int[10];
        int[] endLocations = new int[10];
        int countLocations = 0;
        while (true) {
            int token = lexerToken.getToken();
            int tokenStart = lexerToken.getStartOffset();
            int tokenEnd = lexerToken.getEndOffset();
            if (token == 0) break;
            int nextToken = lexer.lex(lexerToken);
            switch (token) {
                case 133: 
                case 136: {
                    if (nextToken != 55) break;
                    startLocations = this.addIntToArray(startLocations, countLocations, tokenStart);
                    endLocations = this.addIntToArray(endLocations, countLocations, tokenEnd);
                    ++countLocations;
                }
            }
        }
        int[][] nameLocations = super.getKeywordLocations(url, textBuffer);
        int[] nameStartLocations = nameLocations[0];
        int[] nameEndLocations = nameLocations[1];
        int numLocations = nameStartLocations.length;
        int i = 0;
        while (i < numLocations) {
            int nameStart = nameStartLocations[i];
            lexer.setPosition(nameStart);
            lexer.lex(lexerToken);
            int token = lexer.lex(lexerToken);
            if (token == 55) {
                int nameEnd = nameEndLocations[i];
                startLocations = this.addIntToArray(startLocations, countLocations, nameStart);
                endLocations = this.addIntToArray(endLocations, countLocations, nameEnd);
                ++countLocations;
            }
            ++i;
        }
        startLocations = this.trimArrayToSize(startLocations, countLocations);
        endLocations = this.trimArrayToSize(endLocations, countLocations);
        Arrays.sort(startLocations);
        Arrays.sort(endLocations);
        return new int[][]{startLocations, endLocations, nameLocations[2], nameLocations[3]};
    }

    protected void performUsages(SourceFile file, int[] startLocations, int[] endLocations) {
        BaseUsageQuery.findConstructorUsages(file, this._listener, startLocations, endLocations, this._fqClassName, this._fqParameterTypes);
    }
}

