/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.usage;

import java.net.URL;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.jdeveloper.usage.BaseQueryTaskImpl;
import oracle.jdeveloper.usage.UsageManager;
import oracle.jdeveloper.usage.event.FieldUsageListener;
import oracle.jdevimpl.java.usage.BaseUsageQuery;

final class FieldQueryTaskImpl
extends BaseQueryTaskImpl {
    private String _fqClassName;
    private String _fqFieldType;
    private String _fieldName;
    private JavaField _javaField;

    FieldQueryTaskImpl(UsageManager usageManager, String fqClassName, String fieldName, FieldUsageListener listener, URL[] urlsToSearch) {
        this(usageManager, fqClassName, null, fieldName, listener, urlsToSearch);
    }

    FieldQueryTaskImpl(UsageManager usageManager, String fqClassName, String fqFieldType, String fieldName, FieldUsageListener listener, URL[] urlsToSearch) {
        super(usageManager, listener, urlsToSearch);
        this.$init$();
        this._fqClassName = fqClassName;
        this._fqFieldType = fqFieldType;
        this._fieldName = fieldName;
    }

    FieldQueryTaskImpl(UsageManager usageManager, JavaField javaField, FieldUsageListener listener, URL[] urlsToSearch) {
        super(usageManager, listener, urlsToSearch);
        this.$init$();
        this._javaField = javaField;
        this._fqClassName = javaField.getOwningClass().getRawName();
        JavaType fieldType = javaField.getResolvedType();
        if (fieldType != null) {
            this._fqFieldType = fieldType.getRawName();
        }
        this._fieldName = javaField.getName();
    }

    private void $init$() {
        this._fqFieldType = "";
    }

    protected boolean isStartingDataValid() {
        return this._fieldName.length() > 0 && this._fqClassName.length() > 0;
    }

    protected String getSearchKeyword() {
        return this._fieldName;
    }

    protected void performUsages(SourceFile file, int[] startLocations, int[] endLocations) {
        BaseUsageQuery.findFieldUsages(file, this._listener, startLocations, endLocations, this._fqClassName, this._fieldName);
    }
}

