/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.usage;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.EventHandler;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.model.Recognizer;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicEditorPane;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdeveloper.usage.UsageManager;
import oracle.jdeveloper.usage.UsageQueryTask;
import oracle.jdeveloper.usage.event.ClassUsageEvent;
import oracle.jdeveloper.usage.event.ClassUsageListener;
import oracle.jdeveloper.usage.event.ConstructorUsageEvent;
import oracle.jdeveloper.usage.event.ConstructorUsageListener;
import oracle.jdeveloper.usage.event.FieldUsageEvent;
import oracle.jdeveloper.usage.event.FieldUsageListener;
import oracle.jdeveloper.usage.event.MethodUsageEvent;
import oracle.jdeveloper.usage.event.MethodUsageListener;
import oracle.jdeveloper.usage.event.UsageEvent;
import oracle.jdeveloper.usage.util.NodeUtilities;

public class UsageFrame
extends JFrame {
    private static final String VIEW_ROOT = "/home/acyu/m/";
    private static String jdkJar = "/home/acyu/m/oracle/jdk/jre/lib/rt.jar";
    private static String clsDir = "/home/acyu/m/classes";
    private static final String SRC_ROOT = "/home/acyu/m/jdev/src/";
    private static String[] jdevSrcDirs = new String[]{"/home/acyu/m/jdev/src/common"};
    private static String srcPath = UsageFrame.strsToPath(jdevSrcDirs);
    private static String queryClassText = "oracle.javatools.data.HashStructure";
    private static String queryFieldText = "java.awt.Point int x";
    private static String queryConstructorText = "java.lang.String java.lang.String";
    private static String queryMethodText = "java.lang.String substring int";
    private JTextArea _srcRootField;
    private JTextArea _clsRootField;
    private JTextArea _jdkField;
    private JTextField _queryClassField;
    private JTextField _queryFieldField;
    private JTextField _queryConstructorField;
    private JTextField _queryMethodField;
    private JTextArea _buildFeedback;
    private static final GridBagConstraints _gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0);
    private static final byte[] EMPTY_BUFFER = new byte[0];
    private static final boolean USE_LIST = false;

    public UsageFrame() {
        JPanel mainPanel = new JPanel(new GridBagLayout());
        this._jdkField = UsageFrame.newJTextArea(jdkJar);
        this._srcRootField = UsageFrame.newJTextArea(srcPath);
        this._clsRootField = UsageFrame.newJTextArea(clsDir);
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab("Sourcepath", new JScrollPane(this._srcRootField));
        tabbedPane.addTab("Classpath", new JScrollPane(this._clsRootField));
        tabbedPane.addTab("Library Path", new JScrollPane(this._jdkField));
        mainPanel.add((Component)tabbedPane, UsageFrame.gbc(0, 0, 3, 1, 1.0, 1.0, 17, 1));
        this._queryClassField = new JTextField(queryClassText);
        JButton queryClassButton = new JButton("Run Class Query");
        queryClassButton.addActionListener(UsageFrame.createActionListener(this, "startClassQuery"));
        mainPanel.add((Component)new JLabel("Class Usage Search: "), UsageFrame.gbc(0, 3, 1, 1, 0.0, 0.0, 17, 0));
        mainPanel.add((Component)this._queryClassField, UsageFrame.gbc(1, 3, 1, 1, 1.0, 0.0, 17, 2));
        mainPanel.add((Component)queryClassButton, UsageFrame.gbc(2, 3, 1, 1, 0.0, 0.0, 17, 0));
        this._queryFieldField = new JTextField(queryFieldText);
        JButton queryFieldButton = new JButton("Run Field Query");
        queryFieldButton.addActionListener(UsageFrame.createActionListener(this, "startFieldQuery"));
        mainPanel.add((Component)new JLabel("Field Usage Search: "), UsageFrame.gbc(0, 4, 1, 1, 0.0, 0.0, 17, 0));
        mainPanel.add((Component)this._queryFieldField, UsageFrame.gbc(1, 4, 1, 1, 1.0, 0.0, 17, 2));
        mainPanel.add((Component)queryFieldButton, UsageFrame.gbc(2, 4, 1, 1, 0.0, 0.0, 17, 0));
        this._queryConstructorField = new JTextField(queryConstructorText);
        JButton queryConstructorButton = new JButton("Run Constructor Query");
        queryConstructorButton.addActionListener(UsageFrame.createActionListener(this, "startConstructorQuery"));
        mainPanel.add((Component)new JLabel("Constructor Usage Search: "), UsageFrame.gbc(0, 5, 1, 1, 0.0, 0.0, 17, 0));
        mainPanel.add((Component)this._queryConstructorField, UsageFrame.gbc(1, 5, 1, 1, 1.0, 0.0, 17, 2));
        mainPanel.add((Component)queryConstructorButton, UsageFrame.gbc(2, 5, 1, 1, 0.0, 0.0, 17, 0));
        this._queryMethodField = new JTextField(queryMethodText);
        JButton queryMethodButton = new JButton("Run Method Query");
        queryMethodButton.addActionListener(UsageFrame.createActionListener(this, "startMethodQuery"));
        mainPanel.add((Component)new JLabel("Method Usage Search: "), UsageFrame.gbc(0, 6, 1, 1, 0.0, 0.0, 17, 0));
        mainPanel.add((Component)this._queryMethodField, UsageFrame.gbc(1, 6, 1, 1, 1.0, 0.0, 17, 2));
        mainPanel.add((Component)queryMethodButton, UsageFrame.gbc(2, 6, 1, 1, 0.0, 0.0, 17, 0));
        this._buildFeedback = new JTextArea();
        this._buildFeedback.setFont(new Font("DialogInput", 0, 12));
        JScrollPane feedbackScroller = new JScrollPane(this._buildFeedback);
        feedbackScroller.setVerticalScrollBarPolicy(22);
        this.startFeedbackThread();
        mainPanel.add(Box.createVerticalStrut(10), UsageFrame.gbc(0, 9, 3, 1, 1.0, 0.0, 17, 0));
        mainPanel.add((Component)new JLabel("Build Output:"), UsageFrame.gbc(0, 10, 3, 1, 1.0, 0.0, 17, 0));
        mainPanel.add((Component)feedbackScroller, UsageFrame.gbc(0, 11, 3, 1, 1.0, 1.0, 17, 1));
        this.getContentPane().add(mainPanel);
    }

    private void startFeedbackThread() {
        try {
            PipedInputStream inPipe = new PipedInputStream();
            PipedOutputStream outPipe = new PipedOutputStream(inPipe);
            CollaterOutputStream collaterOS = new CollaterOutputStream();
            PrintStream printRedirector = new PrintStream(collaterOS, true);
            System.setOut(printRedirector);
            System.setErr(printRedirector);
            1 collaterRedirector = new 1(this, collaterOS, outPipe);
            new Thread((Runnable)collaterRedirector, "Collater").start();
            2 outputRedirector = new 2(this, inPipe);
            new Thread((Runnable)outputRedirector, "Pipe Redirector").start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String strsToPath(String[] strs) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < strs.length) {
            buf.append(strs[i]).append("\n");
            ++i;
        }
        return buf.toString();
    }

    private static ActionListener createActionListener(Object target, String noArgMethodName) {
        return EventHandler.create(ActionListener.class, target, noArgMethodName);
    }

    private static GridBagConstraints gbc(int gridx, int gridy, int gridwidth, int gridheight, double weightx, double weighty, int anchor, int fill) {
        UsageFrame._gbc.gridx = gridx;
        UsageFrame._gbc.gridy = gridy;
        UsageFrame._gbc.gridwidth = gridwidth;
        UsageFrame._gbc.gridheight = gridheight;
        UsageFrame._gbc.weightx = weightx;
        UsageFrame._gbc.weighty = weighty;
        UsageFrame._gbc.anchor = anchor;
        UsageFrame._gbc.fill = fill;
        return _gbc;
    }

    private static JTextArea newJTextArea(String str) {
        JTextArea ta = new JTextArea(str);
        ta.setFont(new Font("Monospaced", 0, 12));
        return ta;
    }

    private static URLPath extractURLPath(JTextComponent comp) {
        String text = comp.getText();
        StringTokenizer st = new StringTokenizer(text, "\r\n" + File.pathSeparatorChar);
        URLPath urlPath = new URLPath();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            URL url = token.endsWith(".jar") || token.endsWith(".zip") ? URLFactory.newJarURL((File)new File(token), (String)"") : URLFactory.newURL((String)token);
            urlPath.add(url);
        }
        return urlPath;
    }

    public UsageManager getUsageManager() {
        URLPath srcPath = UsageFrame.extractURLPath(this._srcRootField);
        URLPath libPath = UsageFrame.extractURLPath(this._jdkField);
        URLPath clsPath = UsageFrame.extractURLPath(this._clsRootField);
        UsageManager.ProjectPath projectPath = new UsageManager.ProjectPath(srcPath, libPath, clsPath);
        UsageManager usageManager = new UsageManager(projectPath);
        return usageManager;
    }

    public void spawnResultFrame(ResultFrame frame) {
        frame.setSize(1000, 600);
        frame.setDefaultCloseOperation(2);
        frame.setResizable(true);
        frame.setLocation(200, 200);
        frame.setVisible(true);
        frame.performQuery();
    }

    public void startClassQuery() {
        UsageManager usageManager = this.getUsageManager();
        String queryClassText = this._queryClassField.getText().trim();
        ResultFrame frame = new ResultFrame(usageManager, queryClassText);
        frame.setTitle("Class Usage Query Tester");
        this.spawnResultFrame(frame);
    }

    public void startFieldQuery() {
        UsageManager usageManager = this.getUsageManager();
        String queryFieldText = this._queryFieldField.getText().trim();
        int spacePos = queryFieldText.indexOf(32);
        if (spacePos != -1) {
            String queryFieldClassText = queryFieldText.substring(0, spacePos).trim();
            String queryFieldTypeText = queryFieldText.substring(spacePos).trim();
            if ((spacePos = queryFieldTypeText.indexOf(32)) != -1) {
                String queryFieldNameText = queryFieldTypeText.substring(spacePos).trim();
                queryFieldTypeText = queryFieldTypeText.substring(0, spacePos).trim();
                ResultFrame frame = new ResultFrame(usageManager, queryFieldClassText, queryFieldTypeText, queryFieldNameText);
                frame.setTitle("Field Usage Query Tester");
                this.spawnResultFrame(frame);
            }
        }
    }

    public void startConstructorQuery() {
        String queryConstructorClassText;
        UsageManager usageManager = this.getUsageManager();
        String queryConstructorText = this._queryConstructorField.getText().trim();
        ArrayList<String> parameterList = new ArrayList<String>();
        int spacePos = queryConstructorText.indexOf(32);
        if (spacePos == -1) {
            queryConstructorClassText = queryConstructorText;
        } else {
            queryConstructorClassText = queryConstructorText.substring(0, spacePos).trim();
            String nextTypeText = queryConstructorText.substring(spacePos).trim();
            while (nextTypeText.length() > 0) {
                String next;
                String type;
                spacePos = nextTypeText.indexOf(32);
                if (spacePos == -1) {
                    type = nextTypeText;
                    next = "";
                } else {
                    type = nextTypeText.substring(0, spacePos).trim();
                    next = nextTypeText.substring(spacePos).trim();
                }
                parameterList.add(type);
                nextTypeText = next;
            }
        }
        String[] queryParameterTypesText = parameterList.toArray(new String[parameterList.size()]);
        ResultFrame frame = new ResultFrame(usageManager, queryConstructorClassText, queryParameterTypesText);
        frame.setTitle("Constructor Usage Query Tester");
        this.spawnResultFrame(frame);
    }

    public void startMethodQuery() {
        UsageManager usageManager = this.getUsageManager();
        String queryMethodText = this._queryMethodField.getText().trim();
        ArrayList<String> parameterList = new ArrayList<String>();
        int spacePos = queryMethodText.indexOf(32);
        if (spacePos != -1) {
            String queryMethodNameText;
            String queryMethodClassText = queryMethodText.substring(0, spacePos).trim();
            String methodNameText = queryMethodText.substring(spacePos).trim();
            if ((spacePos = methodNameText.indexOf(32)) == -1) {
                queryMethodNameText = methodNameText;
            } else {
                queryMethodNameText = methodNameText.substring(0, spacePos).trim();
                String nextTypeText = methodNameText.substring(spacePos).trim();
                while (nextTypeText.length() > 0) {
                    String next;
                    String type;
                    spacePos = nextTypeText.indexOf(32);
                    if (spacePos == -1) {
                        type = nextTypeText;
                        next = "";
                    } else {
                        type = nextTypeText.substring(0, spacePos).trim();
                        next = nextTypeText.substring(spacePos).trim();
                    }
                    parameterList.add(type);
                    nextTypeText = next;
                }
            }
            String[] queryParameterTypesText = parameterList.toArray(new String[parameterList.size()]);
            ResultFrame frame = new ResultFrame(usageManager, queryMethodClassText, queryMethodNameText, queryParameterTypesText);
            frame.setTitle("Method Usage Query Tester");
            this.spawnResultFrame(frame);
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception e) {
            System.err.println("Could not load system look-and-feel: " + e);
        }
        System.setProperty("ENABLE_BFLIBRARIAN", Boolean.toString(true));
        Recognizer.mapExtensionToClass((String)".java", JavaSourceNode.class);
        Recognizer.mapExtensionToClass((String)".sqlj", JavaSourceNode.class);
        UsageFrame frame = new UsageFrame();
        frame.setSize(800, 600);
        frame.setDefaultCloseOperation(3);
        frame.setResizable(true);
        frame.setTitle("Usage Engine Tester");
        frame.setLocation(100, 100);
        frame.setVisible(true);
        frame._queryClassField.requestFocus();
        frame._queryClassField.selectAll();
    }

    private static void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private static String usageCodeToString(int code) {
        switch (code) {
            case 101: {
                return "import";
            }
            case 102: {
                return "class decl";
            }
            case 103: {
                return "extends";
            }
            case 104: {
                return "implements";
            }
            case 105: {
                return "return type";
            }
            case 106: {
                return "param type";
            }
            case 107: {
                return "throws type";
            }
            case 108: {
                return "field type";
            }
            case 109: {
                return "local variable type";
            }
            case 110: {
                return "static type";
            }
            case 111: {
                return "typecast";
            }
            case 112: {
                return "new";
            }
            case 113: {
                return "instanceof";
            }
            case 301: {
                return "ctor decl";
            }
            case 302: {
                return "ctor this";
            }
            case 303: {
                return "ctor super";
            }
            case 304: {
                return "ctor new";
            }
            case 201: {
                return "field decl";
            }
            case 202: {
                return "field access";
            }
            case 401: {
                return "method decl";
            }
            case 402: {
                return "method call";
            }
        }
        return "unknown (" + code + ")";
    }

    static byte[] ra$EMPTY_BUFFER() {
        return EMPTY_BUFFER;
    }

    static ActionListener maS$createActionListener(Object object, String string) {
        return UsageFrame.createActionListener(object, string);
    }

    static GridBagConstraints maS$gbc(int n, int n2, int n3, int n4, double d, double d2, int n5, int n6) {
        return UsageFrame.gbc(n, n2, n3, n4, d, d2, n5, n6);
    }

    static String maS$usageCodeToString(int n) {
        return UsageFrame.usageCodeToString(n);
    }

    static void maS$sleep(long l) {
        UsageFrame.sleep(l);
    }

    static JTextArea ra$_buildFeedback(UsageFrame usageFrame) {
        return usageFrame._buildFeedback;
    }

    final class 1
    implements Runnable {
        private final /* synthetic */ CollaterOutputStream v$collaterOS;
        private final /* synthetic */ PipedOutputStream v$outPipe;
        final /* synthetic */ UsageFrame this$0;

        public void run() {
            while (true) {
                UsageFrame.maS$sleep(100);
                byte[] data = this.v$collaterOS.getFlushedData();
                if (data.length <= 0) continue;
                try {
                    this.v$outPipe.write(data);
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }

        public 1(UsageFrame usageFrame, CollaterOutputStream collaterOutputStream, PipedOutputStream pipedOutputStream) {
            this.v$outPipe = pipedOutputStream;
            this.v$collaterOS = collaterOutputStream;
            this.this$0 = usageFrame;
        }
    }

    final class 2
    implements Runnable {
        private final /* synthetic */ PipedInputStream v$inPipe;
        final /* synthetic */ UsageFrame this$0;

        public void run() {
            InputStreamReader reader = new InputStreamReader(this.v$inPipe);
            char[] buffer = new char[1024];
            while (true) {
                try {
                    int bytesRead;
                    while ((bytesRead = reader.read(buffer, 0, 1024)) != -1) {
                        String text = new String(buffer, 0, bytesRead);
                        UsageFrame.ra$_buildFeedback(this.this$0).append(text);
                        int lastLine = UsageFrame.ra$_buildFeedback(this.this$0).getLineCount();
                        int lineStart = UsageFrame.ra$_buildFeedback(this.this$0).getLineStartOffset(lastLine - 1);
                        UsageFrame.ra$_buildFeedback(this.this$0).setCaretPosition(lineStart);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }

        public 2(UsageFrame usageFrame, PipedInputStream pipedInputStream) {
            this.v$inPipe = pipedInputStream;
            this.this$0 = usageFrame;
        }
    }

    private static final class CollaterOutputStream
    extends OutputStream {
        private ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        private ByteArrayOutputStream unflushed = new ByteArrayOutputStream();

        public synchronized void write(int b) {
            this.unflushed.write(b);
        }

        public synchronized void flush() throws IOException {
            byte[] dataToFlush = this.unflushed.toByteArray();
            this.unflushed.reset();
            this.buffer.write(dataToFlush);
        }

        public synchronized byte[] getFlushedData() {
            if (this.buffer.size() > 0) {
                byte[] data = this.buffer.toByteArray();
                this.buffer.reset();
                return data;
            }
            return UsageFrame.ra$EMPTY_BUFFER();
        }

        public void close() throws IOException {
        }
    }

    private static class ResultObject {
        protected UsageEvent _event;

        public ResultObject(UsageEvent event) {
            this._event = event;
        }

        public String toString() {
            URL url = this._event.getURL();
            String filename = URLFileSystem.getFileName((URL)url);
            int start = this._event.getStartOffset();
            int end = this._event.getEndOffset();
            return filename + " " + start + "/" + end + " " + this._event.toString();
        }
    }

    private static class ResultFrame
    extends JFrame
    implements ListSelectionListener,
    TreeSelectionListener {
        private JButton _cancelButton;
        private JProgressBar _queryProgress;
        private JLabel _queryProgressLabel;
        private int[] _usageCounters;
        private CategoryList _categoryList;
        private UsageCounter[] _lastSelectedCategories;
        private final ResultGUI _resultGUI;
        private JLabel _lblUsageResults;
        private JTextArea _lblFileContents;
        private BasicEditorPane _resultPane;
        private Timer _queryTimer;
        private boolean _cancelRequested;
        private UsageManager _usageManager;
        private String _queryClassText;
        private String _queryFieldClassText;
        private String _queryFieldTypeText;
        private String _queryFieldNameText;
        private String _queryConstructorClassText;
        private String[] _queryConstructorParameterTypesText;
        private String _queryMethodClassText;
        private String _queryMethodNameText;
        private String[] _queryMethodParameterTypesText;

        private void $init$() {
            this._categoryList = new CategoryList();
            this._cancelRequested = false;
        }

        public ResultFrame(UsageManager usageManager, String queryClassText) {
            this(usageManager);
            this._queryClassText = queryClassText;
        }

        public ResultFrame(UsageManager usageManager, String queryFieldClassText, String queryFieldTypeText, String queryFieldNameText) {
            this(usageManager);
            this._queryFieldClassText = queryFieldClassText;
            this._queryFieldTypeText = queryFieldTypeText;
            this._queryFieldNameText = queryFieldNameText;
        }

        public ResultFrame(UsageManager usageManager, String queryConstructorClassText, String[] queryConstructorParametersTypeText) {
            this(usageManager);
            this._queryConstructorClassText = queryConstructorClassText;
            this._queryConstructorParameterTypesText = queryConstructorParametersTypeText;
        }

        public ResultFrame(UsageManager usageManager, String queryMethodClassText, String queryMethodNameText, String[] queryMethodParametersTypeText) {
            this(usageManager);
            this._queryMethodClassText = queryMethodClassText;
            this._queryMethodNameText = queryMethodNameText;
            this._queryMethodParameterTypesText = queryMethodParametersTypeText;
        }

        public ResultFrame(UsageManager usageManager) {
            this.$init$();
            this._usageManager = usageManager;
            1 timerListener = new 1();
            this._queryTimer = new Timer(200, timerListener);
            this._queryTimer.setRepeats(false);
            this._queryTimer.setCoalesce(true);
            JPanel mainPanel = new JPanel(new GridBagLayout());
            this._cancelButton = new JButton("Cancel Query");
            this._cancelButton.setEnabled(false);
            this._cancelButton.addActionListener(UsageFrame.maS$createActionListener(this, "cancelQuery"));
            this._queryProgress = new JProgressBar(0, 0, 100);
            this._queryProgress.setValue(0);
            this._queryProgressLabel = new JLabel("Initializing...");
            mainPanel.add((Component)this._cancelButton, UsageFrame.maS$gbc(0, 0, 1, 1, 0.0, 0.0, 17, 0));
            mainPanel.add((Component)this._queryProgress, UsageFrame.maS$gbc(1, 0, 1, 1, 1.0, 0.0, 17, 2));
            mainPanel.add((Component)this._queryProgressLabel, UsageFrame.maS$gbc(1, 1, 1, 1, 1.0, 0.0, 17, 2));
            JPanel categoriesPanel = new JPanel(new GridBagLayout());
            this._categoryList.addListSelectionListener(this);
            categoriesPanel.add((Component)new JLabel("Usage Categories:"), UsageFrame.maS$gbc(0, 0, 1, 1, 0.0, 0.0, 17, 0));
            categoriesPanel.add((Component)new JScrollPane(this._categoryList), UsageFrame.maS$gbc(0, 1, 1, 1, 1.0, 1.0, 17, 1));
            JPanel resultsPanel = new JPanel(new GridBagLayout());
            ResultTree resultTree = new ResultTree();
            JTree jtree = resultTree.getGUI();
            jtree.addTreeSelectionListener(this);
            JTree resultComp = jtree;
            this._resultGUI = resultTree;
            this._lblUsageResults = new JLabel();
            resultsPanel.add((Component)this._lblUsageResults, UsageFrame.maS$gbc(0, 0, 1, 1, 1.0, 0.0, 17, 0));
            resultsPanel.add((Component)new JScrollPane(resultComp), UsageFrame.maS$gbc(0, 1, 1, 1, 1.0, 1.0, 17, 1));
            JSplitPane leftSplitPane = new JSplitPane();
            leftSplitPane.setOrientation(1);
            leftSplitPane.setLeftComponent(categoriesPanel);
            leftSplitPane.setRightComponent(resultsPanel);
            leftSplitPane.setResizeWeight(0.0);
            leftSplitPane.setDividerLocation(160);
            leftSplitPane.setDividerSize(5);
            JSplitPane leftPanel = leftSplitPane;
            JPanel rightPanel = new JPanel(new GridBagLayout());
            this._resultPane = new BasicEditorPane();
            this._resultPane.setProtected(true);
            this._resultPane.setLanguageSupport("foo.java");
            JScrollPane paneScroller = new JScrollPane((Component)this._resultPane);
            paneScroller.setVerticalScrollBarPolicy(22);
            paneScroller.setHorizontalScrollBarPolicy(32);
            this._lblFileContents = new JTextArea("File Contents");
            this._lblFileContents.setFont(new JLabel().getFont());
            this._lblFileContents.setEditable(false);
            this._lblFileContents.setBackground(rightPanel.getBackground());
            rightPanel.add((Component)this._lblFileContents, UsageFrame.maS$gbc(0, 0, 1, 1, 1.0, 0.0, 17, 0));
            rightPanel.add((Component)paneScroller, UsageFrame.maS$gbc(0, 1, 1, 1, 1.0, 1.0, 17, 1));
            JSplitPane splitPane = new JSplitPane();
            splitPane.setLeftComponent(leftPanel);
            splitPane.setRightComponent(rightPanel);
            splitPane.setResizeWeight(0.0);
            splitPane.setDividerLocation(400);
            splitPane.setDividerSize(10);
            mainPanel.add(Box.createVerticalStrut(5), UsageFrame.maS$gbc(0, 2, 1, 1, 0.0, 0.0, 17, 0));
            mainPanel.add((Component)splitPane, UsageFrame.maS$gbc(0, 5, 2, 1, 1.0, 1.0, 17, 1));
            this.getContentPane().add(mainPanel);
        }

        private void timerFired() {
            ResultObject resultObject = this._resultGUI.getSelectedResultObject();
            if (resultObject != null) {
                boolean mustRefreshContents;
                UsageEvent event = resultObject._event;
                this._lblFileContents.setText(URLFileSystem.getPlatformPathName((URL)event.getURL()));
                URL eventURL = event.getURL();
                URL currentURL = (URL)this._resultPane.getClientProperty((Object)"URL");
                boolean bl = mustRefreshContents = currentURL == null || !currentURL.equals(eventURL);
                if (mustRefreshContents) {
                    this._resultPane.setProtected(false);
                    this._resultPane.setText("// Loading file...");
                    this._resultPane.setProtected(true);
                    this._resultPane.putClientProperty((Object)"URL", (Object)eventURL);
                }
                int start = event.getStartOffset();
                int end = event.getEndOffset();
                int offset = start;
                int length = end - start;
                2 loadRunnable = new 2(this, event, mustRefreshContents, offset, length);
                Thread loadThread = new Thread(loadRunnable);
                loadThread.start();
            } else {
                this._resultPane.setText("");
            }
        }

        private void cancelQuery() {
            this._cancelRequested = true;
        }

        public void performQuery() {
            this._queryTimer.stop();
            this.clearResults();
            this._queryProgress.setValue(0);
            this._cancelRequested = false;
            this._cancelButton.setEnabled(true);
            long startTime = System.currentTimeMillis();
            3 finishedRunnable = new 3(this, startTime);
            4 queryClassListener = new 4(this, finishedRunnable);
            5 queryFieldListener = new 5(this, finishedRunnable);
            6 queryConstructorListener = new 6(this, finishedRunnable);
            7 queryMethodListener = new 7(this, finishedRunnable);
            this._queryProgress.setValue(0);
            UsageQueryTask queryTask = this._queryClassText != null ? this._usageManager.findClassUsages(this._queryClassText, queryClassListener) : (this._queryFieldClassText != null ? this._usageManager.findFieldUsages(this._queryFieldClassText, this._queryFieldTypeText, this._queryFieldNameText, queryFieldListener) : (this._queryConstructorClassText != null ? this._usageManager.findConstructorUsages(this._queryConstructorClassText, this._queryConstructorParameterTypesText, queryConstructorListener) : (this._queryMethodClassText != null ? this._usageManager.findMethodUsages(this._queryMethodClassText, this._queryMethodNameText, this._queryMethodParameterTypesText, queryMethodListener) : null)));
            if (queryTask != null) {
                8 progressChecker = new 8(this, queryTask);
                Thread progressThread = new Thread(progressChecker);
                progressThread.setPriority(1);
                progressThread.start();
            }
        }

        public void valueChanged(ListSelectionEvent event) {
            Object source = event.getSource();
            if (source == this._categoryList) {
                int n;
                Object[] selected = this._categoryList.getSelectedValues();
                int n2 = n = selected != null ? selected.length : 0;
                if (this._lastSelectedCategories != null && this._lastSelectedCategories.length == n) {
                    boolean areEqual = true;
                    List<Object> selectedAsList = Arrays.asList(selected);
                    int i = 0;
                    while (i < n) {
                        if (!selectedAsList.contains(this._lastSelectedCategories[i])) {
                            areEqual = false;
                            break;
                        }
                        ++i;
                    }
                    if (areEqual) {
                        return;
                    }
                }
                UsageCounter[] selectedCategories = new UsageCounter[n];
                System.arraycopy(selected, 0, selectedCategories, 0, n);
                this._lastSelectedCategories = selectedCategories;
                this._resultGUI.updateSelectedCategories(selectedCategories);
            } else {
                this._queryTimer.restart();
            }
        }

        public void valueChanged(TreeSelectionEvent event) {
            this._queryTimer.restart();
        }

        private void reportResult(UsageEvent usageEvent) {
            this.reportResult(new ResultObject(usageEvent));
        }

        private void reportResult(ResultObject resultObject) {
            UsageEvent event = resultObject._event;
            this._resultGUI.reportResult(resultObject);
            this.incUsageCounter(event.getUsageCode());
        }

        private void incUsageCounter(int usageCode) {
            if (this._usageCounters != null) {
                int n = this._usageCounters.length;
                int i = 0;
                while (i < n) {
                    if (usageCode == this._usageCounters[i]) {
                        int n2 = i + 1;
                        this._usageCounters[n2] = this._usageCounters[n2] + 1;
                        return;
                    }
                    i += 2;
                }
                int[] newCounters = new int[n + 2];
                System.arraycopy(this._usageCounters, 0, newCounters, 0, n);
                newCounters[n] = usageCode;
                newCounters[n + 1] = 1;
                this._usageCounters = newCounters;
            } else {
                this._usageCounters = new int[]{usageCode, 1};
            }
        }

        private void clearResults() {
            this._lblUsageResults.setText("Usage Results:");
            this._categoryList.clearResults();
            this._resultGUI.clearResults();
        }

        private int numResults() {
            return this._resultGUI.numResults();
        }

        static JProgressBar ra$_queryProgress(ResultFrame resultFrame) {
            return resultFrame._queryProgress;
        }

        static JButton ra$_cancelButton(ResultFrame resultFrame) {
            return resultFrame._cancelButton;
        }

        static boolean ra$_cancelRequested(ResultFrame resultFrame) {
            return resultFrame._cancelRequested;
        }

        static int mav$numResults(ResultFrame resultFrame) {
            return resultFrame.numResults();
        }

        static JLabel ra$_lblUsageResults(ResultFrame resultFrame) {
            return resultFrame._lblUsageResults;
        }

        static CategoryList ra$_categoryList(ResultFrame resultFrame) {
            return resultFrame._categoryList;
        }

        static int[] ra$_usageCounters(ResultFrame resultFrame) {
            return resultFrame._usageCounters;
        }

        static void mav$reportResult(ResultFrame resultFrame, UsageEvent usageEvent) {
            resultFrame.reportResult(usageEvent);
        }

        static JLabel ra$_queryProgressLabel(ResultFrame resultFrame) {
            return resultFrame._queryProgressLabel;
        }

        static void mav$timerFired(ResultFrame resultFrame) {
            resultFrame.timerFired();
        }

        static BasicEditorPane ra$_resultPane(ResultFrame resultFrame) {
            return resultFrame._resultPane;
        }

        final class 1
        implements ActionListener {
            public void actionPerformed(ActionEvent e) {
                ResultFrame.mav$timerFired(ResultFrame.this);
            }
        }

        final class 2
        implements Runnable {
            private final /* synthetic */ UsageEvent v$event;
            private final /* synthetic */ boolean v$mustRefreshContents;
            private final /* synthetic */ int v$offset;
            private final /* synthetic */ int v$length;
            final /* synthetic */ ResultFrame this$0;

            public void run() {
                TextBuffer textBuffer = NodeUtilities.getTextBufferFor(this.v$event.getURL());
                1 showRunnable = new 1(this, textBuffer);
                SwingUtilities.invokeLater(showRunnable);
            }

            public 2(ResultFrame resultFrame, UsageEvent usageEvent, boolean bl, int n, int n2) {
                this.v$length = n2;
                this.v$offset = n;
                this.v$mustRefreshContents = bl;
                this.v$event = usageEvent;
                this.this$0 = resultFrame;
            }

            static boolean ra$v$mustRefreshContents(2 var0) {
                return var0.v$mustRefreshContents;
            }

            static int ra$v$offset(2 var0) {
                return var0.v$offset;
            }

            static int ra$v$length(2 var0) {
                return var0.v$length;
            }

            final class 1
            implements Runnable {
                private final /* synthetic */ TextBuffer v$textBuffer;
                final /* synthetic */ 2 this$0;

                public void run() {
                    if (2.ra$v$mustRefreshContents(this.this$0)) {
                        String bufferText = this.v$textBuffer.getString(0, this.v$textBuffer.getLength());
                        ResultFrame.ra$_resultPane(this.this$0.this$0).setProtected(false);
                        ResultFrame.ra$_resultPane(this.this$0.this$0).setText(bufferText);
                        ResultFrame.ra$_resultPane(this.this$0.this$0).setProtected(true);
                    }
                    ResultFrame.ra$_resultPane(this.this$0.this$0).setCaretPositionCenter(2.ra$v$offset(this.this$0));
                    ResultFrame.ra$_resultPane(this.this$0.this$0).moveCaretPositionCenter(2.ra$v$offset(this.this$0) + 2.ra$v$length(this.this$0));
                }

                public 1(2 var1_1, TextBuffer textBuffer) {
                    this.v$textBuffer = textBuffer;
                    this.this$0 = var1_1;
                }
            }
        }

        final class 3
        implements Runnable {
            private final /* synthetic */ long v$startTime;
            final /* synthetic */ ResultFrame this$0;

            public void run() {
                ResultFrame.ra$_queryProgress(this.this$0).setValue(0);
                ResultFrame.ra$_cancelButton(this.this$0).setEnabled(false);
                if (ResultFrame.ra$_cancelRequested(this.this$0)) {
                    System.out.println("Query was canceled");
                } else {
                    int numResults = ResultFrame.mav$numResults(this.this$0);
                    ResultFrame.ra$_lblUsageResults(this.this$0).setText("Usage Results (" + numResults + "):");
                    ResultFrame.ra$_categoryList(this.this$0).reportCategories(ResultFrame.ra$_usageCounters(this.this$0));
                    long endTime = System.currentTimeMillis() - this.v$startTime;
                    System.out.println("Query time (ms): " + endTime);
                    System.out.println("Query occurrences found: " + numResults);
                }
                System.out.println();
            }

            public 3(ResultFrame resultFrame, long l) {
                this.v$startTime = l;
                this.this$0 = resultFrame;
            }
        }

        final class 4
        implements ClassUsageListener {
            private final /* synthetic */ Runnable v$finishedRunnable;
            final /* synthetic */ ResultFrame this$0;

            public void notifyClassUsage(ClassUsageEvent event) {
                ResultFrame.mav$reportResult(this.this$0, event);
            }

            public void notifyFinished(UsageEvent event) {
                SwingUtilities.invokeLater(this.v$finishedRunnable);
            }

            public void notifySkipped(UsageEvent event) {
            }

            public 4(ResultFrame resultFrame, Runnable runnable) {
                this.v$finishedRunnable = runnable;
                this.this$0 = resultFrame;
            }
        }

        final class 5
        implements FieldUsageListener {
            private final /* synthetic */ Runnable v$finishedRunnable;
            final /* synthetic */ ResultFrame this$0;

            public void notifyFieldUsage(FieldUsageEvent event) {
                ResultFrame.mav$reportResult(this.this$0, event);
            }

            public void notifyFinished(UsageEvent event) {
                SwingUtilities.invokeLater(this.v$finishedRunnable);
            }

            public void notifySkipped(UsageEvent event) {
            }

            public 5(ResultFrame resultFrame, Runnable runnable) {
                this.v$finishedRunnable = runnable;
                this.this$0 = resultFrame;
            }
        }

        final class 6
        implements ConstructorUsageListener {
            private final /* synthetic */ Runnable v$finishedRunnable;
            final /* synthetic */ ResultFrame this$0;

            public void notifyConstructorUsage(ConstructorUsageEvent event) {
                ResultFrame.mav$reportResult(this.this$0, event);
            }

            public void notifyFinished(UsageEvent event) {
                SwingUtilities.invokeLater(this.v$finishedRunnable);
            }

            public void notifySkipped(UsageEvent event) {
            }

            public 6(ResultFrame resultFrame, Runnable runnable) {
                this.v$finishedRunnable = runnable;
                this.this$0 = resultFrame;
            }
        }

        final class 7
        implements MethodUsageListener {
            private final /* synthetic */ Runnable v$finishedRunnable;
            final /* synthetic */ ResultFrame this$0;

            public void notifyMethodUsage(MethodUsageEvent event) {
                ResultFrame.mav$reportResult(this.this$0, event);
            }

            public void notifyFinished(UsageEvent event) {
                SwingUtilities.invokeLater(this.v$finishedRunnable);
            }

            public void notifySkipped(UsageEvent event) {
            }

            public 7(ResultFrame resultFrame, Runnable runnable) {
                this.v$finishedRunnable = runnable;
                this.this$0 = resultFrame;
            }
        }

        final class 8
        implements Runnable {
            private final /* synthetic */ UsageQueryTask v$queryTask;
            final /* synthetic */ ResultFrame this$0;

            public void run() {
                while (!this.v$queryTask.isFinished()) {
                    UsageFrame.maS$sleep(100);
                    int progress = this.v$queryTask.getProgress();
                    String progressText = this.v$queryTask.getProgressText();
                    ResultFrame.ra$_queryProgress(this.this$0).setValue(progress);
                    ResultFrame.ra$_queryProgressLabel(this.this$0).setText(progressText);
                    if (!ResultFrame.ra$_cancelRequested(this.this$0)) continue;
                    this.v$queryTask.cancel();
                }
            }

            public 8(ResultFrame resultFrame, UsageQueryTask usageQueryTask) {
                this.v$queryTask = usageQueryTask;
                this.this$0 = resultFrame;
            }
        }
    }

    private static final class UsageCounter {
        private final int _usageCode;
        private final int _count;

        UsageCounter(int usageCode, int count) {
            this._usageCode = usageCode;
            this._count = count;
        }

        int getUsageCode() {
            return this._usageCode;
        }

        int getCount() {
            return this._count;
        }

        public String toString() {
            return this._count + " " + UsageFrame.maS$usageCodeToString(this._usageCode);
        }
    }

    private static final class CategoryList
    extends JList {
        private final DefaultListModel _model;

        private void $init$() {
            this._model = new DefaultListModel();
        }

        CategoryList() {
            this.$init$();
            this.setModel(this._model);
            this.setSelectionMode(2);
        }

        void clearResults() {
            this._model.clear();
        }

        void reportCategories(int[] usageCounters) {
            this.setValueIsAdjusting(true);
            try {
                if (usageCounters != null) {
                    int n = usageCounters.length;
                    int i = 0;
                    while (i < n) {
                        int usageCode = usageCounters[i++];
                        int count = usageCounters[i];
                        this._model.addElement(new UsageCounter(usageCode, count));
                        ++i;
                    }
                }
            }
            finally {
                this.setValueIsAdjusting(false);
            }
        }
    }

    private static abstract class ResultGUI {
        private UsageCounter[] _selectedCategories;

        abstract void reportResult(ResultObject var1);

        abstract int numResults();

        abstract void clearResults();

        abstract ResultObject getSelectedResultObject();

        void updateSelectedCategories(UsageCounter[] selectedCategories) {
            this._selectedCategories = selectedCategories;
        }

        final boolean isSelectedCategory(ResultObject resultObject) {
            if (this._selectedCategories == null || this._selectedCategories.length == 0) {
                return true;
            }
            int usageCode = resultObject._event.getUsageCode();
            int n = this._selectedCategories.length;
            int i = 0;
            while (i < n) {
                UsageCounter cat = this._selectedCategories[i];
                if (cat.getUsageCode() == usageCode) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private ResultGUI() {
        }

        ResultGUI(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static final class ResultList
    extends ResultGUI {
        private final ArrayList _dataItems;
        private final ArrayList _listItems;
        private final ResultListModel _model;
        private final JList _jlist;

        private void $init$() {
            this._dataItems = new ArrayList();
            this._listItems = new ArrayList();
            this._model = new ResultListModel(this._listItems);
            this._jlist = new JList(this._model);
        }

        JList getGUI() {
            return this._jlist;
        }

        void reportResult(ResultObject resultObject) {
            this._dataItems.add(resultObject);
            int insertionPoint = this._listItems.size();
            this._listItems.add(resultObject);
            this._model.fireIntervalAdded(this, insertionPoint, insertionPoint);
        }

        int numResults() {
            return this._model.getSize();
        }

        void clearResults() {
            int n = this._model.getSize();
            this._dataItems.clear();
            this._listItems.clear();
            if (n > 0) {
                this._model.fireIntervalRemoved(this, 0, n - 1);
            }
        }

        ResultObject getSelectedResultObject() {
            Object selected = this._jlist.getSelectedValue();
            return selected instanceof ResultObject ? (ResultObject)selected : null;
        }

        void updateSelectedCategories(UsageCounter[] selectedCategories) {
            super.updateSelectedCategories(selectedCategories);
            int oldSize = this._model.getSize();
            this._listItems.clear();
            if (oldSize > 0) {
                this._model.fireIntervalRemoved(this, 0, oldSize - 1);
            }
            for (ResultObject resultObject : this._dataItems) {
                if (!this.isSelectedCategory(resultObject)) continue;
                this._listItems.add(resultObject);
            }
            int newSize = this._listItems.size();
            if (newSize > 0) {
                this._model.fireIntervalAdded(this, 0, newSize - 1);
            }
        }

        private ResultList() {
            super(null);
            this.$init$();
        }

        private static final class ResultListModel
        extends AbstractListModel {
            private final ArrayList _storage;

            ResultListModel(ArrayList storage) {
                this._storage = storage;
            }

            public int getSize() {
                return this._storage.size();
            }

            public Object getElementAt(int i) {
                return this._storage.get(i);
            }

            protected void fireIntervalAdded(Object source, int index0, int index1) {
                super.fireIntervalAdded(source, index0, index1);
            }

            protected void fireContentsChanged(Object source, int index0, int index1) {
                super.fireContentsChanged(source, index0, index1);
            }

            protected void fireIntervalRemoved(Object source, int index0, int index1) {
                super.fireIntervalRemoved(source, index0, index1);
            }
        }
    }

    private static final class ResultTree
    extends ResultGUI {
        private final DMTNRoot _root;
        private final DefaultTreeModel _model;
        private final JTree _jtree;

        private void $init$() {
            this._root = new DMTNRoot();
            this._model = new DefaultTreeModel(this._root);
            this._jtree = new JTree(this._model);
        }

        ResultTree() {
            super(null);
            this.$init$();
            ToolTipManager.sharedInstance().registerComponent(this._jtree);
            this._jtree.setCellRenderer(new TCR(null));
            DefaultTreeSelectionModel tsm = new DefaultTreeSelectionModel();
            tsm.setSelectionMode(1);
            this._jtree.setSelectionModel(tsm);
            this._jtree.setRootVisible(false);
            this._jtree.setShowsRootHandles(true);
        }

        JTree getGUI() {
            return this._jtree;
        }

        void reportResult(ResultObject resultObject) {
            this._root.reportResult(resultObject);
        }

        int numResults() {
            Enumeration iter = this._root.children();
            int n = 0;
            while (iter.hasMoreElements()) {
                DMTNFile dmtnFile = (DMTNFile)iter.nextElement();
                n += dmtnFile.getChildCount();
            }
            return n;
        }

        void clearResults() {
            this._root.clearResults();
            this._model.nodeStructureChanged(this._root);
        }

        ResultObject getSelectedResultObject() {
            TreePath tp = this._jtree.getSelectionPath();
            if (tp != null) {
                Object dmtnObj = tp.getLastPathComponent();
                if (dmtnObj instanceof DMTNFile) {
                    DMTNFile dmtnFile = (DMTNFile)dmtnObj;
                    return new ResultObject(new UsageEvent(null, 0, dmtnFile.getURL(), 0, 0));
                }
                if (dmtnObj instanceof DMTNUsage) {
                    DMTNUsage dmtnUsage = (DMTNUsage)dmtnObj;
                    return dmtnUsage.getResultObject();
                }
            }
            return null;
        }

        void updateSelectedCategories(UsageCounter[] selectedCategories) {
            super.updateSelectedCategories(selectedCategories);
            this._root.refreshChildNodes();
            this._model.nodeStructureChanged(this._root);
        }

        static DefaultTreeModel ra$_model(ResultTree resultTree) {
            return resultTree._model;
        }

        static JTree ra$_jtree(ResultTree resultTree) {
            return resultTree._jtree;
        }

        static DMTNRoot ra$_root(ResultTree resultTree) {
            return resultTree._root;
        }

        private abstract class ReportNode
        implements TreeNode {
            final ReportNode _parent;
            final ArrayList _dataChildren;
            final ArrayList _nodeChildren;

            private void $init$() {
                this._dataChildren = new ArrayList();
                this._nodeChildren = new ArrayList();
            }

            ReportNode(ReportNode parent) {
                this.$init$();
                this._parent = parent;
            }

            abstract void reportResult(ResultObject var1);

            abstract void refreshChildNodes();

            public Enumeration children() {
                return Collections.enumeration(this._nodeChildren);
            }

            public boolean getAllowsChildren() {
                return true;
            }

            public TreeNode getChildAt(int childIndex) {
                return (TreeNode)this._nodeChildren.get(childIndex);
            }

            public int getChildCount() {
                return this._nodeChildren.size();
            }

            public int getIndex(TreeNode node) {
                return this._nodeChildren.indexOf(node);
            }

            public TreeNode getParent() {
                return this._parent;
            }

            public boolean isLeaf() {
                return this.getChildCount() <= 0;
            }
        }

        private final class DMTNRoot
        extends ReportNode {
            DMTNRoot() {
                super(null);
            }

            void clearResults() {
                this._dataChildren.clear();
                this._nodeChildren.clear();
            }

            void refreshChildNodes() {
                this._nodeChildren.clear();
                for (DMTNFile dmtnFile : this._dataChildren) {
                    dmtnFile.refreshChildNodes();
                    if (dmtnFile.isLeaf()) continue;
                    this._nodeChildren.add(dmtnFile);
                }
            }

            void reportResult(ResultObject resultObject) {
                UsageEvent event = resultObject._event;
                URL fileURL = event.getURL();
                DMTNFile fileNode = this.findOrCreateFileNode(fileURL);
                fileNode.reportResult(resultObject);
            }

            private DMTNFile findOrCreateFileNode(URL fileURL) {
                DMTNFile fileNode = this.findFileNode(fileURL);
                return fileNode != null ? fileNode : this.createFileNode(fileURL);
            }

            private DMTNFile findFileNode(URL fileURL) {
                Enumeration iter = this.children();
                while (iter.hasMoreElements()) {
                    DMTNFile curFile = (DMTNFile)iter.nextElement();
                    if (!curFile.getURL().equals(fileURL)) continue;
                    return curFile;
                }
                return null;
            }

            private DMTNFile createFileNode(URL fileURL) {
                int fileInsertionPoint = this.getChildCount();
                DMTNFile fileNode = new DMTNFile(fileURL);
                this._dataChildren.add(fileNode);
                this._nodeChildren.add(fileNode);
                ResultTree.ra$_model(ResultTree.this).nodesWereInserted(this, new int[]{fileInsertionPoint});
                if (fileInsertionPoint == 0) {
                    TreePath tp = new TreePath(this);
                    ResultTree.ra$_jtree(ResultTree.this).expandPath(tp);
                }
                return fileNode;
            }
        }

        private final class DMTNFile
        extends ReportNode {
            private final URL _url;
            private final String _displayName;

            DMTNFile(URL url) {
                super(ResultTree.ra$_root(ResultTree.this));
                this._url = url;
                this._displayName = URLFileSystem.getFileName((URL)url);
            }

            URL getURL() {
                return this._url;
            }

            void reportResult(ResultObject resultObject) {
                int usageInsertionPoint = this.getChildCount();
                DMTNUsage dmtnUsage = new DMTNUsage(this, resultObject);
                this._dataChildren.add(dmtnUsage);
                this._nodeChildren.add(dmtnUsage);
                ResultTree.ra$_model(ResultTree.this).nodesWereInserted(this, new int[]{usageInsertionPoint});
                ResultTree.ra$_model(ResultTree.this).nodeChanged(this);
            }

            void refreshChildNodes() {
                this._nodeChildren.clear();
                for (DMTNUsage dmtnUsage : this._dataChildren) {
                    if (!ResultTree.this.isSelectedCategory(dmtnUsage.getResultObject())) continue;
                    this._nodeChildren.add(dmtnUsage);
                }
            }

            public String toString() {
                return this._displayName + " (" + this.getChildCount() + ")";
            }
        }

        private final class DMTNUsage
        extends ReportNode {
            private final ResultObject _usageInfo;
            private final String _displayName;

            DMTNUsage(DMTNFile parent, ResultObject usageInfo) {
                super(parent);
                this._usageInfo = usageInfo;
                UsageEvent e = usageInfo._event;
                this._displayName = e.getStartOffset() + "-" + e.getEndOffset() + ": " + UsageFrame.maS$usageCodeToString(e.getUsageCode());
            }

            void reportResult(ResultObject resultObject) {
            }

            void refreshChildNodes() {
            }

            ResultObject getResultObject() {
                return this._usageInfo;
            }

            public String toString() {
                return this._displayName;
            }

            public boolean getAllowsChildren() {
                return false;
            }

            public boolean isLeaf() {
                return true;
            }
        }

        private static final class TCR
        extends DefaultTreeCellRenderer {
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                JLabel comp = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                if (value instanceof DMTNFile) {
                    DMTNFile dmtnFile = (DMTNFile)value;
                    URL url = dmtnFile.getURL();
                    comp.setToolTipText(URLFileSystem.getPlatformPathName((URL)url));
                } else {
                    comp.setToolTipText(null);
                }
                return comp;
            }

            private TCR() {
            }

            TCR(1 var1_1) {
                this();
            }

            public final class 1 {
            }
        }
    }
}

