/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.usage.util;

import java.util.Comparator;
import java.util.Iterator;
import javax.swing.text.Segment;
import oracle.ide.util.ArraySortedSet;

public final class CharArrayPool {
    private CAP _pool;
    public static final Comparator CHAR_ARRAY_COMPARATOR = new CAPC(null);

    public CharArrayPool(int initialSize) {
        this._pool = new CAP(initialSize, null);
    }

    public char[] add(char[] keyword) {
        return (char[])CAP.mav$addIntern(this._pool, keyword);
    }

    public char[] add(String keyword) {
        return (char[])CAP.mav$addIntern(this._pool, keyword);
    }

    public char[] add(Segment keywordSegment) {
        return (char[])CAP.mav$addIntern(this._pool, keywordSegment);
    }

    public int size() {
        return this._pool.size();
    }

    public boolean contains(char[] keyword) {
        return this._pool.contains(keyword);
    }

    public Iterator iterator() {
        return this._pool.iterator();
    }

    public void trimToSize() {
        this._pool.trimToSize();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CAPC
    implements Comparator {
        public int compare(Object obj1, Object obj2) {
            if (obj1 instanceof char[]) {
                if (obj2 instanceof char[]) {
                    return this.compareCharArrays((char[])obj1, (char[])obj2);
                }
                if (obj2 instanceof String) {
                    return this.compareCharArrayString((char[])obj1, (String)obj2);
                }
                return this.compareCharArraySegment((char[])obj1, (Segment)obj2);
            }
            if (obj1 instanceof String) {
                return this.compareStringCharArray((String)obj1, (char[])obj2);
            }
            return this.compareSegmentCharArray((Segment)obj1, (char[])obj2);
        }

        private int compareSegmentCharArray(Segment seg1, char[] ca2) {
            int len1 = seg1.count;
            int len2 = ca2.length;
            int minlen = Math.min(len1, len2);
            int pos = 0;
            int segPos = seg1.offset;
            char[] seg_ca1 = seg1.array;
            while (pos < minlen) {
                char c2;
                char c1;
                if ((c1 = seg_ca1[segPos++]) == (c2 = ca2[pos++])) continue;
                return c1 - c2;
            }
            return len1 - len2;
        }

        private int compareCharArraySegment(char[] ca1, Segment seg2) {
            int len1 = ca1.length;
            int len2 = seg2.count;
            int minlen = Math.min(len1, len2);
            int pos = 0;
            int segPos = seg2.offset;
            char[] seg_ca2 = seg2.array;
            while (pos < minlen) {
                char c2;
                char c1;
                if ((c1 = ca1[pos++]) == (c2 = seg_ca2[segPos++])) continue;
                return c1 - c2;
            }
            return len1 - len2;
        }

        private int compareStringCharArray(String s1, char[] ca2) {
            int len1 = s1.length();
            int len2 = ca2.length;
            int minlen = Math.min(len1, len2);
            int pos = 0;
            while (pos < minlen) {
                char c2;
                char c1 = s1.charAt(pos);
                if (c1 != (c2 = ca2[pos])) {
                    return c1 - c2;
                }
                ++pos;
            }
            return len1 - len2;
        }

        private int compareCharArrayString(char[] ca1, String s2) {
            int len1 = ca1.length;
            int len2 = s2.length();
            int minlen = Math.min(len1, len2);
            int pos = 0;
            while (pos < minlen) {
                char c1 = ca1[pos];
                char c2 = s2.charAt(pos);
                if (c1 != c2) {
                    return c1 - c2;
                }
                ++pos;
            }
            return len1 - len2;
        }

        private int compareCharArrays(char[] ca1, char[] ca2) {
            int len1 = ca1.length;
            int len2 = ca2.length;
            int minlen = Math.min(len1, len2);
            int pos = 0;
            while (pos < minlen) {
                char c1 = ca1[pos];
                char c2 = ca2[pos];
                if (c1 != c2) {
                    return c1 - c2;
                }
                ++pos;
            }
            return len1 - len2;
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof CAPC;
        }

        private CAPC() {
        }

        CAPC(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class CAP
    extends ArraySortedSet {
        private CAP(int initialSize) {
            super(initialSize, CHAR_ARRAY_COMPARATOR);
        }

        private Object addIntern(char[] o) {
            return this.intern(o);
        }

        private Object addIntern(String o) {
            if (this.contains(o)) {
                return this.intern(o);
            }
            char[] ca = o.toCharArray();
            this.add(ca);
            return ca;
        }

        private Object addIntern(Segment o) {
            if (this.contains(o)) {
                return this.intern(o);
            }
            char[] ca = new char[o.count];
            System.arraycopy(o.array, o.offset, ca, 0, o.count);
            this.add(ca);
            return ca;
        }

        static Object mav$addIntern(CAP cAP, Segment segment) {
            return cAP.addIntern(segment);
        }

        static Object mav$addIntern(CAP cAP, String string) {
            return cAP.addIntern(string);
        }

        static Object mav$addIntern(CAP cAP, char[] cArray) {
            return cAP.addIntern(cArray);
        }

        CAP(int n, 1 var3_3) {
            this(n);
        }

        public final class 1 {
        }
    }
}

