/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.usage.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;

public final class FileUtilities {
    private static final int READ_CHUNK = 16384;

    public static byte[] readFile(URL url) throws IOException {
        ArrayList<byte[]> bufferList = new ArrayList<byte[]>();
        InputStream is = URLFileSystem.openInputStream((URL)url);
        int totalRead = 0;
        try {
            boolean eof = false;
            while (!eof) {
                byte[] chunk = new byte[16384];
                int spaceLeft = 16384;
                int bytesRead = 0;
                while (spaceLeft > 0) {
                    int byteCount = is.read(chunk, bytesRead, spaceLeft);
                    if (byteCount == -1) {
                        eof = true;
                        break;
                    }
                    spaceLeft -= byteCount;
                    bytesRead += byteCount;
                }
                totalRead += bytesRead;
                bufferList.add(chunk);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        byte[] finalBuffer = new byte[totalRead];
        int bytesLeft = totalRead;
        int bytesCopied = 0;
        int numChunks = bufferList.size();
        int i = 0;
        while (i < numChunks) {
            byte[] chunk = (byte[])bufferList.get(i);
            int bytesAvail = Math.min(chunk.length, bytesLeft);
            System.arraycopy(chunk, 0, finalBuffer, bytesCopied, bytesAvail);
            bytesLeft -= bytesAvail;
            bytesCopied += bytesAvail;
            ++i;
        }
        Assert.check((bytesLeft == 0 ? 1 : 0) != 0, (String)"Bytes left to copy");
        return finalBuffer;
    }

    public static void writeFile(URL url, byte[] data) throws IOException {
        FileUtilities.writeFile(url, data, 0, data.length);
    }

    public static void writeFile(URL url, byte[] data, int offset, int count) throws IOException {
        OutputStream os = null;
        try {
            os = URLFileSystem.openOutputStream((URL)url);
            os.write(data, offset, count);
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }
}

