/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.usage.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.IdeUtil;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.parser.java.v1.JavaParser;
import oracle.javatools.parser.java.v1.symbol.RootSymbol;
import oracle.jdeveloper.model.JavaSourceNode;

public class NodeUtilities {
    public static RootSymbol getParseTreeFor(URL url, TextBuffer buffer, boolean fullDepth) {
        RootSymbol rootSymbol = null;
        Node srcNode = NodeFactory.find((URL)url);
        if (srcNode != null && srcNode instanceof JavaSourceNode && srcNode.isOpen()) {
            JavaSourceNode javaNode = (JavaSourceNode)srcNode;
            rootSymbol = javaNode.parse1(fullDepth);
        }
        if (rootSymbol == null) {
            JavaParser.ParsingOptions parseOptions = new JavaParser.ParsingOptions();
            parseOptions.startOffset = 0;
            parseOptions.inputType = 1;
            parseOptions.parseDepth = fullDepth ? 3 : 2;
            parseOptions.reportErrors = true;
            rootSymbol = (RootSymbol)JavaParser.parse((ReadTextBuffer)buffer, (JavaParser.ParsingOptions)parseOptions);
        }
        return rootSymbol;
    }

    public static TextBuffer getTextBufferFor(URL url) {
        TextBuffer buffer = null;
        Node srcNode = NodeFactory.find((URL)url);
        if (srcNode != null && srcNode instanceof JavaSourceNode && srcNode.isOpen()) {
            JavaSourceNode javaNode = (JavaSourceNode)srcNode;
            buffer = javaNode.acquireTextBuffer();
        }
        if (buffer == null) {
            String ideEncoding = IdeUtil.getIdeEncoding();
            InputStream is = null;
            InputStreamReader isr = null;
            try {
                try {
                    is = URLFileSystem.openInputStream((URL)url);
                    isr = new InputStreamReader(is, ideEncoding);
                    TextBuffer textBuffer = TextBufferFactory.createArrayTextBuffer();
                    textBuffer.read((Reader)isr);
                    buffer = textBuffer;
                }
                catch (IOException e) {
                    buffer = null;
                }
            }
            finally {
                try {
                    if (isr != null) {
                        isr.close();
                    } else if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e) {}
            }
        }
        return buffer;
    }
}

