/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.usage.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.ide.util.Assert;
import oracle.javatools.parser.util.AsyncScheduler;
import oracle.javatools.parser.util.AsyncTask;
import oracle.jdeveloper.usage.util.AbstractBackgroundTask;
import oracle.jdeveloper.usage.util.BackgroundTask;

public final class TaskMultiplexer {
    private final String _name;
    private final AsyncScheduler MX_SCHEDULER;
    private final Map _taskMap;

    public TaskMultiplexer(String multiplexerName) {
        this.$init$();
        this._name = multiplexerName;
        this.MX_SCHEDULER = new AsyncScheduler(multiplexerName, 10000, 10);
    }

    private void $init$() {
        this._taskMap = new HashMap(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerWrapper(TaskWrapper wrapper, BackgroundTask task) {
        Map map = this._taskMap;
        synchronized (map) {
            ArrayList<TaskWrapper> wrapperList = (ArrayList<TaskWrapper>)this._taskMap.get(task);
            if (wrapperList == null) {
                wrapperList = new ArrayList<TaskWrapper>(5);
                this._taskMap.put(task, wrapperList);
            }
            wrapperList.add(wrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deregisterWrapper(TaskWrapper wrapper, BackgroundTask task) {
        Map map = this._taskMap;
        synchronized (map) {
            List wrapperList = (List)this._taskMap.get(task);
            if (wrapperList == null) {
                Assert.println((String)"Warning, unexpected empty wrapper list.");
                Assert.printStackTrace();
            } else {
                wrapperList.remove(wrapper);
                if (wrapperList.size() == 0) {
                    task.cancel();
                    this._taskMap.remove(task);
                }
            }
        }
    }

    static void mav$registerWrapper(TaskMultiplexer taskMultiplexer, TaskWrapper taskWrapper, BackgroundTask backgroundTask) {
        taskMultiplexer.registerWrapper(taskWrapper, backgroundTask);
    }

    static void mav$deregisterWrapper(TaskMultiplexer taskMultiplexer, TaskWrapper taskWrapper, BackgroundTask backgroundTask) {
        taskMultiplexer.deregisterWrapper(taskWrapper, backgroundTask);
    }

    static AsyncScheduler ra$MX_SCHEDULER(TaskMultiplexer taskMultiplexer) {
        return taskMultiplexer.MX_SCHEDULER;
    }

    public static abstract class TaskWrapper
    extends AbstractBackgroundTask {
        private TaskMultiplexer _multiplexer;

        protected TaskWrapper(TaskMultiplexer multiplexer) {
            this._multiplexer = multiplexer;
        }

        protected void initializeComplete() {
            TaskMultiplexer.ra$MX_SCHEDULER(this._multiplexer).scheduleTask((AsyncTask)this);
        }

        protected final AsyncScheduler getSchedulerImpl() {
            return TaskMultiplexer.ra$MX_SCHEDULER(this._multiplexer);
        }

        protected abstract BackgroundTask getSharedBackgroundTask();

        protected abstract void saveResults(BackgroundTask var1);

        protected Object runTaskImpl() throws AsyncTask.CancelledException {
            BackgroundTask sharedTask = this.getSharedBackgroundTask();
            TaskMultiplexer.mav$registerWrapper(this._multiplexer, this, sharedTask);
            boolean bail = false;
            while (!sharedTask.isFinished()) {
                if (this.isCancelledImpl()) {
                    bail = true;
                    break;
                }
                TaskWrapper.sleep((int)25);
                this.setProgress(sharedTask.getProgress());
                this.setProgressText(sharedTask.getProgressText());
            }
            TaskMultiplexer.mav$deregisterWrapper(this._multiplexer, this, sharedTask);
            if (bail) {
                return "cancelled";
            }
            this.saveResults(sharedTask);
            return null;
        }
    }
}

