/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.util;

import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.regex.Pattern;
import oracle.ide.model.Project;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.model.JavaProject;

public class Helpers {
    public static void removeClasses(Project prj, URL sourceFile) {
        String[] list = Helpers.getClasses(prj, sourceFile);
        Helpers.removeClasses(prj, list);
    }

    public static void removeClasses(Project prj, String[] fqClassNames) {
        URL outputDirectory = JavaProject.getInstance((Project)prj).getOutputDirectory();
        File outFile = new File(outputDirectory.getPath());
        int i = 0;
        while (i < fqClassNames.length) {
            File file = new File(outFile, fqClassNames[i].replace('.', File.separatorChar));
            String cname = file.getName();
            new File(file.getPath() + ".class").delete();
            file = file.getParentFile();
            if (file != null) {
                Pattern pattern = Pattern.compile("^.*" + cname + "\\$..*\\.class$");
                String[] files = file.list();
                int j = 0;
                while (files != null && j < files.length) {
                    if (pattern.matcher(files[j]).matches()) {
                        new File(file, files[j]).delete();
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public static String[] getClasses(Project prj, URL sourceFile) {
        JavaManager javaManager = JavaManager.getJavaManager((Project)prj);
        JavaFile srcFile = javaManager.getFile(sourceFile);
        Collection classes = srcFile.getClasses();
        JavaClass[] aclasses = classes.toArray(new JavaClass[classes.size()]);
        String[] result = new String[aclasses.length];
        int i = 0;
        while (i < aclasses.length) {
            result[i] = aclasses[i].getQualifiedName();
            ++i;
        }
        return result;
    }
}

