/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.util.gutter;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.ide.model.LocatableItem;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.util.gutter.LineGutterMarkList;

public abstract class AbstractLineGutterMarkList
implements LineGutterMarkList {
    private List lineGutterMarkList = new ArrayList();

    public abstract LocatableItem createLineGutterMark(URL var1, int var2);

    public abstract boolean allowMultipleMarksPerLine();

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        int numMarks = this.lineGutterMarkList.size();
        buffer.append("num lineGutterMarks: " + numMarks);
        buffer.append("\n");
        int i = 0;
        while (i < numMarks) {
            LocatableItem lineGutterMark = (LocatableItem)this.lineGutterMarkList.get(i);
            buffer.append(lineGutterMark.toString());
            ++i;
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocatableItem[] getAllLineGutterMarks() {
        LocatableItem[] allLineGutterMarks;
        List list = this.lineGutterMarkList;
        synchronized (list) {
            int numMarks = this.lineGutterMarkList.size();
            allLineGutterMarks = this.lineGutterMarkList.toArray(new LocatableItem[numMarks]);
        }
        return allLineGutterMarks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLineGutterMarkCount() {
        List list = this.lineGutterMarkList;
        synchronized (list) {
            int n = this.lineGutterMarkList.size();
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocatableItem[] findLineGutterMarks(URL url) {
        ArrayList<LocatableItem> matchingList = new ArrayList<LocatableItem>();
        List list = this.lineGutterMarkList;
        synchronized (list) {
            int numMarks = this.lineGutterMarkList.size();
            int i = 0;
            while (i < numMarks) {
                LocatableItem lineGutterMark = (LocatableItem)this.lineGutterMarkList.get(i);
                if (this.matches(lineGutterMark, url)) {
                    matchingList.add(lineGutterMark);
                }
                ++i;
            }
        }
        int numMatches = matchingList.size();
        return matchingList.toArray(new LocatableItem[numMatches]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocatableItem[] findLineGutterMark(URL url, int line) {
        ArrayList<LocatableItem> foundMarkList = new ArrayList<LocatableItem>();
        List list = this.lineGutterMarkList;
        synchronized (list) {
            int numMarks = this.lineGutterMarkList.size();
            int i = 0;
            while (i < numMarks) {
                LocatableItem lineGutterMark = (LocatableItem)this.lineGutterMarkList.get(i);
                if (this.matches(lineGutterMark, url, line)) {
                    foundMarkList.add(lineGutterMark);
                    if (!this.allowMultipleMarksPerLine()) break;
                }
                ++i;
            }
        }
        int listLen = foundMarkList.size();
        if (listLen > 0) {
            return foundMarkList.toArray(new LocatableItem[listLen]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocatableItem addLineGutterMark(URL url, int line) {
        LocatableItem[] existingLineGutterMark;
        if (!this.allowMultipleMarksPerLine() && (existingLineGutterMark = this.findLineGutterMark(url, line)) != null) {
            return existingLineGutterMark[0];
        }
        LocatableItem newLineGutterMark = this.createLineGutterMark(url, line);
        List list = this.lineGutterMarkList;
        synchronized (list) {
            this.insertLineGutterMark(newLineGutterMark);
        }
        return newLineGutterMark;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean modifyLineGutterMark(LocatableItem lineGutterMark, int line) {
        boolean result;
        if (lineGutterMark.getLine() == line) {
            return true;
        }
        List list = this.lineGutterMarkList;
        synchronized (list) {
            if (!this.allowMultipleMarksPerLine()) {
                this.removeLineGutterMark(lineGutterMark);
                lineGutterMark.setLine(line);
                result = this.insertLineGutterMark(lineGutterMark);
            } else {
                lineGutterMark.setLine(line);
                result = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLineGutterMark(LocatableItem lineGutterMark) {
        List list = this.lineGutterMarkList;
        synchronized (list) {
            int index = this.lineGutterMarkList.indexOf(lineGutterMark);
            if (index != -1) {
                this.lineGutterMarkList.remove(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllLineGutterMarks() {
        List list = this.lineGutterMarkList;
        synchronized (list) {
            this.lineGutterMarkList.clear();
        }
    }

    protected abstract boolean insertLineGutterMark(LocatableItem var1);

    public List getLineGutterMarkList() {
        return this.lineGutterMarkList;
    }

    public void setLineGutterMarkList(List list) {
        this.lineGutterMarkList = list;
    }

    private boolean matches(LocatableItem lineGutterMark, URL url) {
        return URLFileSystem.equals((URL)lineGutterMark.getURL(), (URL)url);
    }

    private boolean matches(LocatableItem lineGutterMark, URL url, int line) {
        if (this.matches(lineGutterMark, url)) {
            return lineGutterMark.getLine() == line;
        }
        return false;
    }
}

