/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.util.gutter;

import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeEditorGutter;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.LocatableItem;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.javatools.editor.gutter.GutterColumn;
import oracle.javatools.editor.gutter.GutterColumnListener;
import oracle.javatools.editor.gutter.GutterMark;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.jdeveloper.util.gutter.LineGutterMarkList;
import oracle.jdeveloper.util.gutter.OpenEditor;
import oracle.jdeveloper.util.gutter.OpenLineGutterMark;

public abstract class AbstractLineGutterMarkManager
implements EditorListener,
GutterColumnListener {
    public static final int MISSING_MOVE = 1;
    public static final int MISSING_DISCARD = 2;
    private static final OpenLineGutterMark[] NO_OPEN_LINE_GUTTER_MARKS = new OpenLineGutterMark[0];
    private boolean _started;
    private List openEditorList;

    public AbstractLineGutterMarkManager() {
        this.$init$();
        this.startup();
    }

    private void $init$() {
        this._started = false;
        this.openEditorList = new ArrayList();
    }

    protected void startup() {
        if (!this._started) {
            this._started = true;
            EditorManager editorManager = EditorManager.getEditorManager();
            editorManager.addEditorListener((EditorListener)this);
        }
    }

    protected void shutdown() {
        if (this._started) {
            this._started = false;
            EditorManager editorManager = EditorManager.getEditorManager();
            editorManager.removeEditorListener((EditorListener)this);
        }
    }

    protected void toggleLineGutterMark(CodeEditor codeEditor) {
        int line = codeEditor.getCaretLine();
        this.toggleLineGutterMark(codeEditor, line);
    }

    public void toggleLineGutterMark(CodeEditor codeEditor, int line) {
        URL url = this.getURLFor(codeEditor);
        if (url == null) {
            return;
        }
        LocatableItem[] lineGutterMarks = this.getLineGutterMarkList().findLineGutterMark(url, line);
        if (lineGutterMarks == null) {
            this.createLineGutterMarkFor(url, line);
        } else {
            this.removeLineGutterMark(lineGutterMarks[0]);
        }
    }

    public boolean hasLineGutterMarks() {
        return this.getLineGutterMarkList().getLineGutterMarkCount() != 0;
    }

    public LocatableItem[] getAllLineGutterMarks() {
        return this.getLineGutterMarkList().getAllLineGutterMarks();
    }

    public void gotoLineGutterMark(LocatableItem lineGutterMark) {
        URL url = lineGutterMark.getURL();
        OpenEditor[] openEditors = this.getOpenEditorsFor(url);
        if (openEditors.length > 0) {
            CodeEditor editorToActivate;
            OpenEditor editorToUse = openEditors[0];
            if (openEditors.length > 1) {
                Project activeProject = Ide.getActiveProject();
                Workspace activeWorkspace = Ide.getActiveWorkspace();
                OpenEditor selectedEditor = null;
                int numEditors = openEditors.length;
                int i = 0;
                while (i < numEditors) {
                    Context context = openEditors[i].editor.getContext();
                    if (context.getProject() == activeProject) {
                        selectedEditor = openEditors[i];
                        break;
                    }
                    ++i;
                }
                if (selectedEditor == null) {
                    int i2 = 0;
                    while (i2 < numEditors) {
                        Context context = openEditors[i2].editor.getContext();
                        if (context.getWorkspace() == activeWorkspace) {
                            selectedEditor = openEditors[i2];
                            break;
                        }
                        ++i2;
                    }
                }
                if (selectedEditor != null) {
                    editorToUse = selectedEditor;
                }
            }
            if ((editorToActivate = editorToUse.editor) != null) {
                EditorManager editorManager = EditorManager.getEditorManager();
                Context context = editorToActivate.getContext();
                CodeEditor editorOpened = (CodeEditor)editorManager.openEditorInFrame(CodeEditor.class, context);
                editorOpened.gotoLine(lineGutterMark.getLine(), lineGutterMark.getColumn(), false);
            }
        } else {
            try {
                Node node = NodeFactory.findOrCreate((URL)url);
                if (node != null) {
                    Context context = Context.newIdeContext((Node)node);
                    EditorManager editorManager = EditorManager.getEditorManager();
                    CodeEditor editorOpened = (CodeEditor)editorManager.openEditorInFrame(CodeEditor.class, context);
                    if (editorOpened != null) {
                        editorOpened.gotoLine(lineGutterMark.getLine(), lineGutterMark.getColumn(), false);
                    }
                } else {
                    System.out.println("could not locate node");
                }
            }
            catch (InstantiationException e) {
                System.out.println("could not locate node");
            }
            catch (IllegalAccessException e) {
                System.out.println("could not locate node");
            }
        }
    }

    public void removeLineGutterMark(LocatableItem lineGutterMark) {
        this.getLineGutterMarkList().removeLineGutterMark(lineGutterMark);
        OpenLineGutterMark[] openLineGutterMarks = this.getOpenLineGutterMarksFor(lineGutterMark);
        int numLineGutterMarks = openLineGutterMarks.length;
        int i = 0;
        while (i < numLineGutterMarks) {
            OpenLineGutterMark openLineGutterMark = openLineGutterMarks[i];
            OpenEditor openEditor = this.getOpenEditorFor(openLineGutterMark);
            if (openEditor != null) {
                openEditor.openLineGutterMarkList.remove(openLineGutterMark);
                openLineGutterMark.guttermark.getGutterColumn().removeGutterMark(openLineGutterMark.guttermark);
                if (openEditor.openLineGutterMarkList.size() == 0) {
                    this.removeGutterColumnFrom(openEditor.editor);
                }
            }
            ++i;
        }
    }

    protected abstract Icon getIcon();

    protected abstract HighlightStyle getHighlightStyle();

    protected abstract int getMarkOrder();

    protected abstract int getMarkOptions();

    protected abstract String getGutterColumnName();

    protected abstract LineGutterMarkList getLineGutterMarkList();

    protected abstract int getMissingLineBehavior();

    private boolean shouldRemoveLineGutterMarkForNonExistentLine() {
        int behavior = this.getMissingLineBehavior();
        return behavior == 2;
    }

    public void createLineGutterMarkFor(LocatableItem lineGutterMark) {
        OpenEditor[] openEditors = this.getOpenEditorsFor(lineGutterMark.getURL());
        int numEditors = openEditors.length;
        int i = 0;
        while (i < numEditors) {
            OpenEditor openEditor = openEditors[i];
            this.createGutterColumnFor(openEditor.editor);
            OpenLineGutterMark openLineGutterMark = this.createOpenLineGutterMarkFor(openEditor.gutter, lineGutterMark);
            openEditor.openLineGutterMarkList.add(openLineGutterMark);
            ++i;
        }
    }

    private LocatableItem createLineGutterMarkFor(URL url, int line) {
        LocatableItem lineGutterMark = this.getLineGutterMarkList().addLineGutterMark(url, line);
        OpenEditor[] openEditors = this.getOpenEditorsFor(url);
        int numEditors = openEditors.length;
        int i = 0;
        while (i < numEditors) {
            OpenEditor openEditor = openEditors[i];
            this.createGutterColumnFor(openEditor.editor);
            OpenLineGutterMark openLineGutterMark = this.createOpenLineGutterMarkFor(openEditor.gutter, lineGutterMark);
            openEditor.openLineGutterMarkList.add(openLineGutterMark);
            ++i;
        }
        return lineGutterMark;
    }

    private boolean isLineGutterMarkOnOpenList(LocatableItem lineGutterMark) {
        URL url = lineGutterMark.getURL();
        return this.hasOpenEditorsFor(url);
    }

    protected OpenLineGutterMark[] getOpenLineGutterMarkFor(GutterMark gutterMark) {
        ArrayList<OpenLineGutterMark> openMarks = new ArrayList<OpenLineGutterMark>();
        CodeEditorGutter gutter = (CodeEditorGutter)gutterMark.getGutter();
        OpenEditor openEditor = this.getOpenEditorFor(gutter);
        List openLineGutterMarkList = openEditor.openLineGutterMarkList;
        int numMarks = openLineGutterMarkList.size();
        int i = 0;
        while (i < numMarks) {
            OpenLineGutterMark openLineGutterMark = (OpenLineGutterMark)openLineGutterMarkList.get(i);
            if (openLineGutterMark.guttermark == gutterMark) {
                openMarks.add(openLineGutterMark);
                if (!this.getLineGutterMarkList().allowMultipleMarksPerLine()) break;
            }
            ++i;
        }
        int listLen = openMarks.size();
        if (listLen == 0) {
            return NO_OPEN_LINE_GUTTER_MARKS;
        }
        return openMarks.toArray(new OpenLineGutterMark[listLen]);
    }

    protected OpenEditor getOpenEditorFor(CodeEditorGutter gutter) {
        int numEditors = this.openEditorList.size();
        int i = 0;
        while (i < numEditors) {
            OpenEditor openEditor = (OpenEditor)this.openEditorList.get(i);
            if (openEditor.gutter == gutter) {
                return openEditor;
            }
            ++i;
        }
        return null;
    }

    protected OpenLineGutterMark[] getOpenLineGutterMarksFor(LocatableItem lineGutterMark) {
        ArrayList<OpenLineGutterMark> matchingList = new ArrayList<OpenLineGutterMark>();
        int numEditors = this.openEditorList.size();
        int i = 0;
        while (i < numEditors) {
            OpenEditor openEditor = (OpenEditor)this.openEditorList.get(i);
            OpenLineGutterMark openLineGutterMark = this.getOpenLineGutterMarkFor(openEditor, lineGutterMark);
            if (openLineGutterMark != null) {
                matchingList.add(openLineGutterMark);
            }
            ++i;
        }
        int numMatches = matchingList.size();
        return matchingList.toArray(new OpenLineGutterMark[numMatches]);
    }

    protected OpenLineGutterMark getOpenLineGutterMarkFor(OpenEditor openEditor, LocatableItem lineGutterMark) {
        if (openEditor != null) {
            List openLineGutterMarkList = openEditor.openLineGutterMarkList;
            int numMarks = openLineGutterMarkList.size();
            int i = 0;
            while (i < numMarks) {
                OpenLineGutterMark openLineGutterMark = (OpenLineGutterMark)openLineGutterMarkList.get(i);
                if (openLineGutterMark.lineGutterMark == lineGutterMark) {
                    return openLineGutterMark;
                }
                ++i;
            }
        }
        return null;
    }

    protected OpenEditor getOpenEditorFor(OpenLineGutterMark openLineGutterMark) {
        int numEditors = this.openEditorList.size();
        int i = 0;
        while (i < numEditors) {
            OpenEditor openEditor = (OpenEditor)this.openEditorList.get(i);
            if (openEditor.openLineGutterMarkList.contains(openLineGutterMark)) {
                return openEditor;
            }
            ++i;
        }
        return null;
    }

    private boolean hasOpenEditorsFor(URL url) {
        int numEditors = this.openEditorList.size();
        int i = 0;
        while (i < numEditors) {
            OpenEditor openEditor = (OpenEditor)this.openEditorList.get(i);
            if (openEditor.url.equals(url)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected OpenEditor[] getOpenEditorsFor(URL url) {
        ArrayList<OpenEditor> matchingList = new ArrayList<OpenEditor>();
        int numEditors = this.openEditorList.size();
        int i = 0;
        while (i < numEditors) {
            OpenEditor openEditor = (OpenEditor)this.openEditorList.get(i);
            if (openEditor.url.equals(url)) {
                matchingList.add(openEditor);
            }
            ++i;
        }
        int numMatches = matchingList.size();
        return matchingList.toArray(new OpenEditor[numMatches]);
    }

    protected OpenEditor getOpenEditorFor(CodeEditor codeEditor) {
        int numEditors = this.openEditorList.size();
        int i = 0;
        while (i < numEditors) {
            OpenEditor openEditor = (OpenEditor)this.openEditorList.get(i);
            if (openEditor.editor == codeEditor) {
                return openEditor;
            }
            ++i;
        }
        return null;
    }

    protected URL getURLFor(CodeEditor codeEditor) {
        Node node;
        Context context;
        if (codeEditor != null && (context = codeEditor.getContext()) != null && (node = context.getNode()) != null) {
            return node.getURL();
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private LocatableItem[] getNormalizedLineGutterMarksFor(CodeEditor codeEditor, URL url) {
        validList = new ArrayList<LocatableItem>();
        lineGutterMarks = this.getLineGutterMarkList().findLineGutterMarks(url);
        numMarks = lineGutterMarks.length;
        if (codeEditor.getGUI() == null) {
            return null;
        }
        lineCount = codeEditor.getLineCount();
        i = 0;
        while (i < numMarks) {
            lineGutterMark = lineGutterMarks[i];
            v0 = lineNotFound = lineGutterMark.getLine() > lineCount;
            if (!lineNotFound) ** GOTO lbl-1000
            if (this.isLineGutterMarkOnOpenList(lineGutterMark)) {
                throw new IllegalStateException("bad line open elsewhere");
            }
            shouldRemove = this.shouldRemoveLineGutterMarkForNonExistentLine();
            if (!shouldRemove && !(lineGutterMarkMoved = this.getLineGutterMarkList().modifyLineGutterMark(lineGutterMark, lineCount))) {
                shouldRemove = true;
            }
            if (shouldRemove) {
                this.getLineGutterMarkList().removeLineGutterMark(lineGutterMark);
                lineGutterMarks[i] = null;
            } else lbl-1000:
            // 2 sources

            {
                validList.add(lineGutterMark);
            }
            ++i;
        }
        validLineGutterMarks = validList.size();
        return validList.toArray(new LocatableItem[validLineGutterMarks]);
    }

    private void createGutterColumnFor(CodeEditor codeEditor) {
        CodeEditorGutter gutter = codeEditor.getGutter();
        GutterColumn column = gutter.lookupGutterColumn(this.getGutterColumnName());
        if (column == null) {
            gutter.createGutterColumn(this.getGutterColumnName(), (GutterColumnListener)this);
        }
    }

    protected void removeGutterColumnFrom(CodeEditor codeEditor) {
        CodeEditorGutter gutter = codeEditor.getGutter();
        GutterColumn column = gutter.lookupGutterColumn(this.getGutterColumnName());
        if (column != null) {
            gutter.removeGutterColumn(column);
        }
    }

    protected OpenLineGutterMark createOpenLineGutterMarkFor(CodeEditorGutter gutter, LocatableItem lineGutterMark) {
        GutterColumn column = gutter.lookupGutterColumn(this.getGutterColumnName());
        GutterMark gutterMark = column.addGutterMark(lineGutterMark.getLine(), this.getIcon(), this.getHighlightStyle(), this.getMarkOrder(), this.getMarkOptions());
        OpenLineGutterMark openLineGutterMark = null;
        if (gutterMark != null) {
            gutterMark.setUserData((Object)lineGutterMark);
            openLineGutterMark = new OpenLineGutterMark(lineGutterMark, gutterMark);
        }
        return openLineGutterMark;
    }

    private OpenEditor createOpenEditorFor(CodeEditor codeEditor) {
        URL url = this.getURLFor(codeEditor);
        if (url == null) {
            return null;
        }
        LocatableItem[] lineGutterMarks = this.getNormalizedLineGutterMarksFor(codeEditor, url);
        if (lineGutterMarks == null) {
            return null;
        }
        int numMarks = lineGutterMarks.length;
        CodeEditorGutter gutter = codeEditor.getGutter();
        ArrayList<OpenLineGutterMark> openLineGutterMarkList = new ArrayList<OpenLineGutterMark>();
        if (numMarks > 0) {
            this.createGutterColumnFor(codeEditor);
            int i = 0;
            while (i < numMarks) {
                LocatableItem lineGutterMark = lineGutterMarks[i];
                OpenLineGutterMark openLineGutterMark = this.createOpenLineGutterMarkFor(gutter, lineGutterMark);
                openLineGutterMarkList.add(openLineGutterMark);
                ++i;
            }
        }
        OpenEditor openEditor = new OpenEditor(codeEditor, url, gutter, openLineGutterMarkList);
        return openEditor;
    }

    public void editorOpened(Editor editor) {
        CodeEditor codeEditor;
        OpenEditor openEditor;
        if (editor instanceof CodeEditor && (openEditor = this.createOpenEditorFor(codeEditor = (CodeEditor)editor)) != null) {
            this.openEditorList.add(openEditor);
        }
    }

    public void editorClosed(Editor editor) {
        if (editor instanceof CodeEditor) {
            CodeEditor codeEditor = (CodeEditor)editor;
            OpenEditor openEditor = this.getOpenEditorFor(codeEditor);
            this.removeGutterColumnFrom(codeEditor);
            this.openEditorList.remove(openEditor);
        }
    }

    public void editorActivated(Editor editor) {
    }

    public void editorDeactivated(Editor editor) {
    }

    public void markMoved(GutterMark gutterMark, int oldLine, int newLine) {
        OpenLineGutterMark[] openLineGutterMark = this.getOpenLineGutterMarkFor(gutterMark);
        int i = 0;
        while (i < openLineGutterMark.length) {
            LocatableItem lineGutterMark = openLineGutterMark[i].lineGutterMark;
            boolean markMoved = this.getLineGutterMarkList().modifyLineGutterMark(lineGutterMark, newLine);
            if (!markMoved) {
                this.removeLineGutterMark(lineGutterMark);
            }
            ++i;
        }
    }

    public void markRemoved(GutterMark gutterMark, int deletedLine) {
        OpenLineGutterMark[] openLineGutterMark = this.getOpenLineGutterMarkFor(gutterMark);
        int i = 0;
        while (i < openLineGutterMark.length) {
            LocatableItem lineGutterMark = openLineGutterMark[i].lineGutterMark;
            this.removeLineGutterMark(lineGutterMark);
            ++i;
        }
    }

    public void markClicked(GutterMark gutterMark, int clickedLine, MouseEvent event) {
    }

    public String getMarkToolTip(GutterMark mark, MouseEvent event) {
        String tooltipText = null;
        Object markData = mark.getUserData();
        if (markData != null) {
            Class<?> clazz = markData.getClass();
            try {
                Method method = clazz.getMethod("getTooltip", null);
                if (method != null) {
                    tooltipText = (String)method.invoke(markData, null);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return tooltipText;
    }
}

