/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.xml;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import oracle.bali.xml.dom.DomModel;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.util.SwingClosure;
import oracle.jdeveloper.xml.DomIO;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Document;

public class TextBufferDomIO
extends DomIO {
    private final TextBuffer _buffer;
    private final URL _bufferURL;

    public TextBufferDomIO(TextBuffer buffer, URL bufferURL) {
        this._buffer = buffer;
        this._bufferURL = bufferURL;
    }

    public Document load() throws IOException {
        Reader reader = TextBufferFactory.createReader((ReadTextBuffer)this._buffer);
        return TextBufferDomIO.loadImpl(null, reader, this._bufferURL);
    }

    public void save(Document doc) throws IOException {
        TextBufferDomIO.runSwingClosure(new 1(this, false, doc));
    }

    private boolean tryDumpBufferDomModel(Document doc, TextBuffer targetBuffer) throws IOException {
        if (doc instanceof XMLDocument) {
            XMLDocument xmlDoc = (XMLDocument)doc;
            Object textBufferCopyObj = xmlDoc.getUserData("text-buffer-copy");
            Object domModelCopyObj = xmlDoc.getUserData("dom-model-copy");
            if (textBufferCopyObj != null && domModelCopyObj != null) {
                TextBuffer textBufferCopy = (TextBuffer)textBufferCopyObj;
                DomModel domModelCopy = (DomModel)domModelCopyObj;
                domModelCopy.commitTransaction();
                domModelCopy.startTransaction("internal");
                TextBufferDomIO.dumpToTextBuffer(textBufferCopy, targetBuffer);
                return true;
            }
        }
        return false;
    }

    private void dumpToTextBuffer(Document doc, TextBuffer buffer) throws IOException {
        CharArrayWriter writer = this.getCharArrayWriter(doc);
        TextBufferDomIO.dumpToTextBuffer(writer.toCharArray(), this._buffer);
    }

    private static void dumpToTextBuffer(TextBuffer srcBuffer, TextBuffer dstBuffer) {
        TextBufferDomIO.dumpToTextBuffer(srcBuffer.getChars(0, srcBuffer.getLength()), dstBuffer);
    }

    private static void dumpToTextBuffer(char[] chars, TextBuffer buffer) {
        try {
            buffer.beginEdit();
            buffer.removeToEnd(0);
            buffer.insert(0, chars);
        }
        finally {
            buffer.endEdit();
        }
    }

    static TextBuffer ra$_buffer(TextBufferDomIO textBufferDomIO) {
        return textBufferDomIO._buffer;
    }

    static boolean mav$tryDumpBufferDomModel(TextBufferDomIO textBufferDomIO, Document document, TextBuffer textBuffer) {
        return textBufferDomIO.tryDumpBufferDomModel(document, textBuffer);
    }

    static void mav$dumpToTextBuffer(TextBufferDomIO textBufferDomIO, Document document, TextBuffer textBuffer) {
        textBufferDomIO.dumpToTextBuffer(document, textBuffer);
    }

    final class 1
    extends SwingClosure {
        private final /* synthetic */ Document v$doc;
        final /* synthetic */ TextBufferDomIO this$0;

        protected void runImpl() throws Exception {
            if (!TextBufferDomIO.mav$tryDumpBufferDomModel(this.this$0, this.v$doc, TextBufferDomIO.ra$_buffer(this.this$0))) {
                TextBufferDomIO.mav$dumpToTextBuffer(this.this$0, this.v$doc, TextBufferDomIO.ra$_buffer(this.this$0));
            }
        }

        public 1(TextBufferDomIO textBufferDomIO, boolean bl, Document document) {
            this.v$doc = document;
            this.this$0 = textBufferDomIO;
            super(bl);
        }
    }
}

