/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant;

import java.awt.Window;
import java.io.ByteArrayOutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import oracle.ide.Ide;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Subject;
import oracle.ide.model.TextNode;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.ModelUtil;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.ant.AntBuildfile;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AntBuildfileImpl
implements AntBuildfile {
    private URL url;
    private Document document;
    private Properties properties;
    private ArrayList rootPaths;

    private void $init$() {
        this.properties = new Properties();
        this.rootPaths = new ArrayList();
    }

    public AntBuildfileImpl(URL url, Document document) {
        this.$init$();
        this.url = url;
        this.document = document;
    }

    public URL getURL() {
        return this.url;
    }

    public Document getDocument() {
        return this.document;
    }

    public String[] getTargets() {
        NodeList list = this.document.getElementsByTagNameNS("antlib:org.apache.tools.ant", "target");
        int length = list.getLength();
        ArrayList<String> targets = new ArrayList<String>(length);
        int i = 0;
        while (i < length) {
            Element element = (Element)list.item(i);
            Attr attr = element.getAttributeNodeNS(null, "name");
            if (attr != null) {
                targets.add(attr.getValue());
            }
            ++i;
        }
        return targets.toArray(new String[0]);
    }

    public Element getTarget(String name) {
        NodeList list = this.document.getElementsByTagNameNS("antlib:org.apache.tools.ant", "target");
        int length = list.getLength();
        int i = 0;
        while (i < length) {
            Element element = (Element)list.item(i);
            Attr attr = element.getAttributeNodeNS(null, "name");
            if (attr != null && name.equals(attr.getValue())) {
                return element;
            }
            ++i;
        }
        return null;
    }

    public Element createTarget(String name) {
        return this.createTarget(name, null);
    }

    public Element createTarget(String name, String description) {
        return this.createTarget(name, description, null);
    }

    public void appendBeforeTargets(org.w3c.dom.Node node) {
        NodeList targets = this.document.getElementsByTagNameNS("antlib:org.apache.tools.ant", "target");
        org.w3c.dom.Node target = targets.getLength() > 0 ? targets.item(0) : null;
        Element project = this.document.getDocumentElement();
        project.insertBefore(node, target);
    }

    public void addDependency(String target, String dependency) {
        Element element = this.getTarget(target);
        Attr depends = element.getAttributeNodeNS(null, "depends");
        if (depends == null) {
            element.setAttributeNS(null, "depends", dependency);
        } else {
            StringBuffer buffer = new StringBuffer(depends.getValue());
            buffer.append(",");
            buffer.append(dependency);
            depends.setValue(buffer.toString());
        }
    }

    public Element createTarget(String name, String description, String[] depends) {
        Element target = this.document.createElementNS("antlib:org.apache.tools.ant", "target");
        target.setAttributeNS(null, "name", name);
        if (description != null) {
            target.setAttributeNS(null, "description", description);
        }
        if (depends != null && depends.length > 0) {
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < depends.length) {
                buffer.append(depends[i]);
                if (i < depends.length - 1) {
                    buffer.append(',');
                }
                ++i;
            }
            target.setAttributeNS(null, "depends", buffer.toString());
        }
        this.document.getDocumentElement().appendChild(target);
        return target;
    }

    public void addGlobalProperty(String name, String value) {
        this.properties.setProperty(name, value);
    }

    public void addPathRoot(String property, URL root) {
        this.rootPaths.add(new PathRoot(property, root));
    }

    public String getRelativePath(URL url) {
        URL oracle;
        if (JarUtil.isJarURL((URL)url) && !ModelUtil.hasLength((String)JarUtil.getJarEntry((URL)url))) {
            url = JarUtil.getJarFileURL((URL)url);
        }
        Iterator iterator = this.rootPaths.iterator();
        String path = null;
        while (iterator.hasNext() && path == null) {
            PathRoot root = (PathRoot)iterator.next();
            path = URLFileSystem.toRelativeSpec((URL)url, (URL)root.getURL(), (boolean)true);
            if (path == null) continue;
            path = "${" + root.getProperty() + "}/" + path;
        }
        URL basedir = URLFileSystem.getParent((URL)this.url);
        if (path == null) {
            path = URLFileSystem.toRelativeSpec((URL)url, (URL)basedir, (boolean)true);
        }
        if (path == null && (path = URLFileSystem.toRelativeSpec((URL)url, (URL)(oracle = URLFactory.newDirURL((String)Ide.getOracleHomeDirectory())), (boolean)true)) != null) {
            path = "${oracle.home}/" + path;
        }
        if (path == null && (path = URLFileSystem.toRelativeSpec((URL)url, (URL)basedir, (boolean)false)).equals(url.getPath())) {
            path = URLFileSystem.getPlatformPathName((URL)url);
        }
        if (path == null || path.length() == 0) {
            path = ".";
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public String createPropertyReference(String property) {
        StringBuffer buffer = new StringBuffer(property);
        buffer.insert(0, "${");
        buffer.append("}");
        return buffer.toString();
    }

    public Element createPath(String id, URLPath path) {
        Element element = this.document.createElementNS("antlib:org.apache.tools.ant", "path");
        element.setAttributeNS(null, "id", id);
        URL[] urls = path.getEntries();
        int i = 0;
        while (i < urls.length) {
            Element pe = this.document.createElementNS("antlib:org.apache.tools.ant", "pathelement");
            pe.setAttributeNS(null, "location", this.getRelativePath(urls[i]));
            element.appendChild(pe);
            ++i;
        }
        return element;
    }

    public Element createPatternSet(String id, String[] includes, String[] excludes) {
        Element patternset = this.document.createElementNS("antlib:org.apache.tools.ant", "patternset");
        patternset.setAttributeNS(null, "id", id);
        if (includes != null) {
            int i = 0;
            while (i < includes.length) {
                Element include = this.document.createElementNS("antlib:org.apache.tools.ant", "include");
                include.setAttributeNS(null, "name", includes[i]);
                patternset.appendChild(include);
                ++i;
            }
        }
        if (excludes != null) {
            int i = 0;
            while (i < excludes.length) {
                Element exclude = this.document.createElementNS("antlib:org.apache.tools.ant", "exclude");
                exclude.setAttributeNS(null, "name", excludes[i]);
                patternset.appendChild(exclude);
                ++i;
            }
        }
        return patternset;
    }

    public void saveProperties(URL url) {
        try {
            Node node = NodeFactory.findOrCreate((URL)url);
            if (node instanceof TextNode) {
                TextNode textNode = (TextNode)node;
                TextBuffer textBuffer = null;
                try {
                    textBuffer = textNode.acquireTextBuffer();
                    textBuffer.removeToEnd(0);
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    this.properties.store(out, null);
                    String str = out.toString("8859_1");
                    textBuffer.insert(0, str.toCharArray());
                    UpdateMessage.fireStructureChanged((Subject)textNode);
                }
                finally {
                    if (textBuffer != null) {
                        textNode.releaseTextBuffer();
                    }
                }
            }
            node.save();
        }
        catch (Exception e) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)e);
        }
    }

    private class PathRoot {
        private URL url;
        private String property;

        public PathRoot(String property, URL url) {
            this.property = property;
            this.url = url;
        }

        public URL getURL() {
            return this.url;
        }

        public String getProperty() {
            return this.property;
        }
    }
}

