/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.XmlModelListener;
import oracle.bali.xml.model.event.XmlModelAdapter;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.externaltools.ExternalToolManager;
import oracle.ide.externaltools.macro.MacroRegistry;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.VersionNumber;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.ant.AntContext;
import oracle.jdeveloper.ant.AntRunConfiguration;
import oracle.jdeveloper.ant.Target;
import oracle.jdeveloper.library.JDK;
import oracle.jdevimpl.ant.AntModel;
import oracle.jdevimpl.ant.AntVersion;
import oracle.jdevimpl.ant.TargetImpl;
import oracle.jdevimpl.ant.parser.AntParser;
import oracle.jdevimpl.ant.parser.PropertyFilePropertyProvider;
import oracle.jdevimpl.ant.parser.PropertyProvider;
import oracle.jdevimpl.ant.parser.PropertyProviderListener;
import oracle.jdevimpl.ant.parser.SimplePropertyProvider;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.util.FileUtils;
import org.w3c.dom.Document;

public class AntContextImpl
implements AntContext,
PropertyProviderListener {
    private XmlContext xmlContext;
    private AntParser parser;
    private String projectName;
    private String projectDescription;
    private File baseDir;
    private String defaultTarget;
    private HashMap targets;
    private HashMap targetCache;
    private boolean targetsDirty;
    private LinkedList propertyProviders;
    private HashMap propertyCache;
    private HashMap idCache;
    private boolean propertiesDirty;
    private ArrayList imports;
    private ArrayList importingContexts;
    private FileUtils fileUtils;
    private HashSet alreadySeen;

    private void $init$() {
        this.targets = new HashMap();
        this.targetCache = new HashMap();
        this.targetsDirty = true;
        this.propertyProviders = new LinkedList();
        this.propertyCache = new HashMap();
        this.idCache = new HashMap();
        this.propertiesDirty = true;
        this.imports = new ArrayList();
        this.importingContexts = new ArrayList();
        this.fileUtils = FileUtils.getFileUtils();
        this.alreadySeen = new HashSet();
    }

    public AntContextImpl(XmlContext xmlContext) {
        this.$init$();
        this.xmlContext = xmlContext;
        this.parser = new AntParser(this);
        xmlContext.getModel().addModelListener((XmlModelListener)new ModelListener(null));
    }

    public XmlContext getXmlContext() {
        return this.xmlContext;
    }

    private void addImportingContext(AntContextImpl context) {
        if (!this.importingContexts.contains(context)) {
            this.importingContexts.add(context);
        }
    }

    private void removeImportingContext(AntContextImpl context) {
        this.importingContexts.remove(context);
    }

    private List getImportingContexts() {
        return this.importingContexts;
    }

    public URL getBuildfile() {
        return ((JDevXmlContext)this.xmlContext).getIdeDocument().getURL();
    }

    public File resolveFile(String file) {
        if (this.baseDir == null && !FileUtils.isAbsolutePath((String)file)) {
            return null;
        }
        try {
            File file2 = this.fileUtils.resolveFile(this.baseDir, file);
            return file2;
        }
        catch (BuildException be) {
            File file3 = null;
            return file3;
        }
    }

    public URL resolveImport(String file) {
        URL parent = URLFileSystem.getParent((URL)this.getBuildfile());
        if (parent != null) {
            File dir = new File(URLFileSystem.getPlatformPathName((URL)parent));
            try {
                File importFile = this.fileUtils.resolveFile(dir, file);
                URL uRL = URLFactory.newFileURL((File)importFile);
                return uRL;
            }
            catch (BuildException be) {
                // empty catch block
            }
        }
        return null;
    }

    public AntContextImpl getAntContext(URL url) {
        AntContextImpl context = null;
        XmlModel model = this.xmlContext.getRelatedXmlModel(url);
        if (model instanceof AntModel) {
            context = (AntContextImpl)((AntModel)model).getAntContext();
        }
        return context;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getProjectDescription() {
        return this.projectDescription;
    }

    public Target getDefaultTarget() {
        return this.getTarget(this.defaultTarget);
    }

    public List getTargets() {
        this.loadTargets();
        ArrayList list = new ArrayList();
        Iterator iterator = this.targetCache.entrySet().iterator();
        while (iterator.hasNext()) {
            list.add(iterator.next().getValue());
        }
        list.trimToSize();
        return list;
    }

    public Target getTarget(String name) {
        Target target = (Target)this.targets.get(name);
        if (target == null) {
            this.loadTargets();
            target = (Target)this.targetCache.get(name);
        }
        return target;
    }

    public List getPropertyNames() {
        this.loadProperties();
        ArrayList list = new ArrayList();
        list.addAll(this.propertyCache.keySet());
        list.trimToSize();
        return list;
    }

    public String getProperty(String name) {
        this.loadProperties();
        return (String)this.propertyCache.get(name);
    }

    public List getImports() {
        return this.imports;
    }

    public String getDefaultTargetName() {
        return this.defaultTarget;
    }

    public List getTargetsInternal() {
        ArrayList list = new ArrayList();
        Iterator iterator = this.targets.entrySet().iterator();
        while (iterator.hasNext()) {
            list.add(iterator.next().getValue());
        }
        list.trimToSize();
        return list;
    }

    public String resolveProperties(String str) {
        return this.resolveProperties(str, false);
    }

    public String resolveProperties(String str, boolean mustResolve) {
        this.loadProperties();
        StringBuffer buffer = new StringBuffer();
        Pattern pattern = Pattern.compile("(?:^|[^\\$])(\\$\\{(.+?)\\})");
        Matcher matcher = pattern.matcher(str);
        int last = 0;
        while (matcher.find()) {
            buffer.append(str.substring(last, matcher.start(1)));
            String property = matcher.group(2);
            String value = this.getProperty(property);
            if (value != null) {
                buffer.append(value);
            } else {
                if (mustResolve) {
                    return null;
                }
                buffer.append(matcher.group(1));
            }
            last = matcher.end(1);
        }
        buffer.append(str.substring(last, str.length()));
        return buffer.toString();
    }

    private void dumpCaches() {
        this.dumpPropertyCache();
        this.dumpTargetCache();
    }

    private void dumpPropertyCache() {
        if (!this.propertiesDirty) {
            this.propertiesDirty = true;
            this.propertyCache.clear();
            this.idCache.clear();
        }
    }

    private void dumpTargetCache() {
        if (!this.targetsDirty) {
            this.targetsDirty = true;
            this.targetCache.clear();
        }
    }

    private void loadProperties() {
        if (this.propertiesDirty) {
            this.propertiesDirty = false;
            this.addBuiltInProperties();
            this.addJavaProperties();
            this.addJDevProperties();
            HashSet<URL> alreadySeen = new HashSet<URL>();
            alreadySeen.add(this.getBuildfile());
            this.addConfigurationProperties(alreadySeen);
            this.getProperties(this.propertyCache, this.idCache, alreadySeen);
        }
    }

    private void addBuiltInProperties() {
        File antFile = new File(URLFileSystem.getPlatformPathName((URL)this.getBuildfile()));
        this.addProperty("ant.file", antFile.getAbsolutePath());
        String antVersion = "";
        String antJavaVersion = "";
        URL antHome = null;
        JDevXmlContext jdevXmlContext = (JDevXmlContext)this.xmlContext;
        Project project = jdevXmlContext.getProject();
        AntRunConfiguration arc = this.getAntRunConfiguration();
        if (arc != null) {
            AntVersion ant = null;
            antHome = arc.getAntHome();
            if (antHome != null) {
                ant = AntVersion.createAntVersion(antHome);
            }
            if (ant == null) {
                ant = AntVersion.getDefaultAntVersion();
                antHome = ant.getAntHome();
            }
            antVersion = ant.getVersionString();
            JDK jdk = arc.getJDK(project);
            VersionNumber number = jdk.getJavaVersion();
            if (number.countParts() >= 2) {
                StringBuffer buffer = new StringBuffer(3);
                buffer.append(number.getPart(0));
                buffer.append(".");
                buffer.append(number.getPart(1));
                antJavaVersion = buffer.toString();
            }
        }
        this.addProperty("ant.version", antVersion);
        this.addProperty("ant.java.version", antJavaVersion);
        if (antHome != null) {
            String path = URLFileSystem.getPlatformPathName((URL)antHome);
            this.addProperty("ant.home", path);
        } else {
            this.addProperty("ant.home", "");
        }
    }

    private void addJavaProperties() {
        String javaVersion = "";
        String javaHome = "";
        AntRunConfiguration arc = this.getAntRunConfiguration();
        if (arc != null) {
            JDevXmlContext jdevXmlContext = (JDevXmlContext)this.xmlContext;
            Project project = jdevXmlContext.getProject();
            JDK jdk = arc.getJDK(project);
            VersionNumber number = jdk.getJavaVersion();
            javaVersion = number.toString();
            URL parent = URLFileSystem.getParent((URL)jdk.getSDKBinDir());
            if (parent != null) {
                javaHome = URLFileSystem.getPlatformPathName((URL)parent);
            }
        }
        this.addProperty("file.separator", System.getProperty("file.separator"));
        this.addProperty("line.separator", System.getProperty("line.separator"));
        this.addProperty("path.separator", System.getProperty("path.separator"));
        this.addProperty("os.arch", System.getProperty("os.arch"));
        this.addProperty("os.name", System.getProperty("os.name"));
        this.addProperty("os.version", System.getProperty("os.version"));
        this.addProperty("user.dir", System.getProperty("user.dir"));
        this.addProperty("user.home", System.getProperty("user.home"));
        this.addProperty("user.name", System.getProperty("user.name"));
        this.addProperty("java.home", javaHome);
        this.addProperty("java.version", javaVersion);
        this.addProperty("java.class.path", "");
        this.addProperty("java.class.version", "");
        this.addProperty("java.vendor", "");
        this.addProperty("java.vendor.url", "");
    }

    private void addJDevProperties() {
        this.addProperty("oracle.home", Ide.getOracleHomeDirectory());
    }

    private void addConfigurationProperties(Set alreadySeen) {
        AntRunConfiguration arc = this.getAntRunConfiguration();
        if (arc != null) {
            List names = arc.getPropertyNames();
            List files = arc.getPropertyFiles();
            if (!names.isEmpty() || !files.isEmpty()) {
                Context context = this.getIdeContext();
                MacroRegistry registry = ExternalToolManager.getExternalToolManager().getMacroRegistry();
                Iterator properties = names.iterator();
                Iterator values = arc.getPropertyValues().iterator();
                while (properties.hasNext()) {
                    String property = (String)properties.next();
                    String value = (String)values.next();
                    this.addProperty(property, registry.expand(value, context));
                }
                Iterator iterator = files.iterator();
                while (iterator.hasNext()) {
                    URL url = URLFactory.newFileURL((String)((String)iterator.next()));
                    this.addPropertyProvider(new PropertyFilePropertyProvider(url, null));
                    alreadySeen.add(url);
                }
            }
        }
    }

    private Context getIdeContext() {
        JDevXmlContext jdevXmlContext = (JDevXmlContext)this.xmlContext;
        Context context = Context.newIdeContext((Node)jdevXmlContext.getIdeDocument());
        context.setWorkspace(jdevXmlContext.getWorkspace());
        context.setProject(jdevXmlContext.getProject());
        return context;
    }

    private AntRunConfiguration getAntRunConfiguration() {
        AntRunConfiguration arc = null;
        JDevXmlContext jdevXmlContext = (JDevXmlContext)this.xmlContext;
        Project project = jdevXmlContext.getProject();
        if (project != null) {
            arc = AntRunConfiguration.getInstance((PropertyStorage)project);
        }
        return arc;
    }

    private void loadTargets() {
        if (this.targetsDirty) {
            this.targetCache.putAll(this.targets);
            HashSet<URL> importsSeen = new HashSet<URL>();
            importsSeen.add(this.getBuildfile());
            LinkedList queue = new LinkedList();
            queue.addAll(this.imports);
            while (!queue.isEmpty()) {
                URL url = (URL)queue.removeFirst();
                if (importsSeen.contains(url)) continue;
                AntContextImpl context = this.getAntContext(url);
                if (context != null) {
                    Iterator iterator = context.getTargetsInternal().iterator();
                    while (iterator.hasNext()) {
                        TargetImpl target = new TargetImpl(this, (Target)iterator.next());
                        if (this.targetCache.containsKey(target.getName())) {
                            String project = context.getProjectName();
                            if (project == null) continue;
                            target.setName(project + "." + target.getName());
                        }
                        target.setImported(true);
                        this.targetCache.put(target.getName(), target);
                    }
                    queue.addAll(0, context.getImports());
                }
                importsSeen.add(url);
            }
            this.targetsDirty = false;
        }
    }

    public void getProperties(Map properties, Map ids, Set alreadySeen) {
        for (PropertyProvider provider : this.propertyProviders) {
            provider.getProperties(this, properties, ids, alreadySeen);
        }
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
        this.addProperty("ant.project.name", projectName, null);
    }

    public void setProjectDescription(String projectDescription) {
        this.projectDescription = projectDescription;
    }

    public void setBaseDir(String baseDir) {
        URL parent = URLFileSystem.getParent((URL)this.getBuildfile());
        File dir = new File(URLFileSystem.getPlatformPathName((URL)parent));
        if (baseDir == null) {
            this.baseDir = dir;
        } else {
            try {
                this.baseDir = this.fileUtils.resolveFile(dir, baseDir);
            }
            catch (BuildException be) {
                this.baseDir = null;
            }
        }
        if (this.baseDir != null) {
            this.addProperty("basedir", this.baseDir.getPath(), null);
        } else {
            this.addProperty("basedir", baseDir, null);
        }
    }

    public void setDefaultTarget(String defaultTarget) {
        this.defaultTarget = defaultTarget;
    }

    public void addTarget(Target target) {
        this.targets.put(target.getName(), target);
    }

    public void addImport(URL file) {
        if (!file.equals(this.getBuildfile())) {
            this.imports.add(file);
            AntContextImpl context = this.getAntContext(file);
            if (context != null) {
                context.addImportingContext(this);
                String name = context.getProjectName();
                if (name != null) {
                    String path = URLFileSystem.getPlatformPathName((URL)file);
                    this.addProperty("ant.file." + name, path);
                }
            }
        }
    }

    public String resolveId(String id) {
        this.loadProperties();
        return (String)this.idCache.get(id);
    }

    public void addId(String id, String value) {
        this.addProperty(null, value, id);
    }

    public void addProperty(String name, String value) {
        this.addProperty(name, value, null);
    }

    public void addProperty(String name, String value, String id) {
        SimplePropertyProvider provider;
        if (!this.propertyProviders.isEmpty() && this.propertyProviders.getLast() instanceof SimplePropertyProvider) {
            provider = (SimplePropertyProvider)this.propertyProviders.getLast();
        } else {
            provider = new SimplePropertyProvider();
            this.propertyProviders.add(provider);
        }
        provider.addProperty(name, value, id);
        if (name != null && !this.propertyCache.containsKey(name)) {
            this.propertyCache.put(name, value);
        }
        if (id != null) {
            this.idCache.put(id, value);
        }
    }

    public void addPropertyProvider(PropertyProvider provider) {
        this.propertyProviders.add(provider);
        provider.addPropertyProviderListener(this);
        provider.getProperties(this, this.propertyCache, this.idCache, this.alreadySeen);
    }

    private void reset() {
        this.projectName = null;
        this.projectDescription = null;
        this.baseDir = null;
        this.defaultTarget = null;
        this.targets.clear();
        this.dumpCaches();
        for (URL file : this.imports) {
            AntContextImpl context = this.getAntContext(file);
            if (context == null) continue;
            context.removeImportingContext(this);
        }
        this.imports.clear();
        for (PropertyProvider provider : this.propertyProviders) {
            provider.removePropertyProviderListener(this);
            provider.dispose();
        }
        this.propertyProviders.clear();
        this.alreadySeen.clear();
    }

    public void parseDocument() {
        XmlModel model = this.xmlContext.getModel();
        model.acquireReadLock();
        try {
            this.propertiesDirty = false;
            this.alreadySeen.add(this.getBuildfile());
            this.addBuiltInProperties();
            this.addJavaProperties();
            this.addJDevProperties();
            this.addConfigurationProperties(this.alreadySeen);
            Document document = model.getDocument();
            if (document != null) {
                this.parser.parse(document);
            }
        }
        finally {
            model.releaseReadLock();
            this.propertiesDirty = true;
        }
    }

    private void dumpImportingContextCaches() {
        HashSet<URL> alreadySeen = new HashSet<URL>();
        LinkedList queue = new LinkedList();
        queue.addAll(this.importingContexts);
        while (!queue.isEmpty()) {
            AntContextImpl context = (AntContextImpl)queue.removeFirst();
            URL url = context.getBuildfile();
            if (alreadySeen.contains(url)) continue;
            context.dumpCaches();
            queue.addAll(context.getImportingContexts());
            alreadySeen.add(url);
        }
    }

    public void propertiesChanged(PropertyProvider provider) {
        this.dumpCaches();
        this.dumpImportingContextCaches();
    }

    static void mav$reset(AntContextImpl antContextImpl) {
        antContextImpl.reset();
    }

    static void mav$dumpImportingContextCaches(AntContextImpl antContextImpl) {
        antContextImpl.dumpImportingContextCaches();
    }

    private class ModelListener
    extends XmlModelAdapter {
        public void modelChanged(XmlModelEvent event) {
            if (event.isDomDocumentChanged() || event.isDomTreeChanged()) {
                AntContextImpl.mav$reset(AntContextImpl.this);
                AntContextImpl.this.parseDocument();
                AntContextImpl.mav$dumpImportingContextCaches(AntContextImpl.this);
            }
        }

        private ModelListener() {
        }

        ModelListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

