/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.model.Selection;
import oracle.bali.xml.model.XmlView;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeConstants;
import oracle.ide.cmd.RenameMessage;
import oracle.ide.config.ClientSetting;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.editor.EditorUtil;
import oracle.ide.explorer.ExplorerWindow;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeUtil;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectChangeEvent;
import oracle.ide.model.ProjectChangeListener;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.panels.ProjectPropertiesDialog;
import oracle.ide.net.URLFileSystem;
import oracle.ide.runner.RunProcessListener;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.view.View;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdeveloper.ant.AntContext;
import oracle.jdeveloper.ant.AntManager;
import oracle.jdeveloper.ant.AntNode;
import oracle.jdeveloper.ant.AntRunConfiguration;
import oracle.jdeveloper.compiler.ant.AntConfiguration;
import oracle.jdevimpl.ant.AntArb;
import oracle.jdevimpl.ant.AntContextImpl;
import oracle.jdevimpl.ant.AntOptions;
import oracle.jdevimpl.ant.ProjectBuildfilePanel;
import oracle.jdevimpl.ant.TargetImpl;
import oracle.jdevimpl.ant.runner.AntDebuggingProcess;
import oracle.jdevimpl.ant.runner.AntRunConfigurationDialog;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class AntController
implements Controller,
ContextMenuListener,
Observer {
    private static IdeAction runAntAction;
    private static IdeAction debugAntAction;
    private static IdeAction runTargetAction;
    private static IdeAction debugTargetAction;
    private static IdeAction goToImportAction;
    private static IdeAction runProjectBuildfileAction;
    private static IdeAction manageSettingsAction;
    private static final int RUN_ANT_CMD_ID;
    private static final int DEBUG_ANT_CMD_ID;
    private static final int RUN_TARGET_CMD_ID;
    private static final int DEBUG_TARGET_CMD_ID;
    private static final int GO_TO_IMPORT_CMD_ID;
    private static final int RUN_PROJECT_ANT_CMD_ID;
    private static final int MANAGE_ANT_SETTINGS_CMD_ID;
    private JMenuItem runProjectBuildfileItem;
    private Project activeProject;
    private static final float RUN_TARGET_SECTION = 1.0f;
    private static final float RUN_TARGET_ADVANCED_SECTION = 2.0f;

    public AntController() {
        this.createActions();
        Ide.getSystem().attach((Observer)this);
        Project.addProjectChangeListener((String)AntConfiguration.DATA_KEY, (ProjectChangeListener)new ProjectListener(null));
    }

    public void update(Object observed, UpdateMessage change) {
        int id = change.getMessageID();
        if (observed == Ide.getSystem()) {
            if (id == IdeConstants.ACTIVE_PROJECT_CHANGED) {
                if (this.activeProject != null) {
                    this.activeProject.detach((Observer)this);
                }
                this.activeProject = Ide.getActiveProject();
                if (this.activeProject != null) {
                    this.activeProject.attach((Observer)this);
                }
                this.updateTargetList(this.activeProject);
            }
        } else if (observed instanceof Project) {
            if (id == UpdateMessage.CHILD_REMOVED) {
                this.projectFilesRemoved((Project)observed, change.getRemoveObjects());
            } else if (id == UpdateMessage.CHILD_RENAMED) {
                this.projectFileRenamed((Project)observed, change);
            }
        }
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int commandId = action.getCommandId();
        if (commandId == RUN_TARGET_CMD_ID) {
            Node node;
            String target = this.getTarget(context);
            if (target != null && (node = context.getNode()) != null) {
                Project project;
                this.saveNode(context);
                URL url = node.getURL();
                if (url != null && (project = context.getProject()) != null) {
                    AntRunConfiguration projectConfig = AntRunConfiguration.getInstance((PropertyStorage)project);
                    AntRunConfiguration config = new AntRunConfiguration();
                    projectConfig.copyTo((Object)config);
                    config.setBuildfile(url);
                    config.setTargetList(Collections.singletonList(target));
                    AntManager.getAntManager().runAntNonBlocking(context, config, null);
                }
            }
            return true;
        }
        if (commandId == DEBUG_TARGET_CMD_ID) {
            Node node;
            String target = this.getTarget(context);
            if (target != null && (node = context.getNode()) != null) {
                this.saveNode(context);
                URL url = node.getURL();
                if (url != null) {
                    this.debugAnt(context, url, target);
                }
            }
        } else {
            if (commandId == RUN_ANT_CMD_ID) {
                Node node = context.getNode();
                if (node != null) {
                    AntRunConfiguration config = this.getAntRunConfiguration(context);
                    config.setBuildfile(node.getURL());
                    AntRunConfigurationDialog dialog = new AntRunConfigurationDialog(config);
                    if (dialog.run(context, (Component)Ide.getMainWindow(), false)) {
                        this.saveNode(context);
                        AntManager.getAntManager().runAntNonBlocking(context, config, null);
                    }
                }
                return true;
            }
            if (commandId == DEBUG_ANT_CMD_ID) {
                Node node = context.getNode();
                if (node != null) {
                    AntRunConfiguration config = this.getAntRunConfiguration(context);
                    config.setBuildfile(node.getURL());
                    AntRunConfigurationDialog dialog = new AntRunConfigurationDialog(config);
                    if (dialog.run(context, (Component)Ide.getMainWindow(), false)) {
                        this.debugAnt(config, context);
                    }
                }
                return true;
            }
            if (commandId == RUN_PROJECT_ANT_CMD_ID) {
                Project project = Ide.getActiveProject();
                if (project != null) {
                    AntManager manager = AntManager.getAntManager();
                    URL buildfile = manager.getProjectBuildfile(project);
                    if (buildfile == null && ProjectBuildfilePanel.runDialog(project)) {
                        buildfile = manager.getProjectBuildfile(project);
                    }
                    if (buildfile != null) {
                        String target = manager.getDefaultTarget(project);
                        manager.runAntNonBlocking(context, buildfile, target, null);
                    }
                }
                return true;
            }
            if (commandId == GO_TO_IMPORT_CMD_ID) {
                URL url = this.getImport(context);
                if (url != null) {
                    try {
                        Node node = NodeFactory.findOrCreate((URL)url);
                        if (node != null) {
                            EditorUtil.openExplicitDefaultEditorInFrame((Node)NodeFactory.find((URL)url));
                        }
                    }
                    catch (InstantiationException ie) {
                    }
                    catch (IllegalAccessException iae) {
                        // empty catch block
                    }
                }
                return true;
            }
            if (commandId == MANAGE_ANT_SETTINGS_CMD_ID) {
                Project project = Ide.getActiveProject();
                if (project != null) {
                    String[] path = new String[]{AntArb.getString(164)};
                    ProjectPropertiesDialog.showDialog((Context)context, (Frame)Ide.getMainWindow(), (Project)project, (String[])path);
                }
                return true;
            }
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        int commandId = action.getCommandId();
        if (commandId == RUN_TARGET_CMD_ID || commandId == DEBUG_TARGET_CMD_ID || commandId == RUN_ANT_CMD_ID || commandId == DEBUG_ANT_CMD_ID || commandId == GO_TO_IMPORT_CMD_ID) {
            action.setEnabled(context.getNode() instanceof AntNode);
            return true;
        }
        if (commandId == RUN_PROJECT_ANT_CMD_ID) {
            String name;
            Project project = Ide.getActiveProject();
            action.setEnabled(project != null);
            if (project != null) {
                MessageFormat formatter = new MessageFormat(AntArb.getString(161));
                name = formatter.format(new Object[]{project.getShortLabel()});
            } else {
                name = AntArb.getString(167);
            }
            this.runProjectBuildfileItem.setText(name);
            action.putValue("Name", (Object)name);
            return true;
        }
        if (commandId == MANAGE_ANT_SETTINGS_CMD_ID) {
            Project project = Ide.getActiveProject();
            action.setEnabled(project != null);
            return true;
        }
        return false;
    }

    public void menuWillShow(ContextMenu popup) {
        Node node = popup.getContext().getNode();
        if (node instanceof AntNode) {
            boolean isTarget = false;
            View view = popup.getContext().getView();
            if (view instanceof ExplorerWindow) {
                URL url;
                String target = this.getTarget(popup.getContext());
                if (target != null) {
                    isTarget = true;
                    String actionName = AntArb.format(79, target);
                    runTargetAction.putValue("Name", (Object)actionName);
                    popup.add((Component)popup.createMenuItem((ToggleAction)runTargetAction), JDeveloperMenuConstants.SECTION_RUN_CTXT_MENU);
                    actionName = AntArb.format(216, target);
                    debugTargetAction.putValue("Name", (Object)actionName);
                    popup.add((Component)popup.createMenuItem((ToggleAction)debugTargetAction), JDeveloperMenuConstants.SECTION_RUN_CTXT_MENU);
                }
                if ((url = this.getImport(popup.getContext())) != null && URLFileSystem.exists((URL)url)) {
                    popup.add((Component)popup.createMenuItem((ToggleAction)goToImportAction), MenuConstants.SECTION_NAVIGATE_CTXT_MENU);
                }
            }
            if (!isTarget) {
                Context context = popup.getContext();
                AntContext ac = AntManager.getAntManager().getAntContext(node.getURL(), context.getProject());
                List targets = ac.getTargets();
                if (!targets.isEmpty()) {
                    JMenu runMenu = this.createTargetMenu(context, node, targets, AntArb.getString(124), AntArb.getInteger(96), false);
                    popup.add((Component)runMenu, JDeveloperMenuConstants.SECTION_RUN_CTXT_MENU);
                    JMenu debugMenu = this.createTargetMenu(context, node, targets, AntArb.getString(60), AntArb.getInteger(56), true);
                    popup.add((Component)debugMenu, JDeveloperMenuConstants.SECTION_RUN_CTXT_MENU);
                }
            }
        }
    }

    public void menuWillHide(ContextMenu popup) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    private void createActions() {
        JMenu buildMenu = MenuManager.getJMenu((String)"Build");
        String category = buildMenu.getText();
        runAntAction = IdeAction.get((int)RUN_ANT_CMD_ID, null, (String)AntArb.getString(227), (String)category, (Integer)AntArb.getInteger(20), null, null, null, (boolean)true);
        runAntAction.addController((Controller)this);
        runTargetAction = IdeAction.get((int)RUN_TARGET_CMD_ID, null, (String)AntArb.getString(79), (String)category, (Integer)AntArb.getInteger(35), (ArrayResourceBundle)AntArb.getInstance(), (int)93, null, (boolean)true);
        runTargetAction.addController((Controller)this);
        debugAntAction = IdeAction.get((int)DEBUG_ANT_CMD_ID, null, (String)AntArb.getString(227), (String)category, (Integer)AntArb.getInteger(20), null, null, null, (boolean)true);
        debugAntAction.addController((Controller)this);
        debugTargetAction = IdeAction.get((int)DEBUG_TARGET_CMD_ID, null, (String)AntArb.getString(216), (String)category, (Integer)AntArb.getInteger(228), (ArrayResourceBundle)AntArb.getInstance(), (int)93, null, (boolean)true);
        debugTargetAction.addController((Controller)this);
        goToImportAction = IdeAction.get((int)GO_TO_IMPORT_CMD_ID, null, (String)AntArb.getString(16), (String)category, (Integer)AntArb.getInteger(15), null, null, null, (boolean)true);
        goToImportAction.addController((Controller)this);
        runProjectBuildfileAction = IdeAction.get((int)RUN_PROJECT_ANT_CMD_ID, null, (String)AntArb.getString(167), (String)category, (Integer)AntArb.getInteger(150), (ArrayResourceBundle)AntArb.getInstance(), (int)140, null, (boolean)true);
        runProjectBuildfileAction.addController((Controller)this);
        runProjectBuildfileAction.putValue("NoCtxName", (Object)AntArb.getString(167));
        runProjectBuildfileAction.putValue("ActionMenuActions", (Object)new IdeAction[]{manageSettingsAction});
        Menubar menuBar = Ide.getMenubar();
        this.runProjectBuildfileItem = menuBar.createMenuItem((ToggleAction)runProjectBuildfileAction, JDeveloperMenuConstants.WEIGHT_RUN_ANT);
        menuBar.add((Component)this.runProjectBuildfileItem, buildMenu, JDeveloperMenuConstants.SECTION_BUILD_CONTROL);
        manageSettingsAction = IdeAction.get((int)MANAGE_ANT_SETTINGS_CMD_ID, null, (String)AntArb.getString(76), (String)category, (Integer)AntArb.getInteger(44), null, null, (boolean)true);
        manageSettingsAction.addController((Controller)this);
    }

    private String getTarget(Context context) {
        XmlView view;
        String target = null;
        JDevXmlContext xmlContext = JDevXmlContext.getXmlContext((Context)context);
        if (xmlContext != null && (view = xmlContext.getActiveView()) != null) {
            Selection selection = view.getSelection();
            try {
                selection.acquireModelReadLock();
                if (selection.size() == 1) {
                    org.w3c.dom.Node node = selection.getSelectedNodesArray()[0];
                    target = this.getTarget(node);
                }
            }
            finally {
                selection.releaseModelReadLock();
            }
        }
        return target;
    }

    private String getTarget(org.w3c.dom.Node node) {
        Element element;
        Attr attr;
        if (node != null && node.getNodeType() == 1 && this.isAntNamespace(node.getNamespaceURI()) && "target".equals(node.getLocalName()) && (attr = (element = (Element)node).getAttributeNodeNS(null, "name")) != null) {
            return attr.getValue();
        }
        return null;
    }

    private URL getImport(Context context) {
        XmlView view;
        URL url = null;
        JDevXmlContext xmlContext = JDevXmlContext.getXmlContext((Context)context);
        if (xmlContext != null && (view = xmlContext.getActiveView()) != null) {
            Selection selection = view.getSelection();
            try {
                selection.acquireModelReadLock();
                if (selection.size() == 1) {
                    org.w3c.dom.Node node = selection.getSelectedNodesArray()[0];
                    url = this.getImport(context, node);
                }
            }
            finally {
                selection.releaseModelReadLock();
            }
        }
        return url;
    }

    private URL getImport(Context context, org.w3c.dom.Node node) {
        Element element;
        Attr attr;
        if (node != null && node.getNodeType() == 1 && this.isAntNamespace(node.getNamespaceURI()) && "import".equals(node.getLocalName()) && (attr = (element = (Element)node).getAttributeNodeNS(null, "file")) != null) {
            String file;
            AntContext ac;
            String value = attr.getValue();
            Node contextNode = context.getNode();
            if (contextNode != null && (ac = AntManager.getAntManager().getAntContext(contextNode.getURL(), context.getProject())) != null && (file = ac.resolveProperties(value, true)) != null) {
                return ((AntContextImpl)ac).resolveImport(file);
            }
        }
        return null;
    }

    private boolean isAntNamespace(String namespace) {
        return namespace == null || "antlib:org.apache.tools.ant".equals(namespace);
    }

    private void saveNode(Context context) {
        Node node = context.getNode();
        if (node != null && node.isDirty()) {
            try {
                node.save();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void updateTargetList(Project project) {
        AntManager manager;
        List targets;
        Action[] actions = null;
        if (project != null && project.isOpen() && (targets = (manager = AntManager.getAntManager()).getTargetList(project)).size() > 0) {
            int size = targets.size() + 2;
            Icon icon = AntArb.getIcon(93);
            actions = new Action[size];
            Iterator iterator = targets.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                String target = (String)iterator.next();
                1 action = new 1(target, icon);
                actions[i] = action;
                ++i;
            }
            actions[size - 2] = null;
            actions[size - 1] = manageSettingsAction;
        }
        if (actions == null) {
            actions = new Action[]{manageSettingsAction};
        }
        SwingUtilities.invokeLater(new MenuActionUpdater(actions));
    }

    private void projectFilesRemoved(Project project, List removed) {
        AntConfiguration ac = AntConfiguration.getAntConfiguration((PropertyStorage)project);
        URL buildfile = ac.getProjectBuildfile();
        if (buildfile != null) {
            for (Object o : removed) {
                if (!(o instanceof Locatable) || !((Locatable)o).getURL().equals(buildfile)) continue;
                ac.setProjectBuildfile(null);
                ac.setTargetList(null);
                ac.setMakeTarget(null);
                ac.setRebuildTarget(null);
                project.markDirty(true);
            }
        }
    }

    private void projectFileRenamed(Project project, UpdateMessage change) {
        Node newNode;
        URL oldURL;
        AntConfiguration ac = AntConfiguration.getAntConfiguration((PropertyStorage)project);
        URL buildfile = ac.getProjectBuildfile();
        if (buildfile != null && (oldURL = RenameMessage.getOldURL((UpdateMessage)change)) != null && URLFileSystem.equals((URL)oldURL, (URL)buildfile) && (newNode = RenameMessage.getRenamedNode((UpdateMessage)change)) != null) {
            ac.setProjectBuildfile(newNode.getURL());
            project.markDirty(true);
        }
    }

    private JMenu createTargetMenu(Context context, Node node, List targets, String title, Integer mnemonic, boolean debug) {
        Menubar menubar = Ide.getMenubar();
        JMenu targetMenu = menubar.createSubMenu(title, mnemonic, Float.MAX_VALUE, JDeveloperMenuConstants.SECTION_RUN_CTXT_MENU);
        targetMenu.addMenuListener(new 2(this, targetMenu, context, node, targets, debug));
        return targetMenu;
    }

    private void createTargetSubmenu(Context context, URL buildfile, JMenu menu, List targets, boolean debug) {
        Collections.sort(targets);
        AntOptions options = this.getAntOptions();
        boolean showMainTargets = options.getShowOnlyMainTargets();
        boolean showImportedTargets = options.getShowImportedTargets();
        boolean hasMainTargets = false;
        int menuHeight = 0;
        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>(targets.size());
        Menubar menubar = Ide.getMenubar();
        Icon icon = AntArb.getIcon(93);
        for (TargetImpl target : targets) {
            boolean isMainTarget;
            if (!showImportedTargets && target.isImported()) continue;
            boolean bl = isMainTarget = target.getDescription() != null;
            if (showMainTargets && !hasMainTargets && isMainTarget) {
                hasMainTargets = true;
                items.clear();
                menuHeight = 0;
            }
            if (showMainTargets && hasMainTargets && !isMainTarget) continue;
            String name = target.getName();
            3 action = new 3(this, name, icon, debug, context, buildfile, name);
            JMenuItem menuItem = menubar.createMenuItem((ToggleAction)action, Float.MAX_VALUE);
            menuHeight += menuItem.getPreferredSize().height;
            items.add(menuItem);
        }
        if (items.size() > 0) {
            int screenHeight = ((JMenuItem)items.get((int)0)).getToolkit().getScreenSize().height;
            if (menuHeight > screenHeight * 9 / 10) {
                int size = items.size();
                int availableHeight = screenHeight * 9 / 10;
                int numSubMenus = menuHeight / availableHeight + 1;
                int numElementsPerMenu = items.size() / numSubMenus + 1;
                int nElementsInThisMenu = numElementsPerMenu + 1;
                JMenu subMenu = null;
                int i = 0;
                while (i < size) {
                    JMenuItem item = (JMenuItem)items.get(i);
                    if (nElementsInThisMenu >= numElementsPerMenu) {
                        String fromText = item.getText();
                        int toIndex = Math.min(i + numElementsPerMenu, size) - 1;
                        JMenuItem toItem = (JMenuItem)items.get(toIndex);
                        String toText = toItem.getText();
                        subMenu = new JMenu(fromText + " - " + toText);
                        menubar.add((Component)subMenu, menu, 1.0f);
                        nElementsInThisMenu = 0;
                    }
                    subMenu.add(item);
                    ++nElementsInThisMenu;
                    ++i;
                }
            } else {
                for (JMenuItem item : items) {
                    menubar.add((Component)item, menu, 1.0f);
                }
            }
        }
        JMenuItem item = menubar.createMenuItem((ToggleAction)(debug ? debugAntAction : runAntAction));
        menubar.add((Component)item, menu, 2.0f);
    }

    private AntOptions getAntOptions() {
        ClientSetting settings = ClientSetting.findOrCreate((String)"oracle.jdeveloper");
        return (AntOptions)settings.getData("AntOptions");
    }

    private void debugAnt(Context context, URL buildfile, String target) {
        AntRunConfiguration config = this.getAntRunConfiguration(context);
        config.setBuildfile(buildfile);
        config.addTarget(target);
        this.debugAnt(config, context);
    }

    private void debugAnt(AntRunConfiguration config, Context context) {
        this.saveNode(context);
        AntDebuggingProcess process = new AntDebuggingProcess(config, context);
        HashMap timestampMap = new HashMap();
        NodeUtil.storeAllTimestamps(timestampMap);
        process.setRunProcessListener(new 4(this, timestampMap, process));
        process.start();
    }

    private AntRunConfiguration getAntRunConfiguration(Context context) {
        AntRunConfiguration config = new AntRunConfiguration();
        Project project = context.getProject();
        if (project != null) {
            AntRunConfiguration projectConfig = AntRunConfiguration.getInstance((PropertyStorage)project);
            projectConfig.copyTo((Object)config);
        }
        return config;
    }

    static {
        RUN_ANT_CMD_ID = Ide.findOrCreateCmdID((String)"AntController.RUN_ANT_CMD_ID");
        DEBUG_ANT_CMD_ID = Ide.findOrCreateCmdID((String)"AntController.DEBUG_ANT_CMD_ID");
        RUN_TARGET_CMD_ID = Ide.findOrCreateCmdID((String)"AntController.RUN_TARGET_CMD_ID");
        DEBUG_TARGET_CMD_ID = Ide.findOrCreateCmdID((String)"AntController.DEBUG_TARGET_CMD_ID");
        GO_TO_IMPORT_CMD_ID = Ide.findOrCreateCmdID((String)"AntController.GO_TO_IMPORT_CMD_ID");
        RUN_PROJECT_ANT_CMD_ID = Ide.findOrCreateCmdID((String)"AntController.RUN_PROJECT_ANT_CMD_ID");
        MANAGE_ANT_SETTINGS_CMD_ID = Ide.findOrCreateCmdID((String)"AntController.MANAGE_ANT_SETTINGS_CMD_ID");
    }

    static IdeAction ra$runProjectBuildfileAction() {
        return runProjectBuildfileAction;
    }

    static Project ra$activeProject(AntController antController) {
        return antController.activeProject;
    }

    static void mav$updateTargetList(AntController antController, Project project) {
        antController.updateTargetList(project);
    }

    static void mav$debugAnt(AntController antController, Context context, URL uRL, String string) {
        antController.debugAnt(context, uRL, string);
    }

    static void mav$createTargetSubmenu(AntController antController, Context context, URL uRL, JMenu jMenu, List list, boolean bl) {
        antController.createTargetSubmenu(context, uRL, jMenu, list, bl);
    }

    final class 1
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            AntManager manager;
            URL buildfile;
            Project project = Ide.getActiveProject();
            if (project != null && (buildfile = (manager = AntManager.getAntManager()).getProjectBuildfile(project)) != null) {
                String target = (String)this.getValue("Name");
                Context context = Context.newIdeContext();
                manager.runAntNonBlocking(context, buildfile, target, null);
            }
        }

        public 1(String string, Icon icon) {
            super(string, icon);
        }
    }

    final class 2
    implements MenuListener {
        private final /* synthetic */ JMenu v$targetMenu;
        private final /* synthetic */ Context v$context;
        private final /* synthetic */ Node v$node;
        private final /* synthetic */ List v$targets;
        private final /* synthetic */ boolean v$debug;
        final /* synthetic */ AntController this$0;

        public void menuSelected(MenuEvent e) {
            if (this.v$targetMenu.getMenuComponentCount() == 0) {
                AntController.mav$createTargetSubmenu(this.this$0, this.v$context, this.v$node.getURL(), this.v$targetMenu, this.v$targets, this.v$debug);
            }
        }

        public void menuCanceled(MenuEvent e) {
        }

        public void menuDeselected(MenuEvent e) {
        }

        public 2(AntController antController, JMenu jMenu, Context context, Node node, List list, boolean bl) {
            this.v$debug = bl;
            this.v$targets = list;
            this.v$node = node;
            this.v$context = context;
            this.v$targetMenu = jMenu;
            this.this$0 = antController;
        }
    }

    final class 3
    extends ToggleAction {
        private final /* synthetic */ boolean v$debug;
        private final /* synthetic */ Context v$context;
        private final /* synthetic */ URL v$buildfile;
        private final /* synthetic */ String v$name;
        final /* synthetic */ AntController this$0;

        public void actionPerformed(ActionEvent e) {
            if (this.v$debug) {
                AntController.mav$debugAnt(this.this$0, this.v$context, this.v$buildfile, this.v$name);
            } else {
                AntManager manager = AntManager.getAntManager();
                manager.runAntNonBlocking(this.v$context, this.v$buildfile, this.v$name, null);
            }
        }

        public 3(AntController antController, String string, Icon icon, boolean bl, Context context, URL uRL, String string2) {
            this.v$name = string2;
            this.v$buildfile = uRL;
            this.v$context = context;
            this.v$debug = bl;
            this.this$0 = antController;
            super(string, icon);
        }
    }

    final class 4
    implements RunProcessListener {
        private final /* synthetic */ HashMap v$timestampMap;
        private final /* synthetic */ AntDebuggingProcess v$process;
        final /* synthetic */ AntController this$0;

        public void processFinished(int exitCode) {
            NodeUtil.reloadBuffers((Map)this.v$timestampMap);
            this.v$process.setRunProcessListener(null);
        }

        public 4(AntController antController, HashMap hashMap, AntDebuggingProcess antDebuggingProcess) {
            this.v$process = antDebuggingProcess;
            this.v$timestampMap = hashMap;
            this.this$0 = antController;
        }
    }

    private class MenuActionUpdater
    implements Runnable {
        private Action[] actions;

        public MenuActionUpdater(Action[] actions) {
            this.actions = actions;
        }

        public void run() {
            AntController.ra$runProjectBuildfileAction().putValue("ActionMenuActions", (Object)this.actions);
        }
    }

    private class ProjectListener
    extends ProjectChangeListener {
        public void projectPropertiesChanged(ProjectChangeEvent event) {
            Project project = event.getProject();
            if (AntController.ra$activeProject(AntController.this) == project) {
                AntController.mav$updateTargetList(AntController.this, project);
            }
        }

        public void projectOpened(Project project) {
            if (AntController.ra$activeProject(AntController.this) == project) {
                AntController.mav$updateTargetList(AntController.this, project);
            }
        }

        private ProjectListener() {
        }

        ProjectListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

