/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.bali.xml.model.XmlModel;
import oracle.ide.Context;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeUtil;
import oracle.ide.model.Project;
import oracle.ide.runner.RunProcessListener;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.ant.AntContext;
import oracle.jdeveloper.ant.AntGenerator;
import oracle.jdeveloper.ant.AntListener;
import oracle.jdeveloper.ant.AntManager;
import oracle.jdeveloper.ant.AntNode;
import oracle.jdeveloper.ant.AntRunConfiguration;
import oracle.jdeveloper.compiler.ant.AntConfiguration;
import oracle.jdevimpl.ant.AntArb;
import oracle.jdevimpl.ant.AntModel;
import oracle.jdevimpl.ant.generator.CopyGenerator;
import oracle.jdevimpl.ant.generator.JavaCompilationGenerator;
import oracle.jdevimpl.ant.generator.LibraryGenerator;
import oracle.jdevimpl.ant.runner.AntRunProcess;

public class AntManagerImpl
extends AntManager {
    private ArrayList listeners;
    private ArrayList generators;

    private void $init$() {
        this.listeners = new ArrayList();
        this.generators = new ArrayList();
    }

    public AntManagerImpl() {
        this.$init$();
        this.registerAntGenerators();
    }

    public URL getProjectBuildfile(Project project) {
        AntConfiguration ac;
        if (project != null && (ac = AntConfiguration.getAntConfiguration((PropertyStorage)project)) != null) {
            return ac.getProjectBuildfile();
        }
        return null;
    }

    public String getDefaultTarget(Project project) {
        AntConfiguration ac;
        if (project != null && (ac = AntConfiguration.getAntConfiguration((PropertyStorage)project)) != null) {
            return ac.getMakeTarget();
        }
        return null;
    }

    public List getTargetList(Project project) {
        AntConfiguration ac;
        if (project != null && (ac = AntConfiguration.getAntConfiguration((PropertyStorage)project)) != null) {
            return ac.getTargetList();
        }
        return Collections.EMPTY_LIST;
    }

    public int runAnt(Context context, URL buildfile, String target) {
        return this.runImpl(context, buildfile, target, true, null, true);
    }

    public int runAnt(Context context, URL buildfile, String target, boolean reloadBuffers) {
        return this.runImpl(context, buildfile, target, true, null, reloadBuffers);
    }

    public int runAnt(Context context, URL buildfile, String target, boolean reloadBuffers, String title) {
        return this.runImpl(context, buildfile, target, true, null, reloadBuffers, title);
    }

    public void runAntNonBlocking(Context context, URL buildfile, String target, AntListener listener) {
        this.runImpl(context, buildfile, target, false, listener, true);
    }

    public void runAntNonBlocking(Context context, URL buildfile, String target, AntListener listener, boolean reloadBuffers) {
        this.runImpl(context, buildfile, target, false, listener, reloadBuffers);
    }

    public void runAntNonBlocking(Context context, URL buildfile, String target, AntListener listener, boolean reloadBuffers, String title) {
        this.runImpl(context, buildfile, target, false, listener, reloadBuffers, title);
    }

    public int runAnt(Context context, AntRunConfiguration runConfiguration) {
        return this.runImpl(context, runConfiguration, true, null, true);
    }

    public int runAnt(Context context, AntRunConfiguration runConfiguration, boolean reloadBuffers) {
        return this.runImpl(context, runConfiguration, true, null, reloadBuffers);
    }

    public int runAnt(Context context, AntRunConfiguration runConfiguration, boolean reloadBuffers, String title) {
        return this.runImpl(context, runConfiguration, true, null, reloadBuffers, title);
    }

    public void runAntNonBlocking(Context context, AntRunConfiguration runConfiguration, AntListener listener) {
        this.runImpl(context, runConfiguration, false, listener, true);
    }

    public void runAntNonBlocking(Context context, AntRunConfiguration runConfiguration, AntListener listener, boolean reloadBuffers) {
        this.runImpl(context, runConfiguration, false, listener, reloadBuffers);
    }

    public void runAntNonBlocking(Context context, AntRunConfiguration runConfiguration, AntListener listener, boolean reloadBuffers, String title) {
        this.runImpl(context, runConfiguration, false, listener, reloadBuffers, title);
    }

    public AntContext getAntContext(URL url, Project project) {
        try {
            XMLSourceNode xmlNode;
            XmlModel model;
            Node node = NodeFactory.findOrCreate(AntNode.class, (URL)url);
            if (node instanceof XMLSourceNode && (model = (xmlNode = (XMLSourceNode)node).getModel(project)) instanceof AntModel) {
                AntContext antContext = ((AntModel)model).getAntContext();
                return antContext;
            }
        }
        catch (IllegalAccessException iae) {
        }
        catch (InstantiationException ie) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAntListener(AntListener listener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAntListener(AntListener listener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAntListeners() {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            List list = (List)this.listeners.clone();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAntGenerator(AntGenerator generator) {
        ArrayList arrayList = this.generators;
        synchronized (arrayList) {
            if (!this.generators.contains(generator)) {
                this.generators.add(generator);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAntGenerator(AntGenerator generator) {
        ArrayList arrayList = this.generators;
        synchronized (arrayList) {
            this.generators.remove(generator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getGenerators() {
        List localGenerators;
        ArrayList arrayList = this.generators;
        synchronized (arrayList) {
            localGenerators = (List)this.generators.clone();
        }
        return localGenerators;
    }

    private int runImpl(Context context, URL buildfile, String target, boolean block, AntListener listener, boolean reloadBuffers) {
        return this.runImpl(context, buildfile, target, block, listener, reloadBuffers, null);
    }

    private int runImpl(Context context, URL buildfile, String target, boolean block, AntListener listener, boolean reloadBuffers, String title) {
        AntRunConfiguration config = new AntRunConfiguration();
        Project project = context.getProject();
        if (project != null) {
            AntRunConfiguration projectConfig = AntRunConfiguration.getInstance((PropertyStorage)project);
            projectConfig.copyTo((Object)config);
        }
        config.setBuildfile(buildfile);
        config.addTarget(target);
        return this.runImpl(context, config, block, listener, reloadBuffers, title);
    }

    private int runImpl(Context context, AntRunConfiguration runConfiguration, boolean block, AntListener listener, boolean reloadBuffers) {
        return this.runImpl(context, runConfiguration, block, listener, reloadBuffers, null);
    }

    private int runImpl(Context context, AntRunConfiguration runConfiguration, boolean block, AntListener listener, boolean reloadBuffers, String title) {
        String name = title == null ? AntArb.getString(62) : title;
        AntRunProcess process = new AntRunProcess(runConfiguration, context, name);
        if (reloadBuffers) {
            HashMap timestampMap = new HashMap();
            NodeUtil.storeAllTimestamps(timestampMap);
            process.setRunProcessListener(new 1(this, timestampMap, process));
        }
        if (listener != null) {
            process.setAntListener(listener);
        }
        process.start();
        if (block) {
            try {
                int n = process.waitUntilFinished();
                return n;
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
        return -1;
    }

    private void registerAntGenerators() {
        this.addAntGenerator(new LibraryGenerator());
        this.addAntGenerator(new JavaCompilationGenerator());
        this.addAntGenerator(new CopyGenerator());
    }

    final class 1
    implements RunProcessListener {
        private final /* synthetic */ Map v$timestampMap;
        private final /* synthetic */ AntRunProcess v$process;
        final /* synthetic */ AntManagerImpl this$0;

        public void processFinished(int exitCode) {
            NodeUtil.reloadBuffers((Map)this.v$timestampMap);
            this.v$process.setRunProcessListener(null);
        }

        public 1(AntManagerImpl antManagerImpl, Map map, AntRunProcess antRunProcess) {
            this.v$process = antRunProcess;
            this.v$timestampMap = map;
            this.this$0 = antManagerImpl;
        }
    }
}

