/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import oracle.ide.controls.CustomColorChoice;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.ant.AntArb;
import oracle.jdevimpl.ant.AntOptions;

public class AntOptionsPanel
extends DefaultTraversablePanel {
    private CustomColorChoice errColor;
    private CustomColorChoice warnColor;
    private CustomColorChoice infoColor;
    private CustomColorChoice verboseColor;
    private CustomColorChoice debugColor;
    private JCheckBox showMain;
    private JCheckBox showImported;

    private void $init$() {
        this.errColor = new CustomColorChoice();
        this.warnColor = new CustomColorChoice();
        this.infoColor = new CustomColorChoice();
        this.verboseColor = new CustomColorChoice();
        this.debugColor = new CustomColorChoice();
        this.showMain = new JCheckBox();
        this.showImported = new JCheckBox();
    }

    public AntOptionsPanel() {
        this.$init$();
        this.setHelpID("f1_ant_prefs_html");
        this.jbInit();
    }

    public void onEntry(TraversableContext tc) {
        AntOptions options = this.getAntOptions(tc);
        this.errColor.setClosestSelectedColor(new Color(options.getErrColor()));
        this.warnColor.setClosestSelectedColor(new Color(options.getWarnColor()));
        this.infoColor.setClosestSelectedColor(new Color(options.getInfoColor()));
        this.verboseColor.setClosestSelectedColor(new Color(options.getVerboseColor()));
        this.debugColor.setClosestSelectedColor(new Color(options.getDebugColor()));
        this.showMain.setSelected(options.getShowOnlyMainTargets());
        this.showImported.setSelected(options.getShowImportedTargets());
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        AntOptions options = this.getAntOptions(tc);
        options.setErrColor(this.errColor.getSelectedColor().getRGB());
        options.setWarnColor(this.warnColor.getSelectedColor().getRGB());
        options.setInfoColor(this.infoColor.getSelectedColor().getRGB());
        options.setVerboseColor(this.verboseColor.getSelectedColor().getRGB());
        options.setDebugColor(this.debugColor.getSelectedColor().getRGB());
        options.setShowOnlyMainTargets(this.showMain.isSelected());
        options.setShowImportedTargets(this.showImported.isSelected());
    }

    private AntOptions getAntOptions(TraversableContext tc) {
        return (AntOptions)((Object)tc.find("AntOptions"));
    }

    private void jbInit() {
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 4, 5, 3);
        this.add((Component)this.errColor, AntArb.getString(180), gbc);
        this.add((Component)this.warnColor, AntArb.getString(204), gbc);
        this.add((Component)this.infoColor, AntArb.getString(181), gbc);
        this.add((Component)this.verboseColor, AntArb.getString(82), gbc);
        this.add((Component)this.debugColor, AntArb.getString(190), gbc);
        ResourceUtils.resButton((AbstractButton)this.showMain, (String)AntArb.getString(110));
        ResourceUtils.resButton((AbstractButton)this.showImported, (String)AntArb.getString(29));
        gbc.insets.top = 10;
        gbc.insets.left = 4;
        gbc.insets.right = 4;
        this.add(this.showMain, gbc);
        gbc.insets.top = 0;
        this.add(this.showImported, gbc);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add(new JLabel(), gbc);
    }

    private void add(Component component, String title, GridBagConstraints gbc) {
        JLabel label = new JLabel();
        ResourceUtils.resLabel((JLabel)label, (Component)component, (String)title);
        gbc.gridwidth = -1;
        gbc.insets.left = 4;
        gbc.insets.right = 3;
        this.add(label, gbc);
        gbc.gridwidth = 0;
        gbc.insets.left = 0;
        gbc.insets.right = 4;
        this.add(component, gbc);
    }
}

