/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant;

import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import oracle.ide.Context;
import oracle.ide.ceditor.CEToolTipProvider;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorListener;
import oracle.ide.model.Node;
import oracle.jdeveloper.ant.AntContext;
import oracle.jdeveloper.ant.AntManager;
import oracle.jdeveloper.ant.AntNode;

public class AntTooltipProvider
implements CEToolTipProvider,
EditorListener {
    private boolean enabled;
    private final Pattern pattern;

    private void $init$() {
        this.enabled = true;
        this.pattern = Pattern.compile("(?:^|[^\\$])(\\$\\{(.+?)\\})");
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getToolTipText(CodeEditor codeEditor, MouseEvent mouseEvent, int offset) {
        if (!this.enabled) {
            return null;
        }
        try {
            int line = codeEditor.getLineFromOffset(offset);
            int start = codeEditor.getLineStartOffset(line);
            int end = codeEditor.getLineEndOffset(line);
            int lineOffset = offset - start;
            start = Math.max(start, offset - 100);
            end = Math.min(end, offset + 100);
            String str = codeEditor.getText(start, end - start);
            Matcher matcher = this.pattern.matcher(str);
            String property = null;
            while (matcher.find()) {
                if (matcher.start(1) > lineOffset || matcher.end(1) < lineOffset) continue;
                property = matcher.group(2);
                break;
            }
            if (property != null) {
                Context context = codeEditor.getContext();
                Node node = context.getNode();
                URL url = node.getURL();
                AntContext antContext = AntManager.getAntManager().getAntContext(url, context.getProject());
                String value = antContext.getProperty(property);
                if (value != null && value.trim().length() == 0) {
                    value = null;
                }
                String string = value;
                return string;
            }
        }
        catch (BadLocationException ble) {
            // empty catch block
        }
        return null;
    }

    public void editorOpened(Editor editor) {
        if (editor instanceof CodeEditor) {
            CodeEditor codeEditor = (CodeEditor)editor;
            Context context = editor.getContext();
            Node node = context.getNode();
            if (node instanceof AntNode) {
                codeEditor.addCEToolTipProvider((CEToolTipProvider)this);
            }
        }
    }

    public void editorClosed(Editor editor) {
    }

    public void editorActivated(Editor editor) {
    }

    public void editorDeactivated(Editor editor) {
    }

    public AntTooltipProvider() {
        this.$init$();
    }
}

