/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.ide.Ide;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.VersionNumber;
import oracle.javatools.util.Copyable;

public class AntVersion
implements Copyable {
    public static final String VERSION_PROPERTY = "Version";
    private VersionNumber version;
    private String versionString;
    private URL antHome;
    private static final String ANT_MAIN_CLASS = "org.apache.tools.ant.Main";
    private static final String ANT_VERSION_METHOD = "getAntVersion";
    private static final String ANT_VERSION_PATTERN = "(?:Apache )?Ant version\\s*(\\d+\\.\\d+(?:\\.\\d+)?(?:\\.\\d+)?).*";
    private static final AntVersion defaultAntVersion;

    static {
        URL oracleHome = URLFactory.newDirURL((String)Ide.getOracleHomeDirectory());
        URL antHome = URLFactory.newDirURL((URL)oracleHome, (String)"ant");
        defaultAntVersion = AntVersion.createAntVersion(antHome);
    }

    private AntVersion() {
    }

    public static AntVersion getDefaultAntVersion() {
        return defaultAntVersion;
    }

    public static AntVersion createAntVersion(URL antHome) {
        URLPath classPath = AntVersion.getClassPath(antHome);
        URL[] entries = classPath.getEntries();
        if (entries.length > 0) {
            URLClassLoader loader = new URLClassLoader(entries, null);
            try {
                Class<?> antClass = loader.loadClass(ANT_MAIN_CLASS);
                Method method = antClass.getMethod(ANT_VERSION_METHOD, null);
                String versionString = (String)method.invoke(null, null);
                Pattern pattern = Pattern.compile(ANT_VERSION_PATTERN);
                Matcher matcher = pattern.matcher(versionString);
                if (matcher.matches()) {
                    VersionNumber version = new VersionNumber(matcher.group(1));
                    AntVersion av = new AntVersion();
                    av.version = version;
                    av.versionString = versionString;
                    av.antHome = antHome;
                    AntVersion antVersion = av;
                    return antVersion;
                }
            }
            catch (ClassNotFoundException cnfe) {
            }
            catch (NoSuchMethodException nsme) {
            }
            catch (IllegalAccessException iae) {
            }
            catch (InvocationTargetException ite) {
                // empty catch block
            }
        }
        return null;
    }

    public URL getAntHome() {
        return this.antHome;
    }

    public VersionNumber getVersion() {
        return this.version;
    }

    public String getVersionString() {
        return this.versionString;
    }

    public URLPath getClassPath() {
        return AntVersion.getClassPath(this.antHome);
    }

    private static URLPath getClassPath(URL antHome) {
        URLPath classPath = new URLPath();
        URL libDir = URLFactory.newDirURL((URL)antHome, (String)"lib");
        URL[] urls = URLFileSystem.list((URL)libDir);
        if (urls != null) {
            int i = 0;
            while (i < urls.length) {
                if (!URLFileSystem.isDirectory((URL)urls[i]) && URLFileSystem.getFileName((URL)urls[i]).toLowerCase().endsWith(".jar")) {
                    classPath.add(urls[i]);
                }
                ++i;
            }
        }
        return classPath;
    }

    public Object copyTo(Object object) {
        AntVersion copy = object != null ? (AntVersion)object : new AntVersion();
        this.copyToImpl(copy);
        return copy;
    }

    protected void copyToImpl(AntVersion copy) {
        copy.antHome = this.antHome;
        copy.version = this.version;
        copy.versionString = this.versionString;
    }

    public boolean equals(Object o) {
        return o instanceof AntVersion ? this.equalsImpl((AntVersion)o) : false;
    }

    protected boolean equalsImpl(AntVersion other) {
        return ModelUtil.areEqual((Object)other.antHome, (Object)this.antHome) && ModelUtil.areEqual((Object)other.version, (Object)this.version) && ModelUtil.areEqual((Object)other.versionString, (Object)this.versionString);
    }
}

