/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant.explorer;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.bali.xml.gui.jdev.explorer.XmlExplorer;
import oracle.bali.xml.model.XmlView;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.config.ClientSetting;
import oracle.ide.config.IdeSettings;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.help.HelpInfo;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.view.View;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.Copyable;
import oracle.jdevimpl.ant.AntArb;
import oracle.jdevimpl.ant.explorer.AntExplorerOptions;
import oracle.jdevimpl.ant.explorer.AntExplorerView;
import oracle.jdevimpl.java.JavaArb;

public class AntExplorer
extends XmlExplorer
implements Controller,
PropertyChangeListener {
    private IdeAction showOnlyMainTargetsAction;
    private IdeAction showPropertiesAction;
    private IdeAction showTopLevelAction;
    private IdeAction sortAlphabeticallyAction;
    private IdeAction sortByLocationAction;
    private IdeAction sortByTypeAction;
    private ArrayList toolbarButtons;
    private IdeAction localShowOnlyMainTargetsAction;
    private IdeAction localShowPropertiesAction;
    private IdeAction localShowTopLevelAction;
    private IdeAction[] localSortActions;
    private static final int SHOW_MAIN_TARGETS_ONLY_CMD_ID = Ide.findOrCreateCmdID((String)"AntExplorerShowMainTargetsOnly");
    private static final int SHOW_PROPERTIES_CMD_ID = Ide.findOrCreateCmdID((String)"AntExplorerShowProperties");
    private static final int SHOW_TOP_LEVEL_CMD_ID = Ide.findOrCreateCmdID((String)"AntExplorerShowTopLevel");
    private static final int SORT_BY_LOCATION_CMD_ID = Ide.findOrCreateCmdID((String)"AntExplorerSortByLocation");
    private static final int SORT_ALPHABETICALLY_CMD_ID = Ide.findOrCreateCmdID((String)"AntExplorerSortAlphabetically");
    private static final int SORT_BY_TYPE_CMD_ID = Ide.findOrCreateCmdID((String)"AntExplorerSortByType");
    private static final String SORT_GROUP_NAME = "AntExplorerSortGroup";

    public AntExplorer() {
        this.createActions();
        AntExplorer.getAntExplorerOptions().addPropertyChangeListener(this);
    }

    public void stateChanged(int state) {
        super.stateChanged(state);
        switch (state) {
            case 0: {
                SwingUtilities.invokeLater(new 1());
                break;
            }
            case 1: {
                this.hideToolbarButtons();
                break;
            }
            case 2: {
                AntExplorer.getAntExplorerOptions().removePropertyChangeListener(this);
                this.removeToolbarButtons();
                break;
            }
        }
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_ant_struct_html");
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int commandId = action.getCommandId();
        if (commandId == SHOW_MAIN_TARGETS_ONLY_CMD_ID) {
            AntExplorerOptions options = AntExplorer.getAntExplorerOptions();
            options.setShowMainTargetsOnly(action.getState());
            return true;
        }
        if (commandId == SHOW_PROPERTIES_CMD_ID) {
            AntExplorerOptions options = AntExplorer.getAntExplorerOptions();
            options.setShowProperties(action.getState());
            return true;
        }
        if (commandId == SHOW_TOP_LEVEL_CMD_ID) {
            AntExplorerOptions options = AntExplorer.getAntExplorerOptions();
            options.setShowTopLevelElements(action.getState());
            return true;
        }
        if (commandId == SORT_BY_LOCATION_CMD_ID || commandId == SORT_ALPHABETICALLY_CMD_ID || commandId == SORT_BY_TYPE_CMD_ID) {
            int sortOrder = 0;
            if (commandId == SORT_ALPHABETICALLY_CMD_ID) {
                sortOrder = 1;
            } else if (commandId == SORT_BY_TYPE_CMD_ID) {
                sortOrder = 2;
            } else if (commandId == SORT_ALPHABETICALLY_CMD_ID) {
                sortOrder = 1;
            }
            AntExplorerOptions options = AntExplorer.getAntExplorerOptions();
            options.setSortOrder(sortOrder);
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        int commandId = action.getCommandId();
        return commandId == SHOW_MAIN_TARGETS_ONLY_CMD_ID || commandId == SHOW_PROPERTIES_CMD_ID || commandId == SHOW_TOP_LEVEL_CMD_ID || commandId == SORT_ALPHABETICALLY_CMD_ID || commandId == SORT_BY_TYPE_CMD_ID || commandId == SORT_BY_LOCATION_CMD_ID;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("AntExplorerOptions".equals(event.getPropertyName())) {
            2 updateToolbarItems = new 2();
            SwingUtilities.invokeLater(updateToolbarItems);
            XmlView view = this.getCurrentJDevExplorerGui().getView();
            if (view instanceof AntExplorerView) {
                AntExplorerView antView = (AntExplorerView)view;
                antView.updateViewOptions();
            }
        }
    }

    private static AntExplorerOptions getAntExplorerOptions() {
        IdeSettings settings = Ide.getSettings();
        AntExplorerOptions options = (AntExplorerOptions)settings.getData("AntExplorerOptions");
        if (options == null) {
            options = new AntExplorerOptions();
            ClientSetting.findOrCreate((String)"oracle.jdeveloper").putData("AntExplorerOptions", (Copyable)options);
        }
        return options;
    }

    private void createActions() {
        this.showOnlyMainTargetsAction = IdeAction.get((int)SHOW_MAIN_TARGETS_ONLY_CMD_ID, null, (String)AntArb.getString(213), (String)IdeMainWindow.ACTION_CATEGORY_TOOLS, null, (ArrayResourceBundle)AntArb.getInstance(), (int)93, null, (boolean)true);
        this.showOnlyMainTargetsAction.addController((Controller)this);
        this.showPropertiesAction = IdeAction.get((int)SHOW_PROPERTIES_CMD_ID, null, (String)AntArb.getString(71), (String)IdeMainWindow.ACTION_CATEGORY_TOOLS, null, (Icon)OracleIcons.getIcon((String)"properties.png"), null, (boolean)true);
        this.showPropertiesAction.addController((Controller)this);
        this.showTopLevelAction = IdeAction.get((int)SHOW_TOP_LEVEL_CMD_ID, null, (String)AntArb.getString(201), (String)IdeMainWindow.ACTION_CATEGORY_TOOLS, null, (ArrayResourceBundle)AntArb.getInstance(), (int)154, null, (boolean)true);
        this.showTopLevelAction.addController((Controller)this);
        this.sortByLocationAction = IdeAction.get((int)SORT_BY_LOCATION_CMD_ID, null, (String)AntArb.getString(223), (String)IdeMainWindow.ACTION_CATEGORY_TOOLS, null, (ArrayResourceBundle)JavaArb.getInstance(), (int)109, null, (boolean)true);
        this.sortByLocationAction.addController((Controller)this);
        this.sortAlphabeticallyAction = IdeAction.get((int)SORT_ALPHABETICALLY_CMD_ID, null, (String)AntArb.getString(119), (String)IdeMainWindow.ACTION_CATEGORY_TOOLS, null, (ArrayResourceBundle)JavaArb.getInstance(), (int)274, null, (boolean)true);
        this.sortAlphabeticallyAction.addController((Controller)this);
        this.sortByTypeAction = IdeAction.get((int)SORT_BY_TYPE_CMD_ID, null, (String)AntArb.getString(6), (String)IdeMainWindow.ACTION_CATEGORY_TOOLS, null, (ArrayResourceBundle)JavaArb.getInstance(), (int)280, null, (boolean)true);
        this.sortByTypeAction.addController((Controller)this);
        this.sortByLocationAction.setState(false);
        this.sortAlphabeticallyAction.setState(false);
        this.sortByTypeAction.setState(false);
        this.sortByLocationAction.putValue("Radio", (Object)Boolean.TRUE);
        this.sortAlphabeticallyAction.putValue("Radio", (Object)Boolean.TRUE);
        this.sortByTypeAction.putValue("Radio", (Object)Boolean.TRUE);
        this.sortByLocationAction.putValue("RadioGroupName", (Object)SORT_GROUP_NAME);
        this.sortAlphabeticallyAction.putValue("RadioGroupName", (Object)SORT_GROUP_NAME);
        this.sortByTypeAction.putValue("RadioGroupName", (Object)SORT_GROUP_NAME);
    }

    private void addToolbarButtons() {
        Toolbar toolbar;
        View owner = this.owner();
        Toolbar toolbar2 = toolbar = owner != null ? owner.getToolbar() : null;
        if (toolbar != null) {
            toolbar.addSeparator();
            if (this.toolbarButtons == null) {
                this.toolbarButtons = new ArrayList();
                IdeAction[] sortActions = IdeAction.findGroup((String)SORT_GROUP_NAME);
                int numActions = sortActions.length;
                this.localSortActions = new IdeAction[numActions];
                int i = 0;
                while (i < numActions) {
                    this.localSortActions[i] = sortActions[i].newLocalAction((View)this);
                    ++i;
                }
                this.toolbarButtons.add(toolbar.addMenuButton((ToggleAction[])this.localSortActions));
                this.localShowPropertiesAction = this.showPropertiesAction.newLocalAction((View)this);
                this.localShowTopLevelAction = this.showTopLevelAction.newLocalAction((View)this);
                this.localShowOnlyMainTargetsAction = this.showOnlyMainTargetsAction.newLocalAction((View)this);
                this.toolbarButtons.add(toolbar.addToggleButton((ToggleAction)this.localShowPropertiesAction));
                this.toolbarButtons.add(toolbar.addToggleButton((ToggleAction)this.localShowTopLevelAction));
                this.toolbarButtons.add(toolbar.addToggleButton((ToggleAction)this.localShowOnlyMainTargetsAction));
                this.toolbarButtons.trimToSize();
            } else {
                int i = 0;
                while (i < this.toolbarButtons.size()) {
                    toolbar.add((Component)((AbstractButton)this.toolbarButtons.get(i)));
                    ++i;
                }
            }
        }
    }

    private void hideToolbarButtons() {
        Toolbar toolbar;
        View owner = this.owner();
        Toolbar toolbar2 = toolbar = owner != null ? owner.getToolbar() : null;
        if (toolbar != null && this.toolbarButtons != null) {
            int i = 0;
            while (i < this.toolbarButtons.size()) {
                toolbar.remove((Component)((AbstractButton)this.toolbarButtons.get(i)));
                ++i;
            }
        }
    }

    private void removeToolbarButtons() {
        this.hideToolbarButtons();
        if (this.toolbarButtons != null) {
            int i = 0;
            while (i < this.toolbarButtons.size()) {
                AbstractButton button = (AbstractButton)this.toolbarButtons.get(i);
                button.setAction(null);
                ++i;
            }
            this.toolbarButtons.clear();
            this.toolbarButtons = null;
        }
        this.localSortActions = null;
        this.localShowOnlyMainTargetsAction = null;
        this.localShowPropertiesAction = null;
        this.localShowTopLevelAction = null;
    }

    private void updateToolbarActions() {
        AntExplorerOptions options = AntExplorer.getAntExplorerOptions();
        if (this.localShowOnlyMainTargetsAction != null) {
            this.localShowOnlyMainTargetsAction.setState(options.getShowMainTargetsOnly());
        }
        if (this.localShowPropertiesAction != null) {
            this.localShowPropertiesAction.setState(options.getShowProperties());
        }
        if (this.localShowTopLevelAction != null) {
            this.localShowTopLevelAction.setState(options.getShowTopLevelElements());
        }
        if (this.localSortActions != null) {
            int sortType = options.getSortOrder();
            int commandId = SORT_BY_LOCATION_CMD_ID;
            switch (sortType) {
                case 1: {
                    commandId = SORT_ALPHABETICALLY_CMD_ID;
                    break;
                }
                case 2: {
                    commandId = SORT_BY_TYPE_CMD_ID;
                    break;
                }
                case 0: {
                    commandId = SORT_BY_LOCATION_CMD_ID;
                    break;
                }
            }
            int numActions = this.localSortActions.length;
            int i = 0;
            while (i < numActions) {
                if (this.localSortActions[i].getCommandId() == commandId) {
                    this.localSortActions[i].setState(true);
                    break;
                }
                ++i;
            }
        }
    }

    static void mav$updateToolbarActions(AntExplorer antExplorer) {
        antExplorer.updateToolbarActions();
    }

    static void mav$addToolbarButtons(AntExplorer antExplorer) {
        antExplorer.addToolbarButtons();
    }

    final class 1
    implements Runnable {
        public void run() {
            AntExplorer.mav$addToolbarButtons(AntExplorer.this);
            AntExplorer.mav$updateToolbarActions(AntExplorer.this);
        }
    }

    final class 2
    implements Runnable {
        public void run() {
            AntExplorer.mav$updateToolbarActions(AntExplorer.this);
        }
    }
}

