/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant.explorer;

import java.util.Comparator;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.view.FilteredView;
import oracle.ide.Ide;
import oracle.ide.config.ClientSetting;
import oracle.ide.config.IdeSettings;
import oracle.javatools.util.Copyable;
import oracle.jdevimpl.ant.explorer.AntExplorerOptions;
import oracle.jdevimpl.ant.explorer.SortedTreeTraversal;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AntExplorerView
extends FilteredView {
    private SortedTreeTraversal sortedTraversal;
    private int sortOrder;
    private static final int TYPE_PROJECT = 0;
    private static final int TYPE_TARGET = 1;
    private static final int TYPE_PROPERTY = 2;
    private static final int TYPE_TASK = 3;
    private static final int TYPE_UNKNOWN = 4;

    protected short acceptNode(Node modelNode) {
        short type = modelNode.getNodeType();
        if (type == 1 && "antlib:org.apache.tools.ant".equals(modelNode.getNamespaceURI())) {
            Element element;
            Attr attr;
            AntExplorerOptions options = AntExplorerView.getAntExplorerOptions();
            if (!options.getShowTopLevelElements() && this.isTopLevel(modelNode) && !"target".equals(modelNode.getLocalName())) {
                return 2;
            }
            if (options.getShowMainTargetsOnly() && "target".equals(modelNode.getLocalName()) && (attr = (element = (Element)modelNode).getAttributeNodeNS(null, "description")) == null) {
                return 2;
            }
            if (!options.getShowProperties() && "property".equals(modelNode.getLocalName())) {
                return 2;
            }
        } else if (type == 8 || type == 10) {
            return 2;
        }
        return 1;
    }

    protected TreeTraversal createTreeTraversal() {
        this.sortOrder = AntExplorerView.getAntExplorerOptions().getSortOrder();
        TreeTraversal before = super.createTreeTraversal();
        this.sortedTraversal = new SortedTreeTraversal(before, this.getComparator(this.sortOrder));
        return this.sortedTraversal;
    }

    protected void handleModelChangeEvent(XmlModelEvent event) {
        super.handleModelChangeEvent(event);
        if (event.isDomTreeChanged()) {
            this.sortedTraversal.clearCaches();
        }
    }

    protected String getDisplayName(Node node) {
        return this.getXmlMetadataResolver().getMediumDisplayName(node);
    }

    private Comparator getComparator(int sortOrder) {
        Comparator comparator;
        switch (sortOrder) {
            case 1: {
                comparator = new AlphabeticalNodeComparator();
                break;
            }
            case 2: {
                comparator = new TypeNodeComparitor();
                break;
            }
            default: {
                comparator = null;
                break;
            }
        }
        return comparator;
    }

    public void updateViewOptions() {
        int newSortOrder = AntExplorerView.getAntExplorerOptions().getSortOrder();
        if (newSortOrder != this.sortOrder) {
            this.sortOrder = newSortOrder;
            Comparator comparator = this.getComparator(this.sortOrder);
            this.sortedTraversal.setComparator(comparator);
        }
        this.sortedTraversal.clearCaches();
        this.getBaseModel().getDomModel().forceReparse();
    }

    private static AntExplorerOptions getAntExplorerOptions() {
        IdeSettings settings = Ide.getSettings();
        AntExplorerOptions options = (AntExplorerOptions)settings.getData("AntExplorerOptions");
        if (options == null) {
            options = new AntExplorerOptions();
            ClientSetting.findOrCreate((String)"oracle.jdeveloper").putData("AntExplorerOptions", (Copyable)options);
        }
        return options;
    }

    private boolean isTopLevel(Node node) {
        Node parent = node.getParentNode();
        return parent != null && (parent = parent.getParentNode()) != null && parent.getNodeType() == 9;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AlphabeticalNodeComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Node node1 = (Node)o1;
            Node node2 = (Node)o2;
            return AntExplorerView.this.getDisplayName(node1).compareTo(AntExplorerView.this.getDisplayName(node2));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TypeNodeComparitor
    implements Comparator {
        public int compare(Object o1, Object o2) {
            int type2;
            Node node1 = (Node)o1;
            Node node2 = (Node)o2;
            int type1 = this.getType(node1);
            if (type1 != (type2 = this.getType(node2))) {
                return type1 - type2;
            }
            return AntExplorerView.this.getDisplayName(node1).compareTo(AntExplorerView.this.getDisplayName(node2));
        }

        private int getType(Node node) {
            if (node.getNodeType() == 1 && "antlib:org.apache.tools.ant".equals(node.getNamespaceURI())) {
                String name = node.getLocalName();
                if ("project".equals(name)) {
                    return 0;
                }
                if ("target".equals(name)) {
                    return 1;
                }
                if ("property".equals(name)) {
                    return 2;
                }
                return 3;
            }
            return 4;
        }
    }
}

