/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant.explorer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import org.w3c.dom.Node;

public class SortedTreeTraversal
extends TreeTraversal {
    private TreeTraversal beforeTraversal;
    private List childCache;
    private Comparator comparator;

    public SortedTreeTraversal(TreeTraversal beforeTraversal, Comparator comparator) {
        this.beforeTraversal = beforeTraversal;
        this.comparator = comparator;
    }

    public void clearCaches() {
        if (this.childCache != null) {
            this.childCache.clear();
            this.childCache = null;
        }
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
        this.clearCaches();
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public Node getParentNode(Node node) {
        return this.beforeTraversal.getParentNode(node);
    }

    public Node getFirstChild(Node node) {
        if (this.comparator != null && this.isRootElement(node)) {
            List children = this.getSortedChildList(node);
            return children.size() > 0 ? (Node)children.get(0) : null;
        }
        return this.beforeTraversal.getFirstChild(node);
    }

    public Node getLastChild(Node node) {
        if (this.comparator != null && this.isRootElement(node)) {
            List children = this.getSortedChildList(node);
            return children.size() > 0 ? (Node)children.get(children.size() - 1) : null;
        }
        return this.beforeTraversal.getLastChild(node);
    }

    public Node getNextSibling(Node node) {
        Node parent;
        if (this.comparator != null && (parent = node.getParentNode()) != null && this.isRootElement(parent)) {
            List children = this.getSortedChildList(parent);
            int index = children.indexOf(node);
            return children.size() > index + 1 ? (Node)children.get(index + 1) : null;
        }
        return this.beforeTraversal.getNextSibling(node);
    }

    public Node getPreviousSibling(Node node) {
        Node parent;
        if (this.comparator != null && (parent = node.getParentNode()) != null && this.isRootElement(parent)) {
            List children = this.getSortedChildList(parent);
            int index = children.indexOf(node);
            return index > 0 ? (Node)children.get(index - 1) : null;
        }
        return this.beforeTraversal.getNextSibling(node);
    }

    private List getSortedChildList(Node node) {
        if (this.childCache == null) {
            int len = this.beforeTraversal.getChildCount(node);
            if (len > 0) {
                this.childCache = new ArrayList(len);
                int i = 0;
                while (i < len) {
                    this.childCache.add(this.beforeTraversal.getChild(node, i));
                    ++i;
                }
                Collections.sort(this.childCache, this.comparator);
                ((ArrayList)this.childCache).trimToSize();
            } else {
                this.childCache = Collections.EMPTY_LIST;
            }
        }
        return this.childCache;
    }

    private boolean isRootElement(Node node) {
        Node parent;
        return node.getNodeType() == 1 && (parent = node.getParentNode()) != null && parent.getNodeType() == 9;
    }
}

