/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant.extension;

import java.net.MalformedURLException;
import java.net.URL;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.Extension;
import javax.ide.extension.ExtensionHook;
import javax.ide.extension.I18NStringVisitor;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.jdevimpl.ant.registry.AntRegistry;
import oracle.jdevimpl.ant.registry.AntlibInfo;
import oracle.jdevimpl.ant.registry.PropertyInfo;
import oracle.jdevimpl.ant.registry.TaskInfo;
import oracle.jdevimpl.ant.registry.TypeInfo;

public final class AntHookHandler
extends ExtensionHook {
    private static final String NAMESPACE = "http://xmlns.oracle.com/jdeveloper/1013/jdev-ant";
    private static final String KEY_ANTLIB = "Ant-antlib";
    private static final String KEY_TASK = "Ant-task";
    private static final String KEY_TYPE = "Ant-type";
    private static final String KEY_PROPERTY = "Ant-property";
    private static final String KEY_CLASSPATH = "Ant-classpath";
    private static final String KEY_BASEDIR = "Ant-basedir";
    private static final String KEY_JARFILE = "Ant-jarfile";
    private final ElementVisitor antlibHandler;
    private final ElementVisitor taskHandler;
    private final ElementVisitor typeHandler;
    private final ElementVisitor propertyHandler;
    private final ElementVisitor taskGroupHandler;
    private final ElementVisitor typeGroupHandler;
    private final ElementVisitor displayNameHandler;
    private final ElementVisitor classPathHandler;

    private void $init$() {
        this.antlibHandler = new AntlibHandler(null);
        this.taskHandler = new TaskHandler(null);
        this.typeHandler = new TypeHandler(null);
        this.propertyHandler = new PropertyHandler(null);
        this.taskGroupHandler = new TaskGroupHandler(null);
        this.typeGroupHandler = new TypeGroupHandler(null);
        this.displayNameHandler = new DisplayNameHandler(null);
        this.classPathHandler = new ClassPathHandler(null);
    }

    private static final ElementName ns(String name) {
        return new ElementName(NAMESPACE, name);
    }

    public void start(ElementStartContext context) {
        context.registerChildVisitor(AntHookHandler.ns("antlib"), this.antlibHandler);
        context.registerChildVisitor(AntHookHandler.ns("task"), this.taskHandler);
        context.registerChildVisitor(AntHookHandler.ns("type"), this.typeHandler);
        context.registerChildVisitor(AntHookHandler.ns("property"), this.propertyHandler);
        try {
            URL url = context.getExtensionSourceURI().toURL();
            if (url != null) {
                context.getScopeData().put(KEY_BASEDIR, this.getDirectory(url));
                if (JarUtil.isJarURL((URL)url)) {
                    context.getScopeData().put(KEY_JARFILE, JarUtil.getJarFileURL((URL)url));
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    private URL getDirectory(URL file) {
        file = JarUtil.getJarFileURL((URL)file);
        return URLFileSystem.getParent((URL)file);
    }

    private void getURLPath(URLPath path, String text, URL baseDir) {
        String[] parts = text.split(";");
        int i = 0;
        while (i < parts.length) {
            path.add(URLFactory.newURL((URL)baseDir, (String)parts[i]));
            ++i;
        }
    }

    public AntHookHandler() {
        this.$init$();
    }

    static ElementName maS$ns(String string) {
        return AntHookHandler.ns(string);
    }

    static ElementVisitor ra$displayNameHandler(AntHookHandler antHookHandler) {
        return antHookHandler.displayNameHandler;
    }

    static ElementVisitor ra$classPathHandler(AntHookHandler antHookHandler) {
        return antHookHandler.classPathHandler;
    }

    static ElementVisitor ra$taskGroupHandler(AntHookHandler antHookHandler) {
        return antHookHandler.taskGroupHandler;
    }

    static ElementVisitor ra$typeGroupHandler(AntHookHandler antHookHandler) {
        return antHookHandler.typeGroupHandler;
    }

    static void mav$getURLPath(AntHookHandler antHookHandler, URLPath uRLPath, String string, URL uRL) {
        antHookHandler.getURLPath(uRLPath, string, uRL);
    }

    private class AntlibHandler
    extends ElementVisitor {
        public void start(ElementStartContext context) {
            context.registerChildVisitor(AntHookHandler.maS$ns("displayName"), AntHookHandler.ra$displayNameHandler(AntHookHandler.this));
            context.getScopeData().put(AntHookHandler.KEY_CLASSPATH, new URLPath());
            context.registerChildVisitor(AntHookHandler.maS$ns("classpath"), AntHookHandler.ra$classPathHandler(AntHookHandler.this));
            AntlibInfo antlib = new AntlibInfo();
            antlib.setNamespace(context.getAttributeValue("namespace"));
            antlib.setFile(context.getAttributeValue("file"));
            antlib.setSchema(context.getAttributeValue("schema"));
            Extension extension = context.getExtension();
            antlib.setExtension(extension.getName());
            context.getScopeData().put(AntHookHandler.KEY_ANTLIB, antlib);
        }

        public void end(ElementEndContext context) {
            AntRegistry registry = AntRegistry.getExtensionAntRegistry();
            AntlibInfo antlib = (AntlibInfo)((Object)context.getScopeData().get(AntHookHandler.KEY_ANTLIB));
            antlib.setClassPath((URLPath)context.getScopeData().get(AntHookHandler.KEY_CLASSPATH));
            registry.addAntlib(antlib);
        }

        private AntlibHandler() {
        }

        AntlibHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class TaskHandler
    extends ElementVisitor {
        public void start(ElementStartContext context) {
            context.registerChildVisitor(AntHookHandler.maS$ns("group"), AntHookHandler.ra$taskGroupHandler(AntHookHandler.this));
            context.getScopeData().put(AntHookHandler.KEY_CLASSPATH, new URLPath());
            context.registerChildVisitor(AntHookHandler.maS$ns("classpath"), AntHookHandler.ra$classPathHandler(AntHookHandler.this));
            TaskInfo task = new TaskInfo();
            task.setName(context.getAttributeValue("name"));
            task.setNamespace(context.getAttributeValue("namespace"));
            task.setClassName(context.getAttributeValue("class"));
            try {
                URL url = new URL(context.getAttributeValue("documentation"));
                task.setDocumentation(url);
            }
            catch (MalformedURLException mue) {
                mue.printStackTrace();
            }
            Extension extension = context.getExtension();
            task.setExtension(extension.getName());
            context.getScopeData().put(AntHookHandler.KEY_TASK, task);
        }

        public void end(ElementEndContext context) {
            AntRegistry registry = AntRegistry.getExtensionAntRegistry();
            TaskInfo task = (TaskInfo)((Object)context.getScopeData().get(AntHookHandler.KEY_TASK));
            task.setClassPath((URLPath)context.getScopeData().get(AntHookHandler.KEY_CLASSPATH));
            registry.addTask(task);
        }

        private TaskHandler() {
        }

        TaskHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class TypeHandler
    extends ElementVisitor {
        public void start(ElementStartContext context) {
            context.registerChildVisitor(AntHookHandler.maS$ns("group"), AntHookHandler.ra$typeGroupHandler(AntHookHandler.this));
            context.getScopeData().put(AntHookHandler.KEY_CLASSPATH, new URLPath());
            context.registerChildVisitor(AntHookHandler.maS$ns("classpath"), AntHookHandler.ra$classPathHandler(AntHookHandler.this));
            TypeInfo type = new TypeInfo();
            type.setName(context.getAttributeValue("name"));
            type.setNamespace(context.getAttributeValue("namespace"));
            type.setClassName(context.getAttributeValue("class"));
            Extension extension = context.getExtension();
            type.setExtension(extension.getName());
            context.getScopeData().put(AntHookHandler.KEY_TYPE, type);
        }

        public void end(ElementEndContext context) {
            AntRegistry registry = AntRegistry.getExtensionAntRegistry();
            TypeInfo type = (TypeInfo)((Object)context.getScopeData().get(AntHookHandler.KEY_TYPE));
            type.setClassPath((URLPath)context.getScopeData().get(AntHookHandler.KEY_CLASSPATH));
            registry.addType(type);
        }

        private TypeHandler() {
        }

        TypeHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class PropertyHandler
    extends ElementVisitor {
        public void start(ElementStartContext context) {
            PropertyInfo property = new PropertyInfo();
            property.setName(context.getAttributeValue("name"));
            property.setValue(context.getAttributeValue("value"));
            Extension extension = context.getExtension();
            property.setExtension(extension.getName());
            context.getScopeData().put(AntHookHandler.KEY_PROPERTY, property);
        }

        public void end(ElementEndContext context) {
            AntRegistry registry = AntRegistry.getExtensionAntRegistry();
            PropertyInfo property = (PropertyInfo)((Object)context.getScopeData().get(AntHookHandler.KEY_PROPERTY));
            registry.addProperty(property);
        }

        private PropertyHandler() {
        }

        PropertyHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class DisplayNameHandler
    extends I18NStringVisitor {
        protected void string(ElementContext context, String translatedString) {
            AntlibInfo antlib = (AntlibInfo)((Object)context.getScopeData().get(AntHookHandler.KEY_ANTLIB));
            antlib.setDisplayName(translatedString);
        }

        private DisplayNameHandler() {
        }

        DisplayNameHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class TaskGroupHandler
    extends I18NStringVisitor {
        protected void string(ElementContext context, String translatedString) {
            TaskInfo task = (TaskInfo)((Object)context.getScopeData().get(AntHookHandler.KEY_TASK));
            task.setGroup(translatedString);
        }

        private TaskGroupHandler() {
        }

        TaskGroupHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class TypeGroupHandler
    extends I18NStringVisitor {
        protected void string(ElementContext context, String translatedString) {
            TypeInfo type = (TypeInfo)((Object)context.getScopeData().get(AntHookHandler.KEY_TYPE));
            type.setGroup(translatedString);
        }

        private TypeGroupHandler() {
        }

        TypeGroupHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class ClassPathHandler
    extends ElementVisitor {
        public void end(ElementEndContext context) {
            URL baseDir = (URL)context.getScopeData().get(AntHookHandler.KEY_BASEDIR);
            URLPath path = (URLPath)context.getScopeData().get(AntHookHandler.KEY_CLASSPATH);
            AntHookHandler.mav$getURLPath(AntHookHandler.this, path, context.getText(), baseDir);
            URL jarFile = (URL)context.getScopeData().get(AntHookHandler.KEY_JARFILE);
            if (jarFile != null) {
                path.add(jarFile);
            }
        }

        private ClassPathHandler() {
        }

        ClassPathHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

