/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant.generator;

import java.net.URL;
import java.util.Iterator;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.ant.AntBuildfile;
import oracle.jdeveloper.ant.AntGenerator;
import oracle.jdeveloper.compiler.BuildSystemConfiguration;
import oracle.jdeveloper.model.PathsConfiguration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CopyGenerator
implements AntGenerator {
    private static final String COPY_TARGET = "copy";
    private static final String COPY_TARGET_DESCRIPTION = "Copy files to output directory";
    private static final String COPY_PATTERNS = "copy.patterns";

    public void generate(Project project, AntBuildfile buildfile) {
        Project jproject;
        if (project instanceof Project && this.hasSrcPath(jproject = project)) {
            this.createCopyTarget(jproject, buildfile);
        }
    }

    private boolean hasSrcPath(Project jproject) {
        for (URL url : PathsConfiguration.getInstance((Project)jproject).getProjectSourcePath()) {
            if (!URLFileSystem.exists((URL)url)) continue;
            return true;
        }
        return false;
    }

    private void createCopyTarget(Project jproject, AntBuildfile buildfile) {
        Element target = buildfile.createTarget(COPY_TARGET, COPY_TARGET_DESCRIPTION);
        BuildSystemConfiguration config = BuildSystemConfiguration.getInstance((PropertyStorage)jproject);
        String[] patterns = config.getCopyRes();
        this.fixPatterns(patterns);
        boolean reverse = config.getReverseCopyRes();
        Element patternset = reverse ? buildfile.createPatternSet(COPY_PATTERNS, null, patterns) : buildfile.createPatternSet(COPY_PATTERNS, patterns, null);
        target.appendChild(patternset);
        Document document = buildfile.getDocument();
        Element copy = document.createElementNS("antlib:org.apache.tools.ant", COPY_TARGET);
        copy.setAttributeNS(null, "todir", buildfile.createPropertyReference("output.dir"));
        Iterator iterator = PathsConfiguration.getInstance((Project)jproject).getProjectSourcePath().iterator();
        while (iterator.hasNext()) {
            Element fileset = document.createElementNS("antlib:org.apache.tools.ant", "fileset");
            URL dir = (URL)iterator.next();
            fileset.setAttributeNS(null, "dir", buildfile.getRelativePath(dir));
            patternset = document.createElementNS("antlib:org.apache.tools.ant", "patternset");
            patternset.setAttributeNS(null, "refid", COPY_PATTERNS);
            fileset.appendChild(patternset);
            copy.appendChild(fileset);
        }
        target.appendChild(copy);
        buildfile.addDependency("all", COPY_TARGET);
        buildfile.addDependency(COPY_TARGET, "init");
    }

    private void fixPatterns(String[] patterns) {
        int i = 0;
        while (i < patterns.length) {
            patterns[i] = "**/*" + patterns[i];
            ++i;
        }
    }
}

