/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant.generator;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Dependable;
import oracle.ide.model.DependencyConfiguration;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.PatternFilter;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.ant.AntBuildfile;
import oracle.jdeveloper.ant.AntGenerator;
import oracle.jdeveloper.compiler.BuildSystemConfiguration;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdevimpl.ant.generator.LibraryGenerator;
import oracle.jdevimpl.compiler.CompilerOptionManager;
import oracle.jdevimpl.config.JProjectPaths;
import oracle.ojc.ant.taskdefs.OjcAdapter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JavaCompilationGenerator
implements AntGenerator {
    public static final String CLASSPATH = "classpath";
    private static final String COMPILE_TARGET = "compile";
    private static final String DEBUG_PROPERTY = "javac.debug";
    private static final String NOWARN_PROPERTY = "javac.nowarn";
    private static final String DEPRECATION_PROPERTY = "javac.deprecation";
    private boolean hasClasspath;
    private boolean hasSrcPath;
    private boolean hasSrcPatterns;

    public void generate(Project project, AntBuildfile buildfile) {
        this.hasClasspath = false;
        this.hasSrcPath = false;
        this.hasSrcPatterns = false;
        this.createClassPath(project, buildfile);
        this.createCompileTarget(project, buildfile);
    }

    private void createClassPath(Project project, AntBuildfile buildfile) {
        Document document = buildfile.getDocument();
        Element classpath = document.createElementNS("antlib:org.apache.tools.ant", "path");
        classpath.setAttributeNS(null, "id", CLASSPATH);
        URLPath urlPath = new URLPath();
        JProjectPaths paths = JProjectPaths.getInstance((PropertyStorage)project);
        urlPath.add(paths.getAdditionalClassPath().getEntries());
        Iterator deps = DependencyConfiguration.getInstance((Project)project).getDependencies();
        while (deps.hasNext()) {
            Dependable dependency = (Dependable)deps.next();
            if (!(dependency instanceof Library)) continue;
            Library lib = (Library)dependency;
            urlPath.add(lib.getClassPath());
        }
        URL[] urls = urlPath.getEntries();
        int i = 0;
        while (i < urls.length) {
            Element pathElement = document.createElementNS("antlib:org.apache.tools.ant", "pathelement");
            pathElement.setAttributeNS(null, "location", buildfile.getRelativePath(urls[i]));
            classpath.appendChild(pathElement);
            ++i;
        }
        JProjectLibraries settings = JProjectLibraries.getInstance((PropertyStorage)project);
        JLibrary[] libs = settings.getLibraries();
        int i2 = 0;
        while (i2 < libs.length) {
            Element path = document.createElementNS("antlib:org.apache.tools.ant", "path");
            path.setAttributeNS(null, "refid", LibraryGenerator.getPathName(libs[i2].getName()));
            classpath.appendChild(path);
            ++i2;
        }
        if (classpath.hasChildNodes()) {
            this.hasClasspath = true;
            buildfile.appendBeforeTargets(classpath);
        }
    }

    private void createCompileTarget(Project project, AntBuildfile buildfile) {
        ArrayList<Element> tasks = new ArrayList<Element>();
        Stack<ContentSet> stack = new Stack<ContentSet>();
        PathsConfiguration config = PathsConfiguration.getInstance((Project)project);
        stack.push(config.getJavaContentSet());
        while (!stack.isEmpty()) {
            ContentSet cs = (ContentSet)stack.pop();
            Element task = this.getCompileTask(cs, project, buildfile);
            if (task != null) {
                tasks.add(task);
            }
            int size = cs.countContentSets();
            int i = 0;
            while (i < size) {
                stack.push(cs.getContentSet(i));
                ++i;
            }
        }
        if (!tasks.isEmpty()) {
            Element target = buildfile.createTarget(COMPILE_TARGET, "Compile Java source files");
            for (Element task : tasks) {
                target.appendChild(task);
            }
            buildfile.addDependency("all", COMPILE_TARGET);
            buildfile.addDependency(COMPILE_TARGET, "init");
        }
    }

    private Element getCompileTask(ContentSet cs, Project project, AntBuildfile buildfile) {
        Document document = buildfile.getDocument();
        Element javac = document.createElementNS("antlib:org.apache.tools.ant", "javac");
        javac.setAttributeNS(null, "destdir", buildfile.createPropertyReference("output.dir"));
        this.setJavacOptions(project, buildfile, javac);
        URLPath path = cs.getURLPath();
        if (path.size() > 0) {
            boolean hasContent = false;
            for (URL url : path) {
                if (!URLFileSystem.exists((URL)url)) continue;
                Element src = document.createElementNS("antlib:org.apache.tools.ant", "src");
                src.setAttributeNS(null, "path", buildfile.getRelativePath(url));
                javac.appendChild(src);
                hasContent = true;
            }
            if (hasContent) {
                PatternFilter[] filters = cs.getPatternFilters().getFilters();
                if (filters != null) {
                    int i = 0;
                    while (i < filters.length) {
                        Element pattern = this.getPattern(filters[i], document);
                        if (pattern != null) {
                            javac.appendChild(pattern);
                        }
                        ++i;
                    }
                }
                return javac;
            }
        }
        return null;
    }

    private Element getPattern(PatternFilter filter, Document document) {
        String pattern = this.fixPattern(filter.getPattern());
        if (filter.isInclude()) {
            if (!pattern.equals("**")) {
                Element include = document.createElementNS("antlib:org.apache.tools.ant", "include");
                include.setAttributeNS(null, "name", pattern);
                return include;
            }
        } else {
            Element exclude = document.createElementNS("antlib:org.apache.tools.ant", "exclude");
            exclude.setAttributeNS(null, "name", pattern);
            return exclude;
        }
        return null;
    }

    private String fixPattern(String pattern) {
        if (!pattern.endsWith("/") && !pattern.endsWith("*")) {
            pattern = pattern + "/";
        }
        return pattern;
    }

    private void setJavacOptions(Project project, AntBuildfile buildfile, Element javac) {
        String target;
        String source;
        if (this.hasClasspath) {
            javac.setAttributeNS(null, "classpathref", CLASSPATH);
        }
        BuildSystemConfiguration buildSysConfig = BuildSystemConfiguration.getInstance((PropertyStorage)project);
        CompilerOptionManager optionManager = CompilerOptionManager.getInstance((PropertyStorage)project);
        if (optionManager.isUseOjc()) {
            String[] options;
            String adapter = OjcAdapter.class.getName();
            buildfile.addGlobalProperty("build.compiler", adapter);
            String[] stringArray = options = optionManager.getCompilerOptionsAsArray("Ojc");
            int n = 0;
            while (n < stringArray.length) {
                String option = stringArray[n];
                this.addCompilerArg(buildfile, javac, adapter, option);
                ++n;
            }
        }
        buildfile.addGlobalProperty(DEBUG_PROPERTY, optionManager.isDebugInformation() ? "on" : "off");
        javac.setAttributeNS(null, "debug", buildfile.createPropertyReference(DEBUG_PROPERTY));
        buildfile.addGlobalProperty(NOWARN_PROPERTY, optionManager.isShowWarnings() ? "off" : "on");
        javac.setAttributeNS(null, "nowarn", buildfile.createPropertyReference(NOWARN_PROPERTY));
        buildfile.addGlobalProperty(DEPRECATION_PROPERTY, optionManager.isShowDeprecations() ? "on" : "off");
        javac.setAttributeNS(null, "deprecation", buildfile.createPropertyReference(DEPRECATION_PROPERTY));
        String encoding = buildSysConfig.getCurrentEncoding();
        if (!"Default".equals(encoding)) {
            javac.setAttributeNS(null, "encoding", encoding);
        }
        if (!(source = buildSysConfig.getSource()).equals("Default")) {
            javac.setAttributeNS(null, "source", source);
        }
        if (!(target = buildSysConfig.getTarget()).equals("Default")) {
            javac.setAttributeNS(null, "target", target);
        }
    }

    private void addCompilerArg(AntBuildfile buildfile, Element javac, String adapter, String value) {
        Document document = buildfile.getDocument();
        Element arg = document.createElementNS("antlib:org.apache.tools.ant", "compilerarg");
        arg.setAttributeNS(null, "compiler", adapter);
        arg.setAttributeNS(null, "value", value);
        javac.appendChild(arg);
    }
}

