/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant.grammar;

import java.awt.Window;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.grammar.GrammarException;
import oracle.bali.xml.grammar.GrammarProvider;
import oracle.bali.xml.grammar.LayeredGrammarProvider;
import oracle.bali.xml.grammar.schema.OracleSchema;
import oracle.bali.xml.grammar.schema.OracleSchemaFactory;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.ide.Ide;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.Assert;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.ant.AntRunConfiguration;
import oracle.jdevimpl.ant.grammar.AntGrammar;
import oracle.jdevimpl.ant.registry.AntRegistry;
import oracle.jdevimpl.ant.registry.AntlibInfo;
import oracle.jdevimpl.ant.registry.TaskInfo;
import oracle.jdevimpl.ant.registry.TypeInfo;

public class AntGrammarProvider
extends LayeredGrammarProvider {
    final LinkedHashMap grammars;
    private static SoftReference<Grammar[]> baseGrammarRef;
    private static final Object BASE_GRAMMAR_LOCK;
    private static final String ANT_SCHEMA = "/oracle/jdevimpl/ant/ant.xsd";
    private OracleSchemaFactory schemaFactory;
    private JDevXmlContext context;

    private void $init$() {
        this.grammars = new LinkedHashMap();
        this.schemaFactory = new OracleSchemaFactory();
    }

    public AntGrammarProvider(GrammarProvider base, JDevXmlContext context) {
        super(base);
        this.$init$();
        this.context = context;
        Grammar[] grammarArray = this.getBaseAntGrammars();
        int n = 0;
        while (n < grammarArray.length) {
            Grammar grammar = grammarArray[n];
            String namespace = grammar.getTargetNamespace();
            AntGrammar ag = new AntGrammar(this, namespace);
            ag.setBaseGrammar(grammar);
            this.grammars.put(namespace, ag);
            ++n;
        }
        this.loadExtensionGrammars();
    }

    public JDevXmlContext getContext() {
        return this.context;
    }

    protected Map getLayerGrammarMap() {
        return this.grammars;
    }

    protected Grammar getLayerGrammarForNamespace(String targetNamespace) {
        if (targetNamespace != null) {
            this.findOrCreateGrammar(targetNamespace);
        }
        return super.getLayerGrammarForNamespace(targetNamespace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Grammar[] getBaseAntGrammars() {
        Grammar[] grammars;
        Object object = BASE_GRAMMAR_LOCK;
        synchronized (object) {
            Grammar[] grammarArray = grammars = baseGrammarRef == null ? null : baseGrammarRef.get();
            if (grammars == null) {
                Assert.startTiming((String)(AntGrammar.class.getName() + ".getBaseAntGrammar"), null, (boolean)false);
                URL url = AntGrammar.class.getResource(ANT_SCHEMA);
                try {
                    try {
                        grammars = this.schemaFactory.buildSchemas(url);
                        baseGrammarRef = new SoftReference<Grammar[]>(grammars);
                    }
                    catch (GrammarException ge) {
                        ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)((Object)ge));
                    }
                }
                finally {
                    Assert.endTiming((String)(AntGrammar.class.getName() + ".getBaseAntGrammar"), (String)("Loaded Ant schema from " + URLFileSystem.getPlatformPathName((URL)url)), null, (boolean)false);
                }
            }
        }
        return grammars;
    }

    private AntGrammar findOrCreateGrammar(String namespace) {
        AntGrammar grammar = (AntGrammar)this.grammars.get(namespace);
        if (grammar == null) {
            grammar = new AntGrammar(this, namespace);
            this.grammars.put(namespace, grammar);
        }
        return grammar;
    }

    private void loadExtensionGrammars() {
        AntRegistry registry = AntRegistry.getExtensionAntRegistry();
        List antlibs = registry.getAntlibList();
        for (AntlibInfo antlib : antlibs) {
            this.loadAntlib(antlib);
        }
        List tasks = registry.getTaskList();
        for (TaskInfo task : tasks) {
            String namespace = task.getNamespace();
            if (namespace == null) {
                namespace = "antlib:org.apache.tools.ant";
            }
            AntGrammar grammar = this.findOrCreateGrammar(namespace);
            grammar.addTask(task);
        }
        List types = registry.getTypeList();
        for (TypeInfo type : types) {
            String namespace = type.getNamespace();
            if (namespace == null) {
                namespace = "antlib:org.apache.tools.ant";
            }
            AntGrammar grammar = this.findOrCreateGrammar(namespace);
            grammar.addType(type);
        }
    }

    private void loadAntlib(AntlibInfo antlib) {
        URLPath classpath = antlib.getClassPath();
        String schema = antlib.getSchema();
        if (schema != null) {
            this.loadSchema(schema, classpath);
        } else {
            String namespace = antlib.getNamespace();
            if (namespace != null) {
                AntGrammar grammar = this.findOrCreateGrammar(namespace);
                String file = antlib.getFile();
                URL url = null;
                url = file != null ? this.getClassLoader(classpath).getResource(file) : this.getAntlibFile(namespace, classpath);
                if (url != null) {
                    grammar.loadAntLib(url, classpath);
                }
            }
        }
    }

    private void loadSchema(String schema, URLPath classpath) {
        ClassLoader loader = this.getClassLoader(classpath);
        URL url = loader.getResource(schema);
        if (url != null) {
            try {
                OracleSchema[] grammars = this.schemaFactory.buildSchemas(url);
                int i = 0;
                while (i < grammars.length) {
                    String namespace = grammars[i].getTargetNamespace();
                    AntGrammar grammar = this.findOrCreateGrammar(namespace);
                    grammar.setBaseGrammar((Grammar)grammars[i]);
                    ++i;
                }
            }
            catch (GrammarException ge) {
                ge.printStackTrace();
            }
        } else {
            Assert.print((String)("Antlib schema not found: " + schema));
        }
    }

    protected ClassLoader getClassLoader(URLPath classpath) {
        AntRunConfiguration config = new AntRunConfiguration();
        Project project = this.context.getProject();
        if (project != null) {
            AntRunConfiguration projectConfig = AntRunConfiguration.getInstance((PropertyStorage)project);
            projectConfig.copyTo((Object)config);
        }
        config.setBuildfile(this.context.getIdeDocument().getURL());
        ClassLoader parent = config.getAntClassLoader(project);
        if (classpath != null) {
            return new URLClassLoader(classpath.getEntries(), parent);
        }
        return parent;
    }

    protected URL getAntlibFile(String namespace, URLPath classpath) {
        if (namespace.startsWith("antlib:")) {
            String file = namespace.substring(7).replace('.', '/') + "/antlib.xml";
            ClassLoader loader = this.getClassLoader(classpath);
            return loader.getResource(file);
        }
        return null;
    }

    static {
        BASE_GRAMMAR_LOCK = new Object();
    }
}

