/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant.insight;

import java.awt.Window;
import java.util.List;
import javax.swing.ListModel;
import javax.swing.text.BadLocationException;
import oracle.bali.xml.model.XmlModel;
import oracle.ide.Ide;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.editor.insight.ListDataItem;
import oracle.javatools.editor.insight.ListInsightData;
import oracle.javatools.editor.insight.ReadOnlyListModel;
import oracle.javatools.editor.insight.SortedInsightInputFilter;
import oracle.jdeveloper.ant.AntContext;
import oracle.jdevimpl.ant.AntArb;
import oracle.jdevimpl.ant.AntModel;
import oracle.jdevimpl.ant.insight.AntPropertyDataItem;
import oracle.jdevimpl.ant.insight.AntPropertyInsightProvider;

public class AntPropertyInsightData
implements ListInsightData {
    private ListDataItem[] insightData;
    private ReadOnlyListModel listModel;
    private AntPropertyInsightProvider insight;
    private String currentPrefix;
    private Object[] matchingData;

    public AntPropertyInsightData(AntPropertyInsightProvider insight) {
        this.insight = insight;
        XmlModel model = insight.getXmlContext().getModel();
        if (model instanceof AntModel) {
            AntContext context = ((AntModel)model).getAntContext();
            int i = 0;
            List properties = context.getPropertyNames();
            int len = properties.size();
            this.insightData = new ListDataItem[len];
            while (i < len) {
                this.insightData[i] = new AntPropertyDataItem((String)properties.get(i));
                ++i;
            }
        }
    }

    public Object[] getData() {
        return this.insightData;
    }

    public Object[] getMatchingData() {
        if (this.matchingData == null) {
            String prefix = this.getCurrentPrefix();
            this.matchingData = SortedInsightInputFilter.INSTANCE.getMatchingData(this.insightData, prefix);
        }
        return this.matchingData;
    }

    public int getMatchingDataCount() {
        Object[] matchingData = this.getMatchingData();
        return matchingData != null ? matchingData.length : 0;
    }

    public Object getDefault() {
        String prefix = this.getCurrentPrefix();
        return SortedInsightInputFilter.INSTANCE.findClosestDataItem(this.insightData, prefix);
    }

    public boolean complete(Object selectedObject) {
        AntPropertyDataItem selectedItem = (AntPropertyDataItem)((Object)selectedObject);
        String itemName = selectedItem.getName();
        this.replacePrefix(itemName, true);
        return false;
    }

    public void partialComplete() {
        ListDataItem[] matches = (ListDataItem[])this.getMatchingData();
        if (matches.length > 0) {
            String commonPrefix = matches[0].getName();
            int i = 1;
            while (i < matches.length) {
                commonPrefix = this.getCommonPrefix(commonPrefix, matches[i].getName());
                ++i;
            }
            this.replacePrefix(commonPrefix, false);
        }
    }

    public ListModel getListModel() {
        return this.buildListModel();
    }

    public void updateData() {
        this.matchingData = null;
        this.listModel = null;
        this.currentPrefix = null;
    }

    private String getCommonPrefix(String s1, String s2) {
        int commonLength = Math.min(s1.length(), s2.length());
        int i = 0;
        while (i < commonLength) {
            if (s1.charAt(i) != s2.charAt(i)) {
                return s1.substring(0, i);
            }
            ++i;
        }
        return s1.substring(0, commonLength);
    }

    private int getPropertyStart(ReadTextBuffer textBuffer, int caretPosition) {
        int pos = caretPosition - 1;
        while (pos >= 0) {
            char c = textBuffer.getChar(pos);
            if (c == '{') break;
            --pos;
        }
        return pos + 1;
    }

    private int getPropertyEnd(ReadTextBuffer textBuffer, int caretPosition) {
        int pos = caretPosition;
        int length = textBuffer.getLength();
        while (pos < length) {
            char c = textBuffer.getChar(pos);
            if (c == '}' || c == '\"' || c == '\n' || Character.isWhitespace(c)) break;
            ++pos;
        }
        return pos;
    }

    private ReadOnlyListModel buildListModel() {
        if (this.listModel == null) {
            this.listModel = new ReadOnlyListModel((Object[])this.insightData);
        }
        return this.listModel;
    }

    private String getCurrentPrefix() {
        if (this.currentPrefix == null) {
            TextBuffer textBuffer = this.insight.getTextBuffer();
            int caretPosition = this.insight.getCaretPosition();
            int prefixStart = this.getPropertyStart((ReadTextBuffer)textBuffer, caretPosition);
            int prefixLength = caretPosition - prefixStart;
            this.currentPrefix = textBuffer.getString(prefixStart, prefixLength);
        }
        return this.currentPrefix;
    }

    private void replacePrefix(String str, boolean closeProperty) {
        BasicDocument document = this.insight.getDocument();
        TextBuffer textBuffer = this.insight.getTextBuffer();
        int caretPosition = this.insight.getCaretPosition();
        int startPosition = this.getPropertyStart((ReadTextBuffer)textBuffer, caretPosition);
        int endPosition = this.getPropertyEnd((ReadTextBuffer)textBuffer, caretPosition);
        BasicEditorPane editorPane = this.insight.getEditorPane();
        EditDescriptor ed = new EditDescriptor(AntArb.getString(39));
        editorPane.beginEdit(ed);
        try {
            try {
                document.remove(startPosition, endPosition - startPosition);
                if (closeProperty && !str.endsWith("}") && textBuffer.getChar(startPosition) != '}') {
                    str = str + '}';
                }
                document.insertString(startPosition, str, null);
            }
            catch (BadLocationException ble) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)ble);
            }
        }
        finally {
            editorPane.endEdit();
        }
    }
}

