/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import oracle.jdevimpl.ant.AntContextImpl;
import oracle.jdevimpl.ant.parser.AntHandler;
import oracle.jdevimpl.ant.parser.ApplyHandler;
import oracle.jdevimpl.ant.parser.ChecksumHandler;
import oracle.jdevimpl.ant.parser.ConditionHandler;
import oracle.jdevimpl.ant.parser.DirnameHandler;
import oracle.jdevimpl.ant.parser.FormatHandler;
import oracle.jdevimpl.ant.parser.ImportHandler;
import oracle.jdevimpl.ant.parser.InputHandler;
import oracle.jdevimpl.ant.parser.JUnitHandler;
import oracle.jdevimpl.ant.parser.NiceHandler;
import oracle.jdevimpl.ant.parser.P4SubmitHandler;
import oracle.jdevimpl.ant.parser.PathHandler;
import oracle.jdevimpl.ant.parser.ProjectHandler;
import oracle.jdevimpl.ant.parser.PropertyHandler;
import oracle.jdevimpl.ant.parser.SSHExecHandler;
import oracle.jdevimpl.ant.parser.TStampHandler;
import oracle.jdevimpl.ant.parser.TargetHandler;
import oracle.jdevimpl.ant.parser.WaitForHandler;
import oracle.jdevimpl.ant.parser.XmlPropertyHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;

public class AntParser {
    private AntContextImpl context;
    private HashMap handlers;

    private void $init$() {
        this.handlers = new HashMap();
    }

    public AntParser(AntContextImpl context) {
        this.$init$();
        this.context = context;
        this.handlers.put("checksum", new ChecksumHandler());
        this.handlers.put("classpath", new PathHandler());
        this.handlers.put("dirname", new DirnameHandler());
        this.handlers.put("format", new FormatHandler());
        this.handlers.put("import", new ImportHandler());
        this.handlers.put("input", new InputHandler());
        this.handlers.put("junit", new JUnitHandler());
        this.handlers.put("nice", new NiceHandler());
        this.handlers.put("p4submit", new P4SubmitHandler());
        this.handlers.put("path", new PathHandler());
        this.handlers.put("project", new ProjectHandler());
        this.handlers.put("property", new PropertyHandler());
        this.handlers.put("sshexec", new SSHExecHandler());
        this.handlers.put("target", new TargetHandler());
        this.handlers.put("tstamp", new TStampHandler());
        this.handlers.put("waitfor", new WaitForHandler());
        this.handlers.put("xmlproperty", new XmlPropertyHandler());
        AntHandler handler = new ConditionHandler();
        this.handlers.put("available", handler);
        this.handlers.put("basename", handler);
        this.handlers.put("checksum", handler);
        this.handlers.put("condition", handler);
        this.handlers.put("format", handler);
        this.handlers.put("jarlib-available", handler);
        this.handlers.put("jarlib-resolve", handler);
        this.handlers.put("loadfile", handler);
        this.handlers.put("p4counter", handler);
        this.handlers.put("pathconvert", handler);
        this.handlers.put("tempfile", handler);
        this.handlers.put("uptodate", handler);
        this.handlers.put("whichresource", handler);
        this.handlers.put("resourcecount", handler);
        this.handlers.put("loadresource", handler);
        this.handlers.put("manifestclasspath", handler);
        handler = new ApplyHandler();
        this.handlers.put("apply", handler);
        this.handlers.put("execon", handler);
        this.handlers.put("exec", handler);
        this.handlers.put("java ", handler);
    }

    public void parse(Node node) {
        if (node.getNodeType() == 9) {
            Element root = ((Document)node).getDocumentElement();
            if (root != null) {
                this.parse(root);
            }
        } else if (node.getNodeType() == 1) {
            if (this.isAntNamespace(node.getNamespaceURI()) && "project".equals(node.getLocalName())) {
                this.parseProject((Element)node);
            } else {
                this.parseTree(node);
            }
        }
    }

    private void parseProject(Element project) {
        this.handleElement(project);
        ArrayList<Node> targets = new ArrayList<Node>();
        Node child = project.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1) {
                if (this.isAntNamespace(child.getNamespaceURI()) && "target".equals(child.getLocalName())) {
                    targets.add(child);
                } else {
                    this.parseTree(child);
                }
            }
            child = child.getNextSibling();
        }
        Iterator iterator = targets.iterator();
        while (iterator.hasNext()) {
            this.parseTree((Node)iterator.next());
        }
    }

    private void parseTree(Node root) {
        DocumentTraversal traversal = (DocumentTraversal)((Object)root.getOwnerDocument());
        NodeIterator iterator = traversal.createNodeIterator(root, 1, new AntFilter(null), true);
        try {
            Element element = (Element)iterator.nextNode();
            while (element != null) {
                this.handleElement(element);
                element = (Element)iterator.nextNode();
            }
        }
        finally {
            iterator.detach();
        }
    }

    private void handleElement(Element element) {
        String name = element.getLocalName();
        AntHandler handler = (AntHandler)this.handlers.get(name);
        if (handler != null) {
            handler.handleElement(this.context, element);
        }
    }

    private boolean isAntNamespace(String namespace) {
        return namespace == null || "antlib:org.apache.tools.ant".equals(namespace);
    }

    static boolean mav$isAntNamespace(AntParser antParser, String string) {
        return antParser.isAntNamespace(string);
    }

    private class AntFilter
    implements NodeFilter {
        public short acceptNode(Node n) {
            return AntParser.mav$isAntNamespace(AntParser.this, n.getNamespaceURI()) ? (short)1 : 3;
        }

        private AntFilter() {
        }

        AntFilter(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

